/*
 * dia_SAFeatureSpmBase.cpp
 *
 *  Created on: 19.01.2012
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include <common/framework/sysadapters/dia_SystemAdapterFacade.h>
#endif

#ifndef __INCLUDED_DIA_UTILITIES__
#include <common/framework/utils/dia_utilities.h>
#endif
#include <common/framework/utils/dia_MsgVisitor.h>

#ifndef __INCLUDED_DIA_INTERFACE_SPM_LISTENER__
#include <common/interfaces/dia_ISpmListener.h>
#endif

#ifndef __INCLUDED_DIA_APPCONTROLLER__
#include <common/framework/application/dia_AppController.h>
#endif

#define CFC_FI_S_IMPORT_INTERFACE_CFC_SPMFI_DBGVISITORS
#define CFC_FI_S_IMPORT_INTERFACE_CFC_SPMFI_STDVISITORS
#define CFC_FI_S_IMPORT_INTERFACE_CFC_SPMFI_FUNCTIONIDS
#define CFC_FI_S_IMPORT_INTERFACE_CFC_SPMFI_TYPES

//#ifdef VARIANT_S_FTR_ENABLE_FEAT_SET_DIAG_VAG
//lint -e1516
//lint -e1712
//lint -e1735
//lint -e1739
#include "cfc_fi_if.h"
//lint +e1516
//lint +e1712
//lint +e1735
//lint +e1739
//#endif

#define SPM_FI_S_IMPORT_INTERFACE_SPM_COREFI_DBGVISITORS
#define SPM_FI_S_IMPORT_INTERFACE_SPM_COREFI_STDVISITORS
#define SPM_FI_S_IMPORT_INTERFACE_SPM_COREFI_FUNCTIONIDS
#define SPM_FI_S_IMPORT_INTERFACE_SPM_COREFI_TYPES
#define SPM_FI_S_IMPORT_INTERFACE_FI_TYPES

//lint -e1516
//lint -e1712
//lint -e1735
//lint -e1739
#include "spm_fi_if.h"
//lint +e1516
//lint +e1712
//lint +e1735
//lint +e1739
//#endif

#define DIA_SPM_SYS_STATE_SUSPEND      ((tU32)0x00000000)
#define DIA_SPM_SYS_STATE_STANDBY      ((tU32)0x00000001)
#define DIA_SPM_SYS_STATE_OFF          ((tU32)0x00000002)
#define DIA_SPM_SYS_STATE_DOWNLOAD     ((tU32)0x00000003)
#define DIA_SPM_SYS_STATE_ON           ((tU32)0x00000004)
#define DIA_SPM_SYS_STATE_BACKGROUND   ((tU32)0x00000005)
#define DIA_SPM_SYS_STATE_DOOR_OPEN    ((tU32)0x00000006)
#define DIA_SPM_SYS_STATE_IGNITION     ((tU32)0x00000007)
#define DIA_SPM_SYS_STATE_DIAGNOSIS    ((tU32)0x00000008)
#define DIA_SPM_SYS_STATE_STATE_MAX    ((tU32)0x00000009)



#define MIDW_FI_S_IMPORT_INTERFACE_FI_TYPES
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "midw_fi_if.h" //lint !e451 !e537 repeatedly included header file without standard include guard

#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include "generic_msgs_if.h" //lint !e451 !e537 repeatedly included header file without standard include guard
#include "dia_SAFeatureSpmBase.h"

//// MESSAGE MAP: the function will be called when a message with the
BEGIN_MSG_MAP(dia_SAFeatureSpmBase, dia_SystemAdapterFeature)

ON_MESSAGE(SPM_COREFI_C_U16_SUBSTATES, vHandleSubState)
ON_MESSAGE(SPM_COREFI_C_U16_RESETLIST, vHandleSystemResetList)
//ON_MESSAGE(CFC_SPMFI_C_U16_SWITCHONHISTORY, vHandleStatusSwitchOnHistory)
//ON_MESSAGE(CFC_SPMFI_C_U16_SYSPWRSAVEMODE, vHandleStatusSystemPowerSaveMode)
ON_MESSAGE(SPM_COREFI_C_U16_RESETHISTORY, vHandleStatusResetHistory)
ON_MESSAGE(SPM_COREFI_C_U16_WAKEUPHISTORY, vHandleStatusWakeUpHistory)
ON_MESSAGE(SPM_COREFI_C_U16_STATEHISTORY, vHandleStatusStateHistory)
ON_MESSAGE(SPM_COREFI_C_U16_ERRSTATEHISTORY01, vHandleStatusErrStateHistory)
ON_MESSAGE(SPM_COREFI_C_U16_ERRSTATEHISTORY02, vHandleStatusErrStateHistory)
ON_MESSAGE(SPM_COREFI_C_U16_ERRSTATEHISTORY03, vHandleStatusErrStateHistory)
ON_MESSAGE(SPM_COREFI_C_U16_ERRSTATEHISTORY04, vHandleStatusErrStateHistory)
ON_MESSAGE(SPM_COREFI_C_U16_ERRSTATEHISTORY05, vHandleStatusErrStateHistory)
ON_MESSAGE(SPM_COREFI_C_U16_UBATSENSE, vHandleStatusVoltSplyTerminalValue)
ON_MESSAGE(SPM_COREFI_C_U16_CVMEVENT,  vHandlePowerSupplyStatus)
ON_MESSAGE(SPM_COREFI_C_U16_RESTART,   vHandleSystemRestart)
ON_MESSAGE(SPM_COREFI_C_U16_RESETCOUNTER,  vHandleSystemResetInformation)
ON_MESSAGE(SPM_COREFI_C_U16_RESTARTSYSTEM, vHandleSystemHardReset)
ON_MESSAGE(SPM_COREFI_C_U16_UBATSENSE,     vHandleSystemVoltageInformation)
ON_MESSAGE(SPM_COREFI_C_U16_ONOFFTRIGGER, vHandleOnOffTrigger)
ON_MESSAGE(SPM_COREFI_C_U16_SYSPWRMODE,    vHandleSystemPowerMode)
ON_MESSAGE(SPM_COREFI_C_U16_SYSTEMSTATE,    vHandleSystemState)
ON_MESSAGE(SPM_COREFI_C_U16_PROCESSLIST,    vHandleStartupStatus)
ON_MESSAGE(SPM_COREFI_C_U16_HMISTATE,    vHandleHmiState)
ON_MESSAGE(SPM_COREFI_C_U16_DEGRADEDCOUNT, vHandleStatusDegradedCountValue)
ON_MESSAGE(SPM_COREFI_C_U16_DEGRADEDTIME, vHandleStatusDegradedTimeValue)
ON_MESSAGE(SPM_COREFI_C_U16_UNBALLASTTIMEFROMENGINESTOPPED, vHandleStatusEngineStoppedTimeValue)
ON_MESSAGE(SPM_COREFI_C_U16_VEHICLEID, vHandleStatusVehicleIdentifierValue)

ON_MESSAGE(SPM_COREFI_C_U16_VOLTAGEEVENTCOUNTER,   vHandleVoltageEventCounter)
ON_MESSAGE(SPM_COREFI_C_U16_VOLTAGERANGEHISTOGRAM, vHandleVoltageRangeHistogram)
ON_MESSAGE(SPM_COREFI_C_U16_CPUUSAGESTATISTIC,     vHandleCpuUsageStatistic)
ON_MESSAGE(SPM_COREFI_C_U16_RAMUSAGESTATISTIC,     vHandleRamUsageStatistic)
ON_MESSAGE(SPM_COREFI_C_U16_STARTUPTIMESTATISTIC,  vHandleStartupTimeStatistic)
ON_MESSAGE(SPM_COREFI_C_U16_SPECIFICSWVERSIONSTATISTIC,  vHandleSpecificSwVersionStatistic)
END_MSG_MAP()
static bool isTraceActive() {
   return dia_isTraceActive(DIA_TRACE_CLASS_DIAGNOSTICS_BASE,(tU16)TR_LEVEL_USER_1);
}
#define PRINT_SPM_FI_SWVERSION(BASE, PRINTER)                      \
   DIA_VISIT_MSG_FIELD(BASE, strCustomerVersion, PRINTER);              \
   DIA_VISIT_MSG_FIELD(BASE, strBuildVersionCustomer, PRINTER);         \
   DIA_VISIT_MSG_FIELD(BASE, strBuildVersion, PRINTER);
class ScopedAmtMessage {
public:
   ScopedAmtMessage(amt_tclServiceData* poMessage):
      _poMessage(poMessage)
   {}
   
   ~ScopedAmtMessage() {
      if (_poMessage) {
         (void) _poMessage->bDelete();

   }
   }
   amt_tclServiceData const *get() {
      return _poMessage;
   }
   amt_tclServiceData* _poMessage;
};

template<class FITYPE, class DIATYPE, class LISTENER>
struct FiMsgHandler: public FiMsgHandlerBase<FITYPE>
{
   FiMsgHandler(char const *fnName, int id=-1):
      FiMsgHandlerBase<FITYPE>(id),
      mFnName(fnName)
   {}
   virtual void handleFiMsg(FITYPE &fi) {
      dia::ScopeTrace trc(mFnName);
      do {
         LISTENER *pListener=0;
         querySysAdapterListener<LISTENER>(&pListener);
         if (!pListener) {
            DIA_TR_ERR("%s:unable to resolve Listener", mFnName);
            break;
         }
         DIATYPE dia;
         if (!dia_fiToDia(fi, dia)) {
            DIA_TR_ERR("%s:unable to parse fi-message", mFnName);                  
            break;
         }
         pListener->vOnAdaperResult(&dia);
      } while (0);
   }
   char const *mFnName;
};
template<class FITYPE, class DIATYPE, class LISTENER, class HINT>
struct FiMsgHandlerWithHint: public FiMsgHandlerBase<FITYPE>
{
   FiMsgHandlerWithHint(char const *fnName, HINT &hint, int id=-1):
      FiMsgHandlerBase<FITYPE>(id),
      mFnName(fnName),
      mHint(hint)
   {}
   virtual void handleFiMsg(FITYPE &fi) {
      dia::ScopeTrace trc(mFnName);
      do {
         LISTENER *pListener=0;
         querySysAdapterListener<LISTENER>(&pListener);
         if (!pListener) {
            DIA_TR_ERR("%s:unable to resolve Listener", mFnName);
            break;
         }
         DIATYPE dia;
         if (!dia_fiToDia(fi, dia, mHint)) {
            DIA_TR_ERR("%s:unable to parse fi-message", mFnName);                  
            break;
         }
         pListener->vOnAdaperResult(&dia);
      } while (0);
   }
   char const *mFnName;
   HINT mHint;
};
template<class FIMSG>
bool dia_getFiMessage(amt_tclServiceData* poMessage, char const *fnName, FIMSG &oFiMsg) {
   bool res=false;
   do {
      if (!poMessage) {
         break;
      }
      ScopedAmtMessage amtMsg(poMessage);
      DIA_ASSERT(poMessage->bIsServerMessage());
      tU8 wantOpCode=oFiMsg.u8GetOpCode();
      tU8 opCode=poMessage->u8GetOpCode();
      if (opCode==wantOpCode) {
         fi_tclVisitorMessage oVisitorMsg(poMessage);
         (void) oVisitorMsg.s32GetData(oFiMsg);
         res=true;
      } else {
         DIA_TR_ERR("%s - unexpected opcode want:%d received:%d", fnName, wantOpCode, opCode);
         if (opCode == AMT_C_U8_CCAMSG_OPCODE_ERROR) {
            amt_tclServiceDataError oErrorMsg(poMessage);
            tU16 u16ErrorCode = oErrorMsg.u16GetErrorData();
            DIA_TR_ERR("%s - opcode error received: %d", fnName, u16ErrorCode);
         }
      }
   } while (0);
   return res;
}
template<class LISTENER, class FIMSG>
bool dia_getFiMessageAndListener(amt_tclServiceData* poMessage, char const *fnName, FIMSG &oFiMsg, LISTENER* &pListener) {
   dia::ScopeTrace trc(fnName);
   bool res=false;
   do {
      if (!dia_getFiMessage(poMessage, fnName, oFiMsg)) {
         break;
      }
      ScopedAmtMessage amtMsg(poMessage);
      querySysAdapterListener<dia_ISpmListener>(&pListener);
      if (!pListener) {
         DIA_TR_ERR("%s:unable to resolve Listener", fnName);
         break;
      }
      res=true;
   } while (0);
   return res;
}

static tU32 aSpmRestartModeMapping[DIA_EN_SPM_RESTART_MODE_COUNT] = {
   0xFFFFFFFF, // DIA_EN_SPM_RESTART_MODE_UNKNOWN
   (tU32) spm_fi_tcl_SPM_e32_RESTART_TYPE::FI_EN_SPM_U32_RESTART_ECU,// DIA_EN_SPM_RESTART_MODE_ECU
   (tU32) spm_fi_tcl_SPM_e32_RESTART_TYPE::FI_EN_SPM_U32_RESTART_WDT,// DIA_EN_SPM_RESTART_MODE_WDT
   (tU32) spm_fi_tcl_SPM_e32_RESTART_TYPE::FI_EN_SPM_U32_RESTART_ECU_FAST,// DIA_EN_SPM_RESTART_MODE_ECU_FAST

   (tU32) spm_fi_tcl_SPM_e32_RESTART_TYPE::FI_EN_SPM_U32_RESTART_DOWNLOAD_ERROR,// DIA_EN_SPM_RESTART_MODE_DOWNLOAD_ERROR
   (tU32) spm_fi_tcl_SPM_e32_RESTART_TYPE::FI_EN_SPM_U32_RESTART_DOWNLOAD_FINISHED,//DIA_EN_SPM_RESTART_MODE_DOWNLOAD_FINSIHED
   (tU32) spm_fi_tcl_SPM_e32_RESTART_TYPE::FI_EN_SPM_U32_RESTART_ECU_WITH_SYNC,//DIA_EN_SPM_RESTART_MODE_ECU_WITH_SYNC
   (tU32) spm_fi_tcl_SPM_e32_RESTART_TYPE::FI_EN_SPM_U32_RESTART_DOWNLOAD_ABORTED,//DIA_EN_SPM_RESTART_MODE_DOWNLOAD_ABORTED
   (tU32) spm_fi_tcl_SPM_e32_RESTART_TYPE::FI_EN_SPM_U32_RESTART_ECU_ALTSW_TESTMANAGER,//DIA_EN_SPM_RESTART_MODE_ECU_ALTSW_TESTMANAGER

#ifdef FI_EN_SPM_U32_RESTART_ECU_ALTSW_NAC_TESTSOFTWARE
   (tU32)spm_fi_tcl_SPM_e32_RESTART_TYPE::FI_EN_SPM_U32_RESTART_ECU_ALTSW_NAC_TESTSOFTWARE//DIA_EN_SPM_RESTART_MODE_ECU_ALTSW_NAC_TESTSOFTWARE
#else
   0xFFFFFFFF // DIA_EN_SPM_RESTART_MODE_UNKNOWN
#endif
};

static spm_fi_tcl_SPM_e32_RESTART_TYPE::tenType aSpmCoreRestartModeMapping[DIA_EN_SPM_CORE_RESTART_MODE_COUNT] = {
   (spm_fi_tcl_SPM_e32_RESTART_TYPE::tenType) 0xFFFFFFFF, // DIA_EN_SPM_CORE_RESTART_MODE_UNKNOWN
   (spm_fi_tcl_SPM_e32_RESTART_TYPE::tenType) spm_fi_tcl_SPM_e32_RESTART_TYPE::FI_EN_SPM_U32_RESTART_ECU,// DIA_EN_SPM_CORE_RESTART_MODE_ECU
   (spm_fi_tcl_SPM_e32_RESTART_TYPE::tenType) spm_fi_tcl_SPM_e32_RESTART_TYPE::FI_EN_SPM_U32_RESTART_WDT,// DIA_EN_SPM_CORE_RESTART_MODE_WDT
   (spm_fi_tcl_SPM_e32_RESTART_TYPE::tenType) spm_fi_tcl_SPM_e32_RESTART_TYPE::FI_EN_SPM_U32_RESTART_ECU_FAST,// DIA_EN_SPM_CORE_RESTART_MODE_ECU_FAST
   (spm_fi_tcl_SPM_e32_RESTART_TYPE::tenType) spm_fi_tcl_SPM_e32_RESTART_TYPE::FI_EN_SPM_U32_RESTART_DOWNLOAD_ERROR,// DIA_EN_SPM_CORE_RESTART_MODE_DOWNLOAD_ERROR
   (spm_fi_tcl_SPM_e32_RESTART_TYPE::tenType) spm_fi_tcl_SPM_e32_RESTART_TYPE::FI_EN_SPM_U32_RESTART_DOWNLOAD_FINISHED,//DIA_EN_SPM_CORE_RESTART_MODE_DOWNLOAD_FINSIHED
   (spm_fi_tcl_SPM_e32_RESTART_TYPE::tenType) spm_fi_tcl_SPM_e32_RESTART_TYPE::FI_EN_SPM_U32_RESTART_ECU_WITH_SYNC,//DIA_EN_SPM_CORE_RESTART_MODE_ECU_WITH_SYNC
   (spm_fi_tcl_SPM_e32_RESTART_TYPE::tenType) spm_fi_tcl_SPM_e32_RESTART_TYPE::FI_EN_SPM_U32_RESTART_DOWNLOAD_ABORTED,//DIA_EN_SPM_CORE_RESTART_MODE_DOWNLOAD_ABORTED
   (spm_fi_tcl_SPM_e32_RESTART_TYPE::tenType) spm_fi_tcl_SPM_e32_RESTART_TYPE::FI_EN_SPM_U32_RESTART_ECU_ALTSW_TESTMANAGER,//DIA_EN_SPM_CORE_RESTART_MODE_ECU_ALTSW_TESTMANAGER
   (spm_fi_tcl_SPM_e32_RESTART_TYPE::tenType) spm_fi_tcl_SPM_e32_RESTART_TYPE::FI_EN_SPM_U32_SYNC_WITHOUT_RESTART,//DIA_EN_SPM_CORE_RESTART_MODE_ECU_SYNC_WITHOUT_RESTART

#ifdef FI_EN_SPM_U32_RESTART_ECU_ALTSW_NAC_TESTSOFTWARE
   (spm_fi_tcl_SPM_e32_RESTART_TYPE::tenType) spm_fi_tcl_SPM_e32_RESTART_TYPE::FI_EN_SPM_U32_RESTART_ECU_ALTSW_NAC_TESTSOFTWARE//DIA_EN_SPM_CORE_RESTART_MODE_ECU_ALTSW_NAC_TESTSOFTWARE
#else
   (spm_fi_tcl_SPM_e32_RESTART_TYPE::tenType) 0xFFFFFFFF // DIA_EN_SPM_CORE_RESTART_MODE_UNKNOWN
#endif
};

/*static dia_eSpmSystemState aSpmSystemStateMapping[45] = {
     DIA_EN_SPM_SYSTEM_STATE_SUSPEND, // 0
     DIA_EN_SPM_SYSTEM_STATE_STANDBY, // 1
     DIA_EN_SPM_SYSTEM_STATE_OFF, // 2
     DIA_EN_SPM_SYSTEM_STATE_DOWNLOAD, // 3
     DIA_EN_SPM_SYSTEM_STATE_ON, // 4
     DIA_EN_SPM_SYSTEM_STATE_BACKGROUND, // 5
     DIA_EN_SPM_SYSTEM_STATE_DOOR_OPEN, // 6
     DIA_EN_SPM_SYSTEM_STATE_IGNITION, // 7
     DIA_EN_SPM_SYSTEM_STATE_DIAGNOSIS, // 8
     DIA_EN_SPM_SYSTEM_STATE_PROFILE, // 9
     DIA_EN_SPM_SYSTEM_STATE_UNKNOWN, // 10
     DIA_EN_SPM_SYSTEM_STATE_UNKNOWN, // 11
     DIA_EN_SPM_SYSTEM_STATE_UNKNOWN, // 12
     DIA_EN_SPM_SYSTEM_STATE_UNKNOWN, // 13
     DIA_EN_SPM_SYSTEM_STATE_UNKNOWN, // 14
     DIA_EN_SPM_SYSTEM_STATE_UNKNOWN, // 15
     DIA_EN_SPM_SYSTEM_STATE_PREPARE_SHUTDOWN, // 16
     DIA_EN_SPM_SYSTEM_STATE_SHUTDOWN, // 17
     DIA_EN_SPM_SYSTEM_STATE_UNKNOWN, // 18
     DIA_EN_SPM_SYSTEM_STATE_UNKNOWN, // 19
     DIA_EN_SPM_SYSTEM_STATE_UNKNOWN, // 20
     DIA_EN_SPM_SYSTEM_STATE_UNKNOWN, // 21
     DIA_EN_SPM_SYSTEM_STATE_UNKNOWN, // 22
     DIA_EN_SPM_SYSTEM_STATE_UNKNOWN, // 23
     DIA_EN_SPM_SYSTEM_STATE_UNKNOWN, // 24
     DIA_EN_SPM_SYSTEM_STATE_UNKNOWN, // 25
     DIA_EN_SPM_SYSTEM_STATE_UNKNOWN, // 26
     DIA_EN_SPM_SYSTEM_STATE_UNKNOWN, // 27
     DIA_EN_SPM_SYSTEM_STATE_UNKNOWN, // 28
     DIA_EN_SPM_SYSTEM_STATE_UNKNOWN, // 29
     DIA_EN_SPM_SYSTEM_STATE_UNKNOWN, // 30
     DIA_EN_SPM_SYSTEM_STATE_UNKNOWN, // 31
     DIA_EN_SPM_SYSTEM_STATE_MMI_STANDBY_PWR_SAVE_1, // 32
     DIA_EN_SPM_SYSTEM_STATE_MMI_STANDBY_PWR_SAVE_2, // 33
     DIA_EN_SPM_SYSTEM_STATE_MMI_STANDBY, // 34
     DIA_EN_SPM_SYSTEM_STATE_MMI_ON, // 35
     DIA_EN_SPM_SYSTEM_STATE_MMI_STANDBY_RESTRICTED, // 36
     DIA_EN_SPM_SYSTEM_STATE_MMI_ON_DIAG, // 37
     DIA_EN_SPM_SYSTEM_STATE_MMI_ON_TEL, // 38
     DIA_EN_SPM_SYSTEM_STATE_MMI_ON_SWDL, // 39
     DIA_EN_SPM_SYSTEM_STATE_MMI_STANDBY_CUSTOMER_SWDL, // 40
     DIA_EN_SPM_SYSTEM_STATE_MMI_STANDBY_PWR_SAVE, // 41
     DIA_EN_SPM_SYSTEM_STATE_OVERTEMP, // 42
     DIA_EN_SPM_SYSTEM_STATE_SAFE, // 43
     DIA_EN_SPM_SYSTEM_STATE_UNKNOWN, // 44
};
*/
/*static spm_fi_tcl_SPM_e32_SubStateType::tenType aSpmSubStateMapping[DIA_EN_SPM_SUBSTATE_COUNT] = {
   (spm_fi_tcl_SPM_e32_SubStateType::tenType)0xFFFFFFFF, // DIA_EN_SPM_SUBSTATE_UNKNOWN
   spm_fi_tcl_SPM_e32_SubStateType::FI_EN_SPM_U32_SUBSTATE_DIAG_ACTIVITY, // DIA_EN_SPM_SUBSTATE_DIAGNOSIS_ACTIVITY
   spm_fi_tcl_SPM_e32_SubStateType::FI_EN_SPM_U32_SUBSTATE_FAST_SHUTDOWN, // DIA_EN_SPM_SUBSTATE_FAST_SHUTDOWN
   spm_fi_tcl_SPM_e32_SubStateType::FI_EN_SPM_U32_SUBSTATE_DIAGNOSIS, // DIA_EN_SPM_SUBSTATE_DIAGNOSIS_MODE
   spm_fi_tcl_SPM_e32_SubStateType::FI_EN_SPM_U32_SUBSTATE_IGNITION, // DIA_EN_SPM_SUBSTATE_IGNITION
   spm_fi_tcl_SPM_e32_SubStateType::FI_EN_SPM_U32_SUBSTATE_S_CONTACT, // DIA_EN_SPM_SUBSTATE_ACCESSORY
   spm_fi_tcl_SPM_e32_SubStateType::FI_EN_SPM_U32_SUBSTATE_ON_TIPPER, // DIA_EN_SPM_SUBSTATE_ON_TIPPER
   spm_fi_tcl_SPM_e32_SubStateType::FI_EN_SPM_U32_SUBSTATE_DIAG_REQUEST // DIA_EN_SPM_SUBSTATE_DIAGNOSIS_REQUEST
};
*/
ct_assert((uint32_t)spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_SUSPEND                 == (uint32_t)DIA_EN_SPM_SYSTEM_STATE_SUSPEND);
ct_assert((uint32_t)spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_STATE_PROFILE           == (uint32_t)DIA_EN_SPM_SYSTEM_STATE_PROFILE);
ct_assert((uint32_t)spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_PREPARE_SHUTDOWN        == (uint32_t)DIA_EN_SPM_SYSTEM_STATE_PREPARE_SHUTDOWN);
ct_assert((uint32_t)spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_SHUTDOWN                == (uint32_t)DIA_EN_SPM_SYSTEM_STATE_SHUTDOWN);
ct_assert((uint32_t)spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_MMI_STANDBY_PWR_SAVE_1  == (uint32_t)DIA_EN_SPM_SYSTEM_STATE_MMI_STANDBY_PWR_SAVE_1);
ct_assert((uint32_t)spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_SAFE                    == (uint32_t)DIA_EN_SPM_SYSTEM_STATE_SAFE);


static bool dia_fiToDia(spm_fi_tcl_SPM_e32_SYSTEM_STATES const &fi, dia_eSpmSystemState &dia) {
   bool ok=true;
   switch (fi.enType) 
   {
      case spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_SUSPEND:  dia=DIA_EN_SPM_SYSTEM_STATE_SUSPEND;break;
      case spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_STANDBY:  dia=DIA_EN_SPM_SYSTEM_STATE_STANDBY;break;
      case spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_OFF:  dia=DIA_EN_SPM_SYSTEM_STATE_OFF;break;
      case spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_DOWNLOAD:  dia=DIA_EN_SPM_SYSTEM_STATE_DOWNLOAD;break;
      case spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_ON:  dia=DIA_EN_SPM_SYSTEM_STATE_ON;break;
      case spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_BACKGROUND:  dia=DIA_EN_SPM_SYSTEM_STATE_BACKGROUND;break;
      case spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_DOOR_OPEN:  dia=DIA_EN_SPM_SYSTEM_STATE_DOOR_OPEN;break;
      case spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_IGNITION:  dia=DIA_EN_SPM_SYSTEM_STATE_IGNITION;break;
      case spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_DIAGNOSIS:  dia=DIA_EN_SPM_SYSTEM_STATE_DIAGNOSIS;break;
      case spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_STATE_PROFILE:  dia=DIA_EN_SPM_SYSTEM_STATE_PROFILE;break;
      case spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_PREPARE_SHUTDOWN:  dia=DIA_EN_SPM_SYSTEM_STATE_PREPARE_SHUTDOWN;break;
      case spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_SHUTDOWN:  dia=DIA_EN_SPM_SYSTEM_STATE_SHUTDOWN;break;
      case spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_MMI_STANDBY_PWR_SAVE_1:  dia=DIA_EN_SPM_SYSTEM_STATE_MMI_STANDBY_PWR_SAVE_1;break;
      case spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_MMI_STANDBY_PWR_SAVE_2:  dia=DIA_EN_SPM_SYSTEM_STATE_MMI_STANDBY_PWR_SAVE_2;break;
      case spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_MMI_STANDBY:  dia=DIA_EN_SPM_SYSTEM_STATE_MMI_STANDBY;break;
      case spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_MMI_ON:  dia=DIA_EN_SPM_SYSTEM_STATE_MMI_ON;break;
      case spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_MMI_STANDBY_RESTRICTED:  dia=DIA_EN_SPM_SYSTEM_STATE_MMI_STANDBY_RESTRICTED;break;
      case spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_MMI_ON_DIAG:  dia=DIA_EN_SPM_SYSTEM_STATE_MMI_ON_DIAG;break;
      case spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_MMI_ON_TEL:  dia=DIA_EN_SPM_SYSTEM_STATE_MMI_ON_TEL;break;
      case spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_MMI_ON_SWDL:  dia=DIA_EN_SPM_SYSTEM_STATE_MMI_ON_SWDL;break;
      case spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_MMI_STANDBY_CUSTOMER_SWDL:  dia=DIA_EN_SPM_SYSTEM_STATE_MMI_STANDBY_CUSTOMER_SWDL;break;
      case spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_MMI_STANDBY_PWR_SAVE:  dia=DIA_EN_SPM_SYSTEM_STATE_MMI_STANDBY_PWR_SAVE;break;
      case spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_OVERTEMP:  dia=DIA_EN_SPM_SYSTEM_STATE_OVERTEMP;break;
      case spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_SAFE:  dia=DIA_EN_SPM_SYSTEM_STATE_SAFE;break;
      case spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_STATE_MAX:  dia=DIA_EN_SPM_SYSTEM_STATE_STATE_MAX;break;
         
      default: ok=false;dia=DIA_EN_SPM_SYSTEM_STATE_UNKNOWN;
   }
   return ok;
}
static bool dia_fiToDia(spm_fi_tcl_e8_StateEntryType const &fi, dia_eSpmStateEntry &dia) {
   bool ok=true;
   switch (fi.enType) {
      case spm_fi_tcl_e8_StateEntryType::FI_EN_SPM_E8_HISTORYENTRYWAKEUP:   dia=DIA_EN_SPM_STATE_ENTRY_WAKEUP;break;
      case spm_fi_tcl_e8_StateEntryType::FI_EN_SPM_E8_HISTORYENTRYSUBSTATE: dia=DIA_EN_SPM_STATE_ENTRY_SUBSTATE;break;
      case spm_fi_tcl_e8_StateEntryType::FI_EN_SPM_E8_HISTORYENTRYRESET:    dia=DIA_EN_SPM_STATE_ENTRY_RESET;break;

      default: ok=false;dia=DIA_EN_SPM_STATE_ENTRY_UNKNOWN;
   }
   return ok;
}


static bool dia_fiToDia(spm_fi_tcl_SPM_e32_WAKEUP_REASON const &fi, dia_eSpmWakeUpReason &dia) {
   bool ok=true;
   switch (fi.enType) {
      case spm_fi_tcl_SPM_e32_WAKEUP_REASON::FI_EN_SPM_U32_WAKEUP_INVALID: dia=DIA_EN_SPM_WAKEUP_REASON_UNKNOWN;break;
      case spm_fi_tcl_SPM_e32_WAKEUP_REASON::FI_EN_SPM_U32_WAKEUP_CAN: dia=DIA_EN_SPM_WAKEUP_REASON_CAN;break;
      case spm_fi_tcl_SPM_e32_WAKEUP_REASON::FI_EN_SPM_U32_WAKEUP_EJECT: dia=DIA_EN_SPM_WAKEUP_REASON_EJECT;break;
      case spm_fi_tcl_SPM_e32_WAKEUP_REASON::FI_EN_SPM_U32_WAKEUP_INSERT: dia=DIA_EN_SPM_WAKEUP_REASON_INSERT;break;
      case spm_fi_tcl_SPM_e32_WAKEUP_REASON::FI_EN_SPM_U32_WAKEUP_IGNITION: dia=DIA_EN_SPM_WAKEUP_REASON_IGNITION;break;
      case spm_fi_tcl_SPM_e32_WAKEUP_REASON::FI_EN_SPM_U32_WAKEUP_RTC: dia=DIA_EN_SPM_WAKEUP_REASON_RTC;break;
      case spm_fi_tcl_SPM_e32_WAKEUP_REASON::FI_EN_SPM_U32_WAKEUP_POWER_ON: dia=DIA_EN_SPM_WAKEUP_REASON_POWER_ON;break;
      case spm_fi_tcl_SPM_e32_WAKEUP_REASON::FI_EN_SPM_U32_WAKEUP_ON_TIPPER: dia=DIA_EN_SPM_WAKEUP_REASON_ON_TIPPER;break;
      case spm_fi_tcl_SPM_e32_WAKEUP_REASON::FI_EN_SPM_U32_WAKEUP_MOST: dia=DIA_EN_SPM_WAKEUP_REASON_MOST;break;
      case spm_fi_tcl_SPM_e32_WAKEUP_REASON::FI_EN_SPM_U32_WAKEUP_DEBUG_WAKEUP: dia=DIA_EN_SPM_WAKEUP_REASON_UNKNOWN;break;
      case spm_fi_tcl_SPM_e32_WAKEUP_REASON::FI_EN_SPM_U32_WAKEUP_DOOR_OPEN: dia=DIA_EN_SPM_WAKEUP_REASON_DOOR_OPEN;break;
      case spm_fi_tcl_SPM_e32_WAKEUP_REASON::FI_EN_SPM_U32_SDCARD_INSERT: dia=DIA_EN_SPM_WAKEUP_REASON_SDCARD_INSERT;break;
      case spm_fi_tcl_SPM_e32_WAKEUP_REASON::FI_EN_SPM_U32_WAKEUP_PHONE_MUTE: dia=DIA_EN_SPM_WAKEUP_REASON_PHONE_MUTE;break;
      case spm_fi_tcl_SPM_e32_WAKEUP_REASON::FI_EN_SPM_U32_WAKEUP_ACCESSORY: dia=DIA_EN_SPM_WAKEUP_REASON_ACCESSORY;break;
      case spm_fi_tcl_SPM_e32_WAKEUP_REASON::FI_EN_SPM_U32_WAKEUP_CELLNETWORK: dia=DIA_EN_SPM_WAKEUP_REASON_UNKNOWN;break;
      case spm_fi_tcl_SPM_e32_WAKEUP_REASON::FI_EN_SPM_U32_WAKEUP_CAN2: dia=DIA_EN_SPM_WAKEUP_REASON_CAN;break;
      case spm_fi_tcl_SPM_e32_WAKEUP_REASON::FI_EN_SPM_U32_WAKEUP_CAN3: dia=DIA_EN_SPM_WAKEUP_REASON_CAN;break;
      case spm_fi_tcl_SPM_e32_WAKEUP_REASON::FI_EN_SPM_U32_WAKEUP_CAN4: dia=DIA_EN_SPM_WAKEUP_REASON_CAN;break;
      case spm_fi_tcl_SPM_e32_WAKEUP_REASON::FI_EN_SPM_U32_WAKEUP_ODOMETER: dia=DIA_EN_SPM_WAKEUP_REASON_UNKNOWN;break;
      case spm_fi_tcl_SPM_e32_WAKEUP_REASON::FI_EN_SPM_U32_WAKEUP_LIN: dia=DIA_EN_SPM_WAKEUP_REASON_UNKNOWN;break;
      case spm_fi_tcl_SPM_e32_WAKEUP_REASON::FI_EN_SPM_U32_WAKEUP_ACCELLERATOR_SENSOR: dia=DIA_EN_SPM_WAKEUP_REASON_UNKNOWN;break;
      case spm_fi_tcl_SPM_e32_WAKEUP_REASON::FI_EN_SPM_U32_WAKEUP_EXTERNAL_GPIO: dia=DIA_EN_SPM_WAKEUP_REASON_UNKNOWN;break;
      case spm_fi_tcl_SPM_e32_WAKEUP_REASON::FI_EN_SPM_U32_WAKEUP_EXTERNAL_GPIO2: dia=DIA_EN_SPM_WAKEUP_REASON_UNKNOWN;break;
      case spm_fi_tcl_SPM_e32_WAKEUP_REASON::FI_EN_SPM_U32_WAKEUP_EXTERNAL_GPIO3: dia=DIA_EN_SPM_WAKEUP_REASON_UNKNOWN;break;
      case spm_fi_tcl_SPM_e32_WAKEUP_REASON::FI_EN_SPM_U32_WAKEUP_EXTERNAL_GPIO4: dia=DIA_EN_SPM_WAKEUP_REASON_UNKNOWN;break;
      case spm_fi_tcl_SPM_e32_WAKEUP_REASON::FI_EN_SPM_U32_WAKEUP_BLUETOOTH: dia=DIA_EN_SPM_WAKEUP_REASON_UNKNOWN;break;
      case spm_fi_tcl_SPM_e32_WAKEUP_REASON::FI_EN_SPM_U32_WAKEUP_USB: dia=DIA_EN_SPM_WAKEUP_REASON_UNKNOWN;break;
      case spm_fi_tcl_SPM_e32_WAKEUP_REASON::FI_EN_SPM_U32_WAKEUP_UART: dia=DIA_EN_SPM_WAKEUP_REASON_UNKNOWN;break;
      case spm_fi_tcl_SPM_e32_WAKEUP_REASON::FI_EN_SPM_U32_WAKEUP_UART2: dia=DIA_EN_SPM_WAKEUP_REASON_UNKNOWN;break;
      case spm_fi_tcl_SPM_e32_WAKEUP_REASON::FI_EN_SPM_U32_WAKEUP_RESET: dia=DIA_EN_SPM_WAKEUP_REASON_RESET;break;
      case spm_fi_tcl_SPM_e32_WAKEUP_REASON::FI_EN_SPM_U32_WAKEUP_RESTART: dia=DIA_EN_SPM_WAKEUP_REASON_RESTART;break;

      default: ok=false;dia=DIA_EN_SPM_WAKEUP_REASON_UNKNOWN;
   }
   return ok;
}

static spm_fi_tcl_SPM_e32_SubStateType::tenType aSpmShutdownMode2SubStateMapping[DIA_EN_SPM_SHUTDOWN_MODE_COUNT] =
{
   spm_fi_tcl_SPM_e32_SubStateType::FI_EN_SPM_U32_SUBSTATE_SET_SD_CARD_ACCESS, // dummy value that should never be used if restart type is DIA_EN_SPM_CORE_RESTART_MODE_UNKNOWN
   spm_fi_tcl_SPM_e32_SubStateType::FI_EN_SPM_U32_SUBSTATE_DIAG_FAST_SHUTDOWN, // DIA_EN_SPM_SHUTDOWN_MODE_FAST
   spm_fi_tcl_SPM_e32_SubStateType::FI_EN_SPM_U32_SUBSTATE_OFF_LASTSTATE_CYCLE // DIA_EN_SPM_SHUTDOWN_MODE_OFF_LASTSTATE
};

static bool diaToDia_fi(dia_eSpmSubState const &dia, spm_fi_tcl_SPM_e32_SubStateType &fi) 
{
   bool ok=true;
   switch (dia) 
   {
      case DIA_EN_SPM_SUBSTATE_DIAGNOSIS_ACTIVITY: fi.enType=spm_fi_tcl_SPM_e32_SubStateType::FI_EN_SPM_U32_SUBSTATE_DIAG_ACTIVITY;break;
      case DIA_EN_SPM_SUBSTATE_FAST_SHUTDOWN: fi.enType=spm_fi_tcl_SPM_e32_SubStateType::FI_EN_SPM_U32_SUBSTATE_FAST_SHUTDOWN;break;
      case DIA_EN_SPM_SUBSTATE_DIAGNOSIS_MODE: fi.enType=spm_fi_tcl_SPM_e32_SubStateType::FI_EN_SPM_U32_SUBSTATE_DIAGNOSIS;break;
      case DIA_EN_SPM_SUBSTATE_IGNITION: fi.enType=spm_fi_tcl_SPM_e32_SubStateType::FI_EN_SPM_U32_SUBSTATE_IGNITION;break;
      case DIA_EN_SPM_SUBSTATE_ACCESSORY: fi.enType=spm_fi_tcl_SPM_e32_SubStateType::FI_EN_SPM_U32_SUBSTATE_S_CONTACT;break;
      case DIA_EN_SPM_SUBSTATE_ON_TIPPER: fi.enType=spm_fi_tcl_SPM_e32_SubStateType::FI_EN_SPM_U32_SUBSTATE_ON_TIPPER;break;
      case DIA_EN_SPM_SUBSTATE_DIAGNOSIS_REQUEST: fi.enType=spm_fi_tcl_SPM_e32_SubStateType::FI_EN_SPM_U32_SUBSTATE_DIAG_REQUEST;break;
      default: ok=false; DIA_ASSERT_ALWAYS(); break;
   }
   return ok;
}

//check size of system state, expected size is 4.
ct_assert(sizeof(spm_fi_tcl_SPM_e32_SYSTEM_STATES::enType)==4);

//check size of wakeup reason, expected size is 4.
ct_assert(sizeof(spm_fi_tcl_SPM_e32_WAKEUP_REASON::enType)==4);

//check size of substate, expected size is 4.
ct_assert(sizeof(spm_fi_tcl_SPM_e32_SubStateType::enType)==4);

//------------------------------------------------------------------------------
ct_assert((uint32_t)spm_fi_tcl_SPM_e32_SubStateType::FI_EN_SPM_U32_SUBSTATE_DIAG_ACTIVITY == (uint32_t)DIA_EN_SPM_SUBSTATE_DIAGNOSIS_ACTIVITY);
ct_assert((uint32_t)spm_fi_tcl_SPM_e32_SubStateType::FI_EN_SPM_U32_SUBSTATE_FAST_SHUTDOWN == (uint32_t)DIA_EN_SPM_SUBSTATE_FAST_SHUTDOWN);
ct_assert((uint32_t)spm_fi_tcl_SPM_e32_SubStateType::FI_EN_SPM_U32_SUBSTATE_DIAGNOSIS     == (uint32_t)DIA_EN_SPM_SUBSTATE_DIAGNOSIS_MODE);
ct_assert((uint32_t)spm_fi_tcl_SPM_e32_SubStateType::FI_EN_SPM_U32_SUBSTATE_IGNITION      == (uint32_t)DIA_EN_SPM_SUBSTATE_IGNITION);
ct_assert((uint32_t)spm_fi_tcl_SPM_e32_SubStateType::FI_EN_SPM_U32_SUBSTATE_S_CONTACT     == (uint32_t)DIA_EN_SPM_SUBSTATE_ACCESSORY);
ct_assert((uint32_t)spm_fi_tcl_SPM_e32_SubStateType::FI_EN_SPM_U32_SUBSTATE_ON_TIPPER     == (uint32_t)DIA_EN_SPM_SUBSTATE_ON_TIPPER);
ct_assert((uint32_t)spm_fi_tcl_SPM_e32_SubStateType::FI_EN_SPM_U32_SUBSTATE_DIAG_REQUEST  == (uint32_t)DIA_EN_SPM_SUBSTATE_DIAGNOSIS_REQUEST);


//###################### visitors for dia_ISpm.h / dia_ISpmSVP.h
//###################### visitors for sub-structures for dia_ISpm.h / dia_ISpmSVP.h
static void visitMsg(dia_tSpmResetCounterStatus const &dia, dia::MsgVisitor &visitor) {
   DIA_VISIT_MSG_FIELD(dia, mLastResetReason, visitor);
   DIA_VISIT_MSG_FIELD(dia, mApApplicationError, visitor);
   DIA_VISIT_MSG_FIELD(dia, mApSoftware, visitor);
   DIA_VISIT_MSG_FIELD(dia, mApEcuReset, visitor);
   DIA_VISIT_MSG_FIELD(dia, mApDownload, visitor);
   DIA_VISIT_MSG_FIELD(dia, mApDownloadError, visitor);
   DIA_VISIT_MSG_FIELD(dia, mApOvertemperature, visitor);
   DIA_VISIT_MSG_FIELD(dia, mApUser, visitor);
   DIA_VISIT_MSG_FIELD(dia, mApLcmIntern, visitor);
   DIA_VISIT_MSG_FIELD(dia, mApWarmstartCount, visitor);
   DIA_VISIT_MSG_FIELD(dia, mApPowerOnCount, visitor);
   DIA_VISIT_MSG_FIELD(dia, mApPowerLossCount, visitor);
   DIA_VISIT_MSG_FIELD(dia, mApPowerOffCount, visitor);
   DIA_VISIT_MSG_FIELD(dia, mApSccCount, visitor);
   DIA_VISIT_MSG_FIELD(dia, mApUnknownCount, visitor);
   DIA_VISIT_MSG_FIELD(dia, mSccHwWdtCount, visitor);
   DIA_VISIT_MSG_FIELD(dia, mSccPowerOnCount, visitor);
   DIA_VISIT_MSG_FIELD(dia, mSccColdstartCount, visitor);
   DIA_VISIT_MSG_FIELD(dia, mSccAppmodeChangeCount, visitor);
   DIA_VISIT_MSG_FIELD(dia, mSccDuringLpwCount, visitor);
   DIA_VISIT_MSG_FIELD(dia, mSccDuringPllOszCount, visitor);
   DIA_VISIT_MSG_FIELD(dia, mSccDuringSWCount, visitor);
   DIA_VISIT_MSG_FIELD(dia, mSccWarmstartCount, visitor);
}


static void visitMsg(dia_tSpmStatisticData const &dia, dia::MsgVisitor &visitor) {
   DIA_VISIT_MSG_FIELD(dia, mMaxValue, visitor);
   DIA_VISIT_MSG_FIELD(dia, mAvgValue, visitor);
   DIA_VISIT_MSG_FIELD(dia, mMinValue, visitor);
}

static void visitMsg(dia_tSpmTimeDate const &dia, dia::MsgVisitor &visitor) {
   DIA_VISIT_MSG_FIELD(dia, mYear, visitor);
   DIA_VISIT_MSG_FIELD(dia, mMonth, visitor);
   DIA_VISIT_MSG_FIELD(dia, mDay, visitor);
   DIA_VISIT_MSG_FIELD(dia, mHour, visitor);
   DIA_VISIT_MSG_FIELD(dia, mMinute, visitor);
   DIA_VISIT_MSG_FIELD(dia, mSecond, visitor);
}

static void visitMsg(dia_tSpmSVPWakeupReasonElement const &dia, dia::MsgVisitor &visitor) {
   DIA_VISIT_MSG_SECTION(dia, mTimeDate, visitor);
   DIA_VISIT_MSG_ENUM(dia, mReason, visitor);
}


static void visitMsg(dia_tSpmSVPResetElement const &dia, dia::MsgVisitor &visitor) {
   DIA_VISIT_MSG_SECTION(dia, mTimeDate, visitor);
   DIA_VISIT_MSG_FIELD(dia, mReason, visitor);
}


static void visitMsg(dia_tSpmSVPSubStateElement const &dia, dia::MsgVisitor &visitor) {
   DIA_VISIT_MSG_FIELD(dia, mMask, visitor);
   DIA_VISIT_MSG_FIELD(dia, mData, visitor);
}

static void visitMsg(dia_tSpmSVPStateHistoryElement const &dia, dia::MsgVisitor &visitor) {
   DIA_VISIT_MSG_SECTION(dia, mTimeDate, visitor);
   DIA_VISIT_MSG_FIELD(dia, mSystemState, visitor);
   DIA_VISIT_MSG_ENUM(dia, mEntryType, visitor);
   DIA_VISIT_MSG_LIST(dia, mSubStatesList, visitor);
   DIA_VISIT_MSG_ENUM(dia, mWakeUpReason, visitor);
   DIA_VISIT_MSG_FIELD(dia, mResetReason, visitor);
}

static void visitMsg(dia_tSpmSVPSwVersionInfo const &dia, dia::MsgVisitor &visitor) {
   //DIA_VISIT_MSG_FIELD(dia, mIndex, visitor);
   DIA_VISIT_MSG_FIELD(dia, mCustomerVersion, visitor);
   DIA_VISIT_MSG_FIELD(dia, mBuildVersion, visitor);
   DIA_VISIT_MSG_FIELD(dia, mBuildVersionLabel, visitor);
}



//###################### visitors for structures for dia_ISpm.h / dia_ISpmSVP.h
static void visitMsg(dia_tSpmSVPResetInformationForSWVersion const &dia, dia::MsgVisitor &visitor) {
   DIA_VISIT_MSG_SECTION(dia, mVersion, visitor);
   DIA_VISIT_MSG_SECTION(dia, mData, visitor);
}

static void visitMsg(dia_tSpmSVPWakeupHistoryForSWVersion const &dia, dia::MsgVisitor &visitor) {
   DIA_VISIT_MSG_SECTION(dia, mVersion, visitor);
   DIA_VISIT_MSG_LIST(dia, mList, visitor);
}

static void visitMsg(dia_tSpmSVPResetHistoryForSWVersion const &dia, dia::MsgVisitor &visitor) {
   DIA_VISIT_MSG_SECTION(dia, mVersion, visitor);
   DIA_VISIT_MSG_LIST(dia, mList, visitor);
}

static void visitMsg(dia_tSpmSVPStateHistoryForSWVersion const &dia, dia::MsgVisitor &visitor) {
   DIA_VISIT_MSG_SECTION(dia, mVersion, visitor);
   DIA_VISIT_MSG_LIST(dia, mList, visitor);
}

static void visitMsg(dia_tSpmSVPErrorStateHistoryForSWVersion const &dia, dia::MsgVisitor &visitor) {
   DIA_VISIT_MSG_SECTION(dia, mVersion, visitor);
   DIA_VISIT_MSG_LIST(dia, mList, visitor);
}

static void visitMsg(dia_tSpmSVPSystemOperationTimeForSWVersion const &dia, dia::MsgVisitor &visitor) {
   DIA_VISIT_MSG_SECTION(dia, mVersion, visitor);
   DIA_VISIT_MSG_FIELD(dia, mTimeInSeconds, visitor);
}

static void visitMsg(dia_tSpmSVPAverageCpuLoadForSWVersion const &dia, dia::MsgVisitor &visitor) {
   DIA_VISIT_MSG_SECTION(dia, mVersion, visitor);
   DIA_VISIT_MSG_SECTION(dia, mData, visitor);
}

static void visitMsg(dia_tSpmSVPMaximumRamConsumptionForSWVersion const &dia, dia::MsgVisitor &visitor) {
   DIA_VISIT_MSG_SECTION(dia, mVersion, visitor);
   DIA_VISIT_MSG_SECTION(dia, mData, visitor);
}

static void visitMsg(dia_tSpmSVPStartupTimeStatisticForSWVersion const &dia, dia::MsgVisitor &visitor) {
   DIA_VISIT_MSG_SECTION(dia, mVersion, visitor);
   DIA_VISIT_MSG_SECTION(dia, mData, visitor);
}


//###################### vitors for spm_fi
static void visitMsg(spm_fi_tclTimeDate const &fi, dia::MsgVisitor &visitor) {
   DIA_VISIT_MSG_FIELD(fi, s16Year, visitor);
   DIA_VISIT_MSG_FIELD(fi, u8Month, visitor);
   DIA_VISIT_MSG_FIELD(fi, u8Day, visitor);
   DIA_VISIT_MSG_FIELD(fi, u8Hour, visitor);
   DIA_VISIT_MSG_FIELD(fi, u8Minute, visitor);
   DIA_VISIT_MSG_FIELD(fi, u8Second, visitor);

}

static void visitMsg(spm_fi_tclSwVersionInfo const &fi, dia::MsgVisitor &visitor) {
   DIA_VISIT_MSG_FIELD(fi, tSwBuildVersion, visitor);
   DIA_VISIT_MSG_FIELD(fi, tSwCustomerVersion, visitor);
}

static void visitMsg(spm_fi_tcl_ResetElement const &fi, dia::MsgVisitor &visitor) {
   DIA_VISIT_MSG_SECTION(fi, tResetDate, visitor);
   DIA_VISIT_MSG_SECTION(fi, tSwVersionInfo, visitor);
   DIA_VISIT_MSG_FIENUM(fi, eReset, visitor);
}

static void visitMsg(spm_fi_tcl_WakeupElement const &fi, dia::MsgVisitor &visitor) {
   DIA_VISIT_MSG_SECTION(fi, tWakeupDate, visitor);
   DIA_VISIT_MSG_FIENUM(fi, eWakeupReason, visitor);
}

/*static void visitMsg(spm_fi_tcl_SwitchOnElement const &fi, dia::MsgVisitor &visitor) {
   DIA_VISIT_MSG_SECTION(fi, tSwitchOnDate, visitor);
   DIA_VISIT_MSG_FIENUM(fi, eSwitchOnReason, visitor);
}*/

static void visitMsg(spm_fi_tcl_SubStateEntry const &fi, dia::MsgVisitor &visitor) {
   DIA_VISIT_MSG_FIELD(fi, tSubStateMask0.u32Value, visitor);
   DIA_VISIT_MSG_FIELD(fi, tSubStateData0.u32Value, visitor);
   DIA_VISIT_MSG_FIELD(fi, tSubStateMask1.u32Value, visitor);
   DIA_VISIT_MSG_FIELD(fi, tSubStateData1.u32Value, visitor);
   DIA_VISIT_MSG_FIELD(fi, tSubStateMask2.u32Value, visitor);
   DIA_VISIT_MSG_FIELD(fi, tSubStateData2.u32Value, visitor);
   DIA_VISIT_MSG_FIELD(fi, tSubStateMask3.u32Value, visitor);
   DIA_VISIT_MSG_FIELD(fi, tSubStateData3.u32Value, visitor);
}

static void visitMsg(spm_fi_tcl_StateChangeElement const &fi, dia::MsgVisitor &visitor) {
   DIA_VISIT_MSG_SECTION(fi, tWakeupDate, visitor);
   DIA_VISIT_MSG_FIENUM(fi, tSysState, visitor);
   DIA_VISIT_MSG_FIENUM(fi, tElemType, visitor);
   DIA_VISIT_MSG_FIENUM(fi, tWakeup, visitor);
   DIA_VISIT_MSG_FIENUM(fi, tReset, visitor);
   DIA_VISIT_MSG_SECTION(fi, tSubStates, visitor);
}
/*
static void visitMsg(spm_fi_tcl_SPM_SystemStatisticsData const &fi, dia::MsgVisitor &visitor) {
   DIA_VISIT_MSG_FIELD(fi, MaxValue, visitor);
   DIA_VISIT_MSG_FIELD(fi, AvgValue, visitor);
   DIA_VISIT_MSG_FIELD(fi, MinValue, visitor);
}

static void visitMsg(spm_fi_tcl_SPM_ResetInfoStatisticData const &fi, dia::MsgVisitor &visitor) {
   DIA_VISIT_MSG_SECTION(fi, tLastResetDate, visitor);
   DIA_VISIT_MSG_FIENUM(fi, tLastResetReason, visitor);
   DIA_VISIT_MSG_FIELD(fi, u32ApApplicationError, visitor);
   DIA_VISIT_MSG_FIELD(fi, u32ApSoftware, visitor);
   DIA_VISIT_MSG_FIELD(fi, u32ApEcuReset, visitor);
   DIA_VISIT_MSG_FIELD(fi, u32ApDownload, visitor);
   DIA_VISIT_MSG_FIELD(fi, u32ApDownloadError, visitor);
   DIA_VISIT_MSG_FIELD(fi, u32ApOvertemperature, visitor);
   DIA_VISIT_MSG_FIELD(fi, u32ApUser, visitor);
   DIA_VISIT_MSG_FIELD(fi, u32ApLcmIntern, visitor);
   DIA_VISIT_MSG_FIELD(fi, u32ApWarmstartCount, visitor);
   DIA_VISIT_MSG_FIELD(fi, u32ApPowerOnCount, visitor);
   DIA_VISIT_MSG_FIELD(fi, u32ApPowerLossCount, visitor);
   DIA_VISIT_MSG_FIELD(fi, u32ApPowerOffCount, visitor);
   DIA_VISIT_MSG_FIELD(fi, u32ApSccCount, visitor);
   DIA_VISIT_MSG_FIELD(fi, u32ApUnknownCount, visitor);
   DIA_VISIT_MSG_FIELD(fi, u32SccHwWdtCount, visitor);
   DIA_VISIT_MSG_FIELD(fi, u32SccPowerOnCount, visitor);
   DIA_VISIT_MSG_FIELD(fi, u32SccColdstartCount, visitor);
   DIA_VISIT_MSG_FIELD(fi, u32SccAppmodeChangeCount, visitor);
   DIA_VISIT_MSG_FIELD(fi, u32SccDuringLpwCount, visitor);
   DIA_VISIT_MSG_FIELD(fi, u32SccDuringPllOszCount, visitor);
   DIA_VISIT_MSG_FIELD(fi, u32SccDuringSWCount, visitor);
   DIA_VISIT_MSG_FIELD(fi, u32SccWarmstartCount, visitor);
}

static void visitMsg(spm_fi_tcl_SPM_SWVersionStatisticData const &fi, dia::MsgVisitor &visitor) {
   DIA_VISIT_MSG_FIELD(fi, strBuildVersion, visitor);
   DIA_VISIT_MSG_FIELD(fi, strBuildVersionCustomer, visitor);
   DIA_VISIT_MSG_FIELD(fi, strCustomerVersion, visitor);
   DIA_VISIT_MSG_SECTION(fi, tResetInfo, visitor);
   DIA_VISIT_MSG_LIST(fi, tResetHistoryList, visitor);
   DIA_VISIT_MSG_LIST(fi, tWakeupHistoryList, visitor);
   DIA_VISIT_MSG_LIST(fi, tSwitchOnList, visitor);
   DIA_VISIT_MSG_LIST(fi, tStateHistoryList, visitor);
   DIA_VISIT_MSG_LIST(fi, tErrStateHistory01List, visitor);
   DIA_VISIT_MSG_LIST(fi, tErrStateHistory02List, visitor);
   DIA_VISIT_MSG_LIST(fi, tErrStateHistory03List, visitor);
   DIA_VISIT_MSG_LIST(fi, tErrStateHistory04List, visitor);
   DIA_VISIT_MSG_LIST(fi, tErrStateHistory05List, visitor);
   DIA_VISIT_MSG_FIELD(fi, u32SystemOperationTime, visitor);
   DIA_VISIT_MSG_SECTION(fi, tCpuUsage, visitor);
   DIA_VISIT_MSG_SECTION(fi, tRamUsage, visitor);
   DIA_VISIT_MSG_SECTION(fi, tStartupTime, visitor);
}
*/
#ifdef DIA_SPECIFIC_SW_VERSION_STATISTIC_VERBOSE
static void visitMsg(spm_corefi_tclMsgSpecificSWVersionStatisticMethodResult const &fi, dia::MsgVisitor &visitor) {
   DIA_VISIT_MSG_SECTION(fi, tSWVersionStatistic, visitor)
}
#endif


//########################## coverters spm-fi -> dia ######################
static bool dia_fiToDia(spm_fi_tcl_SPM_SystemStatisticsData const &fi, dia_tSpmStatisticData &dia) {
   dia.mMaxValue =fi.MaxValue;
   dia.mAvgValue =fi.AvgValue;
   dia.mMinValue =fi.MinValue;

   DIA_TR_INF("   mMaxValue=%u", dia.mMaxValue);
   DIA_TR_INF("   mAvgValue=%u", dia.mAvgValue);
   DIA_TR_INF("   mMinValue=%u", dia.mMinValue);

   return true;
}

static bool dia_fiToDia(spm_fi_tcl_SPM_SWVersionStatisticData const &fi, dia_tSpmSVPSwVersionInfo &dia) {
   dia.mCustomerVersion=fi.strCustomerVersion;
   dia.mBuildVersion=fi.strBuildVersionCustomer;
   dia.mBuildVersionLabel=fi.strBuildVersion;
   return true;
}

static bool dia_fiToDia(spm_fi_tclTimeDate const &fi, dia_tSpmTimeDate &dia) {
   dia.mYear=(tU16)fi.s16Year;
   dia.mMonth=fi.u8Month;
   dia.mDay=fi.u8Day;
   dia.mHour=fi.u8Hour;
   dia.mMinute=fi.u8Minute;
   dia.mSecond=fi.u8Second;
   return true;
}

//-------- ResetInformationForSWVersion ---------------------------------------

static bool dia_fiToDia(spm_fi_tcl_SPM_ResetInfoStatisticData const &fi, dia_tSpmResetCounterStatus &dia) {
   //dia_fiToDia(fi.tLastResetDate, dia.mLastResetTimeDate);
   dia.mLastResetReason=(tU8)fi.tLastResetReason.enType;
   dia.mApApplicationError=fi.u32ApApplicationError;
   dia.mApSoftware=fi.u32ApSoftware;
   dia.mApEcuReset=fi.u32ApEcuReset;
   dia.mApDownload=fi.u32ApDownload;
   dia.mApDownloadError=fi.u32ApDownloadError;
   dia.mApOvertemperature=fi.u32ApOvertemperature;
   dia.mApUser=fi.u32ApUser;
   dia.mApLcmIntern=fi.u32ApLcmIntern;
   dia.mApWarmstartCount=fi.u32ApWarmstartCount;
   dia.mApPowerOnCount=fi.u32ApPowerOnCount;
   dia.mApPowerLossCount=fi.u32ApPowerLossCount;
   dia.mApPowerOffCount=fi.u32ApPowerOffCount;
   dia.mApSccCount=fi.u32ApSccCount;
   dia.mApUnknownCount=fi.u32ApUnknownCount;
   dia.mSccHwWdtCount=fi.u32SccHwWdtCount;
   dia.mSccPowerOnCount=fi.u32SccPowerOnCount;
   dia.mSccColdstartCount=fi.u32SccColdstartCount;
   dia.mSccAppmodeChangeCount=fi.u32SccAppmodeChangeCount;
   dia.mSccDuringLpwCount=fi.u32SccDuringLpwCount;
   dia.mSccDuringPllOszCount=fi.u32SccDuringPllOszCount;
   dia.mSccDuringSWCount=fi.u32SccDuringSWCount;
   dia.mSccWarmstartCount=fi.u32SccWarmstartCount;
   return true;
}


template<class MSG>
void printMsg(char const *name, MSG const &msg) {
   if (isTraceActive()) {
      dia::MsgPrinter diaPrinter(name);
      visitMsg(msg, diaPrinter);
   }

}

static bool dia_fiToDia(spm_corefi_tclMsgSpecificSWVersionStatisticMethodResult const &fi, dia_tSpmSVPResetInformationForSWVersion &dia) {
   dia_fiToDia(fi.tSWVersionStatistic, dia.mVersion);
   dia_fiToDia(fi.tSWVersionStatistic.tResetInfo, dia.mData);

   printMsg("dia_tSpmSVPResetInformationForSWVersion", dia);
   return true;
}

//-------- WakeupReasonForSWVersion ---------------------------------------


template<class FIELEM, class DIAG_ELEM>
static bool dia_fiToDia(std::vector<FIELEM> const &fiList, std::vector<DIAG_ELEM> &diaList) {
   for(uint32_t i=0;i< fiList.size();++i) {
      DIAG_ELEM diaElem;
      dia_fiToDia(fiList[i], diaElem);
      diaList.push_back(diaElem);
   }
   return true;
}

static bool dia_fiToDia(spm_fi_tcl_WakeupElement const &fi, dia_tSpmSVPWakeupReasonElement &dia) {
   dia_fiToDia(fi.tWakeupDate, dia.mTimeDate);
   dia_fiToDia(fi.eWakeupReason, dia.mReason);
   return true;
}


static bool dia_fiToDia(spm_corefi_tclMsgSpecificSWVersionStatisticMethodResult const &fi, dia_tSpmSVPWakeupHistoryForSWVersion &dia) {
   spm_fi_tcl_SPM_SWVersionStatisticData const &fiField=fi.tSWVersionStatistic;

   if (isTraceActive()) {
      dia::MsgPrinter fiFrinter("spm_corefi_tclMsgSpecificSWVersionStatisticMethodResult");
      PRINT_SPM_FI_SWVERSION(fiField, fiFrinter)
      DIA_VISIT_MSG_LIST(fiField, tWakeupHistoryList, fiFrinter);
   }

   dia_fiToDia(fiField, dia.mVersion);
   dia_fiToDia(fiField.tWakeupHistoryList, dia.mList);

   printMsg("dia_tSpmSVPWakeupHistoryForSWVersion", dia);

   return true;
}


//-------- ResetHistoryForSWVersion ---------------------------------------
static bool dia_fiToDia(spm_fi_tcl_ResetElement const &fi, dia_tSpmSVPResetElement &dia) {
   dia_fiToDia(fi.tResetDate, dia.mTimeDate);
   dia.mReason=fi.eReset.enType;
   return true;
}

static bool dia_fiToDia(spm_corefi_tclMsgSpecificSWVersionStatisticMethodResult const &fi, dia_tSpmSVPResetHistoryForSWVersion &dia) {
   dia::ScopeTrace trc("dia_fiToDia(spm_corefi_tclMsgSpecificSWVersionStatisticMethodResult, dia_tSpmSVPResetHistoryForSWVersion");

   spm_fi_tcl_SPM_SWVersionStatisticData const &fiField=fi.tSWVersionStatistic;
   if (isTraceActive()) {
      dia::MsgPrinter fiFrinter("spm_corefi_tclMsgSpecificSWVersionStatisticMethodResult");
      PRINT_SPM_FI_SWVERSION(fiField, fiFrinter)
      DIA_VISIT_MSG_LIST(fiField, tResetHistoryList, fiFrinter);
   }

   dia_fiToDia(fiField, dia.mVersion);
   dia_fiToDia(fiField.tResetHistoryList, dia.mList);

   printMsg("dia_tSpmSVPResetHistoryForSWVersion", dia);

   return true;
}

//-------- StateHistoryForSWVersion ---------------------------------------

static bool dia_fiToDia(spm_fi_tcl_e8_LcmResetReason const &fi, uint8_t &dia) {
   dia=(uint8_t)fi.enType;
   return true;
}

template<class SPMSUBSTATE>
static bool dia_fiToDia(SPMSUBSTATE const &fiMask, SPMSUBSTATE const &fiValue, dia_tSpmSVPSubStateElement &dia) {
   dia.mMask=fiMask.u32Value;
   dia.mData=fiValue.u32Value;
   return true;
}

static bool dia_fiToDia(spm_fi_tcl_SubStateEntry const &fi, std::vector<dia_tSpmSVPSubStateElement> &dia) {
   dia=std::vector<dia_tSpmSVPSubStateElement>(4);
   dia_fiToDia(fi.tSubStateMask0, fi.tSubStateData0, dia[0]);
   dia_fiToDia(fi.tSubStateMask1, fi.tSubStateData1, dia[1]);
   dia_fiToDia(fi.tSubStateMask2, fi.tSubStateData2, dia[2]);
   dia_fiToDia(fi.tSubStateMask3, fi.tSubStateData3, dia[3]);
   return true;
}


static bool dia_fiToDia(spm_fi_tcl_StateChangeElement const &fi, dia_tSpmSVPStateHistoryElement &dia) {
   dia_fiToDia(fi.tWakeupDate, dia.mTimeDate);
   dia.mSystemState =(uint32_t)fi.tSysState.enType;
   dia_fiToDia(fi.tElemType, dia.mEntryType);
   dia_fiToDia(fi.tSubStates, dia.mSubStatesList);
   dia_fiToDia(fi.tWakeup, dia.mWakeUpReason);
   dia_fiToDia(fi.tReset, dia.mResetReason);
   return true;
}


static bool dia_fiToDia(spm_corefi_tclMsgSpecificSWVersionStatisticMethodResult const &fi, dia_tSpmSVPStateHistoryForSWVersion &dia) {
   spm_fi_tcl_SPM_SWVersionStatisticData const &fiField=fi.tSWVersionStatistic;

   if (isTraceActive()) {
      dia::MsgPrinter fiFrinter("spm_corefi_tclMsgSpecificSWVersionStatisticMethodResult");
      PRINT_SPM_FI_SWVERSION(fiField, fiFrinter)
      DIA_VISIT_MSG_LIST(fiField, tStateHistoryList, fiFrinter);
   }

   dia_fiToDia(fiField, dia.mVersion);
   dia_fiToDia(fiField.tStateHistoryList, dia.mList);

   printMsg("dia_tSpmSVPStateHistoryForSWVersion", dia);

   return true;
}



//-------- ErrorStateHistoryForSWVersion ---------------------------------------



 static bool dia_fiToDia(spm_corefi_tclMsgSpecificSWVersionStatisticMethodResult const &fi, dia_tSpmSVPErrorStateHistoryForSWVersion &dia, tU8 errorStateIndex) {
   spm_fi_tcl_SPM_SWVersionStatisticData const &fiField=fi.tSWVersionStatistic;

   bool res=false;
   dia_fiToDia(fiField, dia.mVersion);
   switch(errorStateIndex) {
      case 1:
         res = dia_fiToDia(fiField.tErrStateHistory01List, dia.mList);
         break;
      case 2:
         res = dia_fiToDia(fiField.tErrStateHistory02List, dia.mList);
         break;
      case 3:
         res = dia_fiToDia(fiField.tErrStateHistory03List, dia.mList);
         break;
      case 4:
         res = dia_fiToDia(fiField.tErrStateHistory04List, dia.mList);
         break;
      case 5:
         res = dia_fiToDia(fiField.tErrStateHistory05List, dia.mList);
         break;
      default:
         break;;
   }

   printMsg("dia_tSpmSVPErrorStateHistoryForSWVersion", dia);

   return res;
}


//-------- SystemOperationTimeForSWVersion ---------------------------------------



static bool dia_fiToDia(spm_corefi_tclMsgSpecificSWVersionStatisticMethodResult const &fi, dia_tSpmSVPSystemOperationTimeForSWVersion &dia) {
   spm_fi_tcl_SPM_SWVersionStatisticData const &fiField=fi.tSWVersionStatistic;
   dia_fiToDia(fiField, dia.mVersion);
   dia.mTimeInSeconds=fiField.u32SystemOperationTime;
   printMsg("dia_tSpmSVPSystemOperationTimeForSWVersion", dia);
   return true;
}


//-------- AverageCpuLoadForSWVersion ---------------------------------------
static bool dia_fiToDia(spm_corefi_tclMsgSpecificSWVersionStatisticMethodResult const &fi, dia_tSpmSVPAverageCpuLoadForSWVersion &dia) {
   spm_fi_tcl_SPM_SWVersionStatisticData const &fiField=fi.tSWVersionStatistic;
   dia_fiToDia(fiField, dia.mVersion);
   dia_fiToDia(fiField.tCpuUsage, dia.mData);
   printMsg("dia_tSpmSVPAverageCpuLoadForSWVersion", dia);
   return true;
}

//-------- MaximumRamConsumptionForSWVersion ---------------------------------------
static bool dia_fiToDia(spm_corefi_tclMsgSpecificSWVersionStatisticMethodResult const &fi, dia_tSpmSVPMaximumRamConsumptionForSWVersion &dia) {
   spm_fi_tcl_SPM_SWVersionStatisticData const &fiField=fi.tSWVersionStatistic;
   dia_fiToDia(fiField, dia.mVersion);
   dia_fiToDia(fiField.tRamUsage, dia.mData);
   printMsg("dia_tSpmSVPMaximumRamConsumptionForSWVersion", dia);
   return true;
}

//-------- MaximumRamConsumptionForSWVersion ---------------------------------------
static bool dia_fiToDia(spm_corefi_tclMsgSpecificSWVersionStatisticMethodResult const &fi, dia_tSpmSVPStartupTimeStatisticForSWVersion &dia) {
   spm_fi_tcl_SPM_SWVersionStatisticData const &fiField=fi.tSWVersionStatistic;
   dia_fiToDia(fiField, dia.mVersion);
   dia_fiToDia(fiField.tStartupTime, dia.mData);
   printMsg("dia_tSpmSVPStartupTimeStatisticForSWVersion", dia);
   return true;
}


//-----------------------------------------------------------------------------------------
dia_SAFeatureSpmBase::dia_SAFeatureSpmBase(tCString name, dia_SystemAdapterServicePlugin& pSrvPlugin)
   : dia_SystemAdapterFeature(name, pSrvPlugin),
     mSystemState(DIA_EN_SPM_SYSTEM_STATE_UNKNOWN),
     mHmiState(DIA_EN_SPM_HMI_STATE_UNKNOWN),
     mCVMState(DIA_EN_SPM_CVM_STATE_VOLTAGE_UNKNOWN),
     mCVMEvent(DIA_EN_SPM_CVM_EVENT_UNKNOWN),
     mLastRequestedErrState(DIA_EN_SPM_ERR_STATE_UNKNOWN),
     mCmdCounter(10)
{
   dia_tclFnctTrace trc("dia_SAFeatureSpmBase::dia_SAFeatureSpmBase");
}

//-----------------------------------------------------------------------------

dia_SAFeatureSpmBase::~dia_SAFeatureSpmBase(void)
{
}

//-----------------------------------------------------------------------------

tDiaResult dia_SAFeatureSpmBase::startMonitoring(void)
{
   dia_tclFnctTrace trc("dia_SAFeatureSpmBase::startMonitoring()");

   tDiaResult retCode = DIA_SUCCESS;

   if (_bFidReg == FALSE)
   {
      if ( registerFunction(SPM_COREFI_C_U16_SUBSTATES) != DIA_SUCCESS ) { retCode = DIA_FAILED; }
      if ( registerFunction(SPM_COREFI_C_U16_CVMEVENT)  != DIA_SUCCESS ) { retCode = DIA_FAILED; }
      if ( registerFunction(SPM_COREFI_C_U16_SYSPWRMODE)  != DIA_SUCCESS ) { retCode = DIA_FAILED; }
      if ( registerFunction(SPM_COREFI_C_U16_SYSTEMSTATE) != DIA_SUCCESS ) { retCode = DIA_FAILED; }
      if ( registerFunction(SPM_COREFI_C_U16_HMISTATE)  != DIA_SUCCESS ) { retCode = DIA_FAILED; }

      if ( retCode != DIA_SUCCESS )
      {
         DIA_TR_ERR("##### AT LEAST ONE REGISTRATION TO SPM PROPERTIES FAILED #####");
      }
      else
      {
         _bFidReg = TRUE;
      }
   }

   return retCode;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureSpmBase::getSystemState(dia_eSpmSystemState& state)
{
   state = mSystemState;
   return DIA_SUCCESS;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureSpmBase::getHmiState(dia_eSpmHmiState& state)
{
   state = mHmiState;
   return DIA_SUCCESS;
}

//-----------------------------------------------------------------------------
#if 0
tDiaResult dia_SAFeatureSpmBase::getCVMState(dia_eSpmCvmState& state)
{
   state = mCVMState;
   return DIA_SUCCESS;
}
#endif
//-----------------------------------------------------------------------------
#if 0
tDiaResult dia_SAFeatureSpmBase::getCVMLastEvent(dia_eSpmCvmEvent& event)
{
   event = mCVMEvent;
   return DIA_SUCCESS;
}
#endif

//-----------------------------------------------------------------------------

tDiaResult dia_SAFeatureSpmBase::getSystemResetCounter(void)
{
   dia_tclFnctTrace trc("dia_SAFeatureSpmBase::getSystemResetCounter");

   tDiaResult retCode = DIA_FAILED;

   if (mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID) {
      gm_tclU32Message oMessage(
            mAppID,
            mpSrvPlugin->getClientID(),
            mpSrvPlugin->getRegistrationID(),
            0,
            mpSrvPlugin->getServiceID(),
            SPM_COREFI_C_U16_RESETLIST,
            CCA_C_U8_OPCODE_GET
      );

      if (mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE)
         retCode = DIA_SUCCESS;
   }

   return retCode;
}


//-----------------------------------------------------------------------------
tDiaResult dia_SAFeatureSpmBase::getSystemResetInformation(void)
{
   dia_tclFnctTrace trc("dia_SAFeatureSpmBase::getSystemResetInformation");

   tDiaResult retCode = DIA_FAILED;

   if (mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID) {
      gm_tclU32Message oMessage(
            mAppID,
            mpSrvPlugin->getClientID(),
            mpSrvPlugin->getRegistrationID(),
            0,
            mpSrvPlugin->getServiceID(),
         SPM_COREFI_C_U16_RESETCOUNTER,
            CCA_C_U8_OPCODE_GET
      );

      if (mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE)
         retCode = DIA_SUCCESS;
   }

   return retCode;
}

//-----------------------------------------------------------------------------

tDiaResult dia_SAFeatureSpmBase::resetSystemResetCounter(void)
{
   dia_tclFnctTrace trc("dia_SAFeatureSpmBase::resetSystemResetCounter");

   tDiaResult retCode = DIA_FAILED;

   if (mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID) {
      gm_tclU32Message oMessage(
            mAppID,
            mpSrvPlugin->getClientID(),
            mpSrvPlugin->getRegistrationID(),
            0,
            mpSrvPlugin->getServiceID(),
            SPM_COREFI_C_U16_RESETLIST,
            AMT_C_U8_CCAMSG_OPCODE_SET
      );
      oMessage.vSetDWord(0);

      if (mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE)
         retCode = DIA_SUCCESS;
   }

   return retCode;
}

//-----------------------------------------------------------------------------

tDiaResult dia_SAFeatureSpmBase::resetSystemResetInformation(void)
{
   dia_tclFnctTrace trc("dia_SAFeatureSpmBase::resetSystemResetInformation");

   tDiaResult retCode = DIA_FAILED;

   if (mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID) {
      gm_tclU32Message oMessage(
            mAppID,
            mpSrvPlugin->getClientID(),
            mpSrvPlugin->getRegistrationID(),
            0,
            mpSrvPlugin->getServiceID(),
            SPM_COREFI_C_U16_RESETCOUNTER,
            AMT_C_U8_CCAMSG_OPCODE_SET
      );
      oMessage.vSetDWord(0);

      if (mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE)
         retCode = DIA_SUCCESS;
   }

   return retCode;
}

//-----------------------------------------------------------------------------

tDiaResult dia_SAFeatureSpmBase::signalSystemShutdown(dia_eSpmShutdownMode mode)
{
   dia_tclFnctTrace trc("dia_SAFeatureSpmBase::signalSystemShutdown");

   tDiaResult retCode = DIA_FAILED;

#if 0 //STC2HI: TODO
//   Alternative:
//   retCode = setSubState ( DIA_EN_SPM_SUBSTATE_FAST_SHUTDOWN, TRUE );

//   if(retCode==DIA_SUCCESS){
//      DIA_TR_INF("dia_SAFeatureSpmBase::signalSystemShutdown - setSubState SUCCESS.");
//   } else {
//      DIA_TR_INF("dia_SAFeatureSpmBase::signalSystemShutdown - setSubState FAILED.");
//   }
#endif //STC2HI: TODO

   if (mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID) {
      spm_corefi_tclMsgSubStatesSet oData;
      oData.SubStateType.enType = aSpmShutdownMode2SubStateMapping[mode];
      DIA_TR_INF("dia_SAFeatureSpmBase::setSubState - oData.SubStateType.enType %d .", oData.SubStateType.enType);
      oData.SubStateData = TRUE;

      fi_tclVisitorMessage oMsg(oData);
      mpSrvPlugin->vInitServiceData(oMsg, SPM_COREFI_C_U16_SUBSTATES, AMT_C_U8_CCAMSG_OPCODE_SET);

      if (mpSrvPlugin->bTransmitMessage(&oMsg) == TRUE) {
         retCode = DIA_SUCCESS;
         DIA_TR_INF("dia_SAFeatureSpmBase::signalSystemShutdown - bTransmitMessage SUCCESS.");
      } else {
         DIA_TR_INF("dia_SAFeatureSpmBase::signalSystemShutdown - bTransmitMessage FAILED.");
      }
   }

   return retCode;
}

//-----------------------------------------------------------------------------
#if 0
tDiaResult dia_SAFeatureSpmBase::signalWatchdog(void)
{
   dia_tclFnctTrace trc("dia_SAFeatureSpmBase::signalWatchdog");

   tDiaResult retCode = DIA_FAILED;

//   if ( mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID )
//   {
//      gm_tclU32Message oMessage (
//            mAppID,
//            mpSrvPlugin->getClientID(),
//            mpSrvPlugin->getRegistrationID(),
//            0,
//            mpSrvPlugin->getServiceID(),
//            FID_SPM_RESTART,
//            AMT_C_U8_CCAMSG_OPCODE_SET
//      );
//      oMessage.vSetDWord(aRestartModeMapping[DIA_EN_SPM_RESTART_MODE_WATCHDOG]);
//
//      if ( mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE ) retCode = DIA_SUCCESS;
//   }

   return retCode;
}
#endif
//-----------------------------------------------------------------------------

tDiaResult dia_SAFeatureSpmBase::signalSystemRestart(dia_eSpmRestartMode mode)
{
   dia_tclFnctTrace trc("dia_SAFeatureSpmBase::signalSystemRestart");
   tDiaResult retCode = DIA_FAILED;

   if(DIA_EN_SPM_RESTART_MODE_UNKNOWN != mode)
   {
      tU16 regID = mpSrvPlugin->getRegistrationID();

      if (regID != AMT_C_U16_REGID_INVALID)
      {
         gm_tclU32Message oMessage(mAppID, mpSrvPlugin->getClientID(), mpSrvPlugin->getRegistrationID(), 0, mpSrvPlugin->getServiceID(), SPM_COREFI_C_U16_RESTART, AMT_C_U8_CCAMSG_OPCODE_SET);
         oMessage.vSetDWord(aSpmRestartModeMapping[mode]);

         if (mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE)
         {
            DIA_TR_INF("dia_SAFeatureSpmBase::signalSystemRestart - bTransmitMessage SUCCESS.");
            retCode = DIA_SUCCESS;
         }
         else
         {
            DIA_TR_INF("dia_SAFeatureSpmBase::signalSystemRestart - bTransmitMessage FAILED.");
         }
      }
      else
      {
         DIA_TR_ERR("dia_SAFeatureSpmBase::signalSystemRestart getRegistrationID = 0x%04X.", regID);
      }
   }
   else
   {
      DIA_TR_ERR("dia_SAFeatureSpmBase::signalSystemRestart - DIA_EN_SPM_RESTART_MODE_UNKNOWN");
   }
   return retCode;
}

//-----------------------------------------------------------------------------

tDiaResult dia_SAFeatureSpmBase::lcmSystemRestart(dia_eSpmRestartMode mode)
{
   dia_tclFnctTrace trc("dia_SAFeatureSpmBase::lcmSystemRestart");
   tDiaResult retCode = DIA_FAILED;
   tBool aSpmRestartModeMapping_defined = TRUE;

   //DIA_TR_SM("NBS3KOR-- inside dia_SAFeatureSpmBase::lcmSystemRestart -%d", mode);

   switch(mode)
   {

    case DIA_EN_SPM_RESTART_MODE_ECU_ALTSW_NAC_TESTSOFTWARE:
          #ifndef FI_EN_SPM_U32_RESTART_ECU_ALTSW_NAC_TESTSOFTWARE
                aSpmRestartModeMapping_defined = FALSE;
         #endif
       break;
    default:
       break;
   }

   if(!aSpmRestartModeMapping_defined)
   {
      DIA_TR_SM("Requested feature not supported by SPM");
      return retCode;
   }

   if (mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID) {
      gm_tclU32Message oMessage(mAppID, mpSrvPlugin->getClientID(), mpSrvPlugin->getRegistrationID(), 0, mpSrvPlugin->getServiceID(), SPM_COREFI_C_U16_RESTART, AMT_C_U8_CCAMSG_OPCODE_SET);
      oMessage.vSetDWord(aSpmRestartModeMapping[mode]);

      if (mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE) {
         DIA_TR_INF("dia_SAFeatureSpmBase::lcmSystemRestart - bTransmitMessage SUCCESS.");
         retCode = DIA_SUCCESS;
      } else {
         DIA_TR_INF("dia_SAFeatureSpmBase::lcmSystemRestart - bTransmitMessage FAILED.");
      }
   }

   return retCode;
}


//-----------------------------------------------------------------------------

tDiaResult dia_SAFeatureSpmBase::signalSystemReset(dia_eSpmCoreRestartMode mode)
{
   dia_tclFnctTrace trc("dia_SAFeatureSpmBase::signalSystemReset");
   tDiaResult retCode = DIA_FAILED;

   if(DIA_EN_SPM_CORE_RESTART_MODE_UNKNOWN != mode)
   {
      tU16 regID = mpSrvPlugin->getRegistrationID();

      if (regID != AMT_C_U16_REGID_INVALID)
      {
       spm_corefi_tclMsgRestartSystemMethodStart oData;
        oData.eRestartType.enType = aSpmCoreRestartModeMapping[mode];
        fi_tclVisitorMessage oMsg( oData );

        mpSrvPlugin->vInitServiceData( oMsg, SPM_COREFI_C_U16_RESTARTSYSTEM, AMT_C_U8_CCAMSG_OPCODE_METHODSTART );

         if (mpSrvPlugin->bTransmitMessage(&oMsg) == TRUE)
         {
            DIA_TR_INF("dia_SAFeatureSpmBase::signalSystemReset - bTransmitMessage SUCCESS.");
            retCode = DIA_SUCCESS;
         }
         else
         {
            DIA_TR_INF("dia_SAFeatureSpmBase::signalSystemReset - bTransmitMessage FAILED.");
         }
      }
      else
      {
         DIA_TR_ERR("dia_SAFeatureSpmBase::signalSystemReset getRegistrationID = 0x%04X.", regID);
      }
   }
   else
   {
      DIA_TR_ERR("dia_SAFeatureSpmBase::signalSystemReset - DIA_EN_SPM_CORE_RESTART_MODE_UNKNOWN");
   }
   return retCode;
}

//-----------------------------------------------------------------------------


tDiaResult dia_SAFeatureSpmBase::setSubState(dia_eSpmSubState substate, tBool mode)
{
   dia_tclFnctTrace trc("dia_SAFeatureSpmBase::setSubState");

   if (substate == DIA_EN_SPM_SUBSTATE_UNKNOWN) {
      DIA_TR_INF("INVALID SUBSTATE DETECTED !!");
      return DIA_FAILED;
   }

   if (mpSrvPlugin->getRegistrationID() == AMT_C_U16_REGID_INVALID) {
      DIA_TR_INF("INVALID REGISTRATION DETECTED !!");
      return DIA_FAILED;
   }

   if (mode == TRUE) {
      DIA_TR_INF("Activate Substate !!!");
   } else {
      DIA_TR_INF("Deactivate Substate !!!");
   }

   spm_corefi_tclMsgSubStatesSet oData;
   
   diaToDia_fi(substate, oData.SubStateType); //coverity Fix:180715

   DIA_TR_INF("dia_SAFeatureSpmBase::setSubState - substate %d , mode = %s.", oData.SubStateType.enType, (mode == true) ? "true" : "false");

   oData.SubStateData = mode;

   fi_tclVisitorMessage oMsg(oData);
   mpSrvPlugin->vInitServiceData(oMsg, SPM_COREFI_C_U16_SUBSTATES, AMT_C_U8_CCAMSG_OPCODE_SET);

   tDiaResult retCode = DIA_FAILED;
   if (mpSrvPlugin->bTransmitMessage(&oMsg) == TRUE) {
      retCode = DIA_SUCCESS;
   }

   return retCode;
}

//-----------------------------------------------------------------------------

tDiaResult dia_SAFeatureSpmBase::sendOnOffTrigger(dia_eSpmSubState substate, tBool mode)
{
   dia_tclFnctTrace trc("dia_SAFeatureSpmBase::sendOnOffTrigger");

   if (substate == DIA_EN_SPM_SUBSTATE_UNKNOWN) {
      DIA_TR_INF("INVALID SUBSTATE DETECTED !!");
      return DIA_FAILED;
   }

   if (mpSrvPlugin->getRegistrationID() == AMT_C_U16_REGID_INVALID) {
      DIA_TR_INF("INVALID REGISTRATION DETECTED !!");
      return DIA_FAILED;
   }

   spm_corefi_tclMsgOnOffTriggerMethodStart oData;
   
   diaToDia_fi(substate, oData.eSwitchOnTrigger);

   DIA_TR_INF("dia_SAFeatureSpmBase::setSubState - substate %d , mode = %s.", oData.eSwitchOnTrigger.enType, (mode == true) ? "true" : "false");

   oData.bState = mode;

   fi_tclVisitorMessage oMsg(oData);
   mpSrvPlugin->vInitServiceData(oMsg, SPM_COREFI_C_U16_ONOFFTRIGGER, AMT_C_U8_CCAMSG_OPCODE_METHODSTART);

   tDiaResult retCode = DIA_FAILED;
   if (mpSrvPlugin->bTransmitMessage(&oMsg) == TRUE) {
      retCode = DIA_SUCCESS;
   }

   return retCode;
}
tDiaResult dia_SAFeatureSpmBase::getPowerSupplyVoltageEventCounters(void)
{
   dia_tclFnctTrace trc("dia_SAFeatureSpmBase::getPowerSupplyVoltageEventCounters");
   tDiaResult retCode = dia_sendOPCODE_GET(SPM_COREFI_C_U16_VOLTAGEEVENTCOUNTER);
   return retCode;
}
tDiaResult dia_SAFeatureSpmBase::getPowerSupplyVoltageHistogram(void)
{
   dia_tclFnctTrace trc("dia_SAFeatureSpmBase::getPowerSupplyVoltageHistogram");
   tDiaResult retCode = dia_sendOPCODE_GET(SPM_COREFI_C_U16_VOLTAGERANGEHISTOGRAM);
   return retCode;
}
tDiaResult dia_SAFeatureSpmBase::getCpuUsageStatistics(void)
{
   dia_tclFnctTrace trc("dia_SAFeatureSpmBase::getCpuUsageStatistics");
   tDiaResult retCode = dia_sendOPCODE_GET(SPM_COREFI_C_U16_CPUUSAGESTATISTIC);
   return retCode;
}
tDiaResult dia_SAFeatureSpmBase::getRamUsageStatistics(void)
{
   dia_tclFnctTrace trc("dia_SAFeatureSpmBase::getRamUsageStatistics");
   tDiaResult retCode = dia_sendOPCODE_GET(SPM_COREFI_C_U16_RAMUSAGESTATISTIC);
   return retCode;
}
tDiaResult dia_SAFeatureSpmBase::getStartupTimeStatistics(void)
{
   dia_tclFnctTrace trc("dia_SAFeatureSpmBase::getStartupTimeStatistics");
   tDiaResult retCode = dia_sendOPCODE_GET(SPM_COREFI_C_U16_STARTUPTIMESTATISTIC);
   return retCode;
}
bool dia_SAFeatureSpmBase::requestSpecificSwVersionStatistic(uint32_t index) {
   dia_tclFnctTrace trc("dia_SAFeatureSpmBase::requestSpecificSwVersionStatistic");
   spm_corefi_tclMsgSpecificSWVersionStatisticMethodStart fiMsg;
   fiMsg.u32Index=index;
   sendFiMessage(fiMsg, true);
   return true;
}
tDiaResult dia_SAFeatureSpmBase::handleRequest(dia_tSpmSVPReqResetInformationForSWVersion *req)
{
   dia_tclFnctTrace trc("dia_SAFeatureSpmBase::handleRequest(dia_tSpmSVPReqResetInformationForSWVersion)");
   mFiMsgHandlerListSpecificSWVersionStatistic.addHandler(new FiMsgHandler<spm_corefi_tclMsgSpecificSWVersionStatisticMethodResult, 
                                                            dia_tSpmSVPResetInformationForSWVersion, 
                                                          dia_ISpmSVPListener>("SpecificSWVersionStatistic",
                                                                               mCmdCounter));
   return requestSpecificSwVersionStatistic(req->mIndex) ?  DIA_SUCCESS : DIA_FAILED;
}
tDiaResult dia_SAFeatureSpmBase::handleRequest(dia_tSpmSVPReqWakeupHistoryForSWVersion *req)
{
   dia_tclFnctTrace trc("dia_SAFeatureSpmBase::handleRequest(dia_tSpmSVPReqWakeupHistoryForSWVersion)");
   mFiMsgHandlerListSpecificSWVersionStatistic.addHandler(new FiMsgHandler<spm_corefi_tclMsgSpecificSWVersionStatisticMethodResult, 
                                                          dia_tSpmSVPWakeupHistoryForSWVersion, 
                                                          dia_ISpmSVPListener>("SpecificSWVersionStatistic",
                                                                               mCmdCounter));
   return requestSpecificSwVersionStatistic(req->mIndex) ?  DIA_SUCCESS : DIA_FAILED;
}
tDiaResult dia_SAFeatureSpmBase::handleRequest(dia_tSpmSVPReqResetHistoryForSWVersion *req)
{
   dia_tclFnctTrace trc("dia_SAFeatureSpmBase::handleRequest(dia_tSpmSVPReqResetHistoryForSWVersion)");
   mFiMsgHandlerListSpecificSWVersionStatistic.addHandler(new FiMsgHandler<spm_corefi_tclMsgSpecificSWVersionStatisticMethodResult, 
                                                          dia_tSpmSVPResetHistoryForSWVersion, 
                                                          dia_ISpmSVPListener>("SpecificSWVersionStatistic",
                                                                               mCmdCounter));
   return requestSpecificSwVersionStatistic(req->mIndex) ?  DIA_SUCCESS : DIA_FAILED;
}
tDiaResult dia_SAFeatureSpmBase::handleRequest(dia_tSpmSVPReqStateHistoryForSWVersion *req)
{
   dia_tclFnctTrace trc("dia_SAFeatureSpmBase::handleRequest(dia_tSpmSVPReqStateHistoryForSWVersion)");
   mFiMsgHandlerListSpecificSWVersionStatistic.addHandler(new FiMsgHandler<spm_corefi_tclMsgSpecificSWVersionStatisticMethodResult, 
                                                          dia_tSpmSVPStateHistoryForSWVersion, 
                                                          dia_ISpmSVPListener>("SpecificSWVersionStatistic",
                                                                               mCmdCounter));
   return requestSpecificSwVersionStatistic(req->mIndex) ?  DIA_SUCCESS : DIA_FAILED;
}
tDiaResult dia_SAFeatureSpmBase::handleRequest(dia_tSpmSVPReqErrorStateHistoryForSWVersion *req)
{
   dia_tclFnctTrace trc("dia_SAFeatureSpmBase::handleRequest(dia_tSpmSVPReqStateHistoryForSWVersion)");
   mFiMsgHandlerListSpecificSWVersionStatistic.addHandler(new FiMsgHandlerWithHint<spm_corefi_tclMsgSpecificSWVersionStatisticMethodResult, 
                                                          dia_tSpmSVPErrorStateHistoryForSWVersion, 
                                                          dia_ISpmSVPListener,
                                                          tU8>("SpecificSWVersionStatistic", 
                                                               req->mErrorStateIndex,
                                                               mCmdCounter));
   return requestSpecificSwVersionStatistic(req->mIndex) ?  DIA_SUCCESS : DIA_FAILED;
}
tDiaResult dia_SAFeatureSpmBase::handleRequest(dia_tSpmSVPReqSystemOperationTimeForSWVersion *req)
{
   dia_tclFnctTrace trc("dia_SAFeatureSpmBase::handleRequest(dia_tSpmSVPReqSystemOperationTimeForSWVersion)");
   mFiMsgHandlerListSpecificSWVersionStatistic.addHandler(new FiMsgHandler<spm_corefi_tclMsgSpecificSWVersionStatisticMethodResult, 
                                                          dia_tSpmSVPSystemOperationTimeForSWVersion, 
                                                          dia_ISpmSVPListener>("SpecificSWVersionStatistic",
                                                                               mCmdCounter));
   return requestSpecificSwVersionStatistic(req->mIndex) ?  DIA_SUCCESS : DIA_FAILED;
}
tDiaResult dia_SAFeatureSpmBase::handleRequest(dia_tSpmSVPReqAverageCpuLoadForSWVersion *req)
{
   dia_tclFnctTrace trc("dia_SAFeatureSpmBase::handleRequest(dia_tSpmSVPReqAverageCpuLoadForSWVersion)");
   mFiMsgHandlerListSpecificSWVersionStatistic.addHandler(new FiMsgHandler<spm_corefi_tclMsgSpecificSWVersionStatisticMethodResult, 
                                                          dia_tSpmSVPAverageCpuLoadForSWVersion, 
                                                          dia_ISpmSVPListener>("SpecificSWVersionStatistic",
                                                                               mCmdCounter));
   return requestSpecificSwVersionStatistic(req->mIndex) ?  DIA_SUCCESS : DIA_FAILED;
}
tDiaResult dia_SAFeatureSpmBase::handleRequest(dia_tSpmSVPReqMaximumRamConsumptionForSWVersion *req)
{
   dia_tclFnctTrace trc("dia_SAFeatureSpmBase::handleRequest(dia_tSpmSVPReqMaximumRamConsumptionForSWVersion)");
   mFiMsgHandlerListSpecificSWVersionStatistic.addHandler(new FiMsgHandler<spm_corefi_tclMsgSpecificSWVersionStatisticMethodResult, 
                                                          dia_tSpmSVPMaximumRamConsumptionForSWVersion, 
                                                          dia_ISpmSVPListener>("SpecificSWVersionStatistic",
                                                                               mCmdCounter));
   return requestSpecificSwVersionStatistic(req->mIndex) ?  DIA_SUCCESS : DIA_FAILED;
}
tDiaResult dia_SAFeatureSpmBase::handleRequest(dia_tSpmSVPReqStartupTimeStatisticForSWVersion *req)
{
   dia_tclFnctTrace trc("dia_SAFeatureSpmBase::handleRequest(dia_tSpmSVPReqStartupTimeStatisticForSWVersion)");
   mFiMsgHandlerListSpecificSWVersionStatistic.addHandler(new FiMsgHandler<spm_corefi_tclMsgSpecificSWVersionStatisticMethodResult, 
                                                          dia_tSpmSVPStartupTimeStatisticForSWVersion, 
                                                          dia_ISpmSVPListener>("SpecificSWVersionStatistic",
                                                                               mCmdCounter));
   return requestSpecificSwVersionStatistic(req->mIndex) ?  DIA_SUCCESS : DIA_FAILED;
}

//-----------------------------------------------------------------------------

tDiaResult dia_SAFeatureSpmBase::dia_sendOPCODE_GET(tU16 fktID)
{
   dia_tclFnctTrace trc("dia_SAFeatureSpmBase::dia_sendOPCODE_GET");
   tDiaResult retCode = DIA_FAILED;

   if (mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID)
   {
      gm_tclU32Message oMessage(mAppID, mpSrvPlugin->getClientID(), mpSrvPlugin->getRegistrationID(), 0, mpSrvPlugin->getServiceID(), fktID, CCA_C_U8_OPCODE_GET);

      if (mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE)
      {
         retCode = DIA_SUCCESS;
      }
   }

   return retCode;
}
//-----------------------------------------------------------------------------

tDiaResult dia_SAFeatureSpmBase::getResetHistory()
{
   dia_tclFnctTrace trc("dia_SAFeatureSpmBase::getResetHistory");

   tDiaResult retCode = dia_sendOPCODE_GET(SPM_COREFI_C_U16_RESETHISTORY);

   return retCode;

}

//-----------------------------------------------------------------------------

tDiaResult dia_SAFeatureSpmBase::getWakeUpHistory()
{
   dia_tclFnctTrace trc("dia_SAFeatureSpmBase::getWakeUpHistory");

   tDiaResult retCode = dia_sendOPCODE_GET(SPM_COREFI_C_U16_WAKEUPHISTORY);

   return retCode;

}

//-----------------------------------------------------------------------------
#if 0
tDiaResult dia_SAFeatureSpmBase::getSwitchOnHistory()
{
   dia_tclFnctTrace trc("dia_SAFeatureSpmBase::getSwitchOnHistory");

   tDiaResult retCode = dia_sendOPCODE_GET(SPM_COREFI_C_U16_SWITCHONHISTORY);

   return retCode;
}
#endif
//-----------------------------------------------------------------------------
#if 0
tDiaResult dia_SAFeatureSpmBase::getSystemPowerSaveMode()
{
   dia_tclFnctTrace trc("dia_SAFeatureSpmBase::getSystemPowerSaveMode");

   tDiaResult retCode = dia_sendOPCODE_GET(SPM_COREFI_C_U16_SYSPWRSAVEMODE);

   return retCode;
}
#endif
//-----------------------------------------------------------------------------

tDiaResult dia_SAFeatureSpmBase::getVoltageSplyTerminalValue()
{
   dia_tclFnctTrace trc("dia_SAFeatureSpmBase::getVoltageSplyTerminalValue");

   tDiaResult retCode = dia_sendOPCODE_GET(SPM_COREFI_C_U16_UBATSENSE);

   return retCode;
}
//-----------------------------------------------------------------------------

tDiaResult dia_SAFeatureSpmBase::getPowerSupplyStatus()
{
   dia_tclFnctTrace trc("dia_SAFeatureSpmBase::getPowerSupplyStatus");
   tDiaResult retCode = dia_sendOPCODE_GET(SPM_COREFI_C_U16_CVMEVENT);
   return retCode;
}
//-----------------------------------------------------------------------------

tDiaResult dia_SAFeatureSpmBase::getStateHistory()
{
   dia_tclFnctTrace trc("dia_SAFeatureSpmBase::getStateHistory");

   tDiaResult retCode = dia_sendOPCODE_GET(SPM_COREFI_C_U16_STATEHISTORY);

   return retCode;
}

//-----------------------------------------------------------------------------

tDiaResult dia_SAFeatureSpmBase::getErrStateHistory(dia_eSpmErrState errState)
{
   dia_tclFnctTrace trc("dia_SAFeatureSpmBase::getErrStateHistory");
   tDiaResult retCode = DIA_FAILED;

   if (mLastRequestedErrState == DIA_EN_SPM_ERR_STATE_UNKNOWN) {
      switch (errState) {
         case DIA_EN_SPM_ERR_STATE_01:
            DIA_TR_INF("dia_SAFeatureSpmBase::getErrStateHistory send ERRSTATEHISTORY01.");
            mLastRequestedErrState = DIA_EN_SPM_ERR_STATE_01;
            retCode = dia_sendOPCODE_GET(SPM_COREFI_C_U16_ERRSTATEHISTORY01);
            break;
         case DIA_EN_SPM_ERR_STATE_02:
            DIA_TR_INF("dia_SAFeatureSpmBase::getErrStateHistory send ERRSTATEHISTORY02.");
            mLastRequestedErrState = DIA_EN_SPM_ERR_STATE_02;
            retCode = dia_sendOPCODE_GET(SPM_COREFI_C_U16_ERRSTATEHISTORY02);
            break;
         case DIA_EN_SPM_ERR_STATE_03:
            DIA_TR_INF("dia_SAFeatureSpmBase::getErrStateHistory send ERRSTATEHISTORY03.");
            mLastRequestedErrState = DIA_EN_SPM_ERR_STATE_03;
            retCode = dia_sendOPCODE_GET(SPM_COREFI_C_U16_ERRSTATEHISTORY03);
            break;
         case DIA_EN_SPM_ERR_STATE_04:
            DIA_TR_INF("dia_SAFeatureSpmBase::getErrStateHistory send ERRSTATEHISTORY04.");
            mLastRequestedErrState = DIA_EN_SPM_ERR_STATE_04;
            retCode = dia_sendOPCODE_GET(SPM_COREFI_C_U16_ERRSTATEHISTORY04);
            break;
         case DIA_EN_SPM_ERR_STATE_05:
            DIA_TR_INF("dia_SAFeatureSpmBase::getErrStateHistory send ERRSTATEHISTORY05.");
            mLastRequestedErrState = DIA_EN_SPM_ERR_STATE_05;
            retCode = dia_sendOPCODE_GET(SPM_COREFI_C_U16_ERRSTATEHISTORY05);
            break;
         default:
            DIA_TR_ERR("dia_SAFeatureSpmBase::getErrStateHistory ERR STATE HISTORY UNKOWN!");
            break;
      }
   } else {
      DIA_TR_ERR("dia_SAFeatureSpmBase::getErrStateHistory ERR STATE Request is still running!");
   }

   return retCode;
}

//=========================================================================================

tDiaResult dia_SAFeatureSpmBase::getBatteryVoltage(void)
{
   dia_tclFnctTrace trc("dia_SAFeatureSpmBase::getBatteryVoltage");

   tDiaResult retCode = dia_sendOPCODE_GET(SPM_COREFI_C_U16_UBATSENSE);

   return retCode;
}

//=========================================================================================

tDiaResult dia_SAFeatureSpmBase::getSystemPowerMode(void)
{
   dia_tclFnctTrace trc("dia_SAFeatureSpmBase::getSystemPowerMode");

   tDiaResult retCode = dia_sendOPCODE_GET(SPM_COREFI_C_U16_SYSPWRMODE);

   return retCode;
}

tDiaResult dia_SAFeatureSpmBase::getStartupStatus(void)
{
   dia_tclFnctTrace trc("dia_SAFeatureSpmBase::getStartupStatus");

   tDiaResult retCode = dia_sendOPCODE_GET(SPM_COREFI_C_U16_PROCESSLIST);

   return retCode;
}

//=========================================================================================

tDiaResult dia_SAFeatureSpmBase::getRadioState(void)
{
   dia_tclFnctTrace trc("dia_SAFeatureSpmBase::getRadioState");

   tDiaResult retCode = dia_sendOPCODE_GET(SPM_COREFI_C_U16_SYSTEMSTATE);

   return retCode;
}


/* ======================== AIVI-26132 [10/26/2016] ================================= */

tDiaResult dia_SAFeatureSpmBase::getDegradedModeCounter(void)
{
   dia_tclFnctTrace trc("dia_SAFeatureSpmBase::getDegradedModeCounter");

   tDiaResult retCode = dia_sendOPCODE_GET(SPM_COREFI_C_U16_DEGRADEDCOUNT);

   return retCode;
}

tDiaResult dia_SAFeatureSpmBase::getDegradedModeTime(void)
{
   dia_tclFnctTrace trc("dia_SAFeatureSpmBase::getDegradedModeTime");

   tDiaResult retCode = dia_sendOPCODE_GET(SPM_COREFI_C_U16_DEGRADEDTIME);

   return retCode;
}

/* ======================== AIVI-26134 [11/02/2016] ================================= */

tDiaResult dia_SAFeatureSpmBase::getEngineStoppedTime(void)
{
   dia_tclFnctTrace trc("dia_SAFeatureSpmBase::getEngineStoppedTime");

   tDiaResult retCode = dia_sendOPCODE_GET(SPM_COREFI_C_U16_UNBALLASTTIMEFROMENGINESTOPPED);

   return retCode;
}

/* ======================== AIVI-37555 [11/25/2016] ================================= */

tDiaResult dia_SAFeatureSpmBase::getVehicleIdentifierValue(void)
{
   dia_tclFnctTrace trc("dia_SAFeatureSpmBase::getVehicleIdentifierValue");

   tDiaResult retCode = dia_sendOPCODE_GET(SPM_COREFI_C_U16_VEHICLEID);

   return retCode;
}

//=========================================================================================

//-----------------------------------------------------------------------------------------
void dia_SAFeatureSpmBase::vHandleBatteryVoltageADCValue(amt_tclServiceData* poMessage) const
{
   dia_tclFnctTrace trc("dia_SAFeatureSpmBase::vHandleBatteryVoltageADCValue");

   if (poMessage) {
//      DIA_ASSERT(poMessage->bIsServerMessage() == TRUE);
//
//      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS )
//      {
//         dia_ISpmListener* pListener = OSAL_NULL;
//         querySysAdapterListener<dia_ISpmListener>(&pListener);
//         if ( pListener )
//         {
//            gm_tclU16Message oCompResp(const_cast<amt_tclServiceData*>(poMessage));
//
//            tU16 u16Data = oCompResp.u16GetWord();
//            DIA_TR_INF("vHandleBatteryVoltageADCValue: Voltage: %d", u16Data);
//            pListener->vOnBatteryVoltage(u16Data);
//         }
//      }
//      else if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_ERROR )
//      {
//         amt_tclServiceDataError oErrorMsg( poMessage );
//         tU16 u16ErrorCode = oErrorMsg.u16GetErrorData();
//         DIA_TR_INF("dia_SAFeatureSpmBase ---opcode error received with error code: %d", u16ErrorCode);
//      }

      (void) poMessage->bDelete();
   }
}

//-----------------------------------------------------------------------------

//class spm_corefi_tclMsgResetHistoryStatus : public spm_corefi_tclMsgBaseMessage
//{
//public:
//
//   spm_corefi_tclMsgResetHistoryStatus() {}
//
//#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
//   spm_corefi_tclMsgResetHistoryStatus& operator=(const spm_corefi_tclMsgResetHistoryStatus& coRef);
//   spm_corefi_tclMsgResetHistoryStatus(const spm_corefi_tclMsgResetHistoryStatus& coRef);
//#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
//
//   std::vector<spm_fi_tcl_ResetElement, std::allocator<spm_fi_tcl_ResetElement> > tResetList;
//
//   virtual void vDestroy();
//   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
//   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
//   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
//   tBool operator==(const spm_corefi_tclMsgResetHistoryStatus& roRef) const;
//   virtual tS32 s32GetTypeId() const;
//};
//
//class spm_corefi_tclMsgResetCounterStatus : public spm_corefi_tclMsgBaseMessage
//{
//public:
//
//   spm_corefi_tclMsgResetCounterStatus():tLastResetDate(),tLastResetReason(),u32ApApplicationError(0),u32ApSoftware(0),u32ApEcuReset(0),u32ApDownload(0),u32ApDownloadError(0),u32ApOvertemperature(0),u32ApUser(0),u32ApLcmIntern(0),u32ApWarmstartCount(0),u32ApPowerOnCount(0),u32ApPowerLossCount(0),u32ApPowerOffCount(0),u32ApSccCount(0),u32ApUnknownCount(0),u32SccHwWdtCount(0),u32SccPowerOnCount(0),u32SccColdstartCount(0),u32SccAppmodeChangeCount(0),u32SccDuringLpwCount(0),u32SccDuringPllOszCount(0),u32SccDuringSWCount(0),u32SccWarmstartCount(0) {}
//
//#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
//   spm_corefi_tclMsgResetCounterStatus& operator=(const spm_corefi_tclMsgResetCounterStatus& coRef);
//   spm_corefi_tclMsgResetCounterStatus(const spm_corefi_tclMsgResetCounterStatus& coRef);
//#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
//
//   spm_fi_tclTimeDate tLastResetDate;
//   spm_fi_tcl_e8_LcmResetReason tLastResetReason;
//   tU32 u32ApApplicationError;
//   tU32 u32ApSoftware;
//   tU32 u32ApEcuReset;
//   tU32 u32ApDownload;
//   tU32 u32ApDownloadError;
//   tU32 u32ApOvertemperature;
//   tU32 u32ApUser;
//   tU32 u32ApLcmIntern;
//   tU32 u32ApWarmstartCount;
//   tU32 u32ApPowerOnCount;
//   tU32 u32ApPowerLossCount;
//   tU32 u32ApPowerOffCount;
//   tU32 u32ApSccCount;
//   tU32 u32ApUnknownCount;
//   tU32 u32SccHwWdtCount;
//   tU32 u32SccPowerOnCount;
//   tU32 u32SccColdstartCount;
//   tU32 u32SccAppmodeChangeCount;
//   tU32 u32SccDuringLpwCount;
//   tU32 u32SccDuringPllOszCount;
//   tU32 u32SccDuringSWCount;
//   tU32 u32SccWarmstartCount;
//
//   virtual void vDestroy();
//   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
//   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
//   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
//   tBool operator==(const spm_corefi_tclMsgResetCounterStatus& roRef) const;
//   virtual tS32 s32GetTypeId() const;
//};
//dia_tSpmResetStatus status(
//   (tU8)oCompResp.tLastResetReason.enType,
//   oCompResp.tLastResetDate.u8Hour,
//   oCompResp.tLastResetDate.u8Minute,
//   oCompResp.tLastResetDate.u8Day,
//   oCompResp.tLastResetDate.u8Month,
//   oCompResp.tLastResetDate.s16Year,
//   oCompResp.CoproResetByHmi,
//   oCompResp.CoproResetByUndervoltage,
//   oCompResp.HmiResetByCoproStartup,
//   oCompResp.HmiResetByCoproRun,
//   oCompResp.HmiResetByCoproShutdown,
//   oCompResp.HmiResetByHmiWdg,
//   oCompResp.HmiResetByHmiApp,
//   oCompResp.HmiResetByHmiException,
//   oCompResp.HmiResetByHmiExtern,
//   oCompResp.HmiResetByHmiDownload,
//   oCompResp.HmiResetByHmiDiag,
//   oCompResp.FgsResetByHmi);

void
dia_SAFeatureSpmBase::vHandleSystemResetList(amt_tclServiceData* poMessage) const
{
   dia_tclFnctTrace trc("dia_SAFeatureSpmBase::vHandleSystemResetList");

   if (poMessage)
   {
      DIA_ASSERT(poMessage->bIsServerMessage() == TRUE);

      if (poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS)
      {
         dia_ISpmListener* pListener = OSAL_NULL;
         querySysAdapterListener<dia_ISpmListener>(&pListener);
         if (pListener)
         {
            fi_tclVisitorMessage oResultMsg(poMessage);
            spm_corefi_tclMsgResetListStatus oCompResp;

            if (OSAL_OK==oResultMsg.s32GetData(oCompResp))
            {
               dia_tSpmResetStatus status(
                  (tU8)oCompResp.LastResetReason.enType,
                  oCompResp.DateHour,
                  oCompResp.DateMinute,
                  oCompResp.DateDay,
                  oCompResp.DateMonth,
                  oCompResp.DateYear,
                  oCompResp.CoproResetByHmi,
                  oCompResp.CoproResetByUndervoltage,
                  oCompResp.HmiResetByCoproStartup,
                  oCompResp.HmiResetByCoproRun,
                  oCompResp.HmiResetByCoproShutdown,
                  oCompResp.HmiResetByHmiWdg,
                  oCompResp.HmiResetByHmiApp,
                  oCompResp.HmiResetByHmiException,
                  oCompResp.HmiResetByHmiExtern,
                  oCompResp.HmiResetByHmiDownload,
                  oCompResp.HmiResetByHmiDiag,
                  oCompResp.FgsResetByHmi);

               DIA_TR_INF("dia_SAFeatureSpmBase::vHandleSystemResetList LastResetReason           = 0x%02x", oCompResp.LastResetReason.enType);
               DIA_TR_INF("dia_SAFeatureSpmBase::vHandleSystemResetList DateHour                  = %d", oCompResp.DateHour);
               DIA_TR_INF("dia_SAFeatureSpmBase::vHandleSystemResetList DateMinute                = %d", oCompResp.DateMinute);
               DIA_TR_INF("dia_SAFeatureSpmBase::vHandleSystemResetList DateDay                   = %d", oCompResp.DateDay);
               DIA_TR_INF("dia_SAFeatureSpmBase::vHandleSystemResetList DateMonth                 = %d", oCompResp.DateMonth);
               DIA_TR_INF("dia_SAFeatureSpmBase::vHandleSystemResetList DateYear                  = %d", oCompResp.DateYear);
               DIA_TR_INF("dia_SAFeatureSpmBase::vHandleSystemResetList CoproResetByHmi           = %d", oCompResp.CoproResetByHmi);
               DIA_TR_INF("dia_SAFeatureSpmBase::vHandleSystemResetList CoproResetByUndervoltage  = %d", oCompResp.CoproResetByUndervoltage);
               DIA_TR_INF("dia_SAFeatureSpmBase::vHandleSystemResetList HmiResetByCoproStartup    = %d", oCompResp.HmiResetByCoproStartup);
               DIA_TR_INF("dia_SAFeatureSpmBase::vHandleSystemResetList HmiResetByCoproRun        = %d", oCompResp.HmiResetByCoproRun);
               DIA_TR_INF("dia_SAFeatureSpmBase::vHandleSystemResetList HmiResetByCoproShutdown   = %d", oCompResp.HmiResetByCoproShutdown);
               DIA_TR_INF("dia_SAFeatureSpmBase::vHandleSystemResetList HmiResetByHmiWdg          = %d", oCompResp.HmiResetByHmiWdg);
               DIA_TR_INF("dia_SAFeatureSpmBase::vHandleSystemResetList HmiResetByHmiApp          = %d", oCompResp.HmiResetByHmiApp);
               DIA_TR_INF("dia_SAFeatureSpmBase::vHandleSystemResetList HmiResetByHmiException    = %d", oCompResp.HmiResetByHmiException);
               DIA_TR_INF("dia_SAFeatureSpmBase::vHandleSystemResetList HmiResetByHmiExtern       = %d", oCompResp.HmiResetByHmiExtern);
               DIA_TR_INF("dia_SAFeatureSpmBase::vHandleSystemResetList HmiResetByHmiDownload     = %d", oCompResp.HmiResetByHmiDownload);
               DIA_TR_INF("dia_SAFeatureSpmBase::vHandleSystemResetList HmiResetByHmiDiag         = %d", oCompResp.HmiResetByHmiDiag);
               DIA_TR_INF("dia_SAFeatureSpmBase::vHandleSystemResetList FgsResetByHmi             = %d", oCompResp.FgsResetByHmi);

               pListener->vOnResetSystemResetStatus(DIA_SUCCESS);
               //pListener->vOnSystemResetStatus(&status);
            }
            else
            {
               DIA_TR_ERR("dia_SAFeatureSpmBase::vHandleSystemResetList s32GetData FAILED!!!");
               pListener->vOnResetSystemResetStatus(DIA_FAILED);
               //pListener->vOnSystemResetStatus(NULL);
            }
         }
      }
      else if (poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_ERROR)
      {
         amt_tclServiceDataError oErrorMsg(poMessage);
         tU16 u16ErrorCode = oErrorMsg.u16GetErrorData();
         DIA_TR_INF("dia_SAFeatureSpmBase ---opcode error received with error code: %d", u16ErrorCode);
      }

      (void) poMessage->bDelete();
   }
}

//tBool
//dia_tclMcNetEnterFGSTestMode::bIsTMActive ( amt_tclServiceData* msg ) const
//{
//   dia_tclFnctTrace oTrace("dia_tclMcNetEnterFGSTestMode::bIsTMActive");
//   tBool bRetVal = FALSE;
//
//   if(msg!=OSAL_NULL)
//   {
//      fi_tclVisitorMessage oReceivedMsg(msg);
//      cfc_spmfi_tclMsgFgsStateStatus oFgsStateStatus;
//      oReceivedMsg.s32GetData(oFgsStateStatus);
//      tU32 u32FgsState = oFgsStateStatus.FgsState.enType;
//      ET_TRACE_INFO(DIA_TRACE_CLASS_DIAGNOSTICS_STRING, "--Fgs State: %d", u32FgsState);
//
//      if(u32FgsState == cfc_fi_tcl_SPM_e32_PROCESSOR_STATE::FI_EN_SPM_U32_PROC_STATE_TM)
//      {
//         ET_TRACE_INFO(DIA_TRACE_CLASS_DIAGNOSTICS_STRING,"--FGS State : TM");
//         bRetVal = TRUE;
//      }
//   }
//   return bRetVal;
//}

//-----------------------------------------------------------------------------

void
dia_SAFeatureSpmBase::vHandleSystemState ( amt_tclServiceData* poMessage )
{
  dia_tclFnctTrace trc("dia_SAFeatureSpmBase::vHandleSystemState");

  if ( poMessage )
  {
     DIA_ASSERT(poMessage->bIsServerMessage() == TRUE);

     if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS )
     {  
        dia_eSpmSystemState oldSystemState = mSystemState;
        
        fi_tclVisitorMessage oResultMsg(poMessage);
        spm_corefi_tclMsgSystemStateStatus oCompResp;
        (void) oResultMsg.s32GetData(oCompResp);
        
        dia_fiToDia(oCompResp.SystemState, mSystemState);

        DIA_TR_INF("SPM System State %d received", oCompResp.SystemState.enType);
        
        dia_ISpmListener* pListener = OSAL_NULL;
        querySysAdapterListener<dia_ISpmListener>(&pListener);
        if ( pListener )
        {
            pListener->vOnSystemState(mSystemState,oldSystemState);
            pListener->vOnRadioState(mSystemState);
        }
     }
     else if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_ERROR )
     {
        amt_tclServiceDataError oErrorMsg( poMessage );
        tU16 u16ErrorCode = oErrorMsg.u16GetErrorData();
        DIA_TR_INF( "dia_SAFeatureSpmBase ---opcode error received with error code: %d", u16ErrorCode);
     }

     (void) poMessage->bDelete();
  }
}

//-----------------------------------------------------------------------------

void
dia_SAFeatureSpmBase::vHandleHmiState ( amt_tclServiceData* poMessage )
{
  dia_tclFnctTrace trc("dia_SAFeatureSpmBase::vHandleHmiState");

  if ( poMessage )
  {
     DIA_ASSERT(poMessage->bIsServerMessage() == TRUE);

     if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS )
     {
        dia_eSpmHmiState oldSystemState = mHmiState;
        
        fi_tclVisitorMessage oResultMsg(poMessage);
        spm_corefi_tclMsgHmiStateStatus oCompResp;
        (void) oResultMsg.s32GetData(oCompResp);
        
        switch(oCompResp.HmiState.enType)
        {
           case spm_fi_tcl_SPM_e32_HMI_STATE::FI_EN_SPM_U32_HMISTATE_SHOW_OFF:
           case spm_fi_tcl_SPM_e32_HMI_STATE::FI_EN_SPM_U32_HMISTATE_SHOW_STANDBY:
               {
                  DIA_TR_INF("SPM Hmi State --- HMISTATE_SHOW_OFF");
                  mHmiState = DIA_EN_SPM_HMI_STATE_SHOW_OFF;
               }
               break;
            
           case spm_fi_tcl_SPM_e32_HMI_STATE::FI_EN_SPM_U32_HMISTATE_SHOW_HMI:
               {
                  DIA_TR_INF("SPM Hmi State --- HMISTATE_SHOW_HMI");
                  mHmiState = DIA_EN_SPM_HMI_STATE_SHOW_HMI;
               }
               break;
            
           default:
               {
                  DIA_TR_INF("SPM Hmi State %d received", oCompResp.HmiState.enType);
                  mHmiState = DIA_EN_SPM_HMI_STATE_UNKNOWN;
               }
               break;           
        }
        dia_ISpmListener* pListener = OSAL_NULL;
        querySysAdapterListener<dia_ISpmListener>(&pListener);
        if ( pListener )
        {
           pListener->vOnHmiStateChange(mHmiState,oldSystemState);
        }
     }
     else if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_ERROR )
     {
        amt_tclServiceDataError oErrorMsg( poMessage );
        tU16 u16ErrorCode = oErrorMsg.u16GetErrorData();
        DIA_TR_INF( "dia_SAFeatureSpmBase ---opcode error received with error code: %d", u16ErrorCode);
     }

     (void) poMessage->bDelete();
  }
}

//-----------------------------------------------------------------------------

void dia_SAFeatureSpmBase::vHandleSubState(amt_tclServiceData* poMessage) const
{
   dia_tclFnctTrace trc("dia_SAFeatureSpmBase::vHandleSubState");

   if (poMessage) {
      DIA_ASSERT(poMessage->bIsServerMessage() == TRUE);

      if (poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS) {
         dia_ISpmListener* pListener = OSAL_NULL;
         querySysAdapterListener<dia_ISpmListener>(&pListener);

         // notify all registered listeners
         if (pListener) {
            pListener->vOnSubstateAck();
            pListener->vOnSystemFastShutdown(DIA_SUCCESS);
         }
      }

      (void) poMessage->bDelete();
   }
}

//-----------------------------------------------------------------------------

tVoid dia_SAFeatureSpmBase::vHandleOnOffTrigger(amt_tclServiceData* poMessage) const
{
   dia_tclFnctTrace trc("dia_SAFeatureSpmBase::vHandleOnOffTrigger");

   if (poMessage)
   {
      DIA_ASSERT(poMessage->bIsServerMessage() == TRUE);

      if (poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODRESULT)
      {
         dia_ISpmListener* pListener = OSAL_NULL;
         querySysAdapterListener<dia_ISpmListener>(&pListener);

         // notify all registered listeners
         if (pListener)
         {
            pListener->vOnAckOnOffTrigger(DIA_SUCCESS);
         }
      }

      (tVoid) poMessage->bDelete();
   }
}

//-----------------------------------------------------------------------------

//void dia_SAFeatureSpmBase::vHandleRestartSetResult ( amt_tclServiceData* poMessage ) const
//{
//   dia_tclFnctTrace trc("dia_SAFeatureSpmBase::vHandleRestartSetResult");
//
//   if ( poMessage )
//   {
//      DIA_ASSERT(poMessage->bIsServerMessage() == TRUE);
//
//      gm_tclU32Message oRestart(poMessage);
//      tU32 u32RestartType = (tU32)oRestart.u32GetDWord();
//
//      DIA_TR_INF("Restart type: %d", u32RestartType);
//
//     dia_ISpmListener* pListener = OSAL_NULL;
//      querySysAdapterListener<dia_ISpmListener>(&pListener);
//      if ( pListener )
//     {
//// restart type = 0 ?
////        if( u32RestartType & SPM_U32_RESTART_WDT )
//        {
//           pListener->vOnAckWatchdogTest();
//          }
//      }
//
//      poMessage->bDelete();
//   }
//}


//-----------------------------------------------------------------------------

void dia_SAFeatureSpmBase::vHandleStatusVoltSplyTerminalValue(amt_tclServiceData* poMessage) const
{
   dia_tclFnctTrace trc("dia_SAFeatureSpmBase::vHandleStatusVoltSplyTerminalValue");

   if (poMessage)
   {
      DIA_ASSERT(poMessage->bIsServerMessage() == TRUE);

      if (poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS)
      {
         dia_ISpmListener* pListener = OSAL_NULL;
         querySysAdapterListener<dia_ISpmListener>(&pListener);
         if (pListener)
         {
            fi_tclVisitorMessage oResultMsg(poMessage);
            spm_corefi_tclMsgUBatSenseStatus oCompResp;
            (void) oResultMsg.s32GetData(oCompResp);

            DIA_TR_INF("dia_SAFeatureSpmBase::vHandleStatusVoltSplyTerminalValue %d return value:", oCompResp.UBatSense);
            DIA_TR_INF("dia_SAFeatureSpmBase::vHandleStatusVoltSplyTerminalValue =================");
            //pListener->vOnGetVoltageSplyTerminalValue(oCompResp.UBatSense);
            pListener->vOnGetPowerSupply(oCompResp.UBatSense);

         spm_corefi_tclMsgUBatSenseStatus oCompResponse;
            (void) oResultMsg.s32GetData(oCompResponse);
            //DIA_TR_INF("dia_SAFeatureSpmBase::vHandleStatusVoltSplyTerminalValue %d return value:", oCompResponse.UBatSense);
            //DIA_TR_INF("dia_SAFeatureSpmBase::vHandleStatusVoltSplyTerminalValue =================");
            pListener->vOnGetBatteryVoltage(oCompResp.UBatSense);
         }
      }
      else if (poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_ERROR)
      {
         amt_tclServiceDataError oErrorMsg(poMessage);
         tU16 u16ErrorCode = oErrorMsg.u16GetErrorData();
         DIA_TR_ERR("dia_SAFeatureSpmBase::vHandleStatusVoltSplyTerminalValue --- opcode error received: %d", u16ErrorCode);
      }
      (void) poMessage->bDelete();
   }
}

//-----------------------------------------------------------------------------

//============== AIVI-26132 [26/10/2016] =================

void dia_SAFeatureSpmBase::vHandleStatusDegradedCountValue(amt_tclServiceData* poMessage) const
{
   dia_tclFnctTrace trc("dia_SAFeatureSpmBase::vHandleStatusDegradedCountValue");

   if (poMessage)
   {
      DIA_ASSERT(poMessage->bIsServerMessage() == TRUE);

      if (poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS)
      {
         dia_ISpmListener* pListener = OSAL_NULL;
         querySysAdapterListener<dia_ISpmListener>(&pListener);
         if (pListener)
         {
            fi_tclVisitorMessage oResultMsg(poMessage);
            spm_corefi_tclMsgDegradedCountStatus oCompResp;
            (void) oResultMsg.s32GetData(oCompResp);

            DIA_TR_INF("dia_SAFeatureSpmBase::vHandleStatusDegradedCountValue %d return value:", oCompResp.u32DegradedCount);
            DIA_TR_INF("dia_SAFeatureSpmBase::vHandleStatusDegradedCountValue =================");
            pListener->vOnGetDegradedModeCounter(oCompResp.u32DegradedCount);

         }
      }
      else if (poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_ERROR)
      {
         amt_tclServiceDataError oErrorMsg(poMessage);
         tU16 u16ErrorCode = oErrorMsg.u16GetErrorData();
         DIA_TR_ERR("dia_SAFeatureSpmBase::vHandleStatusDegradedCountValue --- opcode error received: %d", u16ErrorCode);
      }
      (void) poMessage->bDelete();
   }
}

//-----------------------------------------------------------------------------

void dia_SAFeatureSpmBase::vHandleStatusDegradedTimeValue(amt_tclServiceData* poMessage) const
{
   dia_tclFnctTrace trc("dia_SAFeatureSpmBase::vHandleStatusDegradedTimeValue");

   if (poMessage)
   {
      DIA_ASSERT(poMessage->bIsServerMessage() == TRUE);

      if (poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS)
      {
         dia_ISpmListener* pListener = OSAL_NULL;
         querySysAdapterListener<dia_ISpmListener>(&pListener);
         if (pListener)
         {
            fi_tclVisitorMessage oResultMsg(poMessage);
            spm_corefi_tclMsgDegradedTimeStatus oCompResp;
            (void) oResultMsg.s32GetData(oCompResp);

            DIA_TR_INF("dia_SAFeatureSpmBase::vHandleStatusDegradedTimeValue %d return value:", oCompResp.u32DegradedTime);
            DIA_TR_INF("dia_SAFeatureSpmBase::vHandleStatusDegradedTimeValue =================");
            pListener->vOnGetDegradedModeTime(oCompResp.u32DegradedTime);

         }
      }
      else if (poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_ERROR)
      {
         amt_tclServiceDataError oErrorMsg(poMessage);
         tU16 u16ErrorCode = oErrorMsg.u16GetErrorData();
         DIA_TR_ERR("dia_SAFeatureSpmBase::vHandleStatusDegradedTimeValue --- opcode error received: %d", u16ErrorCode);
      }
      (void) poMessage->bDelete();
   }
}

//-----------------------------------------------------------------------------


void dia_SAFeatureSpmBase::vHandleStatusEngineStoppedTimeValue(amt_tclServiceData* poMessage) const
{
   dia_tclFnctTrace trc("dia_SAFeatureSpmBase::vHandleStatusEngineStoppedTimeValue");

   if (poMessage)
   {
      DIA_ASSERT(poMessage->bIsServerMessage() == TRUE);

      if (poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS)
      {
         dia_ISpmListener* pListener = OSAL_NULL;
         querySysAdapterListener<dia_ISpmListener>(&pListener);
         if (pListener)
         {
            fi_tclVisitorMessage oResultMsg(poMessage);
            spm_corefi_tclMsgUnballastTimeFromEngineStoppedStatus oCompResp;
            (void) oResultMsg.s32GetData(oCompResp);

            DIA_TR_INF("dia_SAFeatureSpmBase::vHandleStatusEngineStoppedTimeValue %d return value:", oCompResp.u32TimeFromEngineStopped);
            DIA_TR_INF("dia_SAFeatureSpmBase::vHandleStatusEngineStoppedTimeValue =================");
            pListener->vOnGetEngineStoppedTime(oCompResp.u32TimeFromEngineStopped);

         }
      }
      else if (poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_ERROR)
      {
         amt_tclServiceDataError oErrorMsg(poMessage);
         tU16 u16ErrorCode = oErrorMsg.u16GetErrorData();
         DIA_TR_ERR("dia_SAFeatureSpmBase::vHandleStatusEngineStoppedTimeValue --- opcode error received: %d", u16ErrorCode);
      }
      (void) poMessage->bDelete();
   }
}

//-----------------------------------------------------------------------------

void dia_SAFeatureSpmBase::vHandleStatusVehicleIdentifierValue(amt_tclServiceData* poMessage) const
{
   dia_tclFnctTrace trc("dia_SAFeatureSpmBase::vHandleStatusVehicleIdentifierValue");

   if (poMessage)
   {
      DIA_ASSERT(poMessage->bIsServerMessage() == TRUE);

      if (poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS)
      {
         dia_ISpmListener* pListener = OSAL_NULL;
         querySysAdapterListener<dia_ISpmListener>(&pListener);
         if (pListener)
         {
            fi_tclVisitorMessage oResultMsg(poMessage);
            spm_corefi_tclMsgVehicleIDStatus oCompResp;
            (void) oResultMsg.s32GetData(oCompResp);

            DIA_TR_INF("dia_SAFeatureSpmBase::vHandleStatusVehicleIdentifierValue %d return value:", oCompResp.u32VehicleID);
            DIA_TR_INF("dia_SAFeatureSpmBase::vHandleStatusVehicleIdentifierValue =================");
            pListener->vOnGetVehicleIdentifierValue(oCompResp.u32VehicleID);

         }
      }
      else if (poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_ERROR)
      {
         amt_tclServiceDataError oErrorMsg(poMessage);
         tU16 u16ErrorCode = oErrorMsg.u16GetErrorData();
         DIA_TR_ERR("dia_SAFeatureSpmBase::vHandleStatusVehicleIdentifierValue --- opcode error received: %d", u16ErrorCode);
      }
      (void) poMessage->bDelete();
   }
}

//-----------------------------------------------------------------------------

void dia_SAFeatureSpmBase::vHandlePowerSupplyStatus(amt_tclServiceData* poMessage) const
{
   dia_tclFnctTrace trc("dia_SAFeatureSpmBase::vHandlePowerSupplyStatus");

   if (poMessage)
   {
      DIA_ASSERT(poMessage->bIsServerMessage() == TRUE);

      if (poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS)
      {
         dia_ISpmListener* pListener = OSAL_NULL;
         querySysAdapterListener<dia_ISpmListener>(&pListener);
         if (pListener)
         {
            fi_tclVisitorMessage oResultMsg(poMessage);
            spm_corefi_tclMsgCvmEventStatus oCompResp;

            (void) oResultMsg.s32GetData(oCompResp);

            DIA_TR_INF("dia_SAFeatureSpmBase::vHandlePowerSupplyStatus %d return value:", oCompResp.CvmEvent.enType);
            DIA_TR_INF("dia_SAFeatureSpmBase::vHandlePowerSupplyStatus =================");

            dia_AppController* pAppCtrl = getInstanceOfAppController();
            if ( pAppCtrl )
            {
               tU8 voltageState = 0xFF;

               switch ( oCompResp.CvmEvent.enType )
               {
               case spm_fi_tcl_SPM_e32_CVM_EVENT::FI_EN_SPM_U32_CVM_LOW_VOLTAGE_END:
               case spm_fi_tcl_SPM_e32_CVM_EVENT::FI_EN_SPM_U32_CVM_HIGH_VOLTAGE_END:
               case spm_fi_tcl_SPM_e32_CVM_EVENT::FI_EN_SPM_U32_CVM_NO_EVENT:
                  voltageState = 0x00;
                  pAppCtrl->vOnEvent(eAppCtrlEvent_VoltageNormal,0,0);
                  break;

               case spm_fi_tcl_SPM_e32_CVM_EVENT::FI_EN_SPM_U32_CVM_CRITICAL_LOW_VOLTAGE_START:
                  voltageState = 0x01;
                  pAppCtrl->vOnEvent(eAppCtrlEvent_VoltageLow,0,0);
                  break;

               case spm_fi_tcl_SPM_e32_CVM_EVENT::FI_EN_SPM_U32_CVM_CRITICAL_LOW_VOLTAGE_END:
               case spm_fi_tcl_SPM_e32_CVM_EVENT::FI_EN_SPM_U32_CVM_LOW_VOLTAGE_START:
                  voltageState = 0x02;
                  pAppCtrl->vOnEvent(eAppCtrlEvent_VoltageLow,0,0);
                  break;

               case spm_fi_tcl_SPM_e32_CVM_EVENT::FI_EN_SPM_U32_CVM_HIGH_VOLTAGE_START:
               case spm_fi_tcl_SPM_e32_CVM_EVENT::FI_EN_SPM_U32_CVM_CRITICAL_HIGH_VOLTAGE_END:
                  voltageState = 0x03;
                  pAppCtrl->vOnEvent(eAppCtrlEvent_VoltageHigh,0,0);
                  break;

               case spm_fi_tcl_SPM_e32_CVM_EVENT::FI_EN_SPM_U32_CVM_CRITICAL_HIGH_VOLTAGE_START:
                  voltageState = 0x04;
                  pAppCtrl->vOnEvent(eAppCtrlEvent_VoltageHigh,0,0);
                  break;
               default:
                  break;
               }  //lint !e788: not all items intentionally used within defaulted switch

               pListener->vOnGetPowerSupplyStatus(voltageState);
            }
         }
      }
      else if (poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_ERROR)
      {
         amt_tclServiceDataError oErrorMsg(poMessage);
         tU16 u16ErrorCode = oErrorMsg.u16GetErrorData();
         DIA_TR_ERR("dia_SAFeatureSpmBase::vHandlePowerSupplyStatus --- opcode error received: %d", u16ErrorCode);
      }
      (void) poMessage->bDelete();
   }
}

//-----------------------------------------------------------------------------

void dia_SAFeatureSpmBase::vHandleStatusResetHistory(amt_tclServiceData* poMessage) const
{
   dia_tclFnctTrace trc("dia_SAFeatureSpmBase::vHandleStatusResetHistory");

   if (poMessage)
   {
      DIA_ASSERT(poMessage->bIsServerMessage() == TRUE);

      if (poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS)
      {
         dia_ISpmListener* pListener = OSAL_NULL;
         querySysAdapterListener<dia_ISpmListener>(&pListener);
         if (pListener)
         {
            fi_tclVisitorMessage oResultMsg(poMessage);
            spm_corefi_tclMsgResetHistoryStatus oCompResp;
            (void) oResultMsg.s32GetData(oCompResp);

            std::vector<tU8> resetElements;
            DIA_TR_INF("dia_SAFeatureSpmBase::vHandleStatusResetHistory %d / 0x%02x return values:", oCompResp.tResetList.size(), oCompResp.tResetList.size());
            resetElements.push_back((tU8)oCompResp.tResetList.size());
            DIA_TR_INF("dia_SAFeatureSpmBase::vHandleStatusResetHistory =================");

            std::vector<spm_fi_tcl_ResetElement, std::allocator<spm_fi_tcl_ResetElement> >::iterator it =  oCompResp.tResetList.begin();
            for (tU8 i = 0; it!=oCompResp.tResetList.end(); ++it, ++i)
            {
               DIA_TR_INF("dia_SAFeatureSpmBase::vHandleStatusResetHistory(%d) s16Year  = %d / 0x%04x", i, it->tResetDate.s16Year, it->tResetDate.s16Year);
               DIA_TR_INF("dia_SAFeatureSpmBase::vHandleStatusResetHistory(%d) u8Month  = %d", i, it->tResetDate.u8Month);
               DIA_TR_INF("dia_SAFeatureSpmBase::vHandleStatusResetHistory(%d) u8Day    = %d", i, it->tResetDate.u8Day);
               DIA_TR_INF("dia_SAFeatureSpmBase::vHandleStatusResetHistory(%d) u8Hour   = %d", i, it->tResetDate.u8Hour);
               DIA_TR_INF("dia_SAFeatureSpmBase::vHandleStatusResetHistory(%d) u8Minute = %d", i, it->tResetDate.u8Minute);
               DIA_TR_INF("dia_SAFeatureSpmBase::vHandleStatusResetHistory(%d) u8Second = %d", i, it->tResetDate.u8Second);
               DIA_TR_INF("dia_SAFeatureSpmBase::vHandleStatusResetHistory(%d) eSpmResetReason = 0x%02x", i, it->eReset.enType);
               DIA_TR_INF("dia_SAFeatureSpmBase::vHandleStatusResetHistory ------------------------");

               resetElements.push_back(U16_BYTE1((tU16)it->tResetDate.s16Year));
               resetElements.push_back(U16_BYTE2((tU16)it->tResetDate.s16Year));
               resetElements.push_back(it->tResetDate.u8Month);
               resetElements.push_back(it->tResetDate.u8Day);
               resetElements.push_back(it->tResetDate.u8Hour);
               resetElements.push_back(it->tResetDate.u8Minute);
               resetElements.push_back(it->tResetDate.u8Second);
               resetElements.push_back(it->eReset.enType);
            }

            pListener->vOnGetResetHistory(&resetElements);
         }
      }
      else if (poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_ERROR)
      {
         amt_tclServiceDataError oErrorMsg(poMessage);
         tU16 u16ErrorCode = oErrorMsg.u16GetErrorData();
         DIA_TR_ERR("dia_SAFeatureSpmBase::vHandleStatusResetHistory --- opcode error received: %d", u16ErrorCode);
      }
      (void) poMessage->bDelete();
   }
}

//-----------------------------------------------------------------------------

void dia_SAFeatureSpmBase::vHandleStatusWakeUpHistory(amt_tclServiceData* poMessage) const
{
   dia_tclFnctTrace trc("dia_SAFeatureSpmBase::vHandleStatusWakeUpHistory");

   if (poMessage)
   {
      DIA_ASSERT(poMessage->bIsServerMessage() == TRUE);

      if (poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS)
      {
         dia_ISpmListener* pListener = OSAL_NULL;
         querySysAdapterListener<dia_ISpmListener>(&pListener);
         if (pListener)
         {
            fi_tclVisitorMessage oResultMsg(poMessage);
            spm_corefi_tclMsgWakeupHistoryStatus oCompResp;
            (void) oResultMsg.s32GetData(oCompResp);

            std::vector<tU8> wakeupElements;
            DIA_TR_INF("dia_SAFeatureSpmBase::vHandleStatusWakeUpHistory %d/0x%02x return values:", oCompResp.tWakeupList.size(), oCompResp.tWakeupList.size());
            DIA_TR_INF("dia_SAFeatureSpmBase::vHandleStatusWakeUpHistory =================");

            std::vector<spm_fi_tcl_WakeupElement, std::allocator<spm_fi_tcl_WakeupElement> >::iterator it =  oCompResp.tWakeupList.begin();

            for (tU8 i = 0; it!=oCompResp.tWakeupList.end(); ++it, ++i)
            {
               DIA_TR_INF("::vHandleStatusWakeUpHistory(%d) s16Year              = %d / 0x%04x", i, it->tWakeupDate.s16Year, it->tWakeupDate.s16Year);
               DIA_TR_INF("::vHandleStatusWakeUpHistory(%d) u8Month              = %d",      i, it->tWakeupDate.u8Month);
               DIA_TR_INF("::vHandleStatusWakeUpHistory(%d) u8Day                = %d",      i, it->tWakeupDate.u8Day);
               DIA_TR_INF("::vHandleStatusWakeUpHistory(%d) u8Hour               = %d",      i, it->tWakeupDate.u8Hour);
               DIA_TR_INF("::vHandleStatusWakeUpHistory(%d) u8Minute             = %d",      i, it->tWakeupDate.u8Minute);
               DIA_TR_INF("::vHandleStatusWakeUpHistory(%d) u8Second             = %d",      i, it->tWakeupDate.u8Second);
               DIA_TR_INF("::vHandleStatusWakeUpHistory(%d) eWakeupReason (tU32) = 0x%08x",  i, it->eWakeupReason.enType);
               DIA_TR_INF("::vHandleStatusWakeUpHistory ------------------------");

               wakeupElements.push_back(U16_BYTE1((tU16)it->tWakeupDate.s16Year));        // byte#0
               wakeupElements.push_back(U16_BYTE2((tU16)it->tWakeupDate.s16Year));        // byte#1
               wakeupElements.push_back(it->tWakeupDate.u8Month);                         // byte#2
               wakeupElements.push_back(it->tWakeupDate.u8Day);                           // byte#3
               wakeupElements.push_back(it->tWakeupDate.u8Hour);                          // byte#4
               wakeupElements.push_back(it->tWakeupDate.u8Minute);                        // byte#5
               wakeupElements.push_back(it->tWakeupDate.u8Second);                        // byte#6

               wakeupElements.push_back(U32_BYTE1((tU32)((void*)it->eWakeupReason.enType))); // byte#7
               wakeupElements.push_back(U32_BYTE2((tU32)((void*)it->eWakeupReason.enType))); // byte#8
               wakeupElements.push_back(U32_BYTE3((tU32)((void*)it->eWakeupReason.enType))); // byte#9
               wakeupElements.push_back(U32_BYTE4((tU32)((void*)it->eWakeupReason.enType))); // byte#10
            }

            pListener->vOnGetWakeUpHistory(&wakeupElements);
         }
      } else if (poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_ERROR) {
         amt_tclServiceDataError oErrorMsg(poMessage);
         tU16 u16ErrorCode = oErrorMsg.u16GetErrorData();
         DIA_TR_ERR("dia_SAFeatureSpmBase::vHandleStatusWakeUpHistory --- opcode error received: %d", u16ErrorCode);
      }
      (void) poMessage->bDelete();
   }
}

//-----------------------------------------------------------------------------

void dia_SAFeatureSpmBase::vHandleStatusStateHistory(amt_tclServiceData* poMessage) const
{
   dia_tclFnctTrace trc("dia_SAFeatureSpmBase::vHandleStatusStateHistory");

   if (poMessage)
   {
      DIA_ASSERT(poMessage->bIsServerMessage() == TRUE);

      if (poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS)
      {
         dia_ISpmListener* pListener = OSAL_NULL;
         querySysAdapterListener<dia_ISpmListener>(&pListener);
         if (pListener)
         {
            fi_tclVisitorMessage oResultMsg(poMessage);
            spm_corefi_tclMsgStateHistoryStatus oCompResp;
            (void) oResultMsg.s32GetData(oCompResp);

            std::vector<tU8> stateElements;
            DIA_TR_INF("dia_SAFeatureSpmBase::vHandleStatusStateHistory %d / 0x%02x return values:", oCompResp.tStateList.size(), oCompResp.tStateList.size());
            DIA_TR_INF("dia_SAFeatureSpmBase::vHandleStatusStateHistory =================");

            std::vector<spm_fi_tcl_StateChangeElement, std::allocator<spm_fi_tcl_StateChangeElement> >::iterator it =  oCompResp.tStateList.begin();

            for (tU8 i = 0; it!=oCompResp.tStateList.end(); ++it, ++i)
            {
               DIA_TR_INF("::vHandleStatusStateHistory(%d) s16Year              = %d / 0x%04x", i, it->tWakeupDate.s16Year, it->tWakeupDate.s16Year);
               DIA_TR_INF("::vHandleStatusStateHistory(%d) u8Month              = %d", i, it->tWakeupDate.u8Month);
               DIA_TR_INF("::vHandleStatusStateHistory(%d) u8Day                = %d", i, it->tWakeupDate.u8Day);
               DIA_TR_INF("::vHandleStatusStateHistory(%d) u8Hour               = %d", i, it->tWakeupDate.u8Hour);
               DIA_TR_INF("::vHandleStatusStateHistory(%d) u8Minute             = %d", i, it->tWakeupDate.u8Minute);
               DIA_TR_INF("::vHandleStatusStateHistory(%d) u8Second             = %d", i, it->tWakeupDate.u8Second);

               DIA_TR_INF("::vHandleStatusStateHistory(%d) SystemState   (tS32) = %d", i, it->tSysState.enType);   // 4 bytes
               DIA_TR_INF("::vHandleStatusStateHistory(%d) StateEntry    (tS8)  = %d", i, it->tElemType.enType);
               DIA_TR_INF("::vHandleStatusStateHistory(%d) WakeUp Reason (tS32) = %d", i, it->tWakeup.enType);     // 4 bytes
               DIA_TR_INF("::vHandleStatusStateHistory(%d) ResetReason   (tU8)  = 0x%02x", i, it->tReset.enType);

               DIA_TR_INF("::vHandleStatusStateHistory(%d) tSubStateMask0 = 0x%08x", i, it->tSubStates.tSubStateMask0.u32Value);
               DIA_TR_INF("::vHandleStatusStateHistory(%d) tSubStateData0 = 0x%08x", i, it->tSubStates.tSubStateData0.u32Value);
               DIA_TR_INF("::vHandleStatusStateHistory(%d) tSubStateMask1 = 0x%08x", i, it->tSubStates.tSubStateMask1.u32Value);
               DIA_TR_INF("::vHandleStatusStateHistory(%d) tSubStateData1 = 0x%08x", i, it->tSubStates.tSubStateData1.u32Value);
               DIA_TR_INF("::vHandleStatusStateHistory(%d) tSubStateMask2 = 0x%08x", i, it->tSubStates.tSubStateMask2.u32Value);
               DIA_TR_INF("::vHandleStatusStateHistory(%d) tSubStateData2 = 0x%08x", i, it->tSubStates.tSubStateData2.u32Value);
               DIA_TR_INF("::vHandleStatusStateHistory ------------------------");

               stateElements.push_back(U16_BYTE1((tU16)it->tWakeupDate.s16Year));            //byte#0
               stateElements.push_back(U16_BYTE2((tU16)it->tWakeupDate.s16Year));            //byte#1
               stateElements.push_back(it->tWakeupDate.u8Month);                             //byte#2
               stateElements.push_back(it->tWakeupDate.u8Day);                               //byte#3
               stateElements.push_back(it->tWakeupDate.u8Hour);                              //byte#4
               stateElements.push_back(it->tWakeupDate.u8Minute);                            //byte#5
               stateElements.push_back(it->tWakeupDate.u8Second);                            //byte#6

               tU32 u32SystemState = DIA_SPM_SYS_STATE_STATE_MAX;

            switch(it->tSysState.enType)
            {
            case spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_BACKGROUND:
               u32SystemState = DIA_SPM_SYS_STATE_BACKGROUND;
               break;
            case spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_PREPARE_SHUTDOWN:
               u32SystemState = DIA_SPM_SYS_STATE_STATE_MAX;
               break;
            case spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_SHUTDOWN:
               u32SystemState = DIA_SPM_SYS_STATE_STATE_MAX;
               break;
            case spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_SUSPEND:
               u32SystemState = DIA_SPM_SYS_STATE_SUSPEND;
               break;
            case spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_STANDBY:
               u32SystemState = DIA_SPM_SYS_STATE_STANDBY;
               break;
            case spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_OFF:
               u32SystemState = DIA_SPM_SYS_STATE_OFF;
               break;
            case spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_DOWNLOAD:
               u32SystemState = DIA_SPM_SYS_STATE_DOWNLOAD;
               break;
            case spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_ON:
               u32SystemState = DIA_SPM_SYS_STATE_ON;
               break;
            case spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_DOOR_OPEN:
               u32SystemState = DIA_SPM_SYS_STATE_DOOR_OPEN;
               break;
            case spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_IGNITION:
               u32SystemState =  DIA_SPM_SYS_STATE_IGNITION;
               break;
            case spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_DIAGNOSIS:
               u32SystemState =  DIA_SPM_SYS_STATE_DIAGNOSIS;
               break;
            case spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_STATE_PROFILE:
               u32SystemState =  DIA_SPM_SYS_STATE_STATE_MAX;
               break;
            case spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_MMI_STANDBY_PWR_SAVE_1:
               u32SystemState =  DIA_SPM_SYS_STATE_STATE_MAX;
               break;
            case spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_MMI_STANDBY_PWR_SAVE_2:
               u32SystemState =  DIA_SPM_SYS_STATE_STATE_MAX;
               break;
            case spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_MMI_STANDBY:
               u32SystemState =  DIA_SPM_SYS_STATE_STATE_MAX;
               break;
            case spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_MMI_ON:
               u32SystemState =  DIA_SPM_SYS_STATE_STATE_MAX;
               break;
            case spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_MMI_STANDBY_RESTRICTED:
               u32SystemState =  DIA_SPM_SYS_STATE_STATE_MAX;
               break;
            case spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_MMI_ON_DIAG:
               u32SystemState =  DIA_SPM_SYS_STATE_STATE_MAX;
               break;
            case spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_MMI_ON_TEL:
               u32SystemState =  DIA_SPM_SYS_STATE_STATE_MAX;
               break;
            case spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_MMI_ON_SWDL:
               u32SystemState =  DIA_SPM_SYS_STATE_STATE_MAX;
               break;
            case spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_MMI_STANDBY_CUSTOMER_SWDL:
               u32SystemState =  DIA_SPM_SYS_STATE_STATE_MAX;
               break;
            case spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_MMI_STANDBY_PWR_SAVE:
               u32SystemState =  DIA_SPM_SYS_STATE_STATE_MAX;
               break;
            default:
               break;
            }
            stateElements.push_back(U32_BYTE1(u32SystemState));                           //byte#7    System state
               stateElements.push_back(U32_BYTE2(u32SystemState));                           //byte#8    System state
               stateElements.push_back(U32_BYTE3(u32SystemState));                           //byte#9    System state
               stateElements.push_back(U32_BYTE4(u32SystemState));                           //byte#10   System state

               /*
            stateElements.push_back(U32_BYTE1((tU32)sysState));               //byte#7    System state
               stateElements.push_back(U32_BYTE2((tU32)sysState));               //byte#8    System state
               stateElements.push_back(U32_BYTE3((tU32)sysState));               //byte#9    System state
               stateElements.push_back(U32_BYTE4((tU32)sysState));               //byte#10   System state
            */
               stateElements.push_back(it->tElemType.enType);                                //byte#11   State entry
               stateElements.push_back(U32_BYTE1((tU32)((void*)it->tWakeup.enType)));        //byte#12   Wakeup reason
               stateElements.push_back(U32_BYTE2((tU32)((void*)it->tWakeup.enType)));        //byte#13   Wakeup reason
               stateElements.push_back(U32_BYTE3((tU32)((void*)it->tWakeup.enType)));        //byte#14   Wakeup reason
               stateElements.push_back(U32_BYTE4((tU32)((void*)it->tWakeup.enType)));        //byte#15   Wakeup reason
               stateElements.push_back(it->tReset.enType);                                   //byte#16   Reset reason

               stateElements.push_back(U32_BYTE1(it->tSubStates.tSubStateMask0.u32Value));   //byte#17
               stateElements.push_back(U32_BYTE2(it->tSubStates.tSubStateMask0.u32Value));   //byte#18
               stateElements.push_back(U32_BYTE3(it->tSubStates.tSubStateMask0.u32Value));   //byte#19
               stateElements.push_back(U32_BYTE4(it->tSubStates.tSubStateMask0.u32Value));   //byte#20

               stateElements.push_back(U32_BYTE1(it->tSubStates.tSubStateData0.u32Value));   //byte#21
               stateElements.push_back(U32_BYTE2(it->tSubStates.tSubStateData0.u32Value));   //byte#22
               stateElements.push_back(U32_BYTE3(it->tSubStates.tSubStateData0.u32Value));   //byte#23
               stateElements.push_back(U32_BYTE4(it->tSubStates.tSubStateData0.u32Value));   //byte#24

               stateElements.push_back(U32_BYTE1(it->tSubStates.tSubStateMask1.u32Value));   //byte#25
               stateElements.push_back(U32_BYTE2(it->tSubStates.tSubStateMask1.u32Value));   //byte#26
               stateElements.push_back(U32_BYTE3(it->tSubStates.tSubStateMask1.u32Value));   //byte#27
               stateElements.push_back(U32_BYTE4(it->tSubStates.tSubStateMask1.u32Value));   //byte#28

               stateElements.push_back(U32_BYTE1(it->tSubStates.tSubStateData1.u32Value));   //byte#29
               stateElements.push_back(U32_BYTE2(it->tSubStates.tSubStateData1.u32Value));   //byte#30
               stateElements.push_back(U32_BYTE3(it->tSubStates.tSubStateData1.u32Value));   //byte#31
               stateElements.push_back(U32_BYTE4(it->tSubStates.tSubStateData1.u32Value));   //byte#32

               stateElements.push_back(U32_BYTE1(it->tSubStates.tSubStateMask2.u32Value));   //byte#33
               stateElements.push_back(U32_BYTE2(it->tSubStates.tSubStateMask2.u32Value));   //byte#34
               stateElements.push_back(U32_BYTE3(it->tSubStates.tSubStateMask2.u32Value));   //byte#35
               stateElements.push_back(U32_BYTE4(it->tSubStates.tSubStateMask2.u32Value));   //byte#36

               stateElements.push_back(U32_BYTE1(it->tSubStates.tSubStateData2.u32Value));   //byte#37
               stateElements.push_back(U32_BYTE2(it->tSubStates.tSubStateData2.u32Value));   //byte#38
               stateElements.push_back(U32_BYTE3(it->tSubStates.tSubStateData2.u32Value));   //byte#39
               stateElements.push_back(U32_BYTE4(it->tSubStates.tSubStateData2.u32Value));   //byte#40
            }

            pListener->vOnGetStateHistory(&stateElements);
         }
      }
      else if (poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_ERROR)
      {
         amt_tclServiceDataError oErrorMsg(poMessage);
         tU16 u16ErrorCode = oErrorMsg.u16GetErrorData();
         DIA_TR_ERR("dia_SAFeatureSpmBase::vHandleStatusStateHistory --- opcode error received: %d", u16ErrorCode);
      }
      (void) poMessage->bDelete();
   }
}

//-----------------------------------------------------------------------------

void dia_SAFeatureSpmBase::vHandleStatusErrStateHistory(amt_tclServiceData* poMessage)
{
   dia_tclFnctTrace trc("dia_SAFeatureSpmBase::vHandleStatusErrStateHistory");

   if (poMessage)
   {
      DIA_ASSERT(poMessage->bIsServerMessage() == TRUE);

      if (poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS)
      {
         dia_ISpmListener* pListener = OSAL_NULL;
         querySysAdapterListener<dia_ISpmListener>(&pListener);
         if (pListener)
         {
            fi_tclVisitorMessage oResultMsg(poMessage);
            spm_corefi_tclMsgStateHistoryStatus oCompResp;
            (void) oResultMsg.s32GetData(oCompResp);

            std::vector<tU8> errStateElements;
            DIA_TR_INF("dia_SAFeatureSpmBase::vHandleStatusErrStateHistory %d return values:", oCompResp.tStateList.size());
            DIA_TR_INF("dia_SAFeatureSpmBase::vHandleStatusErrStateHistory =================");

            std::vector<spm_fi_tcl_StateChangeElement, std::allocator<spm_fi_tcl_StateChangeElement> >::iterator it =  oCompResp.tStateList.begin();

            for (tU8 i = 0; it!=oCompResp.tStateList.end(); ++it, ++i)
            {
               DIA_TR_INF("::vHandleStatusErrStateHistory(%d) s16Year  = %d / 0x%04x.", i, it->tWakeupDate.s16Year, it->tWakeupDate.s16Year);
               DIA_TR_INF("::vHandleStatusErrStateHistory u8Month  = %d .", it->tWakeupDate.u8Month);
               DIA_TR_INF("::vHandleStatusErrStateHistory u8Day    = %d .", it->tWakeupDate.u8Day);
               DIA_TR_INF("::vHandleStatusErrStateHistory u8Hour   = %d .", it->tWakeupDate.u8Hour);
               DIA_TR_INF("::vHandleStatusErrStateHistory u8Minute = %d .", it->tWakeupDate.u8Minute);
               DIA_TR_INF("::vHandleStatusErrStateHistory u8Second = %d .", it->tWakeupDate.u8Second);

               DIA_TR_INF("::vHandleStatusErrStateHistory SystemState(tU32)= %d",  it->tSysState.enType);
               DIA_TR_INF("::vHandleStatusErrStateHistory StateEntry       = %d",  it->tElemType.enType);
               DIA_TR_INF("::vHandleStatusErrStateHistory WakeUp Reason    = %d",  it->tWakeup.enType);
               DIA_TR_INF("::vHandleStatusErrStateHistory ResetReason      = %d",  it->tReset.enType);

               DIA_TR_INF("::vHandleStatusErrStateHistory ResetReason = 0x%08x", it->tSubStates.tSubStateMask0.u32Value);
               DIA_TR_INF("::vHandleStatusErrStateHistory ResetReason = 0x%08x", it->tSubStates.tSubStateData0.u32Value);
               DIA_TR_INF("::vHandleStatusErrStateHistory ResetReason = 0x%08x", it->tSubStates.tSubStateMask1.u32Value);
               DIA_TR_INF("::vHandleStatusErrStateHistory ResetReason = 0x%08x", it->tSubStates.tSubStateData1.u32Value);
               DIA_TR_INF("::vHandleStatusErrStateHistory ResetReason = 0x%08x", it->tSubStates.tSubStateMask2.u32Value);
               DIA_TR_INF("::vHandleStatusErrStateHistory ResetReason = 0x%08x", it->tSubStates.tSubStateData2.u32Value);
               DIA_TR_INF("::vHandleStatusErrStateHistory ------------------------");

               errStateElements.push_back(U16_BYTE1((tU16)it->tWakeupDate.s16Year));         //byte#0
               errStateElements.push_back(U16_BYTE2((tU16)it->tWakeupDate.s16Year));         //byte#1
               errStateElements.push_back(it->tWakeupDate.u8Month);                          //byte#2
               errStateElements.push_back(it->tWakeupDate.u8Day);                            //byte#3
               errStateElements.push_back(it->tWakeupDate.u8Hour);                           //byte#4
               errStateElements.push_back(it->tWakeupDate.u8Minute);                         //byte#5
               errStateElements.push_back(it->tWakeupDate.u8Second);                         //byte#6

               errStateElements.push_back(U32_BYTE1((tU32)it->tSysState.enType));            //byte#7    System state
               errStateElements.push_back(U32_BYTE2((tU32)it->tSysState.enType));            //byte#8    System state
               errStateElements.push_back(U32_BYTE3((tU32)it->tSysState.enType));            //byte#9    System state
               errStateElements.push_back(U32_BYTE4((tU32)it->tSysState.enType));            //byte#10   System state

               errStateElements.push_back(it->tElemType.enType);                             //byte#11

               errStateElements.push_back(U32_BYTE1((tU32)((void*)it->tWakeup.enType)));     //byte#12   Wakeup reason
               errStateElements.push_back(U32_BYTE2((tU32)((void*)it->tWakeup.enType)));     //byte#13   Wakeup reason
               errStateElements.push_back(U32_BYTE3((tU32)((void*)it->tWakeup.enType)));     //byte#14   Wakeup reason
               errStateElements.push_back(U32_BYTE4((tU32)((void*)it->tWakeup.enType)));     //byte#15   Wakeup reason

               errStateElements.push_back(it->tReset.enType);                                //byte#16

               errStateElements.push_back(U32_BYTE1(it->tSubStates.tSubStateMask0.u32Value));//byte#17
               errStateElements.push_back(U32_BYTE2(it->tSubStates.tSubStateMask0.u32Value));//byte#18
               errStateElements.push_back(U32_BYTE3(it->tSubStates.tSubStateMask0.u32Value));//byte#19
               errStateElements.push_back(U32_BYTE4(it->tSubStates.tSubStateMask0.u32Value));//byte#20

               errStateElements.push_back(U32_BYTE1(it->tSubStates.tSubStateData0.u32Value));//byte#21
               errStateElements.push_back(U32_BYTE2(it->tSubStates.tSubStateData0.u32Value));//byte#22
               errStateElements.push_back(U32_BYTE3(it->tSubStates.tSubStateData0.u32Value));//byte#23
               errStateElements.push_back(U32_BYTE4(it->tSubStates.tSubStateData0.u32Value));//byte#24

               errStateElements.push_back(U32_BYTE1(it->tSubStates.tSubStateMask1.u32Value));//byte#25
               errStateElements.push_back(U32_BYTE2(it->tSubStates.tSubStateMask1.u32Value));//byte#26
               errStateElements.push_back(U32_BYTE3(it->tSubStates.tSubStateMask1.u32Value));//byte#27
               errStateElements.push_back(U32_BYTE4(it->tSubStates.tSubStateMask1.u32Value));//byte#28

               errStateElements.push_back(U32_BYTE1(it->tSubStates.tSubStateData1.u32Value));//byte#29
               errStateElements.push_back(U32_BYTE2(it->tSubStates.tSubStateData1.u32Value));//byte#30
               errStateElements.push_back(U32_BYTE3(it->tSubStates.tSubStateData1.u32Value));//byte#31
               errStateElements.push_back(U32_BYTE4(it->tSubStates.tSubStateData1.u32Value));//byte#32

               errStateElements.push_back(U32_BYTE1(it->tSubStates.tSubStateMask2.u32Value));//byte#33
               errStateElements.push_back(U32_BYTE2(it->tSubStates.tSubStateMask2.u32Value));//byte#34
               errStateElements.push_back(U32_BYTE3(it->tSubStates.tSubStateMask2.u32Value));//byte#35
               errStateElements.push_back(U32_BYTE4(it->tSubStates.tSubStateMask2.u32Value));//byte#36

               errStateElements.push_back(U32_BYTE1(it->tSubStates.tSubStateData2.u32Value));//byte#37
               errStateElements.push_back(U32_BYTE2(it->tSubStates.tSubStateData2.u32Value));//byte#38
               errStateElements.push_back(U32_BYTE3(it->tSubStates.tSubStateData2.u32Value));//byte#39
               errStateElements.push_back(U32_BYTE4(it->tSubStates.tSubStateData2.u32Value));//byte#40
            }

            pListener->vOnGetErrStateHistory(mLastRequestedErrState, &errStateElements);
            mLastRequestedErrState = DIA_EN_SPM_ERR_STATE_UNKNOWN;
         }
      }
      else if (poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_ERROR)
      {
         amt_tclServiceDataError oErrorMsg(poMessage);
         tU16 u16ErrorCode = oErrorMsg.u16GetErrorData();
         DIA_TR_ERR("dia_SAFeatureSpmBase::vHandleStatusErrStateHistory --- opcode error received: %d", u16ErrorCode);
      }
      (void) poMessage->bDelete();
   }
}
//-----------------------------------------------------------------------------

void dia_SAFeatureSpmBase::vHandleSystemRestart(amt_tclServiceData* poMessage) const
{
   dia_tclFnctTrace trc("dia_SAFeatureSpmBase::vHandleSystemRestart");

   if (poMessage)
   {
      DIA_ASSERT(poMessage->bIsServerMessage() == TRUE);
      if (poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS)
      {
         dia_ISpmListener* pListener = OSAL_NULL;
         querySysAdapterListener<dia_ISpmListener>(&pListener);
         // notify all registered listeners
         if (pListener)
         {
            //pListener->vOnRestartAck();
            pListener->vOnSystemRestart(DIA_SUCCESS);
            pListener->vOnSystemRestartDone(DIA_SUCCESS);

            fi_tclVisitorMessage oResultMsg(poMessage);
            dia_eSpmRestartMode restartMode = DIA_EN_SPM_RESTART_MODE_COUNT;

            spm_corefi_tclMsgRestartStatus oCompResp;
            (void) oResultMsg.s32GetData(oCompResp);
            DIA_TR_INF("dia_SAFeatureSpmBase::vHandleSystemRestart %d return value:", oCompResp.Restart.enType);
            DIA_TR_INF("dia_SAFeatureSpmBase::vHandleSystemRestart =================");

            switch(oCompResp.Restart.enType)
            {
            case  spm_fi_tcl_SPM_e32_RESTART_TYPE::FI_EN_SPM_U32_RESTART_ECU:
                  restartMode = DIA_EN_SPM_RESTART_MODE_ECU;
                  break;
            case  spm_fi_tcl_SPM_e32_RESTART_TYPE::FI_EN_SPM_U32_RESTART_WDT:
                  restartMode = DIA_EN_SPM_RESTART_MODE_WDT;
                  break;
            case  spm_fi_tcl_SPM_e32_RESTART_TYPE::FI_EN_SPM_U32_RESTART_ECU_FAST:
                  restartMode = DIA_EN_SPM_RESTART_MODE_ECU_FAST;
                  break;
            case  spm_fi_tcl_SPM_e32_RESTART_TYPE::FI_EN_SPM_U32_RESTART_DOWNLOAD_ERROR:
                  restartMode = DIA_EN_SPM_RESTART_MODE_DOWNLOAD_ERROR;
                  break;
            case  spm_fi_tcl_SPM_e32_RESTART_TYPE::FI_EN_SPM_U32_RESTART_DOWNLOAD_FINISHED:
                  restartMode = DIA_EN_SPM_RESTART_MODE_DOWNLOAD_FINSIHED;
                  break;
            case  spm_fi_tcl_SPM_e32_RESTART_TYPE::FI_EN_SPM_U32_RESTART_ECU_WITH_SYNC:
                  restartMode = DIA_EN_SPM_RESTART_MODE_ECU_WITH_SYNC;
                  break;
            case  spm_fi_tcl_SPM_e32_RESTART_TYPE::FI_EN_SPM_U32_RESTART_DOWNLOAD_ABORTED:
                  restartMode = DIA_EN_SPM_RESTART_MODE_DOWNLOAD_ABORTED;
                  break;
            case  spm_fi_tcl_SPM_e32_RESTART_TYPE::FI_EN_SPM_U32_RESTART_ECU_ALTSW_TESTMANAGER:
                  restartMode = DIA_EN_SPM_RESTART_MODE_ECU_ALTSW_TESTMANAGER;
                  break;
            #ifdef FI_EN_SPM_U32_RESTART_ECU_ALTSW_NAC_TESTSOFTWARE
            case  spm_fi_tcl_SPM_e32_RESTART_TYPE::FI_EN_SPM_U32_RESTART_ECU_ALTSW_NAC_TESTSOFTWARE:
                  restartMode = DIA_EN_SPM_RESTART_MODE_ECU_ALTSW_NAC_TESTSOFTWARE;
                  break;
                #endif
            default:
                  break;
            }
            pListener->vOnGetSystemRestartValue(restartMode);
         }
      }
      else if (poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_ERROR)
      {
          amt_tclServiceDataError oErrorMsg(poMessage);
         tU16 u16ErrorCode = oErrorMsg.u16GetErrorData();
         DIA_TR_ERR("dia_SAFeatureSpmBase::vHandleSystemRestart --- opcode error received: %d", u16ErrorCode);
      }
      (void) poMessage->bDelete();
   }
}

//-----------------------------------------------------------------------------
#if 0
void dia_SAFeatureSpmBase::vHandleStatusSystemPowerSaveMode(amt_tclServiceData* poMessage) const
{
   dia_tclFnctTrace trc("dia_SAFeatureSpmBase::vHandleStatusSystemPowerSaveMode");

   if (poMessage)
   {
      DIA_ASSERT(poMessage->bIsServerMessage() == TRUE);

      if (poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS)
      {
         dia_ISpmListener* pListener = OSAL_NULL;
         querySysAdapterListener<dia_ISpmListener>(&pListener);
         if (pListener)
         {
            fi_tclVisitorMessage oResultMsg(poMessage);
            spm_corefi_tclMsgSysPwrSaveModeStatus oCompResp;
            (void) oResultMsg.s32GetData(oCompResp);

            tU32 sysPwrSaveMode;
            sysPwrSaveMode = (tU32) (oCompResp.SysPwrSaveMode.u32Value);
            DIA_TR_INF("dia_SAFeatureSpmBase::vHandleStatusSystemPowerSaveMode %d return value:", sysPwrSaveMode);
            DIA_TR_INF("dia_SAFeatureSpmBase::vHandleStatusSystemPowerSaveMode =================");

            pListener->vOnGetSystemPowerSaveMode(sysPwrSaveMode);
         }
      }
      else if (poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_ERROR)
      {
         amt_tclServiceDataError oErrorMsg(poMessage);
         tU16 u16ErrorCode = oErrorMsg.u16GetErrorData();
         DIA_TR_ERR("dia_SAFeatureSpmBase::vHandleStatusSystemPowerSaveMode --- opcode error received: %d", u16ErrorCode);
      }
      (void) poMessage->bDelete();
   }
}
#endif
//-----------------------------------------------------------------------------
#if 0
void dia_SAFeatureSpmBase::vHandleStatusSwitchOnHistory(amt_tclServiceData* poMessage) const
{
   dia_tclFnctTrace trc("dia_SAFeatureSpmBase::vHandleStatusSwitchOnHistory");

   if (poMessage)
   {
      DIA_ASSERT(poMessage->bIsServerMessage() == TRUE);

      if (poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS)
      {
         dia_ISpmListener* pListener = OSAL_NULL;
         querySysAdapterListener<dia_ISpmListener>(&pListener);
         if (pListener)
         {
            fi_tclVisitorMessage oResultMsg(poMessage);
            spm_corefi_tclMsgSwitchOnHistoryStatus oCompResp;
            (void) oResultMsg.s32GetData(oCompResp);

            std::vector<tU8> switchOnElements;
            DIA_TR_INF("dia_SAFeatureSpmBase::vHandleStatusSwitchOnHistory %d/0x%02x return values:", oCompResp.tSwitchOnList.size(), oCompResp.tSwitchOnList.size());
            switchOnElements.push_back((tU8)oCompResp.tSwitchOnList.size());
            DIA_TR_INF("dia_SAFeatureSpmBase::vHandleStatusSwitchOnHistory =================");

            std::vector<spm_fi_tcl_SwitchOnElement, std::allocator<spm_fi_tcl_SwitchOnElement> >::iterator it =  oCompResp.tSwitchOnList.begin();
            for (tU8 i = 0; it!=oCompResp.tSwitchOnList.end(); ++it, ++i)
            {
               DIA_TR_INF("::vHandleStatusSwitchOnHistory(%d) s16Year                = %d / 0x%04x", i, it->tSwitchOnDate.s16Year, it->tSwitchOnDate.s16Year);
               DIA_TR_INF("::vHandleStatusSwitchOnHistory(%d) u8Month                = %d", i, it->tSwitchOnDate.u8Month);
               DIA_TR_INF("::vHandleStatusSwitchOnHistory(%d) u8Day                  = %d", i, it->tSwitchOnDate.u8Day);
               DIA_TR_INF("::vHandleStatusSwitchOnHistory(%d) u8Hour                 = %d", i, it->tSwitchOnDate.u8Hour);
               DIA_TR_INF("::vHandleStatusSwitchOnHistory(%d) u8Minute               = %d", i, it->tSwitchOnDate.u8Minute);
               DIA_TR_INF("::vHandleStatusSwitchOnHistory(%d) u8Second               = %d", i, it->tSwitchOnDate.u8Second);
               DIA_TR_INF("::vHandleStatusSwitchOnHistory(%d) eSwitchOnReason (tU32) = 0x%08x", i, it->eSwitchOnReason.enType);
               DIA_TR_INF("::vHandleStatusSwitchOnHistory ------------------------");

               switchOnElements.push_back(U16_BYTE1((tU16)it->tSwitchOnDate.s16Year));                //byte#0
               switchOnElements.push_back(U16_BYTE2((tU16)it->tSwitchOnDate.s16Year));                //byte#1
               switchOnElements.push_back(it->tSwitchOnDate.u8Month);                                 //byte#2
               switchOnElements.push_back(it->tSwitchOnDate.u8Day);                                   //byte#3
               switchOnElements.push_back(it->tSwitchOnDate.u8Hour);                                  //byte#4
               switchOnElements.push_back(it->tSwitchOnDate.u8Minute);                                //byte#5
               switchOnElements.push_back(it->tSwitchOnDate.u8Second);                                //byte#6

               switchOnElements.push_back(U32_BYTE1((tU32)it->eSwitchOnReason.enType));               //byte#7
               switchOnElements.push_back(U32_BYTE2((tU32)it->eSwitchOnReason.enType));               //byte#8
               switchOnElements.push_back(U32_BYTE3((tU32)it->eSwitchOnReason.enType));               //byte#9
               switchOnElements.push_back(U32_BYTE4((tU32)it->eSwitchOnReason.enType));               //byte#10
            }

            dia_eSpmStartUpReason startUpReason = DIA_EN_SPM_STARTUP_REASON_UNKNOWN;
            if (((tU8)oCompResp.tSwitchOnList.size()) >= 1)
            {
               switch ( oCompResp.tSwitchOnList.at(0).eSwitchOnReason.enType )
               {
                  case spm_fi_tcl_SPM_e32_SubStateType::FI_EN_SPM_U32_SUBSTATE_S_CONTACT:
                      startUpReason = DIA_EN_SPM_STARTUP_REASON_S_CONTACT;
                      break;
                  case spm_fi_tcl_SPM_e32_SubStateType::FI_EN_SPM_U32_SUBSTATE_PHONE:
                      startUpReason = DIA_EN_SPM_STARTUP_REASON_PHONE;
                      break;
                  case spm_fi_tcl_SPM_e32_SubStateType::FI_EN_SPM_U32_SUBSTATE_DOWNLOAD:
                      startUpReason = DIA_EN_SPM_STARTUP_REASON_DOWNLOAD;
                      break;
                  case spm_fi_tcl_SPM_e32_SubStateType::FI_EN_SPM_U32_SUBSTATE_ON_TIPPER:
                      startUpReason = DIA_EN_SPM_STARTUP_REASON_ON_TIPPER;
                      break;
                  default:
                      break;
               }  //lint !e788: not all items intentionally used within defaulted switch
            }
            pListener->vOnGetStartUpReason(startUpReason);

            dia_eSpmStartUpReason lastStartUpReason = DIA_EN_SPM_STARTUP_REASON_UNKNOWN;
            if (((tU8)oCompResp.tSwitchOnList.size()) >= 2)
            {
               switch ( oCompResp.tSwitchOnList.at(1).eSwitchOnReason.enType )
               {
                  case spm_fi_tcl_SPM_e32_SubStateType::FI_EN_SPM_U32_SUBSTATE_S_CONTACT:
                     lastStartUpReason = DIA_EN_SPM_STARTUP_REASON_S_CONTACT;
                  break;
                  case spm_fi_tcl_SPM_e32_SubStateType::FI_EN_SPM_U32_SUBSTATE_PHONE:
                     lastStartUpReason = DIA_EN_SPM_STARTUP_REASON_PHONE;
                  break;
                  case spm_fi_tcl_SPM_e32_SubStateType::FI_EN_SPM_U32_SUBSTATE_DOWNLOAD:
                     lastStartUpReason = DIA_EN_SPM_STARTUP_REASON_DOWNLOAD;
                  break;
                  case spm_fi_tcl_SPM_e32_SubStateType::FI_EN_SPM_U32_SUBSTATE_ON_TIPPER:
                     lastStartUpReason = DIA_EN_SPM_STARTUP_REASON_ON_TIPPER;
                  break;
                  default:
                     break;
               }
            }
            pListener->vOnGetLastStartUpReason(lastStartUpReason);
         }
      }
      else if (poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_ERROR)
      {
         amt_tclServiceDataError oErrorMsg(poMessage);
         tU16 u16ErrorCode = oErrorMsg.u16GetErrorData();
         DIA_TR_ERR("dia_SAFeatureSpmBase::vHandleStatusSwitchOnHistory --- opcode error received: %d", u16ErrorCode);
      }
      (void) poMessage->bDelete();
   }
}
#endif
//-----------------------------------------------------------------------------

void dia_SAFeatureSpmBase::vHandleSystemResetInformation(amt_tclServiceData* poMessage) const
{
   dia_tclFnctTrace trc("dia_SAFeatureSpmBase::vHandleSystemResetInformation");
   if (poMessage)
   {
      DIA_ASSERT(poMessage->bIsServerMessage() == TRUE);

      if (poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS)
      {
         dia_ISpmListener* pListener = OSAL_NULL;
         querySysAdapterListener<dia_ISpmListener>(&pListener);
         if (pListener)
         {
            fi_tclVisitorMessage oResultMsg(poMessage);
         spm_corefi_tclMsgResetCounterStatus oCompResp;
         if (OSAL_OK==oResultMsg.s32GetData(oCompResp))
         {
            pListener->vOnResetSystemResetStatus(DIA_SUCCESS);

            dia_tSpmResetDate lastResetdate(
              (tU16)oCompResp.tLastResetDate.s16Year,
              oCompResp.tLastResetDate.u8Month,
              oCompResp.tLastResetDate.u8Day,
              oCompResp.tLastResetDate.u8Hour,
              oCompResp.tLastResetDate.u8Minute,
              oCompResp.tLastResetDate.u8Second);

               dia_tSpmResetCounterStatus status(
              (tU8)oCompResp.tLastResetReason.enType,
              oCompResp.u32ApApplicationError,
              oCompResp.u32ApSoftware,
              oCompResp.u32ApEcuReset,
              oCompResp.u32ApDownload,
              oCompResp.u32ApDownloadError,
              oCompResp.u32ApOvertemperature,
              oCompResp.u32ApUser,
              oCompResp.u32ApLcmIntern,
              oCompResp.u32ApWarmstartCount,
              oCompResp.u32ApPowerOnCount,
              oCompResp.u32ApPowerLossCount,
              oCompResp.u32ApPowerOffCount,
              oCompResp.u32ApSccCount,
              oCompResp.u32ApUnknownCount,
              oCompResp.u32SccHwWdtCount,
              oCompResp.u32SccPowerOnCount,
              oCompResp.u32SccColdstartCount,
              oCompResp.u32SccAppmodeChangeCount,
              oCompResp.u32SccDuringLpwCount,
              oCompResp.u32SccDuringPllOszCount,
              oCompResp.u32SccDuringSWCount,
              oCompResp.u32SccWarmstartCount);

            DIA_TR_INF("dia_SAFeatureSpmBase::vHandleSystemResetInformation LastResetReason         = %d", oCompResp.tLastResetReason.enType);
            DIA_TR_INF("dia_SAFeatureSpmBase::vHandleSystemResetInformation DateYear               = %d", oCompResp.tLastResetDate.s16Year);
            DIA_TR_INF("dia_SAFeatureSpmBase::vHandleSystemResetInformation DateMonth            = %d", oCompResp.tLastResetDate.u8Month);
            DIA_TR_INF("dia_SAFeatureSpmBase::vHandleSystemResetInformation DateDay               = %d", oCompResp.tLastResetDate.u8Day);
            DIA_TR_INF("dia_SAFeatureSpmBase::vHandleSystemResetInformation DateHour               = %d", oCompResp.tLastResetDate.u8Hour);
            DIA_TR_INF("dia_SAFeatureSpmBase::vHandleSystemResetInformation DateMinute            = %d", oCompResp.tLastResetDate.u8Minute);
            DIA_TR_INF("dia_SAFeatureSpmBase::vHandleSystemResetInformation DateSecone            = %d", oCompResp.tLastResetDate.u8Second);
            DIA_TR_INF("dia_SAFeatureSpmBase::vHandleSystemResetInformation ApApplicationError      = %d", oCompResp.u32ApApplicationError);
            DIA_TR_INF("dia_SAFeatureSpmBase::vHandleSystemResetInformation ApSoftware            = %d", oCompResp.u32ApSoftware);
            DIA_TR_INF("dia_SAFeatureSpmBase::vHandleSystemResetInformation ApEcuReset            = %d", oCompResp.u32ApEcuReset);
            DIA_TR_INF("dia_SAFeatureSpmBase::vHandleSystemResetInformation ApDownload            = %d", oCompResp.u32ApDownload);
            DIA_TR_INF("dia_SAFeatureSpmBase::vHandleSystemResetInformation ApDownloadError         = %d", oCompResp.u32ApDownloadError);
            DIA_TR_INF("dia_SAFeatureSpmBase::vHandleSystemResetInformation ApOvertemperature      = %d", oCompResp.u32ApOvertemperature);
            DIA_TR_INF("dia_SAFeatureSpmBase::vHandleSystemResetInformation ApUser               = %d", oCompResp.u32ApUser);
            DIA_TR_INF("dia_SAFeatureSpmBase::vHandleSystemResetInformation ApLcmIntern            = %d", oCompResp.u32ApLcmIntern);
            DIA_TR_INF("dia_SAFeatureSpmBase::vHandleSystemResetInformation ApWarmstartCount         = %d", oCompResp.u32ApWarmstartCount);
            DIA_TR_INF("dia_SAFeatureSpmBase::vHandleSystemResetInformation ApPowerOnCount         = %d", oCompResp.u32ApPowerOnCount);
            DIA_TR_INF("dia_SAFeatureSpmBase::vHandleSystemResetInformation ApPowerLossCount         = %d", oCompResp.u32ApPowerLossCount);
            DIA_TR_INF("dia_SAFeatureSpmBase::vHandleSystemResetInformation ApPowerOffCount         = %d", oCompResp.u32ApPowerOffCount);
            DIA_TR_INF("dia_SAFeatureSpmBase::vHandleSystemResetInformation ApSccCount            = %d", oCompResp.u32ApSccCount);
            DIA_TR_INF("dia_SAFeatureSpmBase::vHandleSystemResetInformation ApUnknownCount         = %d", oCompResp.u32ApUnknownCount);
            DIA_TR_INF("dia_SAFeatureSpmBase::vHandleSystemResetInformation SccHwWdtCount         = %d", oCompResp.u32SccHwWdtCount);
            DIA_TR_INF("dia_SAFeatureSpmBase::vHandleSystemResetInformation SccPowerOnCount         = %d", oCompResp.u32SccPowerOnCount);
            DIA_TR_INF("dia_SAFeatureSpmBase::vHandleSystemResetInformation SccColdstartCount      = %d", oCompResp.u32SccColdstartCount);
            DIA_TR_INF("dia_SAFeatureSpmBase::vHandleSystemResetInformation SccAppmodeChangeCount   = %d", oCompResp.u32SccAppmodeChangeCount);
            DIA_TR_INF("dia_SAFeatureSpmBase::vHandleSystemResetInformation SccDuringLpwCount      = %d", oCompResp.u32SccDuringLpwCount);
            DIA_TR_INF("dia_SAFeatureSpmBase::vHandleSystemResetInformation SccDuringPllOszCount      = %d", oCompResp.u32SccDuringPllOszCount);
            DIA_TR_INF("dia_SAFeatureSpmBase::vHandleSystemResetInformation SccDuringSWCount         = %d", oCompResp.u32SccDuringSWCount);
            DIA_TR_INF("dia_SAFeatureSpmBase::vHandleSystemResetInformation SccWarmstartCount      = %d", oCompResp.u32SccWarmstartCount);

               pListener->vOnSystemResetInformation(&lastResetdate, &status);
            }
            else
            {
               DIA_TR_ERR("dia_SAFeatureSpmBase::vHandleSystemResetInformation s32GetData FAILED!!!");
            pListener->vOnResetSystemResetStatus(DIA_FAILED);
               pListener->vOnSystemResetInformation(NULL, NULL);
            }
         }
      }
      else if (poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_ERROR)
      {
         amt_tclServiceDataError oErrorMsg(poMessage);
         tU16 u16ErrorCode = oErrorMsg.u16GetErrorData();
         DIA_TR_INF("dia_SAFeatureSpmBase ---opcode error received with error code: %d", u16ErrorCode);
      }
      (void) poMessage->bDelete();
   }
}
//-----------------------------------------------------------------------------

void dia_SAFeatureSpmBase::vHandleSystemHardReset(amt_tclServiceData* poMessage) const
{
   dia_tclFnctTrace trc("dia_SAFeatureSpmBase::vHandleSystemHardReset");

   if (poMessage)
   {
      DIA_ASSERT(poMessage->bIsServerMessage() == TRUE);
      if (poMessage->u8GetOpCode() == CCA_C_U8_OPCODE_METHODRESULT)
      {
         dia_ISpmListener* pListener = OSAL_NULL;
         querySysAdapterListener<dia_ISpmListener>(&pListener);
         // notify all registered listeners
         if (pListener)
         {
          pListener->vOnSystemRestart(DIA_SUCCESS);
       }
      }
      else if (poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_ERROR)
      {
         amt_tclServiceDataError oErrorMsg(poMessage);
         tU16 u16ErrorCode = oErrorMsg.u16GetErrorData();
         DIA_TR_ERR("dia_SAFeatureSpmBase::vHandleSystemHardReset --- opcode error received: %d", u16ErrorCode);
      }
      (void) poMessage->bDelete();
   }
}

//-----------------------------------------------------------------------------

void dia_SAFeatureSpmBase::vHandleSystemVoltageInformation(amt_tclServiceData* poMessage) const
{
   dia_tclFnctTrace trc("dia_SAFeatureSpmBase::vHandleSystemVoltageInformation");

   if (poMessage)
   {
      DIA_ASSERT(poMessage->bIsServerMessage() == TRUE);

      if (poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS)
      {
         dia_ISpmListener* pListener = OSAL_NULL;
         querySysAdapterListener<dia_ISpmListener>(&pListener);
         if (pListener)
         {
            fi_tclVisitorMessage oResultMsg(poMessage);
            spm_corefi_tclMsgUBatSenseStatus oCompResp;
            (void) oResultMsg.s32GetData(oCompResp);

            DIA_TR_INF("dia_SAFeatureSpmBase::vHandleSystemVoltageInformation %d return value:", oCompResp.UBatSense);
            DIA_TR_INF("dia_SAFeatureSpmBase::vHandleSystemVoltageInformation =================");
            pListener->vOnGetBatteryVoltage(oCompResp.UBatSense);
         }
      }
      else if (poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_ERROR)
      {
         amt_tclServiceDataError oErrorMsg(poMessage);
         tU16 u16ErrorCode = oErrorMsg.u16GetErrorData();
         DIA_TR_ERR("dia_SAFeatureSpmBase::vHandleSystemVoltageInformation --- opcode error received: %d", u16ErrorCode);
      }
      (void) poMessage->bDelete();
   }
}

//-----------------------------------------------------------------------------

void dia_SAFeatureSpmBase::vHandleSystemPowerMode(amt_tclServiceData* poMessage) const
{
   dia_tclFnctTrace trc("dia_SAFeatureSpmBase::vHandleSystemPowerMode");

   if (poMessage) {
      DIA_ASSERT(poMessage->bIsServerMessage() == TRUE);

      if (poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS) {
         dia_ISpmListener* pListener = OSAL_NULL;
         querySysAdapterListener<dia_ISpmListener>(&pListener);
         if (pListener) {
            fi_tclVisitorMessage oResultMsg(poMessage);
            spm_corefi_tclMsgSysPwrModeStatus oCompResp;
            (void) oResultMsg.s32GetData(oCompResp);

            dia_eSpmSystemPowerState state = DIA_EN_SYS_PWR_STATE_UNKNOWN;
            switch(oCompResp.SysPwrMode.enType){
               case spm_fi_tcl_SPM_e32_SYSPWRMODE::FI_EN_SPM_U32_SYSPWRMODE_OFF:
                  DIA_TR_INF("dia_SAFeatureSpmBase::vHandleSystemPowerMode Power Mode is OFF.");
                  state = DIA_EN_SYS_PWR_STATE_OFF;
                  break;
               case spm_fi_tcl_SPM_e32_SYSPWRMODE::FI_EN_SPM_U32_SYSPWRMODE_ACCESSORY:
                  DIA_TR_INF("dia_SAFeatureSpmBase::vHandleSystemPowerMode Power Mode is ACCESSORY.");
                  state = DIA_EN_SYS_PWR_STATE_ACCESSORY;
                  break;
               case spm_fi_tcl_SPM_e32_SYSPWRMODE::FI_EN_SPM_U32_SYSPWRMODE_RUN:
                  DIA_TR_INF("dia_SAFeatureSpmBase::vHandleSystemPowerMode Power Mode is RUN.");
                  state = DIA_EN_SYS_PWR_STATE_RUN;
                  break;
               default:
                  DIA_TR_ERR("dia_SAFeatureSpmBase::vHandleSystemPowerMode UNKNOWN POWER MODE 0x%02x !", oCompResp.SysPwrMode.enType);
                  break;
            }

            pListener->vOnPowerState ( state );
         } else {
            DIA_TR_ERR("dia_SAFeatureSpmBase::vHandleSystemPowerMode unable to resolve Listener");
         }
      } else if (poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_ERROR) {
         amt_tclServiceDataError oErrorMsg(poMessage);
         tU16 u16ErrorCode = oErrorMsg.u16GetErrorData();
         DIA_TR_ERR("dia_SAFeatureSpmBase::vHandleSystemPowerMode - opcode error received: %d", u16ErrorCode);
      }
      (void) poMessage->bDelete();
   }
}

//-----------------------------------------------------------------------------

void dia_SAFeatureSpmBase::vHandleVoltageEventCounter(amt_tclServiceData* poMessage) const
{
   spm_corefi_tclMsgVoltageEventCounterStatus oFiMsg;
   dia_ISpmListener* pListener;
   if (dia_getFiMessageAndListener(poMessage, "dia_SAFeatureSpmBase::vHandleVoltageEventCounter", oFiMsg, pListener)) {
      spm_fi_tcl_SPM_VoltageEventCounter const & spmCounters = oFiMsg.tVoltageEventCounter;
      dia_tPowerSupplyVoltageEventCounters diagStatus(spmCounters.LowVoltageCount
                                                      , spmCounters.CrLowVoltageCount
                                                      , spmCounters.HighVoltageCount
                                                      , spmCounters.CrHighVoltageCount
                                                      );

      DIA_TR_INF("   LowVoltageCount=%u", spmCounters.LowVoltageCount);
      DIA_TR_INF("   CrLowVoltageCount=%u", spmCounters.CrLowVoltageCount);
      DIA_TR_INF("   HighVoltageCount=%u", spmCounters.HighVoltageCount);
      DIA_TR_INF("   CrHighVoltageCount=%u", spmCounters.CrHighVoltageCount);

      pListener->vOnGetPowerSupplyVoltageEventCounters(diagStatus);
   }
}

void dia_SAFeatureSpmBase::vHandleVoltageRangeHistogram(amt_tclServiceData* poMessage) const
{
   spm_corefi_tclMsgVoltageRangeHistogramStatus oFiMsg;
   dia_ISpmListener* pListener;
   if (dia_getFiMessageAndListener(poMessage, "dia_SAFeatureSpmBase::tclMsgVoltageRangeHistogramStatus", oFiMsg, pListener)) {


      // fill the internal histogram
      std::vector<dia_tSpmVoltageHistogramElement> diagStatus;
      for (std::vector<spm_fi_tcl_SPM_VoltageRange>::iterator iter =  oFiMsg.listVoltageRangeHistogram.begin();
           iter != oFiMsg.listVoltageRangeHistogram.end();
           ++iter)
      {
         DIA_TR_INF("got entry: %u mV -> %u s", iter->VoltageValue, iter->OperationTime);
         diagStatus.push_back(dia_tSpmVoltageHistogramElement(iter->VoltageValue, iter->OperationTime));
      }

      pListener->vOnGetPowerSupplyVoltageHistogram(&diagStatus);
   }
}



void dia_SAFeatureSpmBase::vHandleCpuUsageStatistic(amt_tclServiceData* poMessage) const
{
   spm_corefi_tclMsgCpuUsageStatisticStatus oFiMsg;
   dia_ISpmListener* pListener;
   if (dia_getFiMessageAndListener(poMessage, "dia_SAFeatureSpmBase::vHandleCpuUsageStatistic", oFiMsg, pListener)) {
      dia_tSpmStatisticData diagStatus;
      dia_fiToDia(oFiMsg.tCpuUsageStatisticsData, diagStatus);
      pListener->vOnGetCpuUsageStatistics(diagStatus);
   }
}

void dia_SAFeatureSpmBase::vHandleRamUsageStatistic(amt_tclServiceData* poMessage) const
{
   spm_corefi_tclMsgRamUsageStatisticStatus oFiMsg;
   dia_ISpmListener* pListener;
   if (dia_getFiMessageAndListener(poMessage, "dia_SAFeatureSpmBase::vHandleRamUsageStatistic", oFiMsg, pListener)) {
      dia_tSpmStatisticData diagStatus;
      dia_fiToDia(oFiMsg.tRamUsageStatisticsData, diagStatus);
      pListener->vOnGetRamUsageStatistics(diagStatus);
   }
}

void dia_SAFeatureSpmBase::vHandleStartupTimeStatistic(amt_tclServiceData* poMessage) const
{
   spm_corefi_tclMsgStartupTimeStatisticStatus oFiMsg;
   dia_ISpmListener* pListener;
   if (dia_getFiMessageAndListener(poMessage, "dia_SAFeatureSpmBase::vHandleStartupTimeStatistic", oFiMsg, pListener)) {
      dia_tSpmStatisticData diagStatus;
      dia_fiToDia(oFiMsg.tStartupTimeStatisticsData, diagStatus);
      pListener->vOnGetStartupTimeStatistics(diagStatus);
   }
}

void dia_SAFeatureSpmBase::vHandleStartupStatus( amt_tclServiceData* poMessage ) const
{
   dia_tclFnctTrace trc("dia_SAFeatureSpmBase::vHandleStartupStatus");

   DIA_TR_INF("dia_SAFeatureSpmBase::vHandleStartupStatus");

   if (poMessage) {
     DIA_ASSERT(poMessage->bIsServerMessage() == TRUE);

     if (poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS) {
       dia_ISpmListener* pListener = OSAL_NULL;
       querySysAdapterListener<dia_ISpmListener>(&pListener);
       if (pListener) {
         fi_tclVisitorMessage oResultMsg(poMessage);
         spm_corefi_tclMsgProcessListStatus oCompResp;
         (void) oResultMsg.s32GetData(oCompResp);
         DIA_TR_INF("dia_SAFeatureSpmBase::vHandleStartupStatus process size: %d", oCompResp.tProcesses.tProcesses.size());

         std::vector<dia_tSpmStartupStatus> startupStatusElements;
         std::vector<spm_fi_tcl_ProcessElement, std::allocator<spm_fi_tcl_ProcessElement> >::iterator it;
         for (it = oCompResp.tProcesses.tProcesses.begin(); it != oCompResp.tProcesses.tProcesses.end(); ++it)
         {
            dia_tSpmStartupStatus spmStartupStatus(
               std::string(it->tProcessName.szValue),
               (tU8) it->eProcState.enType,
               it->u32StartTimeSinceStart,
               it->tSwitchOnDate.s16Year,
               it->tSwitchOnDate.u8Month,
               it->tSwitchOnDate.u8Day,
               it->tSwitchOnDate.u8Hour,
               it->tSwitchOnDate.u8Minute,
               it->tSwitchOnDate.u8Second);

            startupStatusElements.push_back(spmStartupStatus);
         }

         pListener->vOnStartupStatus( &startupStatusElements );
       } else {
         DIA_TR_ERR("dia_SAFeatureSpmBase::vHandleStartupStatus unable to resolve Listener");
       }
     } else if (poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_ERROR) {
       amt_tclServiceDataError oErrorMsg(poMessage);
       tU16 u16ErrorCode = oErrorMsg.u16GetErrorData();
       DIA_TR_ERR("dia_SAFeatureSpmBase::vHandleStartupStatus - opcode error received: %d", u16ErrorCode);
     }
     (void) poMessage->bDelete();
   }
}

void dia_SAFeatureSpmBase::vHandleSpecificSwVersionStatistic(amt_tclServiceData* poMessage)
{
   dia_tclFnctTrace trc("dia_SAFeatureSpmBase::vHandleSpecificSwVersionStatistic()");
   uint16_t cmdCounter=poMessage->u16GetCmdCounter();
   FiMsgHandlerBase< spm_corefi_tclMsgSpecificSWVersionStatisticMethodResult> *msgHandler=
   mFiMsgHandlerListSpecificSWVersionStatistic.getHandler(cmdCounter);
   if (!msgHandler) {
      return;
   }
   spm_corefi_tclMsgSpecificSWVersionStatisticMethodResult oFiMsg;
   if (!dia_getFiMessage(poMessage, "SpecificSwVersionStatistic", oFiMsg)) {
      return;
   }


   DIA_TR_INF("vHandleSpecificSwVersionStatistic:XXX rcv cmdCounter=%u", cmdCounter);

#ifdef DIA_SPECIFIC_SW_VERSION_STATISTIC_VERBOSE
 // switched off, causes too much output, left here has example for smaller messages
   if (isTraceActive()) {
      dia::MsgPrinter printer("spm_corefi_tclMsgSpecificSWVersionStatisticMethodResult");
      visitMsg(oFiMsg, printer);
   }
#endif
   msgHandler->handleFiMsg(oFiMsg);
   mFiMsgHandlerListSpecificSWVersionStatistic.deleteHandler(cmdCounter);
}


