 /*
 * \file        dia_SAFeatureSelftestController.h
 *
 * \brief       System Adapter for selftest controller (used DiagLib routine control)
 *
 * \details
 *
 * \author      wgl2hi, kaa1hi
 *
 * \date        14-Nov-2014
 *
 * \copyright   Robert Bosch Car Multimedia 2014
 *
 */

#ifndef DIA_SAFEATURESELFTESTRSEROUTINECTRL_H_
#define DIA_SAFEATURESELFTESTRSEROUTINECTRL_H_

#ifndef DIA_SAFEATURESELFTESTCONTROLLERENUM_H_
#include "project/framework/sysadapters/dia_SAFeatureSelftestControllerEnum.h"
#endif

#ifndef __INCLUDED_DIA_COMMON_CORE__
#include "common/depricated/dia_common_core.h"
#endif

#ifndef DIA_SELFTESTCONTROLLERPLUGIN_H_
#include "common/framework/application/dia_SelftestControllerPlugin.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_DIAGLIB_ROUTINE_CONTROL_LISTENER__
#include "common/depricated/SystemAdapter/dia_IDiaglibRoutineControlListener.h"
#endif

#ifndef __INCLUDED_DIA_COMMON_SYSTEM_ADAPTERS__
#include "common/framework/sysadapters/dia_common_system_adapters.h"
#endif

//-----------------------------------------------------------------------------
// class definition
//-----------------------------------------------------------------------------

class dia_SAFeatureSelftestController
   : public dia_SystemAdapterFeatureDiaglib,
     public dia_SelftestControllerPlugin,
     public dia_IDiaglibRoutineControlListener
{
public:
   //! constructor
   dia_SAFeatureSelftestController ( tCString name, dia_eSelftestControllerPluginType id, tU32 diagLibRoutineCtrlID, dia_SystemAdapterServicePluginDiaglib& pSrvPlugin );

   //! destructor
   virtual ~dia_SAFeatureSelftestController ( tVoid );

   //! return the diaglib IDs managed by this feature
   virtual tDiaResult getDiaglibIDs ( std::list<tU32>& results ) const;

   //-------------------------------------------------------------------------
   //
   // Overloaded dia_SelftestControllerPlugin methods
   //
   //-------------------------------------------------------------------------

   //! start selftest (send request to component)
   virtual tDiaResult startSelftest ( void );

   //! force the status of the last selftest (send request to component)
   virtual tDiaResult forceSelftestResult ( void );

   //-------------------------------------------------------------------------
   //
   // Overloaded dia_IDiaglibRoutineControlListener methods
   //
   //-------------------------------------------------------------------------

   //! called on starting routine control
   virtual tVoid vOnRoutineCtrlResult ( tU32 u32RoutineId, tenRoutineCtrlResult enRoutineStatus, const tDiaglibParamVector& oStartResult );

   //! called on requesting routine result
   virtual tVoid vOnGetRoutineResult ( tU32 u32RoutineId, tenRoutineCtrlResult enRoutineStatus, const tDiaglibParamVector& oStartResult );

protected:
   //! deprecated default constructor
   dia_SAFeatureSelftestController ( tVoid );

   //! handle incoming CCA message for routine control
   tVoid vHandleRoutineControl ( amt_tclServiceData* poMessage );

   //! handle incoming CCA message for routine result
   tVoid vHandleRoutineControlResult ( amt_tclServiceData* poMessage );

protected:
   //! diaglib routine control id
   const tU32 mDiagLibRoutineCtrlID;

   // declare message map data structures
   DECLARE_MSG_MAP(dia_SAFeatureSelftestController)
};

#endif /* DIA_SAFEATURESELFTESTRSEROUTINECTRL_H_ */
