/*
 * \file        dia_SAFeatureSelfDiagnosisSecondDisplay.cpp
 *
 * \brief       System Adapter for selftest routine control (used by any
 *              component communicated with DiagLib)
 *
 * \details
 *
 * \author      stc2hi
 *
 * \date        19.10.2017
 *
 * \copyright   Robert Bosch Car Multimedia 2014
 *
 */

#ifndef __INCLUDED_DIA_SYSTEM_SETTINGS_MANAGER__
#include <common/framework/sysset/dia_SystemSettingsManager.h>
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_DIAGLIB__
#include "project/framework/sysadapters/dia_SAFeatureDiaglib.h"
#endif

#ifndef __INCLUDED_DIA_SAFEATURE_SELF_DIAGNOSIS_SECOND_DISPLAY__
#include "dia_SAFeatureSelfDiagnosisSecondDisplay.h"
#endif

#define DIMMING_FI_S_IMPORT_INTERFACE_DIMMING_MAINFI_TYPES
#define DIMMING_FI_S_IMPORT_INTERFACE_DIMMING_MAINFI_FUNCTIONIDS
#define DIMMING_FI_S_IMPORT_INTERFACE_DIMMING_MAINFI_SERVICEINFO
#include "dimming_fi_if.h"

/// MESSAGE MAP:
// The message map maps IDs of incoming CCA messages to proper handle methods
BEGIN_MSG_MAP(dia_SAFeatureSelfDiagnosisSecondDisplay,dia_SystemAdapterFeature)
   ON_MESSAGE( DIMMING_MAINFI_C_U16_DIM_SECOND_DISP_SELFDIAGNOSISRESULT, vHandleSelfDiagnosisResult )
END_MSG_MAP()


static const dia_SystemSettingsModuleTypeInfo systemSettingsModuleTypeInfo =
{
      DIA_C_U32_SYSTEM_SETTING_TYPE_MASK_SELF_DIAGNOSIS,
      DIA_C_STR_SYSTEM_SETTING_TYPE_SELF_DIAGNOSIS,
      DIA_C_UID_SYSTEM_SETTING_TYPE_SELF_DIAGNOSIS
};

//------------------------------------------------------------------------------

dia_SAFeatureSelfDiagnosisSecondDisplay::dia_SAFeatureSelfDiagnosisSecondDisplay (tCString name, dia_SystemAdapterServicePlugin& pSrvPlugin)
    : dia_SystemAdapterFeature(name,pSrvPlugin),
      dia_SystemSettingsModule(name)/*,
      mDiagLibRoutineCtrlID(ROUTINEID_EXT_AUDIO_AMPLIFIER_SELFTEST)*/
{
   dia_tclFnctTrace trc("dia_SAFeatureSelfDiagnosisSecondDisplay::dia_SAFeatureSelfDiagnosisSecondDisplay");

   dia_SystemSettingsModule::mTypeLookupRep[DIA_C_UID_SYSTEM_SETTING_TYPE_SELF_DIAGNOSIS] = systemSettingsModuleTypeInfo;
   dia_SystemSettingsModule::isTypeMaskUsed = true;
}

//-----------------------------------------------------------------------------

dia_SAFeatureSelfDiagnosisSecondDisplay::~dia_SAFeatureSelfDiagnosisSecondDisplay ( )
{}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureSelfDiagnosisSecondDisplay::prepareSystemSetting ( dia_UID typeUID, const dia_SystemSettingExtendedData& /*extData*/ )
{
   dia_tclFnctTrace trc("dia_SAFeatureSelfDiagnosisSecondDisplay::prepareSystemSetting()");

   tDiaResult retCode = DIA_SUCCESS;

   DIA_ASSERT(typeUID == DIA_C_UID_SYSTEM_SETTING_TYPE_SELF_DIAGNOSIS);

   getInstanceOfSystemSettingsManager()->onSystemSettingsModuleUpdate(*this,typeUID,DIA_EN_SYSTEM_SETTING_LEVEL_PREPARE,retCode);

   return retCode;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureSelfDiagnosisSecondDisplay::executeSystemSetting ( dia_UID typeUID, const dia_SystemSettingExtendedData& /*extData*/ )
{
   dia_tclFnctTrace trc("dia_SAFeatureSelfDiagnosisSecondDisplay::executeSystemSetting()");

   tDiaResult retCode = DIA_FAILED;

   DIA_ASSERT(typeUID == DIA_C_UID_SYSTEM_SETTING_TYPE_SELF_DIAGNOSIS);

   dimming_mainfi_tclMsgDIM_SECOND_DISP_SelfDiagnosisResultGet oMsgData;
   fi_tclVisitorMessage oMessage(oMsgData);
   mpSrvPlugin->vInitServiceData(oMessage, DIMMING_MAINFI_C_U16_DIM_SECOND_DISP_SELFDIAGNOSISRESULT, CCA_C_U8_OPCODE_GET);

   if ( mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE )
   {
        retCode = DIA_SUCCESS;
   }
   else
   {
      DIA_TR_ERR("dia_SAFeatureSelfDiagnosisSecondDisplay::executeSystemSetting - transmitMessage failed!!!");
   }

   return retCode;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureSelfDiagnosisSecondDisplay::finalizeSystemSetting ( dia_UID typeUID, const dia_SystemSettingExtendedData& /*extData*/ )
{
   dia_tclFnctTrace trc("dia_SAFeatureSelfDiagnosisSecondDisplay::finalizeSystemSetting()");

   tDiaResult retCode = DIA_SUCCESS;

#if 0 //not required (see dia_SystemSettingsManager::vFsmSendSystemSettingsRequests)
   DIA_ASSERT(typeUID == DIA_C_UID_SYSTEM_SETTING_TYPE_SELF_DIAGNOSIS);

   getInstanceOfSystemSettingsManager()->onSystemSettingsModuleUpdate(*this, typeUID, DIA_EN_SYSTEM_SETTING_LEVEL_FINALIZE, retCode);
#endif

   return retCode;
}

//-----------------------------------------------------------------------------
// .... HANDLER ...............................................................
//-----------------------------------------------------------------------------

void
dia_SAFeatureSelfDiagnosisSecondDisplay::vHandleSelfDiagnosisResult ( amt_tclServiceData* poMessage )
{
   dia_tclFnctTrace trc("dia_SAFeatureSelfDiagnosisSecondDisplay::vHandleSelfDiagnosisResult()");

   if ( poMessage )
   {
      DIA_ASSERT(poMessage->bIsServerMessage() == TRUE);

      if ( poMessage->u8GetOpCode() == CCA_C_U8_OPCODE_STATUS )
      {
         fi_tclVisitorMessage oReceivedMsg(poMessage);
         dimming_mainfi_tclMsgDIM_SECOND_DISP_SelfDiagnosisResultStatus oReceivedData;

         if (OSAL_OK == oReceivedMsg.s32GetData(oReceivedData))
         {
            DIA_TR_INF("u16SelfDiagResult: 0x%x", oReceivedData.u16SelfDiagResult);
         }
      }
      else if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_ERROR )
      {
         amt_tclServiceDataError oErrorMsg( poMessage );
         DIA_TR_ERR("Opcode error received with error code: 0x%04x", oErrorMsg.u16GetErrorData());
      }
      else
      {
         DIA_ASSERT_ALWAYS();
      }

      (void) poMessage->bDelete();
   }

   getInstanceOfSystemSettingsManager()->onSystemSettingsModuleUpdate(*this,
         DIA_C_UID_SYSTEM_SETTING_TYPE_SELF_DIAGNOSIS, DIA_EN_SYSTEM_SETTING_LEVEL_EXECUTE, DIA_SUCCESS);
}

