/*
 * \file        dia_SAFeatureSelfDiagnosisExtAmplifier.cpp
 *
 * \brief       System Adapter for selftest routine control (used by any
 *              component communicated with DiagLib)
 *
 * \details
 *
 * \author      wgl2hi, kaa1hi
 *
 * \date        14.11.2014
 *
 * \copyright   Robert Bosch Car Multimedia 2014
 *
 */

#ifndef __INCLUDED_DIA_SYSTEM_SETTINGS_MANAGER__
#include <common/framework/sysset/dia_SystemSettingsManager.h>
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_DIAGLIB__
#include "project/framework/sysadapters/dia_SAFeatureDiaglib.h"
#endif

#ifndef __INCLUDED_DIA_SAFEATURE_SELF_DIAGNOSIS_EXTERNAL_AMPLIFIER__
#include "dia_SAFeatureSelfDiagnosisExtAmplifier.h"
#endif

#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGLIBFI_FUNCTIONIDS
#include "midw_fi_if.h" //lint !e451 !e537 repeatedly included header file without standard include guard

#include "common/depricated/SystemAdapter/dia_IdSpecEnum.h"

/// MESSAGE MAP:
// The message map maps IDs of incoming CCA messages to proper handle methods
BEGIN_MSG_MAP(dia_SAFeatureSelfDiagnosisExtAmplifier,dia_SystemAdapterFeatureDiaglib)
   ON_MESSAGE( MIDW_DIAGLIBFI_C_U16_ROUTINECONTROL, vHandleRoutineControl )
END_MSG_MAP()


static const dia_SystemSettingsModuleTypeInfo systemSettingsModuleTypeInfo =
{
      DIA_C_U32_SYSTEM_SETTING_TYPE_MASK_SELF_DIAGNOSIS,
      DIA_C_STR_SYSTEM_SETTING_TYPE_SELF_DIAGNOSIS,
      DIA_C_UID_SYSTEM_SETTING_TYPE_SELF_DIAGNOSIS
};

//------------------------------------------------------------------------------

dia_SAFeatureSelfDiagnosisExtAmplifier::dia_SAFeatureSelfDiagnosisExtAmplifier (tCString name, dia_SystemAdapterServicePluginDiaglib& pSrvPlugin)
    : dia_SystemAdapterFeatureDiaglib(name,pSrvPlugin),
      dia_SystemSettingsModule(name),
      mDiagLibRoutineCtrlID(ROUTINEID_EXT_AUDIO_AMPLIFIER_SELFTEST)
{
   dia_tclFnctTrace trc("dia_SAFeatureSelfDiagnosisExtAmplifier::dia_SAFeatureSelfDiagnosisExtAmplifier");

   dia_SystemSettingsModule::mTypeLookupRep[DIA_C_UID_SYSTEM_SETTING_TYPE_SELF_DIAGNOSIS] = systemSettingsModuleTypeInfo;
   dia_SystemSettingsModule::isTypeMaskUsed = true;
}

//-----------------------------------------------------------------------------

dia_SAFeatureSelfDiagnosisExtAmplifier::~dia_SAFeatureSelfDiagnosisExtAmplifier ( )
{}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureSelfDiagnosisExtAmplifier::getDiaglibIDs ( std::list<tU32>& results ) const
{
   dia_tclFnctTrace trc("dia_SAFeatureSelfDiagnosisExtAmplifier::getDiaglibIDs()");
   results.push_back(mDiagLibRoutineCtrlID);

   return DIA_SUCCESS;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureSelfDiagnosisExtAmplifier::prepareSystemSetting ( dia_UID typeUID, const dia_SystemSettingExtendedData& /*extData*/ )
{
   dia_tclFnctTrace trc("dia_SAFeatureSelfDiagnosisExtAmplifier::prepareSystemSetting()");

   tDiaResult retCode = DIA_SUCCESS;

   DIA_ASSERT(typeUID == DIA_C_UID_SYSTEM_SETTING_TYPE_SELF_DIAGNOSIS);

   getInstanceOfSystemSettingsManager()->onSystemSettingsModuleUpdate(*this,typeUID,DIA_EN_SYSTEM_SETTING_LEVEL_PREPARE,retCode);

   return retCode;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureSelfDiagnosisExtAmplifier::executeSystemSetting ( dia_UID typeUID, const dia_SystemSettingExtendedData& /*extData*/ )
{
   dia_tclFnctTrace trc("dia_SAFeatureSelfDiagnosisExtAmplifier::executeSystemSetting()");

   tDiaResult retCode = DIA_FAILED;

   DIA_ASSERT(typeUID == DIA_C_UID_SYSTEM_SETTING_TYPE_SELF_DIAGNOSIS);

   /* no input parameter is necessary */
   tDiaglibParamVector vecRequest;
   if (dia_SAFeatureDiaglib::bRoutineControlStart(mDiagLibRoutineCtrlID, EN_ROUTINE_FLAG_WRITE_TO_RM, vecRequest, mpSrvPlugin) == TRUE)
   {
      retCode = DIA_SUCCESS;
   }
   else
   {
      DIA_TR_ERR("dia_SAFeatureSelfDiagnosisExtAmplifier::executeSystemSetting => bRoutineControlStart FAILED !!!");
   }


   return retCode;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureSelfDiagnosisExtAmplifier::finalizeSystemSetting ( dia_UID typeUID, const dia_SystemSettingExtendedData& /*extData*/ )
{
   dia_tclFnctTrace trc("dia_SAFeatureSelfDiagnosisExtAmplifier::finalizeSystemSetting()");

   tDiaResult retCode = DIA_SUCCESS;

#if 0 //not required (see dia_SystemSettingsManager::vFsmSendSystemSettingsRequests)
   DIA_ASSERT(typeUID == DIA_C_UID_SYSTEM_SETTING_TYPE_SELF_DIAGNOSIS);

   getInstanceOfSystemSettingsManager()->onSystemSettingsModuleUpdate(*this, typeUID, DIA_EN_SYSTEM_SETTING_LEVEL_FINALIZE, retCode);
#endif

   return retCode;
}

//-----------------------------------------------------------------------------
// .... HANDLER ...............................................................
//-----------------------------------------------------------------------------

void
dia_SAFeatureSelfDiagnosisExtAmplifier::vHandleRoutineControl ( amt_tclServiceData* poMessage )
{
   dia_tclFnctTrace trc("dia_SAFeatureSelfDiagnosisExtAmplifier::vHandleRoutineControl()");

   dia_SAFeatureDiaglib::u32EvalRoutineCtrlMessage( poMessage, this );
}

//-----------------------------------------------------------------------------

void
dia_SAFeatureSelfDiagnosisExtAmplifier::vOnRoutineCtrlResult ( tU32 u32RoutineId,
                                                       tenRoutineCtrlResult enRoutineStatus,
                                                       const tDiaglibParamVector& oStartResult
                                                      )
{
   dia_tclFnctTrace trc("dia_SAFeatureSelfDiagnosisExtAmplifier::vOnRoutineCtrlResult");

   if (u32RoutineId != mDiagLibRoutineCtrlID)
   {
      DIA_TR_ERR("dia_SAFeatureSelfDiagnosisExtAmplifier::vOnRoutineCtrlResult - RoutineId=%d ERROR!!", u32RoutineId);
   }
   else
   {
      if ( EN_ROUTINE_CONTROL_OK == enRoutineStatus )
      {
         tenDiaglibSelfTestResult selfTestResult = EN_SelfTestResultNA;

         /* Only one output parameter is expected (selftest result) */
         if (oStartResult.size() == ROUTINEID_EXT_AUDIO_AMPLIFIER_SELFTEST_RESULT_LEN)
         {
            trParameter param = oStartResult[ROUTINEID_EXT_AUDIO_AMPLIFIER_SELFTEST_RESULT_u8TestResult];
            if (param.enType == static_cast<tenParameterType>(ROUTINEID_EXT_AUDIO_AMPLIFIER_SELFTEST_RESULT_PARAM1))
            {
               selfTestResult = static_cast<tenDiaglibSelfTestResult>(param.u8Value);
            }
            else
            {
               DIA_TR_ERR("dia_SAFeatureSelfDiagnosisExtAmplifier::vOnRoutineCtrlResult - param type=%d ERROR!!", param.enType);
            }
         }
         else
         {
            DIA_TR_ERR("dia_SAFeatureSelfDiagnosisExtAmplifier::vOnRoutineCtrlResult - number of params=%d ERROR!!", oStartResult.size());
         }

         DIA_TR_INF("dia_SAFeatureSelfDiagnosisExtAmplifier::vOnRoutineCtrlResult SelftTest Result = %d", selfTestResult);

         switch(selfTestResult)
         {
            case EN_SelfTestResultCOMPLETED_AND_OK:
                DIA_TR_INF("dia_SAFeatureSelfDiagnosisExtAmplifier::vOnRoutineCtrlResult COMPLETED_OK");
            break;

            case EN_SelfTestResultCOMPLETED_AND_NOK:
                DIA_TR_INF("dia_SAFeatureSelfDiagnosisExtAmplifier::vOnRoutineCtrlResult COMPLETED_NOK");
            break;

            case EN_SelfTestResultNA:
                DIA_TR_INF("dia_SAFeatureSelfDiagnosisExtAmplifier::vOnRoutineCtrlResult NA ==> COMPLETED_OK");
            break;

            default:
                DIA_TR_INF("dia_SAFeatureSelfDiagnosisExtAmplifier::vOnRoutineCtrlResult ABORTED");
            break;
         }
      }
      else if ( EN_ROUTINE_CONTROL_STARTED == enRoutineStatus )
      {
         DIA_TR_INF("dia_SAFeatureSelfDiagnosisExtAmplifier::vOnRoutineCtrlResult EN_ROUTINE_CONTROL_STARTED");

         tenInternalError internalError = static_cast<tenInternalError>(oStartResult[0].u8Value);

         DIA_TR_INF("dia_SAFeatureSelfDiagnosisExtAmplifier::vOnRoutineCtrlResult internalError=%d", internalError);
      }
      else if ( EN_ROUTINE_CONTROL_NOT_OK == enRoutineStatus )
      {
         DIA_TR_ERR("dia_SAFeatureSelfDiagnosisExtAmplifier::vOnRoutineCtrlResult EN_ROUTINE_CONTROL_NOT_OK !!!");

         tenInternalError internalError = static_cast<tenInternalError>(oStartResult[0].u8Value);

         DIA_TR_INF("dia_SAFeatureSelfDiagnosisExtAmplifier::vOnRoutineCtrlResult internalError=%d", internalError);
      }
      else
      {
         DIA_TR_INF("dia_SAFeatureSelfDiagnosisExtAmplifier::vOnRoutineCtrlResult enRoutineStatus = %d is UNKNOWN!!!", enRoutineStatus);
      }
   }

   getInstanceOfSystemSettingsManager()->onSystemSettingsModuleUpdate(*this,
         DIA_C_UID_SYSTEM_SETTING_TYPE_SELF_DIAGNOSIS, DIA_EN_SYSTEM_SETTING_LEVEL_EXECUTE, DIA_SUCCESS);
}

