/*
 * dia_SAFeatureSecurity.h
 *
 *  Created on: 19.01.2012
 *      Author: gib2hi
 */

#ifndef DIA_SAFEATURESECURITY_H_
#define DIA_SAFEATURESECURITY_H_

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FEATURE__
#include "common/framework/sysadapters/dia_SystemAdapterFeature.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_AIVI_SECURITY_LISTENER__
#include "project/interfaces/dia_IAIVISecurityListener.h"
#endif

//-----------------------------------------------------------------------------
// class definition
//-----------------------------------------------------------------------------

class dia_SAFeatureSecurity
   : /*public dia_SystemAdapterFeature,*/
     public dia_IAIVISecurity
{
//   DECL_DEPRECATED_DEFAULT_CONSTRUCTOR(dia_SAFeatureSecurity);

public:
#if 0
   //! constructor
   dia_SAFeatureSecurity ( tCString name, dia_SystemAdapterServicePlugin& pSrvPlugin );
#else
   //! constructor
   dia_SAFeatureSecurity ( void );
#endif

   //! destructor
   virtual ~dia_SAFeatureSecurity ( void );

   //-------------------------------------------------------------------------
   //
   // Overloaded dia_IAIVISecurity methods
   //
   //-------------------------------------------------------------------------

   //! request the ECU Serial Number
   virtual tDiaResult getEcuSerialNumber ( void );
   //! request the StaticKey used to encrypt the SecretSeed
   virtual tDiaResult getStaticKey ( void );
   //! request the IndexSrvData used by the Unlocking Server to guess the StaticKey (when decrypting the SecuritySeed)
   virtual tDiaResult getIndexSrvData ( void );
   //! request the StaticKey used to encrypt the SecretSeed for CMC
   virtual tDiaResult getStaticKey4CMCSecLevDoip ( void );

protected:

   void vOnEcuSerialNumber ( const std::vector<tU8>& );
   void vOnStaticKey ( const std::vector<tU8>& );
   void vOnIndexSrvData ( const std::vector<tU8>& );

#if 0
   tVoid vHandleManufacturersEnableCounter(amt_tclServiceData* poMessage) const;
   tVoid vHandleVehicleIdentificationNumber(amt_tclServiceData* poMessage) const;
   tVoid vHandleClearVin( amt_tclServiceData* poMessage ) const;
   tVoid vHandleSecurityState( amt_tclServiceData* poMessage ) const;

   // declare message map data structures
   DECLARE_MSG_MAP(dia_SAFeatureSecurity)
#endif

protected:
   tDiaResult mResult;
   tBool mbTestKey;
   std::vector<tU8> mSerialno;

};

#endif /* DIA_SAFEATURESECURITY_H_ */
