/*
 * dia_SAFeatureSdsGuiPopup.cpp
 *
 *  Created on: Apr 19, 2016
 *      Author: jas1hi
 */

#include "dia_SAFeatureSdsGuiPopup.h"

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_SERVICE_PLUGIN_ASF__
#include <common/framework/platform/asf/dia_SystemAdapterServicePluginASF.h>
#endif


dia_SAFeatureSdsGuiPopup::dia_SAFeatureSdsGuiPopup(dia_SystemAdapterServicePluginASF<PopUpServiceProxy>& pSrvPlugin)
	: dia_SystemAdapterFeatureASF<PopUpServiceProxy>(pSrvPlugin)
{
}

//-----------------------------------------------------------------------------

dia_SAFeatureSdsGuiPopup::~dia_SAFeatureSdsGuiPopup()
{
	// TODO Auto-generated destructor stub
}

//-----------------------------------------------------------------------------


tDiaResult dia_SAFeatureSdsGuiPopup::startMonitoring()
{
   dia_tclFnctTrace trc("dia_SAFeatureSdsGuiPopup::startMonitoring");

   if( (mpSrvPlugin) && (mpSrvPlugin->getProxy())    )
   {
     // Register to properties
   }
   return DIA_SUCCESS;
}

//-----------------------------------------------------------------------------


tDiaResult dia_SAFeatureSdsGuiPopup::stopMonitoring()
{
   dia_tclFnctTrace trc("dia_SAFeatureSdsGuiPopup::stopMonitoring");

   if( (mpSrvPlugin) && (mpSrvPlugin->getProxy()))
   {
     // DeRegister properties
   }
   return DIA_SUCCESS;
}

//-----------------------------------------------------------------------------

tDiaResult dia_SAFeatureSdsGuiPopup::getSdsSpeechInputStatus ( tVoid )
{
	dia_tclFnctTrace trc("dia_SAFeatureSdsGuiPopup::getSdsSpeechInputStatus");

	tDiaResult retCode = DIA_FAILED;

	if ((mpSrvPlugin) && (mpSrvPlugin->getProxy()))
	{
	  act_t token = mpSrvPlugin->getProxy()->sendSdsStatusGet(*this);
	  if (0!=token)
	  {
		 retCode = DIA_SUCCESS;
	  }
	}
	else
	{
	  DIA_TR_ERR("dia_SAFeatureSdsGuiPopup::getSdsSpeechInputStatus. mpSrvPlugin or mpSrvPlugin->getProxy is NULL.");
	}

	DIA_TR_INF("dia_SAFeatureSdsGuiPopup::getSdsSpeechInputStatus. returned %s", (DIA_SUCCESS==retCode? "SUCCESS": "FAILED"));

	return retCode;
}

//-----------------------------------------------------------------------------

tDiaResult dia_SAFeatureSdsGuiPopup::registerToSdsSpeechInputStatus ( void )
{
	dia_tclFnctTrace trc("dia_SAFeatureSdsGuiPopup::registerToSdsSpeechInputStatus");

	tDiaResult retCode = DIA_FAILED;

	if ((mpSrvPlugin) && (mpSrvPlugin->getProxy()))
	{
	  act_t token = mpSrvPlugin->getProxy()->sendSdsStatusRegister(*this);
	  if (0!=token)
	  {
		 retCode = DIA_SUCCESS;
	  }
	}
	else
	{
	  DIA_TR_ERR("dia_SAFeatureSdsGuiPopup::registerToSdsSpeechInputStatus. mpSrvPlugin or mpSrvPlugin->getProxy is NULL.");
	}

	DIA_TR_INF("dia_SAFeatureSdsGuiPopup::registerToSdsSpeechInputStatus. returned %s", (DIA_SUCCESS==retCode? "SUCCESS": "FAILED"));

	return retCode;
}

//-----------------------------------------------------------------------------

tDiaResult dia_SAFeatureSdsGuiPopup::getSdsScreenID ( tVoid )
{
	dia_tclFnctTrace trc("dia_SAFeatureSdsGuiPopup::getSdsScreenID");

	tDiaResult retCode = DIA_FAILED;

	if ((mpSrvPlugin) && (mpSrvPlugin->getProxy()))
	{
	  act_t token = mpSrvPlugin->getProxy()->sendScreenIDGet(*this);
	  if (0!=token)
	  {
		 retCode = DIA_SUCCESS;
	  }
	}
	else
	{
	  DIA_TR_ERR("dia_SAFeatureSdsGuiPopup::getSdsScreenID. mpSrvPlugin or mpSrvPlugin->getProxy is NULL.");
	}

	DIA_TR_INF("dia_SAFeatureSdsGuiPopup::getSdsScreenID. returned %s", (DIA_SUCCESS==retCode? "SUCCESS": "FAILED"));

	return retCode;
}

//-----------------------------------------------------------------------------

tDiaResult dia_SAFeatureSdsGuiPopup::registerToSdsScreenID ( tVoid )
{
	dia_tclFnctTrace trc("dia_SAFeatureSdsGuiPopup::registerToSdsScreenID");

	tDiaResult retCode = DIA_FAILED;

	if ((mpSrvPlugin) && (mpSrvPlugin->getProxy()))
	{
	  act_t token = mpSrvPlugin->getProxy()->sendScreenIDRegister(*this);
	  if (0!=token)
	  {
		 retCode = DIA_SUCCESS;
	  }
	}
	else
	{
	  DIA_TR_ERR("dia_SAFeatureSdsGuiPopup::registerToSdsScreenID. mpSrvPlugin or mpSrvPlugin->getProxy is NULL.");
	}

	DIA_TR_INF("dia_SAFeatureSdsGuiPopup::registerToSdsScreenID. returned %s", (DIA_SUCCESS==retCode? "SUCCESS": "FAILED"));

	return retCode;
}

//=============================================================================
//=============================================================================

tVoid dia_SAFeatureSdsGuiPopup::onScreenIDError(const ::boost::shared_ptr< PopUpServiceProxy >& /*proxy*/, const ::boost::shared_ptr< ScreenIDError >& error)
{
	 dia_tclFnctTrace trc("dia_SAFeatureSdsGuiPopup::onScreenIDError");

	 DIA_TR_ERR( "dia_SAFeatureSdsGuiPopup::onScreenIDError. ErrorName     = \"%s\"", error->getName().c_str() );
	 DIA_TR_ERR( "dia_SAFeatureSdsGuiPopup::onScreenIDError. ErrorMessage  = \"%s\"", error->getMessage().c_str() );
}

//-----------------------------------------------------------------------------

tVoid dia_SAFeatureSdsGuiPopup::onScreenIDUpdate(const ::boost::shared_ptr< PopUpServiceProxy >& /*proxy*/, const ::boost::shared_ptr< ScreenIDUpdate >& update)
{
	dia_tclFnctTrace trc("dia_SAFeatureSdsGuiPopup::onScreenIDUpdate");

	std::string screenID = update->getScreenID();
	DIA_TR_INF("dia_SAFeatureSdsGuiPopup::onScreenIDUpdate. screenID '%s'", screenID.c_str());

	getInstanceOfApplication()->postMessage (
		 OSAL_NEW dia_tclDiagSession::tclEventIntMsgRxGeneric (
			   OSAL_NEW dia_FunctorOneArgNoReturnValue<dia_SAFeatureSdsGuiPopup, std::string>(this, &dia_SAFeatureSdsGuiPopup::onScreenIDUpdate, screenID)
		 )
	);
}

//-----------------------------------------------------------------------------

tVoid dia_SAFeatureSdsGuiPopup::onScreenIDUpdate(std::string screenID)
{
    dia_tclFnctTrace trc("dia_SAFeatureSdsGuiPopup::onScreenIDUpdate(std::string)");

//    DIA_TR_INF("dia_SAFeatureSdsGuiPopup::onScreenIDUpdate(std::string): screenID: '%s'", screenID.c_str());
    dia_ISdsGuiPopupListener* pListener = 0;
	if ((querySysAdapterListener<dia_ISdsGuiPopupListener>(&pListener) == DIA_SUCCESS) && pListener)
	{
		pListener->vOnSdsScreenIDStatus(screenID);
	}
	else
	{
	  DIA_TR_WRN("dia_SAFeatureSdsGuiPopup::onScreenIDUpdate. querySysAdapterListener dia_ISdsGuiPopupListener NULL");
	}
}

//-----------------------------------------------------------------------------

tVoid dia_SAFeatureSdsGuiPopup::onSdsStatusError(const ::boost::shared_ptr< PopUpServiceProxy >& /*proxy*/, const ::boost::shared_ptr< SdsStatusError >& error)
{
	 dia_tclFnctTrace trc("dia_SAFeatureSdsGuiPopup::onSdsStatusError");

	 DIA_TR_ERR( "dia_SAFeatureSdsGuiPopup::onSdsStatusError. ErrorName     = \"%s\"", error->getName().c_str() );
	 DIA_TR_ERR( "dia_SAFeatureSdsGuiPopup::onSdsStatusError. ErrorMessage  = \"%s\"", error->getMessage().c_str() );
}

//-----------------------------------------------------------------------------

tVoid dia_SAFeatureSdsGuiPopup::onSdsStatusUpdate(const ::boost::shared_ptr< PopUpServiceProxy >& /*proxy*/, const ::boost::shared_ptr< SdsStatusUpdate >& update)
{
	dia_tclFnctTrace trc("dia_SAFeatureSdsGuiPopup::onSdsStatusUpdate");

	dia_eSpeechInputStatus speechInputStatus = DIA_EN_SPEECH_INPUT_STATUS_UNKNOWN;
	switch (update->getSdsStatus())
	{
	case SpeechInputState__IDLE:
		speechInputStatus = DIA_EN_SPEECH_INPUT_STATUS_IDLE;
		break;

	case SpeechInputState__DIALOGOPEN:
		speechInputStatus = DIA_EN_SPEECH_INPUT_STATUS_DIALOGOPEN;
		break;

	case SpeechInputState__LOADING:
		speechInputStatus = DIA_EN_SPEECH_INPUT_STATUS_LOADING;
		break;

	case SpeechInputState__ERROR:
		speechInputStatus = DIA_EN_SPEECH_INPUT_STATUS_ERROR;
		break;

	case SpeechInputState__LISTENING:
		speechInputStatus = DIA_EN_SPEECH_INPUT_STATUS_LISTENING;
		break;

	case SpeechInputState__ACTIVE:
		speechInputStatus = DIA_EN_SPEECH_INPUT_STATUS_ACTIVE;
		break;

	case SpeechInputState__PAUSE:
		speechInputStatus = DIA_EN_SPEECH_INPUT_STATUS_PAUSE;
		break;

	default:
		break;
	}  //lint !e788: not all items intentionally used within defaulted switch
	DIA_TR_INF( "dia_SAFeatureSdsGuiPopup::onSdsStatusUpdate Received - speechInputStatus = 0x%02x", speechInputStatus);

	getInstanceOfApplication()->postMessage (
		 OSAL_NEW dia_tclDiagSession::tclEventIntMsgRxGeneric (
			   OSAL_NEW dia_FunctorOneArgNoReturnValue<dia_SAFeatureSdsGuiPopup, dia_eSpeechInputStatus>(this, &dia_SAFeatureSdsGuiPopup::onSdsStatusUpdate, speechInputStatus)
		 )
	);
}

//-----------------------------------------------------------------------------

tVoid dia_SAFeatureSdsGuiPopup::onSdsStatusUpdate(dia_eSpeechInputStatus speechInputStatus)
{
	dia_tclFnctTrace trc("dia_SAFeatureSdsGuiPopup::onSdsStatusUpdate(dia_eSpeechInputStatus)");

//	DIA_TR_INF("dia_SAFeatureSdsGuiPopup::onSdsStatusUpdate(tU32). startupTimeInterval '%d'", speechInputStatus);
	dia_ISdsGuiPopupListener* pListener = 0;
	if ((querySysAdapterListener<dia_ISdsGuiPopupListener>(&pListener) == DIA_SUCCESS) && pListener)
	{
		pListener->vOnSdsSpeechStatus(speechInputStatus);
	}
	else
	{
	  DIA_TR_WRN("dia_SAFeatureSdsGuiPopup::onSdsStatusUpdate. querySysAdapterListener dia_ISdsGuiPopupListener NULL");
	}
}
