/*
 * dia_SAFeatureSdsDiagnosisService.h
 *
 *  Created on: sep 05, 2017
 *      Author: nlk1kor
 */

#ifndef DIA_SAFEATURESDSDIAGNOSISSERVICE_H_
#define DIA_SAFEATURESDSDIAGNOSISSERVICE_H_

#include <sds_gui_fi/SdsDiagnosisServiceProxy.h>
#include <sds_gui_fi/SdsDiagnosisServiceClientBase.h>

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FEATURE_ASF__
#include <common/framework/platform/asf/dia_SystemAdapterFeatureASF.h>
#endif

#ifndef __INCLUDED_DIA_INTERFACE_SDSDIAGNOSISSERVICE_LISTENER__
#include <project/interfaces/dia_ISdsDiagnosisServiceListener.h>
#endif



using namespace sds_gui_fi::SdsDiagnosisService;

//-----------------------------------------------------------------------------
// class definition
//-----------------------------------------------------------------------------

class dia_SAFeatureSdsDiagnosisService
   : public dia_SystemAdapterFeatureASF<SdsDiagnosisServiceProxy>,
	 public SdsDiagnosisServiceClientBase,
     public dia_ISdsDiagnosisService
{
public:
	//! constructor
	   dia_SAFeatureSdsDiagnosisService (dia_SystemAdapterServicePluginASF<SdsDiagnosisServiceProxy>& pSrvPlugin );

	//! destructor
	virtual ~dia_SAFeatureSdsDiagnosisService();

	//! start monitoring of properties
	virtual tDiaResult startMonitoring();
	//! stop monitoring of properties
	virtual tDiaResult stopMonitoring();
	virtual tDiaResult registerToExtendedSDSLoggingDataUpdate ( tVoid );

	//-------------------------------------------------------------------------
	//
	// Overloaded PopUpServiceClientBase methods
	//
	//-------------------------------------------------------------------------
	virtual tVoid onExtendedSDSLoggingDataUpdateError(const ::boost::shared_ptr< SdsDiagnosisServiceProxy >& proxy, const ::boost::shared_ptr< ExtendedSDSLoggingDataUpdateError >& error);
	virtual tVoid onExtendedSDSLoggingDataUpdateSignal(const ::boost::shared_ptr< SdsDiagnosisServiceProxy >& proxy, const ::boost::shared_ptr< ExtendedSDSLoggingDataUpdateSignal >& signal);
	virtual tVoid onExtendedSDSLoggingDataUpdateSignal(dia_eExtendedSDSLoggingData extendedSDSLoggingData, tU16 sdsTimestamp);


protected:
   //! deprecated default constructor
	dia_SAFeatureSdsDiagnosisService ();
};

#endif /* DIA_SAFEATURESDSDIAGNOSISSERVICE_H_ */
