/*
 * dia_SAFeatureSwUpdate.h
 *
 */

#ifndef DIA_SAFEATURESWUPDATEPRJ_H_
#define DIA_SAFEATURESWUPDATEPRJ_H_


#include "fcswupdatesrv/FcSwUpdateSrvProxy.h"         //GEN folder
#include "fcswupdatesrv/FcSwUpdateSrvClientBase.h"    //GEN folder

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FEATURE_ASF__
#include <common/framework/platform/asf/dia_SystemAdapterFeatureASF.h>
#endif

#ifndef __INCLUDED_DIA_INTERFACE_SWUPDATEPRJ__
#include <project/interfaces/dia_ISWUpdatePrj.h>
#endif

#ifndef __INCLUDED_DIA_INTERFACE_SWUPDATEPRJ_LISTENER__
#include <project/interfaces/dia_ISWUpdatePrjListener.h>
#endif

using namespace fcswupdatesrv::FcSwUpdateSrv;

//-----------------------------------------------------------------------------
// class definition
//-----------------------------------------------------------------------------

class dia_SAFeatureSWUpdatePrj
      : public dia_SystemAdapterFeatureASF<FcSwUpdateSrvProxy>,
      public FcSwUpdateSrvClientBase,
      public dia_ISWUpdatePrj
{
public:
   //! constructor
   dia_SAFeatureSWUpdatePrj (dia_SystemAdapterServicePluginASF<FcSwUpdateSrvProxy>& pSrvPlugin );

   //! destructor
   virtual ~dia_SAFeatureSWUpdatePrj();

   //! start monitoring of properties
   virtual tDiaResult startMonitoring();
   //! stop monitoring of properties
   virtual tDiaResult stopMonitoring();
   /*
   virtual dia_eSourceType getSourceType(tU32 sourceType);

   virtual dia_eUpdateState getUpdateState(tU32 upState);

   virtual dia_eUpdOptions getUpdOptions(tU32 updOption);

   virtual dia_eUpdDirection getUpdDirection(tU32 updDirection);*/

   //-------------------------------------------------------------------------
   //
   // Overloaded dia_ISWUpdatePrj methods
   //
   //-------------------------------------------------------------------------

   virtual tDiaResult getUpdateState ( tVoid );

   virtual tDiaResult getReleaseDoc ( tVoid );

   virtual tDiaResult getUpdateErrors ( tVoid );

   virtual tDiaResult getUpdateOptionsInfo ( tVoid/*const dia_tUpdateOptions& updateOptions*/ );
   virtual tDiaResult SetSoftwareUpdateType(tU8 updateType);

   virtual tDiaResult getUpdateProgress ( tVoid );

   virtual tDiaResult setAllowRecoveryModeRequest(bool flag);
   virtual tDiaResult handleStartDownloadRequest();
   virtual tDiaResult sendAbortRequest();
   virtual tDiaResult SetReleaseFilter();
   //-------------------------------------------------------------------------
   //
   // Overloaded FcSwUpdateSrvClientBase methods
   //
   //-------------------------------------------------------------------------

   // Callback 'UpdateStateCallbackIF'

   virtual void onUpdateStateError(const ::boost::shared_ptr< FcSwUpdateSrvProxy >& proxy, const ::boost::shared_ptr< UpdateStateError >& error);

   virtual void onUpdateStateUpdate(const ::boost::shared_ptr< FcSwUpdateSrvProxy >& proxy, const ::boost::shared_ptr< UpdateStateUpdate >& update);

   // Callback 'ReleaseDocCallbackIF'

   virtual void onReleaseDocError(const ::boost::shared_ptr< FcSwUpdateSrvProxy >& proxy, const ::boost::shared_ptr< ReleaseDocError >& error);

   virtual void onReleaseDocUpdate(const ::boost::shared_ptr< FcSwUpdateSrvProxy >& proxy, const ::boost::shared_ptr< ReleaseDocUpdate >& update);

   // Callback 'UpdateErrorsCallbackIF'

   virtual void onUpdateErrorsError(const ::boost::shared_ptr< FcSwUpdateSrvProxy >& proxy, const ::boost::shared_ptr< UpdateErrorsError >& error);

   virtual void onUpdateErrorsUpdate(const ::boost::shared_ptr< FcSwUpdateSrvProxy >& proxy, const ::boost::shared_ptr< UpdateErrorsUpdate >& update);

   // Callback 'UpdateProgressCallbackIF'

   virtual void onUpdateProgressError(const ::boost::shared_ptr< FcSwUpdateSrvProxy >& proxy, const ::boost::shared_ptr< UpdateProgressError >& error);

   virtual void onUpdateProgressUpdate(const ::boost::shared_ptr< FcSwUpdateSrvProxy >& proxy, const ::boost::shared_ptr< UpdateProgressUpdate >& update);

   // Callback 'SetUpdateOptionsCallbackIF'

   virtual void onSetUpdateOptionsError(const ::boost::shared_ptr< FcSwUpdateSrvProxy >& proxy, const ::boost::shared_ptr< SetUpdateOptionsError >& error);

   virtual void onSetUpdateOptionsResponse(const ::boost::shared_ptr< FcSwUpdateSrvProxy >& proxy, const ::boost::shared_ptr< SetUpdateOptionsResponse >& response);

   // Callback 'ApplyDocCallbackIF'
   virtual void onApplyDocError(const ::boost::shared_ptr< FcSwUpdateSrvProxy >& /*proxy*/, const ::boost::shared_ptr< ApplyDocError >& error);

   virtual void onApplyDocResponse(const ::boost::shared_ptr< FcSwUpdateSrvProxy >& /*proxy*/, const ::boost::shared_ptr< ApplyDocResponse >& response);

   // Callback 'SetAllowRecoveryModeCallbackIF'
   virtual void  onSetAllowRecoveryModeError(const ::boost::shared_ptr<  fcswupdatesrv::FcSwUpdateSrv::FcSwUpdateSrvProxy >& proxy, const ::boost::shared_ptr<  fcswupdatesrv::FcSwUpdateSrv::SetAllowRecoveryModeError >& error);

   virtual void  onSetAllowRecoveryModeResponse(const ::boost::shared_ptr<  fcswupdatesrv::FcSwUpdateSrv::FcSwUpdateSrvProxy >& proxy, const ::boost::shared_ptr<  fcswupdatesrv::FcSwUpdateSrv::SetAllowRecoveryModeResponse >& response);

   // Callback 'UpdateAbortCallbackIF'
   virtual void onUpdateAbortError(const ::boost::shared_ptr< fcswupdatesrv::FcSwUpdateSrv::FcSwUpdateSrvProxy >& proxy, const ::boost::shared_ptr< fcswupdatesrv::FcSwUpdateSrv::UpdateAbortError >& error);

   virtual void onUpdateAbortResponse(const ::boost::shared_ptr< fcswupdatesrv::FcSwUpdateSrv::FcSwUpdateSrvProxy >& proxy, const ::boost::shared_ptr< fcswupdatesrv::FcSwUpdateSrv::UpdateAbortResponse >& response);

   // Callback 'UpdateSetReleaseFilterCallbackIF'
   virtual void onUpdateSetReleaseFilterError(const ::boost::shared_ptr< fcswupdatesrv::FcSwUpdateSrv::FcSwUpdateSrvProxy >& proxy, const ::boost::shared_ptr< fcswupdatesrv::FcSwUpdateSrv::UpdateSetReleaseFilterError >& error);

   virtual void onUpdateSetReleaseFilterResponse(const ::boost::shared_ptr< fcswupdatesrv::FcSwUpdateSrv::FcSwUpdateSrvProxy >& proxy, const ::boost::shared_ptr< fcswupdatesrv::FcSwUpdateSrv::UpdateSetReleaseFilterResponse >& response);

protected:
   //! deprecated default constructor
   dia_SAFeatureSWUpdatePrj ();

   // Update to listeners
  
   virtual void diagUpdateErrorsUpdate(dia_eSWUpdatePrjError eError);
   virtual void onUpdateAbortResponse(bool bUpdateAbortResponse);
   virtual void onUpdateSetReleaseFilterResponse(tU32 updateSetReleaseFilterResponse);

   dia_eUpdateState updateFinalState;
   bool vCheck;

};

#endif /* dia_SAFeatureSWUpdatePrj_H_ */
