/*
 * dia_SAFeatureRVCControl.h
 *
 *  Created on: 22.01.2013
 *      Author: shw2abt
 */

#ifndef DIA_SAFEATURERVCCONTROL_H_
#define DIA_SAFEATURERVCCONTROL_H_

/*
#ifndef __INCLUDED_DIA_COMMON_CORE__
#include "common/depricated/dia_common_core.h"
#endif
*/

#ifndef __INCLUDED_DIA_INTERFACE_RVCCONTROL_LISTENER__
#include "common/interfaces/dia_IRVCControlListener.h"
#endif

#ifndef __INCLUDED_DIA_DIAGLIB_IOCONTROL_LISTENER__
#include "common/depricated/SystemAdapter/dia_IDiaglibIoControlListener.h"
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FEATURE_DIAGLIB__
#include "common/framework/sysadapters/dia_SystemAdapterFeatureDiaglib.h"
#endif

//-----------------------------------------------------------------------------
// class definition
//-----------------------------------------------------------------------------

class dia_SAFeatureRVCControl
   : public dia_SystemAdapterFeatureDiaglib,
     public dia_IRVCControl,
     public dia_IDiaglibIoControlListener
{
public:
   //! constructor
   dia_SAFeatureRVCControl ( tCString name, dia_SystemAdapterServicePluginDiaglib& pSrvPlugin );

   //! destructor
   virtual ~dia_SAFeatureRVCControl ( tVoid );

   //! return the diaglib IDs managed by this feature
   virtual tDiaResult getDiaglibIDs ( std::list<tU32>& results ) const;

   // receive functions
   virtual tVoid vOnIoCtrlResult(tU32 u32IoCtrlId, tenIoCtrlResult enResult, tenIoControlAction enActionId, const tDiaglibParamVector& oStartResult);

   //-------------------------------------------------------------------------
   //
   // Overloaded dia_IRVCControl methods
   //
   //-------------------------------------------------------------------------

   //! freeze the IOCtrl for RVC Control Line
   virtual tDiaResult freezeRVCControl_ControlLine ( dia_eRVCControl_ControlLineFreeze mode );
   //! set the rvc control line value
   virtual tDiaResult setRVCControl_ControlLine ( dia_eRVCControl_ControlLine mode );

protected:
   //! deprecated default constructor
   dia_SAFeatureRVCControl ( tVoid );

   //! handle incoming CCA message
   tVoid vHandleIOControl ( amt_tclServiceData* poMessage );

   //tVoid vHandleRVC_ControlLine ( amt_tclServiceData* poMessage ) const;

   // declare message map data structures
   DECLARE_MSG_MAP(dia_SAFeatureRVCControl)
};

#endif /* DIA_SAFEATURERVCCONTROL_H_ */
