/*
 * dia_SAFeatureRVC.h
 *
 *  Created on:   11.01.2011
 *  Modified on:  21.04.2016, 11.06.2020
 *      Author:   gib2hi, kaa1hi, ama8kor
 */

#ifndef DIA_SAFEATURERVC_H_
#define DIA_SAFEATURERVC_H_

#ifndef __INCLUDED_DIA_INTERFACE_REAR_VIEW_CAMERA_LISTENER__
#include "common/interfaces/dia_IRVCListener.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_MICROPHONE_LISTENER__
#include "common/interfaces/dia_IMicrophoneListener.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_CVBSCONNECTION_LISTENER__
#include "project/interfaces/dia_ICVBSConnectionListener.h"
#endif

class amt_tclServiceData;

class dia_SAFeatureRVC
    : public dia_SystemAdapterFeature,
      public dia_IRVC,
      public dia_IMicrophone,
	  public dia_ICVBSConnection
{
   DECL_DEPRECATED_DEFAULT_CONSTRUCTOR(dia_SAFeatureRVC);

public:
    //! default class constructor
    	dia_SAFeatureRVC ( tCString name, dia_SystemAdapterServicePlugin& pSrvPlugin);
    //! class destructor
    virtual ~dia_SAFeatureRVC ( void );

    //-------------------------------------------------------------------------
    //
    // Implementation of dia_IRVC interface
    //
    //-------------------------------------------------------------------------
    virtual tDiaResult getRVCConnectionInfo ( void );

    //-------------------------------------------------------------------------
    //
    // Implementation of dia_IMicrophone interface
    //
    //-------------------------------------------------------------------------
    virtual tDiaResult getMicrophoneConnectionInfo ( tU16 micID );

    //DEPRECATED! PLEASE DO NOT USE IN THE FUTURE
    virtual tDiaResult getMicrophoneConnectionStatus ( void ) { return DIA_FAILED; };
	
	//-------------------------------------------------------------------------
    //
    // Implementation of dia_ICVBSConnection interface
    //
    //-------------------------------------------------------------------------
    virtual tDiaResult getCVBSConnectionStatus ( void );

protected:

   //! handle the result of getRVCPwrSupplyStatus
   void vHandleRVCConnectionInfo(amt_tclServiceData* poMessage) const;

   //! handle the result of getMicrophoneConnectionInfo
   void vHandleMicrophoneConnectionInfo(amt_tclServiceData* poMessage) const;
   
   //! handle the result of getCVBSConnectionStatus
   void vHandleCVBSConnectionStatus(amt_tclServiceData* poMessage) const;

   //! overloaded to register for all needed FIDs when the service is available
   // virtual tBool bOnServiceStateAvailable ( tU16 u16SrvID, tU16 u16SubId );

   tBool bSendMessage (
         const tU8  u8MessageType,
         const tU16 u16FID,
         const tU8  u8Opcode,
         const tU16 u16MsgLength,
         const tU8  u8MsgBuffer[]
         );

   // declare message map data structures
   DECLARE_MSG_MAP(dia_SAFeatureRVC)
};

#endif /* DIA_SAFEATURERVC_H_ */
