/*
 * dia_SAFeaturePhoneConnectionSetting.h
 *
 *  Created on: Jun 1, 2016
 *      Author: jas1hi
 */

#ifndef DIA_SAFEATUREPHONECONNECTIONSETTING_H_
#define DIA_SAFEATUREPHONECONNECTIONSETTING_H_


#include <bosch/cm/ai/nissan/hmi/phoneconnectionduration/PhoneConnectionDurationProxy.h>
#include <bosch/cm/ai/nissan/hmi/phoneconnectionduration/PhoneConnectionDurationClientBase.h>

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FEATURE_ASF__
#include <common/framework/platform/asf/dia_SystemAdapterFeatureASF.h>
#endif

#ifndef __INCLUDED_DIA_INTERFACE_PHONECONNECTIONSETTING_LISTENER__
#include <project/interfaces/dia_IPhoneConnectionSettingListener.h>
#endif

using namespace bosch::cm::ai::nissan::hmi::phoneconnectionduration::PhoneConnectionDuration;



class dia_SAFeaturePhoneConnectionSetting
  : public dia_SystemAdapterFeatureASF<PhoneConnectionDurationProxy>,
	public PhoneConnectionDurationClientBase,
	public dia_IPhoneConnectionSetting
{
public:
	//! constructor
	dia_SAFeaturePhoneConnectionSetting (dia_SystemAdapterServicePluginASF<PhoneConnectionDurationProxy>& pSrvPlugin );

	//! destructor
	virtual ~dia_SAFeaturePhoneConnectionSetting();

	//! start monitoring of properties
	virtual tDiaResult startMonitoring();
	//! stop monitoring of properties
	virtual tDiaResult stopMonitoring();

	//-------------------------------------------------------------------------
	//
	// Overloaded dia_IPhoneConnectionSetting methods
	//
	//-------------------------------------------------------------------------
	virtual tDiaResult getPhoneConnectionEstablishmentDuration ( tVoid );
	virtual tDiaResult registerToPhoneConnectionEstablishmentDuration ( tVoid );

	//-------------------------------------------------------------------------
	//
	// Overloaded PhoneConnectionDurationClientBase methods
	//
	//-------------------------------------------------------------------------
	virtual tVoid onHFPConnectionDurationStatusError(const ::boost::shared_ptr< PhoneConnectionDurationProxy >& proxy, const ::boost::shared_ptr< HFPConnectionDurationStatusError >& error);
	virtual void onHFPConnectionDurationStatusUpdate(const ::boost::shared_ptr< PhoneConnectionDurationProxy >& proxy, const ::boost::shared_ptr< HFPConnectionDurationStatusUpdate >& update);
	virtual void onHFPConnectionDurationStatusUpdate( tU32 duration );

protected:
   //! deprecated default constructor
	dia_SAFeaturePhoneConnectionSetting ();
};

#endif /* DIA_SAFEATUREPHONECONNECTIONSETTING_H_ */
