/*
 * dia_SAFeaturePhoneConnectionSetting.cpp
 *
 *  Created on: Jun 1, 2016
 *      Author: jas1hi
 */

#include "dia_SAFeaturePhoneConnectionSetting.h"

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_SERVICE_PLUGIN_ASF__
#include <common/framework/platform/asf/dia_SystemAdapterServicePluginASF.h>
#endif


dia_SAFeaturePhoneConnectionSetting::dia_SAFeaturePhoneConnectionSetting (dia_SystemAdapterServicePluginASF<PhoneConnectionDurationProxy>& pSrvPlugin )
	: dia_SystemAdapterFeatureASF<PhoneConnectionDurationProxy>(pSrvPlugin)
{

}

//-----------------------------------------------------------------------------

dia_SAFeaturePhoneConnectionSetting::~dia_SAFeaturePhoneConnectionSetting()
{
	// TODO Auto-generated destructor stub
}

//-----------------------------------------------------------------------------


tDiaResult dia_SAFeaturePhoneConnectionSetting::startMonitoring()
{
   dia_tclFnctTrace trc("dia_SAFeaturePhoneConnectionSetting::startMonitoring");

   if( (mpSrvPlugin) && (mpSrvPlugin->getProxy())    )
   {
     // Register to properties
   }
   return DIA_SUCCESS;
}

//-----------------------------------------------------------------------------


tDiaResult dia_SAFeaturePhoneConnectionSetting::stopMonitoring()
{
   dia_tclFnctTrace trc("dia_SAFeaturePhoneConnectionSetting::stopMonitoring");

   if( (mpSrvPlugin) && (mpSrvPlugin->getProxy()))
   {
     // DeRegister properties
   }
   return DIA_SUCCESS;
}

//-----------------------------------------------------------------------------

tDiaResult dia_SAFeaturePhoneConnectionSetting::getPhoneConnectionEstablishmentDuration ( tVoid )
{
	dia_tclFnctTrace trc("dia_SAFeaturePhoneConnectionSetting::getPhoneConnectionEstablishmentDuration");

	tDiaResult retCode = DIA_FAILED;

	if ((mpSrvPlugin) && (mpSrvPlugin->getProxy()))
	{
	  act_t token = mpSrvPlugin->getProxy()->sendHFPConnectionDurationStatusGet(*this); // TODO: Note that the GET method is not available yet;
	  if (0!=token)
	  {
		 retCode = DIA_SUCCESS;
	  }
	}
	else
	{
	  DIA_TR_ERR("dia_SAFeaturePhoneConnectionSetting::getPhoneConnectionEstablishmentDuration. mpSrvPlugin or mpSrvPlugin->getProxy is NULL.");
	}

	DIA_TR_INF("dia_SAFeaturePhoneConnectionSetting::getPhoneConnectionEstablishmentDuration. returned %s", (DIA_SUCCESS==retCode? "SUCCESS": "FAILED"));

	return retCode;
}

//-----------------------------------------------------------------------------

tDiaResult dia_SAFeaturePhoneConnectionSetting::registerToPhoneConnectionEstablishmentDuration ( tVoid )
{
	dia_tclFnctTrace trc("dia_SAFeaturePhoneConnectionSetting::registerToPhoneConnectionEstablishmentDuration");

	tDiaResult retCode = DIA_FAILED;

	if ((mpSrvPlugin) && (mpSrvPlugin->getProxy()))
	{
	  act_t token = mpSrvPlugin->getProxy()->sendHFPConnectionDurationStatusRegister(*this);
	  if (0!=token)
	  {
		 retCode = DIA_SUCCESS;
	  }
	}
	else
	{
	  DIA_TR_ERR("dia_SAFeaturePhoneConnectionSetting::registerToPhoneConnectionEstablishmentDuration. mpSrvPlugin or mpSrvPlugin->getProxy is NULL.");
	}

	DIA_TR_INF("dia_SAFeaturePhoneConnectionSetting::registerToPhoneConnectionEstablishmentDuration. returned %s", (DIA_SUCCESS==retCode? "SUCCESS": "FAILED"));

	return retCode;
}

//=============================================================================
//=============================================================================

tVoid dia_SAFeaturePhoneConnectionSetting::onHFPConnectionDurationStatusError(const ::boost::shared_ptr< PhoneConnectionDurationProxy >& proxy, const ::boost::shared_ptr< HFPConnectionDurationStatusError >& error)
{
	 dia_tclFnctTrace trc("dia_SAFeaturePhoneConnectionSetting::onHFPConnectionDurationStatusError");

	 DIA_TR_ERR( "dia_SAFeaturePhoneConnectionSetting::onHFPConnectionDurationStatusError. ErrorName     = \"%s\"", error->getName().c_str() );
	 DIA_TR_ERR( "dia_SAFeaturePhoneConnectionSetting::onHFPConnectionDurationStatusError. ErrorMessage  = \"%s\"", error->getMessage().c_str() );
}

//-----------------------------------------------------------------------------

void dia_SAFeaturePhoneConnectionSetting::onHFPConnectionDurationStatusUpdate(const ::boost::shared_ptr< PhoneConnectionDurationProxy >& proxy, const ::boost::shared_ptr< HFPConnectionDurationStatusUpdate >& update)
{
	dia_tclFnctTrace trc("dia_SAFeaturePhoneConnectionSetting::onHFPConnectionDurationStatusUpdate");

	tU32 duration = update->getHFPConnectionDurationStatus();
	DIA_TR_INF("dia_SAFeaturePhoneConnectionSetting::onHFPConnectionDurationStatusUpdate. duration '%d'", duration);

	getInstanceOfApplication()->postMessage (
		 OSAL_NEW dia_tclDiagSession::tclEventIntMsgRxGeneric (
			   OSAL_NEW dia_FunctorOneArgNoReturnValue<dia_SAFeaturePhoneConnectionSetting, tU32>(this, &dia_SAFeaturePhoneConnectionSetting::onHFPConnectionDurationStatusUpdate, duration)
		 )
	);
}

//-----------------------------------------------------------------------------

void dia_SAFeaturePhoneConnectionSetting::onHFPConnectionDurationStatusUpdate( tU32 duration )
{
	dia_tclFnctTrace trc("dia_SAFeaturePhoneConnectionSetting::onHFPConnectionDurationStatusUpdate(tU32)");

	DIA_TR_INF("dia_SAFeaturePhoneConnectionSetting::onHFPConnectionDurationStatusUpdate(tU32): duration: '%d'", duration);
	dia_IPhoneConnectionSettingListener* pListener = 0;
	if ((querySysAdapterListener<dia_IPhoneConnectionSettingListener>(&pListener) == DIA_SUCCESS) && pListener)
	{
		pListener->vOnPhoneConnectionEstablishmentDurationStatus(duration);
	}
	else
	{
	  DIA_TR_WRN("dia_SAFeaturePhoneConnectionSetting::onHFPConnectionDurationStatusUpdate. querySysAdapterListener dia_IPhoneConnectionSettingListener NULL");
	}
}
