/*
 * dia_SAFeatureVideoSource.cpp
 *
 *  Created on: 13.08.2012
 *      Author:
 
*--------------------------------------------------------------------------------------------------------------------
* 24.02.2017		| 1.6	| NLK1KOR (RBCM  )	| implemented feature  Feature 	AIVI-38980 	Working class for the Communication
 (connection) status
 Changed from midw_ext_fi to meter_srv_fi
*--------------------------------------------------------------------------------------------------------------------
 */

#ifndef __INCLUDED_DIA_COMMON_CORE__
#include "common/depricated/dia_common_core.h"
#endif

//#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
//#define MIDW_EXT_FI_S_IMPORT_INTERFACE_MIDW_EXT_METERFI_DBGVISITORS
//#define MIDW_EXT_FI_S_IMPORT_INTERFACE_MIDW_EXT_METERFI_STDVISITORS
//#define MIDW_EXT_FI_S_IMPORT_INTERFACE_MIDW_EXT_METERFI_TYPES
//#define MIDW_EXT_FI_S_IMPORT_INTERFACE_MIDW_EXT_METERFI_FUNCTIONIDS
//#define MIDW_EXT_FI_S_IMPORT_INTERFACE_MIDW_EXT_METERFI_SERVICEINFO
//#include "midw_ext_fi_if.h" //lint !e451 !e537 repeatedly included header file without standard include guard

//lint -e1516
//lint -e1712
//lint -e1735
//lint -e1739
#define CFC_FI_S_IMPORT_INTERFACE_CFC_VEHICLEFI_STDVISITORS
#define CFC_FI_S_IMPORT_INTERFACE_CFC_VEHICLEFI_SERVICEINFO
#define CFC_FI_S_IMPORT_INTERFACE_CFC_VEHICLEFI_FUNCTIONIDS
#include "cfc_fi_if.h" //lint !e451 !e537 repeatedly included header file without standard include guard
//lint +e1516
//lint +e1712
//lint +e1735
//lint +e1739

//#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#define METERSRV_FI_S_IMPORT_INTERFACE_METERSRV_MAINFI_DBGVISITORS
#define METERSRV_FI_S_IMPORT_INTERFACE_METERSRV_MAINFI_STDVISITORS   
#define METERSRV_FI_S_IMPORT_INTERFACE_METERSRV_MAINFI_TYPES
#define METERSRV_FI_S_IMPORT_INTERFACE_METERSRV_MAINFI_FUNCTIONIDS
#define METERSRV_FI_S_IMPORT_INTERFACE_METERSRV_MAINFI_SERVICEINFO
#include "metersrv_fi_if.h"

#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include "generic_msgs_if.h" //lint !e451 !e537 repeatedly included header file without standard include guard


#include "project/interfaces/dia_INissanMCanInfoListener.h"
#include "project/interfaces/dia_INissanBusStateListener.h"

#include "dia_SAFeatureMeter.h"

#define DIAGLIB_INCLUDE_ROUTINE_CONTROL
#include "diaglib_if.h" //lint !e451 !e537 repeatedly included header file without standard include guard


// MESSAGE MAP:
// Such a map and an own handler is needed for every service you are accessing!
// Enter the function IDs (FID) and the corresponding functions here.
// The function will be called when a message with the corresponding FID arrives

// MESSAGE MAP:
// The message map maps IDs of incoming CCA messages to proper handle methods
BEGIN_MSG_MAP(dia_SAFeatureMeter, dia_SystemAdapterFeature)
   ON_MESSAGE(METERSRV_MAINFI_C_U16_CONNECTION, vHandleMCanConnectionState)
   ON_MESSAGE(METERSRV_MAINFI_C_U16_DATATRANSMISSION, vHandleMCanDataTransmissionStatus)
   END_MSG_MAP()


//------------------------------------------------------------------------------

dia_SAFeatureMeter::dia_SAFeatureMeter (
      tCString name,    // feature name
      dia_SystemAdapterServicePlugin& pSrvPlugin
   )
    : dia_SystemAdapterFeature(name,pSrvPlugin)
{
   dia_tclFnctTrace trc("dia_SAFeatureMeter::dia_SAFeatureMeter");
}

//-----------------------------------------------------------------------------

dia_SAFeatureMeter::~dia_SAFeatureMeter ( tVoid )
{}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureMeter::getNissanMCANInfo ( tVoid )
{
    dia_tclFnctTrace trc("dia_SAFeatureMeter::getNissanMCANInfo");

    tDiaResult retCode = DIA_FAILED;

    if ( mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID )
    {
   	 DIA_TR_INF("dia_SAFeatureMeter::getNissanMCANInfo - send message.");
   	 gm_tclEmptyMessage oMessage (
          mAppID,
          mpSrvPlugin->getClientID(),
          mpSrvPlugin->getRegistrationID(),
          0,
          mpSrvPlugin->getServiceID(),
		 METERSRV_MAINFI_C_U16_CONNECTION,
          CCA_C_U8_OPCODE_GET
       );

   	   if ( mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE ){
      	 retCode = DIA_SUCCESS;
      	 DIA_TR_INF("dia_SAFeatureMeter::getNissanMCANInfo - transmitMessage success.");
       } else {
      	 DIA_TR_INF("dia_SAFeatureMeter::getNissanMCANInfo - transmitMessage failed.");
       }
    } else {
   	 DIA_TR_INF("dia_SAFeatureMeter::getNissanMCANInfo - getRegistrationID failed.");
   	 DIA_TR_INF("dia_SAFeatureMeter::getNissanMCANInfo - getRegistrationID == AMT_C_U16_REGID_INVALID.");
    }

    return retCode;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureMeter::getNissanMCANTransmissionStatus ( tVoid )
{
    dia_tclFnctTrace trc("dia_SAFeatureMeter::getNissanMCANTransmissionStatus()");

    tDiaResult retCode = DIA_FAILED;

    if ( mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID )
    {
   	 DIA_TR_INF("dia_SAFeatureMeter::getNissanMCANTransmissionStatus - send message.");
   	 gm_tclEmptyMessage oMessage (
          mAppID,
          mpSrvPlugin->getClientID(),
          mpSrvPlugin->getRegistrationID(),
          0,
          mpSrvPlugin->getServiceID(),
		 METERSRV_MAINFI_C_U16_DATATRANSMISSION,
          CCA_C_U8_OPCODE_GET
       );

   	   if ( mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE ){
      	 retCode = DIA_SUCCESS;
      	 DIA_TR_INF("dia_SAFeatureMeter::getNissanMCANTransmissionStatus - transmitMessage success.");
       } else {
      	 DIA_TR_INF("dia_SAFeatureMeter::getNissanMCANTransmissionStatus - transmitMessage failed.");
       }
    } else {
   	 DIA_TR_INF("dia_SAFeatureMeter::getNissanMCANTransmissionStatus - getRegistrationID failed.");
   	 DIA_TR_INF("dia_SAFeatureMeter::getNissanMCANTransmissionStatus - getRegistrationID == AMT_C_U16_REGID_INVALID.");
    }

    return retCode;
}
//-----------------------------------------------------------------------------


tVoid
dia_SAFeatureMeter::vHandleMCanConnectionState ( amt_tclServiceData* poMessage ) const
{
    dia_tclFnctTrace trc("dia_SysAdapterMeter::vHandleMCanConnectionState");

    // Extract the op code from the message.
    tU8 u8OpCode = poMessage->u8GetOpCode();
	dia_INissanMCanInfoListener* pMCanListener = OSAL_NULL;
	std::vector<dia_meterMCANInfo> mmeterMCANInfoList;
    // Switch on the opcode received
	// CID - 86571 Fix
	if ((querySysAdapterListener<dia_INissanMCanInfoListener>(&pMCanListener) == DIA_SUCCESS) && pMCanListener)
	{
    switch (u8OpCode)
    {
    case AMT_C_U8_CCAMSG_OPCODE_STATUS:
        {
            /*fi_tclVisitorMessage oStatusMessage(poMessage); // Task 254932:Removal of meter component library dependency from diagnostic component on IMX
			metersrv_mainfi_tclMsgConnectionStatus oStatusMsgData;
            (tVoid) oStatusMessage.s32GetData(oStatusMsgData);

            DIA_TR_INF("dia_SysAdapterMeter::vHandleMCanConnectionState - Received Connection State");


            querySysAdapterListener<dia_INissanMCanInfoListener>(&pMCanListener);
            if ( pMCanListener )
            {
                dia_NissanMCanInfo nwInfo;
	
				dia_meterMCANInfo element; 
                DIA_TR_INF("dia_SysAdapterMeter::vHandleMCanConnectionState - Num of absent ECUs: %d",oStatusMsgData.arConnectionStatusList.size());
                std::vector<metersrv_fi_tcl_Meter_UnitConnectionStatus>::const_iterator it = oStatusMsgData.arConnectionStatusList.begin();
                for ( ; it != oStatusMsgData.arConnectionStatusList.end(); ++it )
                {
					metersrv_fi_tcl_Meter_UnitConnectionStatus oEcu = (*it);
                    //if ( oEcu.bConnected == FALSE )
                    {
                        switch ( oEcu.e8UnitType.enType )
                        {
                        case metersrv_fi_tcl_e8_Meter_UnitType::FI_EN_AUDIO:
							nwInfo.setAbsentState(DIA_EN_NISSAN_ECU_MCAN_AUD, oEcu.u8AbsenceState);
							element.McanDeviceType = DIA_EN_NISSAN_MCAN_AUD;
							element.McanConnectionState = oEcu.u8CommunicationState;
							DIA_TR_INF("dia_SysAdapterMeter::vHandleMCanConnectionState - DIA_EN_NISSAN_ECU_MCAN_AUD");
                            break;

                        case metersrv_fi_tcl_e8_Meter_UnitType::FI_EN_NAVI:
                            nwInfo.setAbsentState(DIA_EN_NISSAN_ECU_MCAN_NAV, oEcu.u8AbsenceState);
							element.McanDeviceType = DIA_EN_NISSAN_MCAN_NAV;
							element.McanConnectionState = oEcu.u8CommunicationState;
                            DIA_TR_INF("dia_SysAdapterMeter::vHandleMCanConnectionState - DIA_EN_NISSAN_ECU_MCAN_NAV");
                            break;

                        case metersrv_fi_tcl_e8_Meter_UnitType::FI_EN_SWSC:
                            nwInfo.setAbsentState(DIA_EN_NISSAN_ECU_MCAN_SWC, oEcu.u8AbsenceState);
							element.McanDeviceType = DIA_EN_NISSAN_MCAN_SWC;
							element.McanConnectionState = oEcu.u8CommunicationState;
							DIA_TR_INF("dia_SysAdapterMeter::vHandleMCanConnectionState - DIA_EN_NISSAN_ECU_MCAN_SWC");
                            break;

                        case metersrv_fi_tcl_e8_Meter_UnitType::FI_EN_NAVI2:
                           nwInfo.setAbsentState(DIA_EN_NISSAN_ECU_MCAN_NAV_GEN2, oEcu.u8AbsenceState);
                           DIA_TR_INF("dia_SysAdapterMeter::vHandleMCanConnectionState - DIA_EN_NISSAN_ECU_MCAN_NAV_GEN2");
                           break;

                        default:
                           DIA_TR_ERR("dia_SysAdapterMeter::vHandleMCanConnectionState - Unknown UnitType = %d", oEcu.e8UnitType.enType);
                            break;
                        }
						mmeterMCANInfoList.push_back(element);
						DIA_TR_INF("dia_SAFeatureMeter::vHandleMCanMeterConnectionState - Connected=%d, Absence=0x%02x, Mute=0x%02x COM_STATE", oEcu.bConnected, oEcu.u8AbsenceState, oEcu.u8MuteState,oEcu.u8CommunicationState);
						DIA_TR_INF("dia_SAFeatureMeter::vHandleMCanMeterConnectionState - CONNECTION_STATE = %d", oEcu.u8CommunicationState);

						
                    }
                } //for ( ; it != oStatusMsgData.arConnectionStatusList.end(); ++it )

                pMCanListener->vOnMCanInfo(nwInfo);   //neera check this
				
                DIA_TR_INF("dia_SysAdapterMeter::vHandleMCanConnectionState - MCAN Information forwarded to listener");
            }
            else
            {
            	DIA_TR_INF("dia_SysAdapterMeter::vHandleMCanConnectionState - No MCAN listener registered. Discarded!");
            }
        */}
        break;

    case AMT_C_U8_CCAMSG_OPCODE_ERROR:
        {
        	DIA_TR_INF("dia_SysAdapterMeter::vHandleMCanConnectionState - Message with opcode error received");
        }
        break;

    default:
        break;
    }
	//vHandleMCanDataTransmissionStatus(poMessage);
	pMCanListener->vOnMCanMeterInfo(mmeterMCANInfoList);
    // Delete the message we are unable process it at this time
    (tVoid) poMessage->bDelete();
	}
	else
	{
		DIA_TR_INF("dia_SysAdapterMeter::vHandleMCanConnectionState - No MCAN listener registered. Discarded!");
	}
}

//-----------------------------------------------------------------------------
tVoid dia_SAFeatureMeter::vHandleMCanDataTransmissionStatus ( amt_tclServiceData* poMessage ) const
{
    dia_tclFnctTrace trc("dia_SysAdapterMeter::vHandleMCanDataTransmissionStatus");

    // Extract the op code from the message.
    tU8 u8OpCode = poMessage->u8GetOpCode();

    // Switch on the opcode received
    switch (u8OpCode)
    {
    case AMT_C_U8_CCAMSG_OPCODE_STATUS:
        {
            /*fi_tclVisitorMessage oStatusMessage(poMessage); // Task 254932:Removal of meter component library dependency from diagnostic component on IMX
			metersrv_mainfi_tclMsgDataTransmissionStatus oStatusMsgData;
            (tVoid) oStatusMessage.s32GetData(oStatusMsgData);

            DIA_TR_INF("dia_SysAdapterMeter::vHandleMCanDataTransmissionStatus - Received Transmission State");

            dia_INissanMCanInfoListener* pMCanListener = OSAL_NULL;
            querySysAdapterListener<dia_INissanMCanInfoListener>(&pMCanListener);
            if ( pMCanListener )
            {
                dia_NissanMCanTransmissionStatus transStatus;

                std::vector<metersrv_fi_tcl_Meter_UnitDataTransmissionStatus>::const_iterator it = oStatusMsgData.arDataTransmissionStatusList.begin();
                for ( ; it != oStatusMsgData.arDataTransmissionStatusList.end(); ++it )
                {
					metersrv_fi_tcl_Meter_UnitDataTransmissionStatus oEcu = (*it);
                    switch ( oEcu.e8UnitType.enType )
                    {
                    case metersrv_fi_tcl_e8_Meter_UnitType::FI_EN_AUDIO:
                        transStatus.setMPDTMuteState(DIA_EN_NISSAN_ECU_MCAN_AUD, oEcu.u8MPDTMuteState);
                        break;

                    case metersrv_fi_tcl_e8_Meter_UnitType::FI_EN_NAVI:
                        transStatus.setMPDTMuteState(DIA_EN_NISSAN_ECU_MCAN_NAV, oEcu.u8MPDTMuteState);
                        break;

                    case metersrv_fi_tcl_e8_Meter_UnitType::FI_EN_SWSC:
                        transStatus.setMPDTMuteState(DIA_EN_NISSAN_ECU_MCAN_SWC, oEcu.u8MPDTMuteState);
                        break;

                    default:
                        break;
                    }
                }

                pMCanListener->vOnMCanTransmissionStatus(transStatus);
                DIA_TR_INF("dia_SysAdapterMeter::vHandleMCanDataTransmissionStatus - MCAN Transmission Information forwarded to listener");
            }
            else
            {
            	DIA_TR_INF("dia_SysAdapterMeter::vHandleMCanDataTransmissionStatus - No MCAN listener registered. Discarded!");
            }
        */}
        break;

    case AMT_C_U8_CCAMSG_OPCODE_ERROR:
        {
        	DIA_TR_INF("dia_SysAdapterMeter::vHandleMCanDataTransmissionStatus - Message with opcode error received");
        }
        break;

    default:
        break;
    }

    // Delete the message we are unable process it at this time
    (tVoid) poMessage->bDelete();

}
tDiaResult
dia_SAFeatureMeter::getNissanMCANMeterInfo(tVoid)
{
	dia_tclFnctTrace trc("dia_SAFeatureMeter::getNissanMCANMeterInfo");

	tDiaResult retCode = DIA_FAILED;

	if (mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID)
	{
		DIA_TR_INF("dia_SAFeatureMeter::getNissanMCANMeterInfo - send message.");
		gm_tclEmptyMessage oMessage(
			mAppID,
			mpSrvPlugin->getClientID(),
			mpSrvPlugin->getRegistrationID(),
			0,
			mpSrvPlugin->getServiceID(),
			METERSRV_MAINFI_C_U16_CONNECTION,
			CCA_C_U8_OPCODE_UPREG
			);

		if (mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE) {
			retCode = DIA_SUCCESS;
			DIA_TR_INF("dia_SAFeatureMeter::getNissanMCANMeterInfo - transmitMessage success.");
		}
		else {
			DIA_TR_INF("dia_SAFeatureMeter::getNissanMCANMeterInfo - transmitMessage failed.");
		}
	}
	else {
		DIA_TR_INF("dia_SAFeatureMeter::getNissanMCANMeterInfo - getRegistrationID failed.");
		DIA_TR_INF("dia_SAFeatureMeter::getNissanMCANMeterInfo - getRegistrationID == AMT_C_U16_REGID_INVALID.");
	}

	return retCode;
}
/*
tVoid
dia_SAFeatureMeter::vHandleMCanMeterConnectionState(amt_tclServiceData* poMessage) const
{
	dia_tclFnctTrace trc("dia_SAFeatureMeter::vHandleMCanMeterConnectionState");

	// Extract the op code from the message.
	tU8 u8OpCode = poMessage->u8GetOpCode();

	// Switch on the opcode received
	switch (u8OpCode)
	{
	case AMT_C_U8_CCAMSG_OPCODE_STATUS:
	{
		fi_tclVisitorMessage oStatusMessage(poMessage);
		metersrv_mainfi_tclMsgConnectionStatus oStatusMsgData;
		(tVoid)oStatusMessage.s32GetData(oStatusMsgData);

		DIA_TR_INF("dia_SAFeatureMeter::vHandleMCanMeterConnectionState - Received Connection State");

		dia_INissanMCanInfoListener* pMCanListener = OSAL_NULL;
		querySysAdapterListener<dia_INissanMCanInfoListener>(&pMCanListener);
		if (pMCanListener)
		{
			std::vector<dia_meterMCANInfo*> mmeterMCANInfoList;
			dia_meterMCANInfo* element = new dia_meterMCANInfo;

			DIA_TR_INF("dia_SAFeatureMeter::vHandleMCanMeterConnectionState - Num of absent ECUs: %d", oStatusMsgData.arConnectionStatusList.size());
			std::vector<metersrv_fi_tcl_Meter_UnitConnectionStatus>::const_iterator it = oStatusMsgData.arConnectionStatusList.begin();
			for (; it != oStatusMsgData.arConnectionStatusList.end(); ++it)
			{

				metersrv_fi_tcl_Meter_UnitConnectionStatus oEcu = (*it);
				//if ( oEcu.bConnected == FALSE )
				{
					switch (oEcu.e8UnitType.enType)
					{
					case metersrv_fi_tcl_e8_Meter_UnitType::FI_EN_AUDIO:
						element->McanDeviceType = DIA_EN_NISSAN_MCAN_AUD;
						element->McanConnectionState = oEcu.u8CommunicationState;

						DIA_TR_INF("dia_SAFeatureMeter::vHandleMCanMeterConnectionState - DIA_EN_NISSAN_ECU_MCAN_AUD");
						break;

					case metersrv_fi_tcl_e8_Meter_UnitType::FI_EN_NAVI:
						element->McanDeviceType = DIA_EN_NISSAN_MCAN_NAV;
						element->McanConnectionState = oEcu.u8CommunicationState;
						//mmeterMCANInfoList.push_back(meterInfo);
						DIA_TR_INF("dia_SAFeatureMeter::vHandleMCanMeterConnectionState - DIA_EN_NISSAN_ECU_MCAN_NAV");
						break;

					case metersrv_fi_tcl_e8_Meter_UnitType::FI_EN_SWSC:
						element->McanDeviceType = DIA_EN_NISSAN_MCAN_AUD;
						element->McanConnectionState = oEcu.u8CommunicationState;
						//mmeterMCANInfoList.push_back(meterInfo);
						DIA_TR_INF("dia_SAFeatureMeter::vHandleMCanMeterConnectionState - DIA_EN_NISSAN_ECU_MCAN_SWC");
						break;

					default:
						DIA_TR_ERR("dia_SAFeatureMeter::vHandleMCanMeterConnectionState - Unknown UnitType = %d", oEcu.e8UnitType.enType);
						break;
					}
					DIA_TR_INF("dia_SAFeatureMeter::vHandleMCanMeterConnectionState - Connected=%d, Absence=0x%02x, Mute=0x%02x", oEcu.bConnected, oEcu.u8AbsenceState, oEcu.u8MuteState);
					tU8 connectionStatus = oEcu.u8CommunicationState;
					DIA_TR_INF("dia_SysAdapterMeter::vHandleMCanMeterConnectionState - connectionStatus: %d", connectionStatus);


				}
				mmeterMCANInfoList.push_back(element);
			} //for ( ; it != oStatusMsgData.arConnectionStatusList.end(); ++it )

			pMCanListener->vOnMCanMeterInfo(mmeterMCANInfoList);
			DIA_TR_INF("dia_SAFeatureMeter::vHandleMCanMeterConnectionState - MCAN Information forwarded to listener");
		}
		else
		{
			DIA_TR_INF("dia_SAFeatureMeter::vHandleMCanMeterConnectionState - No MCAN listener registered. Discarded!");
		}
	}
	break;

	case AMT_C_U8_CCAMSG_OPCODE_ERROR:
	{
		DIA_TR_INF("dia_SAFeatureMeter::vHandleMCanMeterConnectionState - Message with opcode error received");
	}
	break;

	default:
		break;
	}

	// Delete the message we are unable process it at this time
	(tVoid)poMessage->bDelete();

}*/