

/******************************************************************************************
 * dia_SAFeatureInputHandling.h
 *
 *  Created on: 28.01.2012
 *      Author: wgl2hi
 
 * ------------------------------------------------------------------------------------------
 * Date 			| Author			 | Modification
 * 27.11.15    		| ata7kor	  		 | Added a code change to resolve ticket AIVI-15132
 * 13.07.18			| bma9kor			 | Modified for NCG3D-102634
 * ------------------------------------------------------------------------------------------
 ********************************************************************************************/

#ifndef DIA_SAFEATUREINPUTHANDLING_H_
#define DIA_SAFEATUREINPUTHANDLING_H_

#ifndef __INCLUDED_DIA_INTERFACE_INPUTHANDLINGPRJ_LISTENER__
#include "project/interfaces/dia_IInputHandlingPrjListener.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_INPUTHANDLING_LISTENER__
#include "common/interfaces/dia_IInputHandlingListener.h"
#endif

#ifndef INPUT_FI_S_ALREADY_INCLUDE_INPUT_MAINFI_TYPES
#define INPUT_FI_S_IMPORT_INTERFACE_FI_TYPES
#include"input_fi_if.h"
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FEATURE__
#include "common/framework/sysadapters/dia_SystemAdapterFeature.h"
#endif
#ifndef __INCLUDED_DIA_INTERFACE_PIVI_INPUTHANDLING_LISTENER__
#include "project/interfaces/dia_IPIVIInputHandlingListener.h"
#endif

#include <map>
//-----------------------------------------------------------------------------
// class definition
//-----------------------------------------------------------------------------

class dia_SAFeatureInputHandling
   : public dia_SystemAdapterFeature,
   	 public dia_IInputHandling,
     public dia_IInputHandlingPrj,
	 public dia_IPIVIInputHandling
{
public:
   //! constructor
   dia_SAFeatureInputHandling ( tCString name, dia_SystemAdapterServicePlugin& pSrvPlugin );
   //! destructor
   virtual ~dia_SAFeatureInputHandling ( void );

   //-------------------------------------------------------------------------
   //
   // Overloaded dia_IInputHandlingPrj methods
   //
   //-------------------------------------------------------------------------

   //!
   virtual tDiaResult getPressedKeys ( void );
   //!
   virtual tDiaResult getEncoderStatus ( void );
   //!
   virtual tDiaResult getEncoderDirStatus ( void  );
   //!
   virtual tDiaResult getTouchInfo ( void );
   //!
   virtual tDiaResult setKeyDia ( const dia_eInputHandlingKeyCodePrj eKeyCode, const dia_eInputHandlingKeyInfoPrj eKeyInfo );
   virtual tDiaResult setKeyDia ( const dia_eInputHandlingKeyCode eKeyCode, const dia_eInputHandlingKeyInfo eKeyInfo );
   //!
   virtual tDiaResult setKeyIntern ( const tU16 u16KeyCode, const dia_eInputHandlingKeyInfoPrj eKeyInfo );
   virtual tDiaResult setKeyIntern ( const tU16 u16KeyCode, const dia_eInputHandlingKeyInfo eKeyInfo );

   virtual tDiaResult setKeyInternalCode ( const dia_eVdInuptHandlingKeyCodePrj KeyID, const dia_eInputHandlingKeyInfoPrj eKeyInfo );
   virtual tDiaResult setKeyInternalCode ( const dia_eVdInuptHandlingKeyCode KeyID, const dia_eInputHandlingKeyInfo eKeyInfo );
   //!
   virtual tDiaResult lockControlUnit ( const dia_eInputHandlingLockInfoControlPrj eLock );
   virtual tDiaResult lockControlUnit ( const dia_eInputHandlingLockInfoControl eLock );
   //!
   virtual tDiaResult setEncoder ( const dia_eInputHandlingEncoderPrj eEncoder, const tS8 s8ControlValue );
   virtual tDiaResult setEncoder ( const dia_eInputHandlingEncoder eEncoder, const tS8 s8ControlValue );
   //!
   virtual tDiaResult startTouchPanelAlignment ( void  );
   //! start the input event simulation (requirement from VD_Input)
   virtual tDiaResult enableInputEvents ( void  );
   //!
   virtual tDiaResult setTouchIntern ( const tU16 u16X, const tU16 u16Y, const dia_eInputHandlingTouchInfoPrj eTouchInfo );
   virtual tDiaResult setTouchIntern ( const tU16 u16X, const tU16 u16Y, const dia_eInputHandlingTouchInfo eTouchInfo );
   //!
   virtual tDiaResult setTouchSlideIntern ( const tU16 u16XStart, const tU16 u16YStart, const tU16 u16XEnd, const tU16 u16YEnd, const tU16 u16Duration );

   virtual tDiaResult recordGesture ( const dia_eInputHandlingGestureRecordPrj eStartStop, const std::string& filePath );
   virtual tDiaResult recordGesture ( const dia_eInputHandlingGestureRecord eStartStop, const std::string& filePath );

   virtual tDiaResult replayGesture ( const dia_eInputHandlingGestureReplayPrj eStartStop, const std::string& filePath );
   virtual tDiaResult replayGesture ( const dia_eInputHandlingGestureReplay eStartStop, const std::string& filePath );
   
   virtual tDiaResult setPIVITouchIntern (const tU16 u16X, const tU16 u16Y, const tU16 u16ScreenNumber, const dia_eInputHandlingTouchInfoPrj eTouchInfo);
   //!
   virtual tDiaResult getTouchPIVISecondaryInfo ( void );
protected:
   //! deprecated default constructor
   dia_SAFeatureInputHandling ( void );
   //!
   void vHandleGetPressedKey ( amt_tclServiceData* poMessage ) const;
   //!
   void vHandleTouchScreenStatus ( amt_tclServiceData* poMessage ) const;
   void vHandleSetKey ( amt_tclServiceData* poMessage ) const;
#if 0
   //!
   void vHandleEjectButtonStatus ( amt_tclServiceData* poMessage ) const;
   //!
   void vHandleLockControlUnit ( amt_tclServiceData* poMessage ) const;
#endif
   //!
   void vHandleEncoderStatus ( amt_tclServiceData* poMessage ) const;
   //!
   void vHandleEncoderDirStatus ( amt_tclServiceData* poMessage ) const;
#if 0
   //!
   void vHandleTouchPanelAlignment ( amt_tclServiceData* poMessage ) const;
#endif

   void vHandleEnableInputEvents ( amt_tclServiceData* poMessage ) const;

   void vHandleSetTouch ( amt_tclServiceData* poMessage ) const;

   void vHandleSetTouchSlide ( amt_tclServiceData* poMessage ) const;

   void vHandleRecordGesture ( amt_tclServiceData* poMessage ) const;
   void vHandleReplayGesture ( amt_tclServiceData* poMessage ) const;
   void vHandleSetEncoder ( amt_tclServiceData* poMessage ) const;
   void vHandlePIVISetTouch ( amt_tclServiceData* poMessage ) const;
   void vHandlePIVITouchScreenStatus ( amt_tclServiceData* poMessage ) const;
private:
#if 0
   //!
   dia_eInputHandlingKeyInfoPrj getDiaKeyInfo ( midw_fi_tcl_KeyAction::tenType eKeyAct ) const;
#endif
   //!
   void fillKeyCodeprjMap();
   void fillKeyCodeMap();
   dia_eInputHandlingTouchInfoPrj getDiaPrjTouchInfo ( input_fi_tcl_e8_TouchStatus::tenType eTouchStatus ) const;
   dia_eInputHandlingTouchInfo getDiaTouchInfo ( input_fi_tcl_e8_TouchStatus::tenType eTouchStatus ) const;
   //!
   dia_eVdInuptHandlingKeyCodePrj getDiaPrjKeyCode ( input_fi_tcl_e16_KeyCode::tenType eKeyCode ) const;
   dia_eVdInuptHandlingKeyCodePrj getDiaPrjSWCKeyCode ( input_fi_tcl_e16_KeyCode::tenType eKeyCode ) const;
   input_fi_tcl_e16_KeyCode::tenType getPrjInternalKeyCodeMapping(dia_eVdInuptHandlingKeyCodePrj KeyID) const;

   dia_eVdInuptHandlingKeyCode getDiaKeyCode ( input_fi_tcl_e16_KeyCode::tenType eKeyCode ) const;
   dia_eVdInuptHandlingKeyCode getDiaSWCKeyCode ( input_fi_tcl_e16_KeyCode::tenType eKeyCode ) const;
   input_fi_tcl_e16_KeyCode::tenType getInternalKeyCodeMapping(dia_eVdInuptHandlingKeyCode KeyID) const;

   //! declare message map data structures
   DECLARE_MSG_MAP(dia_SAFeatureInputHandling)
};

#endif /* DIA_SAFEATUREINPUTHANDLING_H_ */
