/*******************************************************************************************
 * dia_SAFeatureInputHandling.cpp
 *
 *  Created on: 29.01.2012
 *      Author: wgl2hi
 *
 * ------------------------------------------------------------------------------------------
 * Date          | Author          | Modification
 * 27.11.15          | ata7kor            | Added a code change to resolve ticket AIVI-15132
 * 30.09.16         | dvd5kor          | Mapping for KeyPress(buttons) added for 2.1 scope
 * ------------------------------------------------------------------------------------------
********************************************************************************************/

#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include "generic_msgs_if.h" //lint !e451 !e537 repeatedly included header file without standard include guard

#define INPUT_FI_S_IMPORT_INTERFACE_FI_TYPES
#define INPUT_FI_S_IMPORT_INTERFACE_INPUT_MAINFI_STDVISITORS
#define INPUT_FI_S_IMPORT_INTERFACE_INPUT_MAINFI_TYPES
#define INPUT_FI_S_IMPORT_INTERFACE_INPUT_MAINFI_FUNCTIONIDS
#include"input_fi_if.h"

#define UNKNOWN_INTERNAL_KEY_CODE 0XFFFF
#include "dia_SAFeatureInputHandling.h"
#define DIA_PRJ_KEY_TOUCH_PRESSED  1
#define DIA_PRJ_KEY_TOUCH_RELEASED 0
#define DIA_EN_KEY_TOUCH_PRESSED 1
#define DIA_KEY_TOUCH_RELEASED 0

#define UNKNOWN_INTERNAL_ENCODER_TYPE 0XFF
/*
//Mapping diagnosis specified keycode to internal keycode (the order of elements below is important!)
input_fi_tcl_e16_KeyCode::tenType dia_InternalKeyCodeMapping[DIA_PRJ_KEY_CODE_COUNT] =
{
      (input_fi_tcl_e16_KeyCode::tenType) UNKNOWN_INTERNAL_KEY_CODE,
      (input_fi_tcl_e16_KeyCode::tenType) input_fi_tcl_e16_KeyCode:: FI_EN_INPUT_HK_PHONE,
      (input_fi_tcl_e16_KeyCode::tenType) input_fi_tcl_e16_KeyCode:: FI_EN_INPUT_HK_CD,
      (input_fi_tcl_e16_KeyCode::tenType) input_fi_tcl_e16_KeyCode:: FI_EN_INPUT_HK_CAMERA,
      (input_fi_tcl_e16_KeyCode::tenType) input_fi_tcl_e16_KeyCode:: FI_EN_INPUT_HK_AUX,
      (input_fi_tcl_e16_KeyCode::tenType) input_fi_tcl_e16_KeyCode:: FI_EN_INPUT_HK_PREV,
      (input_fi_tcl_e16_KeyCode::tenType) input_fi_tcl_e16_KeyCode:: FI_EN_INPUT_HK_NEXT,
      (input_fi_tcl_e16_KeyCode::tenType) input_fi_tcl_e16_KeyCode:: FI_EN_INPUT_HK_RADIO,
      (input_fi_tcl_e16_KeyCode::tenType) input_fi_tcl_e16_KeyCode:: FI_EN_INPUT_HK_INFO,
      (input_fi_tcl_e16_KeyCode::tenType) input_fi_tcl_e16_KeyCode:: FI_EN_INPUT_HK_SETUP,
      (input_fi_tcl_e16_KeyCode::tenType) input_fi_tcl_e16_KeyCode:: FI_EN_INPUT_HK_MAP,
      (input_fi_tcl_e16_KeyCode::tenType) input_fi_tcl_e16_KeyCode:: FI_EN_INPUT_HK_BACK,
      (input_fi_tcl_e16_KeyCode::tenType) input_fi_tcl_e16_KeyCode:: FI_EN_INPUT_HK_DAY_NIGHT,
      (input_fi_tcl_e16_KeyCode::tenType) input_fi_tcl_e16_KeyCode:: FI_EN_INPUT_HK_NAV,
      (input_fi_tcl_e16_KeyCode::tenType) input_fi_tcl_e16_KeyCode:: FI_EN_INPUT_HK_ENTER,
      (input_fi_tcl_e16_KeyCode::tenType) input_fi_tcl_e16_KeyCode:: FI_EN_INPUT_HK_XM,
      (input_fi_tcl_e16_KeyCode::tenType) input_fi_tcl_e16_KeyCode:: FI_EN_INPUT_HK_FM_AM,
      (input_fi_tcl_e16_KeyCode::tenType) input_fi_tcl_e16_KeyCode:: FI_EN_INPUT_HK_MENU,
      (input_fi_tcl_e16_KeyCode::tenType) input_fi_tcl_e16_KeyCode:: FI_EN_INPUT_HK_APP,
      (input_fi_tcl_e16_KeyCode::tenType) input_fi_tcl_e16_KeyCode:: FI_EN_INPUT_HK_AUDIO,
      (input_fi_tcl_e16_KeyCode::tenType) input_fi_tcl_e16_KeyCode:: FI_EN_INPUT_HK_DISP,
      (input_fi_tcl_e16_KeyCode::tenType) input_fi_tcl_e16_KeyCode:: FI_EN_INPUT_HK_HOME,
      (input_fi_tcl_e16_KeyCode::tenType) input_fi_tcl_e16_KeyCode:: FI_EN_INPUT_HK_MEX,
      (input_fi_tcl_e16_KeyCode::tenType) input_fi_tcl_e16_KeyCode:: FI_EN_INPUT_HK_MUTE,
	  (input_fi_tcl_e16_KeyCode::tenType) input_fi_tcl_e16_KeyCode:: FI_EN_INPUT_HK_VIRT_SRV_TEST,
	  (input_fi_tcl_e16_KeyCode::tenType) input_fi_tcl_e16_KeyCode:: FI_EN_INPUT_HK_FOLDER_NEXT,
	  (input_fi_tcl_e16_KeyCode::tenType) input_fi_tcl_e16_KeyCode:: FI_EN_INPUT_HK_FOLDER_PREV,
	  (input_fi_tcl_e16_KeyCode::tenType) input_fi_tcl_e16_KeyCode:: FI_EN_INPUT_HK_PIVI_CLIMATE,
      (input_fi_tcl_e16_KeyCode::tenType) input_fi_tcl_e16_KeyCode:: FI_EN_INPUT_SYS_KEY_POWER,
      (input_fi_tcl_e16_KeyCode::tenType) input_fi_tcl_e16_KeyCode:: FI_EN_INPUT_SYS_KEY_EJECT,
      (input_fi_tcl_e16_KeyCode::tenType) input_fi_tcl_e16_KeyCode:: FI_EN_INPUT_SWC_MODE,
      (input_fi_tcl_e16_KeyCode::tenType) input_fi_tcl_e16_KeyCode:: FI_EN_INPUT_SWC_OK,
      (input_fi_tcl_e16_KeyCode::tenType) input_fi_tcl_e16_KeyCode:: FI_EN_INPUT_SWC_SEEK_UP,
      (input_fi_tcl_e16_KeyCode::tenType) input_fi_tcl_e16_KeyCode:: FI_EN_INPUT_SWC_SEEK_DOWN,
      (input_fi_tcl_e16_KeyCode::tenType) input_fi_tcl_e16_KeyCode:: FI_EN_INPUT_SWC_TEL_VR,
      (input_fi_tcl_e16_KeyCode::tenType) input_fi_tcl_e16_KeyCode:: FI_EN_INPUT_SWC_VOL_DOWN,
      (input_fi_tcl_e16_KeyCode::tenType) input_fi_tcl_e16_KeyCode:: FI_EN_INPUT_SWC_VOL_UP,
      (input_fi_tcl_e16_KeyCode::tenType) input_fi_tcl_e16_KeyCode:: FI_EN_INPUT_SWC_TEL_HANG_UP,
      (input_fi_tcl_e16_KeyCode::tenType) input_fi_tcl_e16_KeyCode:: FI_EN_INPUT_SWC_BACK,
      (input_fi_tcl_e16_KeyCode::tenType) input_fi_tcl_e16_KeyCode:: FI_EN_INPUT_SWC_UP,
      (input_fi_tcl_e16_KeyCode::tenType) input_fi_tcl_e16_KeyCode:: FI_EN_INPUT_SWC_DOWN,
      (input_fi_tcl_e16_KeyCode::tenType) input_fi_tcl_e16_KeyCode:: FI_EN_INPUT_SWC_MUTE,
      (input_fi_tcl_e16_KeyCode::tenType) input_fi_tcl_e16_KeyCode:: FI_EN_INPUT_SWC_AUDIO_SRC_UP,
      (input_fi_tcl_e16_KeyCode::tenType) input_fi_tcl_e16_KeyCode:: FI_EN_INPUT_SWC_AUDIO_SRC_DOWN,
      (input_fi_tcl_e16_KeyCode::tenType) input_fi_tcl_e16_KeyCode:: FI_EN_INPUT_SWC_RADIO,
      (input_fi_tcl_e16_KeyCode::tenType) input_fi_tcl_e16_KeyCode:: FI_EN_INPUT_SWC_ENTER,
      (input_fi_tcl_e16_KeyCode::tenType) input_fi_tcl_e16_KeyCode:: FI_EN_INPUT_JOYSTICK_UP,
      (input_fi_tcl_e16_KeyCode::tenType) input_fi_tcl_e16_KeyCode:: FI_EN_INPUT_JOYSTICK_DOWN,
      (input_fi_tcl_e16_KeyCode::tenType) input_fi_tcl_e16_KeyCode:: FI_EN_INPUT_JOYSTICK_LEFT,
      (input_fi_tcl_e16_KeyCode::tenType) input_fi_tcl_e16_KeyCode:: FI_EN_INPUT_JOYSTICK_RIGHT,
      (input_fi_tcl_e16_KeyCode::tenType) input_fi_tcl_e16_KeyCode:: FI_EN_INPUT_JOYSTICK_UPPER_LEFT,
      (input_fi_tcl_e16_KeyCode::tenType) input_fi_tcl_e16_KeyCode:: FI_EN_INPUT_JOYSTICK_UPPER_RIGHT,
      (input_fi_tcl_e16_KeyCode::tenType) input_fi_tcl_e16_KeyCode:: FI_EN_INPUT_JOYSTICK_LOWER_LEFT,
      (input_fi_tcl_e16_KeyCode::tenType) input_fi_tcl_e16_KeyCode:: FI_EN_INPUT_JOYSTICK_LOWER_RIGHT,
      (input_fi_tcl_e16_KeyCode::tenType) input_fi_tcl_e16_KeyCode:: FI_EN_INPUT_JOYSTICK_ENTER,
      (input_fi_tcl_e16_KeyCode::tenType) input_fi_tcl_e16_KeyCode:: FI_EN_INPUT_JOYSTICK_MAP,
      (input_fi_tcl_e16_KeyCode::tenType) input_fi_tcl_e16_KeyCode:: FI_EN_INPUT_JOYSTICK_HOME,
      (input_fi_tcl_e16_KeyCode::tenType) input_fi_tcl_e16_KeyCode:: FI_EN_INPUT_JOYSTICK_BACK,
     (input_fi_tcl_e16_KeyCode::tenType) input_fi_tcl_e16_KeyCode:: FI_EN_INPUT_JOYSTICK_DAY_NIGHT,
     (input_fi_tcl_e16_KeyCode::tenType) input_fi_tcl_e16_KeyCode:: FI_EN_INPUT_JOYSTICK_DISP,
     (input_fi_tcl_e16_KeyCode::tenType) input_fi_tcl_e16_KeyCode:: FI_EN_INPUT_JOYSTICK_OPTION

 };
*/
//Mapping diagnosis specified encoder type to internal encoder type
input_fi_tcl_e8_EncoderType::tenType dia_InternalEncoderTypeMapping[DIA_EN_PRJ_ENCODER_COUNT] =
{
      (input_fi_tcl_e8_EncoderType::tenType) UNKNOWN_INTERNAL_ENCODER_TYPE,
      (input_fi_tcl_e8_EncoderType::tenType) input_fi_tcl_e8_EncoderType:: FI_EN_LEFT_ENCODER,
      (input_fi_tcl_e8_EncoderType::tenType) input_fi_tcl_e8_EncoderType:: FI_EN_RIGHT_ENCODER,
	  (input_fi_tcl_e8_EncoderType::tenType) input_fi_tcl_e8_EncoderType:: FI_EN_JOYSTICK_ENCODER,
	  (input_fi_tcl_e8_EncoderType::tenType) input_fi_tcl_e8_EncoderType:: FI_EN_MSMENCODER,
	  (input_fi_tcl_e8_EncoderType::tenType) input_fi_tcl_e8_EncoderType:: FI_EN_SWRCENCODER,
      (input_fi_tcl_e8_EncoderType::tenType) UNKNOWN_INTERNAL_ENCODER_TYPE, // No mapping for DIA_EN_PRJ_ENCODER_SWC_VOLUME
      (input_fi_tcl_e8_EncoderType::tenType) UNKNOWN_INTERNAL_ENCODER_TYPE, // No mapping for DIA_EN_PRJ_ENCODER_SWC_UP_DOWN
 };


#if 0
// convert DIA key code to internal (in key component) defined key code
midw_fi_tcl_KeyCode::tenType aInternalKeyCode[DIA_EN_PRJ_KEY_CODE_COUNT] =
{
   midw_fi_tcl_KeyCode::FI_EN_NO_KEY,
   midw_fi_tcl_KeyCode::FI_EN_RADIO,
   midw_fi_tcl_KeyCode::FI_EN_AM_FM,
   midw_fi_tcl_KeyCode::FI_EN_MEDIA,
   midw_fi_tcl_KeyCode::FI_EN_CAR,
   midw_fi_tcl_KeyCode::FI_EN_SETUP,
   midw_fi_tcl_KeyCode::FI_EN_PHONE,
   midw_fi_tcl_KeyCode::FI_EN_SOUND,
   midw_fi_tcl_KeyCode::FI_EN_MUTE,
   midw_fi_tcl_KeyCode::FI_EN_TP,
   midw_fi_tcl_KeyCode::FI_EN_MENU,
   midw_fi_tcl_KeyCode::FI_EN_RIGHT_ENCODER_BUTTON,
   midw_fi_tcl_KeyCode::FI_EN_RIGHT_ENCODER_BUTTON,
   midw_fi_tcl_KeyCode::FI_EN_EJECT
};

// convert DIA lock option to internal (in key component) defined lock option
midw_fi_tcl_KeyLock::tenType aInternalLock[DIA_EN_PRJ_INFO_CONTROL_COUNT] =
{
   midw_fi_tcl_KeyLock::FI_EN_UNLOCK,
   midw_fi_tcl_KeyLock::FI_EN_LOCK,
   midw_fi_tcl_KeyLock::FI_EN_UNLOCK
};

// convert DIA encoder code to internal (in key component) defined encoder code
midw_fi_tcl_EncoderCode::tenType aInternalEncoderCode[DIA_EN_PRJ_ENCODER_COUNT] =
{
   midw_fi_tcl_EncoderCode::FI_EN_NONE,
   midw_fi_tcl_EncoderCode::FI_EN_ENCODER_VOLUME,
   midw_fi_tcl_EncoderCode::FI_EN_ENCODER_MULTIFUNCTION,
   midw_fi_tcl_EncoderCode::FI_EN_INC_SWC_VOLUME,
   midw_fi_tcl_EncoderCode::FI_EN_INC_SWC_UP_DOWN
};
#endif

// MESSAGE MAP: the function will be called when a message with the
// corresponding FID arrives
BEGIN_MSG_MAP(dia_SAFeatureInputHandling, dia_SystemAdapterFeature)
   ON_MESSAGE(INPUT_MAINFI_C_U16_PRESSEDKEYS,                vHandleGetPressedKey)
   ON_MESSAGE(INPUT_MAINFI_C_U16_ENABLEINPUTEVENTS,          vHandleEnableInputEvents)
   ON_MESSAGE(INPUT_MAINFI_C_U16_ENCODERSTATUS,              vHandleEncoderStatus)
   ON_MESSAGE(INPUT_MAINFI_C_U16_ENCODERDIRSTATUS,           vHandleEncoderDirStatus)
   ON_MESSAGE(INPUT_MAINFI_C_U16_TOUCHSTATUS,                vHandleTouchScreenStatus)
   ON_MESSAGE(INPUT_MAINFI_C_U16_SIMULATEKEYINJECTION,       vHandleSetKey)
   ON_MESSAGE(INPUT_MAINFI_C_U16_SIMULATESINGLETOUCH,        vHandleSetTouch)
   ON_MESSAGE(INPUT_MAINFI_C_U16_SIMULATETOUCHSLIDE,         vHandleSetTouchSlide)
   ON_MESSAGE(INPUT_MAINFI_C_U16_GESTURERECORD,             vHandleRecordGesture)
   ON_MESSAGE(INPUT_MAINFI_C_U16_GESTUREREPLAY,             vHandleReplayGesture)
   ON_MESSAGE(INPUT_MAINFI_C_U16_SIMULATEENCROTATION,        vHandleSetEncoder)
   ON_MESSAGE(INPUT_MAINFI_C_U16_SIMULATEPIVITOUCH,        vHandlePIVISetTouch)
   ON_MESSAGE(INPUT_MAINFI_C_U16_TOUCHSTATUSPIVISECONDARY,               vHandlePIVITouchScreenStatus)
#if 0 //TODO: Convert to INPUT_MAINFI
   ON_MESSAGE(MIDW_KBDFI_C_U16_STARTTOUCHSCREENCALIBRATION, vHandleTouchPanelAlignment)
   ON_MESSAGE(MIDW_KBDFI_C_U16_KEYLOCK,                     vHandleLockControlUnit)

#endif
END_MSG_MAP()
static std::map<input_fi_tcl_e16_KeyCode::tenType,dia_eVdInuptHandlingKeyCodePrj> keyCodeMap;
static std::map<input_fi_tcl_e16_KeyCode::tenType,dia_eVdInuptHandlingKeyCode> keyCodeCoreMap;
//------------------------------------------------------------------------------

dia_SAFeatureInputHandling::dia_SAFeatureInputHandling (
      tCString name,    // feature name
      dia_SystemAdapterServicePlugin& pSrvPlugin
   )
    : dia_SystemAdapterFeature(name,pSrvPlugin)
{
   dia_tclFnctTrace trc("dia_SAFeatureInputHandling::dia_SAFeatureInputHandling");
   fillKeyCodeprjMap();
   fillKeyCodeMap();
}

//-----------------------------------------------------------------------------

dia_SAFeatureInputHandling::~dia_SAFeatureInputHandling ( void )
{
}

//-----------------------------------------------------------------------------
void dia_SAFeatureInputHandling::fillKeyCodeprjMap()
{
keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_SWC_MODE]= DIA_PRJ_SWC_KEY_CODE_MODE;                				
keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_SWC_OK]=DIA_PRJ_SWC_KEY_CODE_OK;
keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_SWC_SEEK_UP]=DIA_PRJ_SWC_KEY_CODE_SEEK_UP;
keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_SWC_SEEK_DOWN]=DIA_PRJ_SWC_KEY_CODE_SEEK_DOWN;		
keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_SWC_TEL_VR]=DIA_PRJ_SWC_KEY_CODE_TEL_VR;				
keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_SWC_VOL_DOWN]=DIA_PRJ_SWC_KEY_CODE_VOL_DOWN;
keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_SWC_VOL_UP]=DIA_PRJ_SWC_KEY_CODE_VOL_UP;				
keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_SWC_TEL_HANG_UP]=DIA_PRJ_SWC_KEY_CODE_TEL_HANG_UP;			
keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_SWC_BACK]=DIA_PRJ_SWC_KEY_CODE_BACK;					
keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_SWC_UP]=DIA_PRJ_SWC_KEY_CODE_UP;
keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_SWC_DOWN]=DIA_PRJ_SWC_KEY_CODE_DOWN;					
keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_SWC_MUTE]=DIA_PRJ_SWC_KEY_CODE_MUTE;					
keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_SWC_AUDIO_SRC_UP]=DIA_PRJ_SWC_KEY_CODE_AUDIO_SRC_UP;			
keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_SWC_AUDIO_SRC_DOWN]=DIA_PRJ_SWC_KEY_CODE_AUDIO_SRC_DOWN;
keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_SWC_RADIO]=DIA_PRJ_SWC_KEY_CODE_RADIO;				
keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_SWC_ENTER]=DIA_PRJ_SWC_KEY_CODE_ENTER;
keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_SWC_LEFT]=DIA_PRJ_SWC_KEY_CODE_LEFT;					
keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_SWC_RIGHT]=DIA_PRJ_SWC_KEY_CODE_RIGHT;				
keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_HK_HOME_LONG]=DIA_PRJ_KEY_CODE_HOME_LONGPRESS;				
keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_HK_MENU_LONG]=DIA_PRJ_KEY_CODE_MENU_LONGPRESS;          				
keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_HK_SETUP_LONG]=DIA_PRJ_KEY_CODE_SETUP_LONGPRESS;			
keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_HK_DAY_NIGHT_LONG]=DIA_PRJ_KEY_CODE_DAY_NIGHT_LONGPRESS;		
keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_SYS_KEY_POWER_LONG]=DIA_PRJ_KEY_CODE_POWER_LONGPRESS;				
#ifdef VARIANT_S_FTR_MC_ENABLE_AIVI2
 keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_HK_PHONE_GEN4]=DIA_PRJ_KEY_CODE_PHONE;    
 keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_HK_CD_GEN4]=DIA_PRJ_KEY_CODE_CD;
 keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_HK_CAMERA_GEN4]=DIA_PRJ_KEY_CODE_CAMERA;
 keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_HK_AUX_GEN4]=DIA_PRJ_KEY_CODE_AUX;
 keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_HK_PREV_GEN4]=DIA_PRJ_KEY_CODE_PREV;
 keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_HK_NEXT_GEN4]=DIA_PRJ_KEY_CODE_NEXT;
 keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_HK_RADIO_GEN4]=DIA_PRJ_KEY_CODE_RADIO;
 keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_HK_INFO_GEN4]=DIA_PRJ_KEY_CODE_INFO;
 keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_HK_SETUP_GEN4]=DIA_PRJ_KEY_CODE_SETUP;
 keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_HK_MAP_GEN4]=DIA_PRJ_KEY_CODE_MAP;
 keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_HK_BACK_GEN4]=DIA_PRJ_KEY_CODE_BACK;
 keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_HK_DAY_NIGHT_GEN4]=DIA_PRJ_KEY_CODE_DAY_NIGHT;
 keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_HK_NAV_GEN4]=DIA_PRJ_KEY_CODE_NAV;
 keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_HK_ENTER_GEN4]=DIA_PRJ_KEY_CODE_ENTER;
 keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_HK_XM_GEN4]=DIA_PRJ_KEY_CODE_XM;
 keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_SYS_KEY_POWER_GEN4]=DIA_PRJ_KEY_CODE_POWER;
 keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_SYS_KEY_EJECT_GEN4]=DIA_PRJ_KEY_CODE_EJECT;
 keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_HK_FM_AM_GEN4]=DIA_PRJ_KEY_CODE_AM_FM;
 keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_HK_MENU_GEN4]=DIA_PRJ_KEY_CODE_MENU;
 keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_HK_APP_GEN4]=DIA_PRJ_KEY_CODE_APP;
 keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_HK_AUDIO_GEN4]=DIA_PRJ_KEY_CODE_AUDIO;
 keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_HK_DISP_GEN4]=DIA_PRJ_KEY_CODE_DISP;
 keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_HK_VOLUME_UP_GEN4]=DIA_PRJ_KEY_CODE_VOL_UP;
 keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_HK_VOLUME_DOWN_GEN4]=DIA_PRJ_KEY_CODE_VOL_DOWN;
 keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_HK_VOLUME_GEN4]=DIA_PRJ_KEY_CODE_VOLUME;
 keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_HK_HOME_GEN4]=DIA_PRJ_KEY_CODE_HOME;
 keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_SYS_KEY_RSC_ON_OFF_GEN4]=DIA_PRJ_KEY_CODE_RSC_ON_OFF;
 keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_HK_ELECTRO_VEHICLE_GEN4]=DIA_PRJ_KEY_CODE_EV;
 keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_HK_FOLDER_NEXT_GEN4]=DIA_PRJ_KEY_CODE_FOLDER_NEXT;
 keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_HK_FOLDER_PREV_GEN4]=DIA_PRJ_KEY_CODE_FOLDER_PREV;
 keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_HK_MUTE_GEN4]=DIA_PRJ_KEY_CODE_MUTE;
 keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_HK_PIVI_CLIMATE_GEN4]=DIA_PRJ_KEY_CODE_PIVI_CLIMATE;
 keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_HK_MEX_GEN4]=DIA_PRJ_KEY_CODE_MEX;   
#if 0
   keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_HK__GEN4]=DIA_PRJ_KEY_CODE_TRAFFIC_INFO;
#endif
   keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_HK_VIRT_SRV_TEST_GEN4]=DIA_PRJ_KEY_CODE_VIRT_ENG_TESTMODE; 
#if 0
   keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_HK__GEN4]=DIA_PRJ_KEY_CODE_VIRT_SCREENSHOT;
#endif
   keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_HVAC_MEX_GEN4]=DIA_PRJ_KEY_CODE_HVAC_MEX;
   keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_HVAC_SEAT_GEN4]=DIA_PRJ_KEY_CODE_HVAC_SEAT;
   keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_HK_VIRT_VOL_COMBI_GEN4]=DIA_PRJ_KEY_CODE_VIRT_VOL_COMBI;

#if 0
   keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_MEDIA_GEN4]=DIA_PRJ_KEY_CODE_MEDIA;
   keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_CAR_GEN4]=DIA_PRJ_KEY_CODE_CAR;
   keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_SOUND_GEN4]=DIA_PRJ_KEY_CODE_SOUND; 
   keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_MUTE_GEN4]=DIA_PRJ_KEY_CODE_MUTE;
   keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_TP_GEN4]=DIA_PRJ_KEY_CODE_TP;
#endif

   keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_JOYSTICK_OPTION_LONGPRESS_GEN4]=DIA_PRJ_JOYSTICK_KEY_CODE_OPTION_LONGPRESS;
   keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_JOYSTICK_HOME_LONGPRESS_GEN4]=DIA_PRJ_JOYSTICK_KEY_CODE_HOME_LONGPRESS;
   keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_JOYSTICK_BACK_LONGPRESS_GEN4]=DIA_PRJ_JOYSTICK_KEY_CODE_BACK_LONGPRESS;
   keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_JOYSTICK_ENTER_LONGPRESS_GEN4]=DIA_PRJ_JOYSTICK_KEY_CODE_ENTER_LONGPRESS;
   keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_JOYSTICK_UP_GEN4]=DIA_PRJ_JOYSTICK_KEY_CODE_UP;
   keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_JOYSTICK_DOWN_GEN4]=DIA_PRJ_JOYSTICK_KEY_CODE_DOWN;
   keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_JOYSTICK_LEFT_GEN4]=DIA_PRJ_JOYSTICK_KEY_CODE_LEFT;
   keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_JOYSTICK_RIGHT_GEN4]=DIA_PRJ_JOYSTICK_KEY_CODE_RIGHT;
   keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_JOYSTICK_UPPER_LEFT_GEN4]=DIA_PRJ_JOYSTICK_KEY_CODE_UPPER_LEFT;
   keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_JOYSTICK_UPPER_RIGHT_GEN4]=DIA_PRJ_JOYSTICK_KEY_CODE_UPPER_RIGHT;
   keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_JOYSTICK_LOWER_LEFT_GEN4]=DIA_PRJ_JOYSTICK_KEY_CODE_LOWER_LEFT;
   keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_JOYSTICK_LOWER_RIGHT_GEN4]=DIA_PRJ_JOYSTICK_KEY_CODE_LOWER_RIGHT;
   keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_JOYSTICK_ENTER_GEN4]=DIA_PRJ_JOYSTICK_KEY_CODE_ENTER;
   keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_JOYSTICK_MAP_GEN4]=DIA_PRJ_JOYSTICK_KEY_CODE_MAP;
   keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_JOYSTICK_OPTION_GEN4]=DIA_PRJ_JOYSTICK_KEY_CODE_OPTION;
   keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_JOYSTICK_HOME_GEN4]=DIA_PRJ_JOYSTICK_KEY_CODE_HOME;
   keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_JOYSTICK_BACK_GEN4]=DIA_PRJ_JOYSTICK_KEY_CODE_BACK;
   keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_JOYSTICK_DAY_NIGHT_GEN4]=DIA_PRJ_JOYSTICK_KEY_CODE_DAY_NIGHT;
   keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_JOYSTICK_DISP_GEN4]=DIA_PRJ_JOYSTICK_KEY_CODE_DISP;
#if 0
   keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_HK__GEN4]=DIA_PRJ_KEY_CODE_REL_JOYSTICK_WHEEL;
#endif
#else
 
 keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_HK_PHONE]=DIA_PRJ_KEY_CODE_PHONE;    
 keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_HK_CD]=DIA_PRJ_KEY_CODE_CD;
 keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_HK_CAMERA]=DIA_PRJ_KEY_CODE_CAMERA;
 keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_HK_AUX]=DIA_PRJ_KEY_CODE_AUX;
 keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_HK_PREV]=DIA_PRJ_KEY_CODE_PREV;
 keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_HK_NEXT]=DIA_PRJ_KEY_CODE_NEXT;
 keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_HK_RADIO]=DIA_PRJ_KEY_CODE_RADIO;
 keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_HK_INFO]=DIA_PRJ_KEY_CODE_INFO;
 keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_HK_SETUP]=DIA_PRJ_KEY_CODE_SETUP;
 keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_HK_MAP]=DIA_PRJ_KEY_CODE_MAP;
 keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_HK_BACK]=DIA_PRJ_KEY_CODE_BACK;
 keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_HK_DAY_NIGHT]=DIA_PRJ_KEY_CODE_DAY_NIGHT;
 keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_HK_NAV]=DIA_PRJ_KEY_CODE_NAV;
 keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_HK_ENTER]=DIA_PRJ_KEY_CODE_ENTER;
 keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_HK_XM]=DIA_PRJ_KEY_CODE_XM;
 keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_SYS_KEY_POWER]=DIA_PRJ_KEY_CODE_POWER;
 keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_SYS_KEY_EJECT]=DIA_PRJ_KEY_CODE_EJECT;
 keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_HK_FM_AM]=DIA_PRJ_KEY_CODE_AM_FM;
 keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_HK_MENU]=DIA_PRJ_KEY_CODE_MENU;
 keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_HK_APP]=DIA_PRJ_KEY_CODE_APP;
 keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_HK_AUDIO]=DIA_PRJ_KEY_CODE_AUDIO;
 keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_HK_DISP]=DIA_PRJ_KEY_CODE_DISP;
 keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_HK_VOLUME_UP]=DIA_PRJ_KEY_CODE_VOL_UP;
 keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_HK_VOLUME_DOWN]=DIA_PRJ_KEY_CODE_VOL_DOWN;
 keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_HK_VOLUME]=DIA_PRJ_KEY_CODE_VOLUME;
 keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_HK_HOME]=DIA_PRJ_KEY_CODE_HOME;
 keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_SYS_KEY_RSC_ON_OFF]=DIA_PRJ_KEY_CODE_RSC_ON_OFF;
 keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_HK_ELECTRO_VEHICLE]=DIA_PRJ_KEY_CODE_EV;
 keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_HK_FOLDER_NEXT]=DIA_PRJ_KEY_CODE_FOLDER_NEXT;
 keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_HK_FOLDER_PREV]=DIA_PRJ_KEY_CODE_FOLDER_PREV;
 keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_HK_MUTE]=DIA_PRJ_KEY_CODE_MUTE;
 keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_HK_PIVI_CLIMATE]=DIA_PRJ_KEY_CODE_PIVI_CLIMATE;
 keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_HK_MEX]=DIA_PRJ_KEY_CODE_MEX;   
#if 0
   keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_HK_]=DIA_PRJ_KEY_CODE_TRAFFIC_INFO;
#endif
   keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_HK_VIRT_SRV_TEST]=DIA_PRJ_KEY_CODE_VIRT_ENG_TESTMODE; 
#if 0
   keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_HK_]=DIA_PRJ_KEY_CODE_VIRT_SCREENSHOT;
#endif
   keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_HVAC_MEX]=DIA_PRJ_KEY_CODE_HVAC_MEX;
   keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_HVAC_SEAT]=DIA_PRJ_KEY_CODE_HVAC_SEAT;
   keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_HK_VIRT_VOL_COMBI]=DIA_PRJ_KEY_CODE_VIRT_VOL_COMBI;

#if 0
   keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_MEDIA]=DIA_PRJ_KEY_CODE_MEDIA;
   keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_CAR]=DIA_PRJ_KEY_CODE_CAR;
   keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_SOUND]=DIA_PRJ_KEY_CODE_SOUND; 
   keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_MUTE]=DIA_PRJ_KEY_CODE_MUTE;
   keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_TP]=DIA_PRJ_KEY_CODE_TP;
#endif

   keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_JOYSTICK_OPTION_LONGPRESS]=DIA_PRJ_JOYSTICK_KEY_CODE_OPTION_LONGPRESS;
   keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_JOYSTICK_HOME_LONGPRESS]=DIA_PRJ_JOYSTICK_KEY_CODE_HOME_LONGPRESS;
   keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_JOYSTICK_BACK_LONGPRESS]=DIA_PRJ_JOYSTICK_KEY_CODE_BACK_LONGPRESS;
   keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_JOYSTICK_ENTER_LONGPRESS]=DIA_PRJ_JOYSTICK_KEY_CODE_ENTER_LONGPRESS;
   keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_JOYSTICK_UP]=DIA_PRJ_JOYSTICK_KEY_CODE_UP;
   keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_JOYSTICK_DOWN]=DIA_PRJ_JOYSTICK_KEY_CODE_DOWN;
   keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_JOYSTICK_LEFT]=DIA_PRJ_JOYSTICK_KEY_CODE_LEFT;
   keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_JOYSTICK_RIGHT]=DIA_PRJ_JOYSTICK_KEY_CODE_RIGHT;
   keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_JOYSTICK_UPPER_LEFT]=DIA_PRJ_JOYSTICK_KEY_CODE_UPPER_LEFT;
   keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_JOYSTICK_UPPER_RIGHT]=DIA_PRJ_JOYSTICK_KEY_CODE_UPPER_RIGHT;
   keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_JOYSTICK_LOWER_LEFT]=DIA_PRJ_JOYSTICK_KEY_CODE_LOWER_LEFT;
   keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_JOYSTICK_LOWER_RIGHT]=DIA_PRJ_JOYSTICK_KEY_CODE_LOWER_RIGHT;
   keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_JOYSTICK_ENTER]=DIA_PRJ_JOYSTICK_KEY_CODE_ENTER;
   keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_JOYSTICK_MAP]=DIA_PRJ_JOYSTICK_KEY_CODE_MAP;
   keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_JOYSTICK_OPTION]=DIA_PRJ_JOYSTICK_KEY_CODE_OPTION;
   keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_JOYSTICK_HOME]=DIA_PRJ_JOYSTICK_KEY_CODE_HOME;
   keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_JOYSTICK_BACK]=DIA_PRJ_JOYSTICK_KEY_CODE_BACK;
   keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_JOYSTICK_DAY_NIGHT]=DIA_PRJ_JOYSTICK_KEY_CODE_DAY_NIGHT;
   keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_JOYSTICK_DISP]=DIA_PRJ_JOYSTICK_KEY_CODE_DISP;
#if 0
   keyCodeMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_HK_]=DIA_PRJ_KEY_CODE_REL_JOYSTICK_WHEEL;
#endif
#endif
}
void dia_SAFeatureInputHandling::fillKeyCodeMap()
{
keyCodeCoreMap[input_fi_tcl_e16_KeyCode:: FI_EN_INPUT_SWC_MODE]=DIA_SWC_KEY_CODE_MODE;
keyCodeCoreMap[input_fi_tcl_e16_KeyCode:: FI_EN_INPUT_SWC_OK]=DIA_SWC_KEY_CODE_OK;
keyCodeCoreMap[input_fi_tcl_e16_KeyCode:: FI_EN_INPUT_SWC_SEEK_UP]= DIA_SWC_KEY_CODE_SEEK_UP;
keyCodeCoreMap[input_fi_tcl_e16_KeyCode:: FI_EN_INPUT_SWC_SEEK_DOWN]=DIA_SWC_KEY_CODE_SEEK_DOWN;
keyCodeCoreMap[input_fi_tcl_e16_KeyCode:: FI_EN_INPUT_SWC_TEL_VR]=DIA_SWC_KEY_CODE_TEL_VR;
keyCodeCoreMap[input_fi_tcl_e16_KeyCode:: FI_EN_INPUT_SWC_VOL_DOWN]=DIA_SWC_KEY_CODE_VOL_DOWN;
keyCodeCoreMap[input_fi_tcl_e16_KeyCode:: FI_EN_INPUT_SWC_VOL_UP]=DIA_SWC_KEY_CODE_VOL_UP;
keyCodeCoreMap[input_fi_tcl_e16_KeyCode:: FI_EN_INPUT_SWC_TEL_HANG_UP]=DIA_SWC_KEY_CODE_TEL_HANG_UP;
keyCodeCoreMap[input_fi_tcl_e16_KeyCode:: FI_EN_INPUT_SWC_BACK]=DIA_SWC_KEY_CODE_BACK;
keyCodeCoreMap[input_fi_tcl_e16_KeyCode:: FI_EN_INPUT_SWC_UP]=DIA_SWC_KEY_CODE_UP;
keyCodeCoreMap[input_fi_tcl_e16_KeyCode:: FI_EN_INPUT_SWC_DOWN]=DIA_SWC_KEY_CODE_DOWN;
keyCodeCoreMap[input_fi_tcl_e16_KeyCode:: FI_EN_INPUT_SWC_MUTE]=DIA_SWC_KEY_CODE_MUTE;
keyCodeCoreMap[input_fi_tcl_e16_KeyCode:: FI_EN_INPUT_SWC_AUDIO_SRC_UP]=DIA_SWC_KEY_CODE_AUDIO_SRC_UP;
keyCodeCoreMap[input_fi_tcl_e16_KeyCode:: FI_EN_INPUT_SWC_AUDIO_SRC_DOWN]=DIA_SWC_KEY_CODE_AUDIO_SRC_DOWN;
keyCodeCoreMap[input_fi_tcl_e16_KeyCode:: FI_EN_INPUT_SWC_RADIO]=DIA_SWC_KEY_CODE_RADIO;
#ifdef VARIANT_S_FTR_MC_ENABLE_AIVI2
keyCodeCoreMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_HK_PHONE_GEN4]=DIA_KEY_CODE_PHONE;
keyCodeCoreMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_HK_CD_GEN4]=DIA_KEY_CODE_CD;
keyCodeCoreMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_HK_CAMERA_GEN4]=DIA_KEY_CODE_CAMERA;
keyCodeCoreMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_HK_AUX_GEN4]=DIA_KEY_CODE_AUX;
keyCodeCoreMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_HK_PREV_GEN4]=DIA_KEY_CODE_PREV;
keyCodeCoreMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_HK_NEXT_GEN4]=DIA_KEY_CODE_NEXT;
keyCodeCoreMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_HK_RADIO_GEN4]=DIA_KEY_CODE_RADIO;
keyCodeCoreMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_HK_INFO_GEN4]=DIA_KEY_CODE_INFO;
keyCodeCoreMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_HK_SETUP_GEN4]=DIA_KEY_CODE_SETUP;
keyCodeCoreMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_HK_MAP_GEN4]=DIA_KEY_CODE_MAP;
keyCodeCoreMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_HK_BACK_GEN4]=DIA_KEY_CODE_BACK;
keyCodeCoreMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_HK_DAY_NIGHT_GEN4]=DIA_KEY_CODE_DAY_NIGHT;
keyCodeCoreMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_HK_NAV_GEN4]=DIA_KEY_CODE_NAV;
keyCodeCoreMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_HK_ENTER_GEN4]=DIA_KEY_CODE_ENTER;
keyCodeCoreMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_HK_XM_GEN4]=DIA_KEY_CODE_XM;
keyCodeCoreMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_SYS_KEY_POWER_GEN4]=DIA_KEY_CODE_POWER;
keyCodeCoreMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_SYS_KEY_EJECT_GEN4]=DIA_KEY_CODE_EJECT;
keyCodeCoreMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_HK_FM_AM_GEN4]=DIA_KEY_CODE_AM_FM;
keyCodeCoreMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_HK_MENU_GEN4]=DIA_KEY_CODE_MENU;
keyCodeCoreMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_HK_APP_GEN4]=DIA_KEY_CODE_APP;
keyCodeCoreMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_HK_AUDIO_GEN4]=DIA_KEY_CODE_AUDIO;
keyCodeCoreMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_HK_DISP_GEN4]=DIA_KEY_CODE_DISP;
keyCodeCoreMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_JOYSTICK_OPTION_LONGPRESS_GEN4]=DIA_JOYSTICK_KEY_CODE_OPTION_LONGPRESS;
keyCodeCoreMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_JOYSTICK_HOME_LONGPRESS_GEN4]=DIA_JOYSTICK_KEY_CODE_HOME_LONGPRESS;
keyCodeCoreMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_JOYSTICK_BACK_LONGPRESS_GEN4]=DIA_JOYSTICK_KEY_CODE_BACK_LONGPRESS;
keyCodeCoreMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_JOYSTICK_ENTER_LONGPRESS_GEN4]=DIA_JOYSTICK_KEY_CODE_ENTER_LONGPRESS;
keyCodeCoreMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_JOYSTICK_UP_GEN4]=DIA_JOYSTICK_KEY_CODE_UP;
keyCodeCoreMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_JOYSTICK_DOWN_GEN4]=DIA_JOYSTICK_KEY_CODE_DOWN;
keyCodeCoreMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_JOYSTICK_LEFT_GEN4]=DIA_JOYSTICK_KEY_CODE_LEFT;
keyCodeCoreMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_JOYSTICK_RIGHT_GEN4]=DIA_JOYSTICK_KEY_CODE_RIGHT;
keyCodeCoreMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_JOYSTICK_UPPER_LEFT_GEN4]=DIA_JOYSTICK_KEY_CODE_UPPER_LEFT;
keyCodeCoreMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_JOYSTICK_UPPER_RIGHT_GEN4]=DIA_JOYSTICK_KEY_CODE_UPPER_RIGHT;
keyCodeCoreMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_JOYSTICK_LOWER_LEFT_GEN4]=DIA_JOYSTICK_KEY_CODE_LOWER_LEFT;
keyCodeCoreMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_JOYSTICK_LOWER_RIGHT_GEN4]=DIA_JOYSTICK_KEY_CODE_LOWER_RIGHT;
keyCodeCoreMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_JOYSTICK_ENTER_GEN4]=DIA_JOYSTICK_KEY_CODE_ENTER;
keyCodeCoreMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_JOYSTICK_MAP_GEN4]=DIA_JOYSTICK_KEY_CODE_MAP;
keyCodeCoreMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_JOYSTICK_HOME_GEN4]=DIA_JOYSTICK_KEY_CODE_HOME;
keyCodeCoreMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_JOYSTICK_BACK_GEN4]=DIA_JOYSTICK_KEY_CODE_BACK;
keyCodeCoreMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_JOYSTICK_DAY_NIGHT_GEN4]=DIA_JOYSTICK_KEY_CODE_DAY_NIGHT;
keyCodeCoreMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_JOYSTICK_DISP_GEN4]=DIA_JOYSTICK_KEY_CODE_DISP;
#else
keyCodeCoreMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_HK_PHONE]=DIA_KEY_CODE_PHONE;
keyCodeCoreMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_HK_CD]=DIA_KEY_CODE_CD;
keyCodeCoreMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_HK_CAMERA]=DIA_KEY_CODE_CAMERA;
keyCodeCoreMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_HK_AUX]=DIA_KEY_CODE_AUX;
keyCodeCoreMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_HK_PREV]=DIA_KEY_CODE_PREV;
keyCodeCoreMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_HK_NEXT]=DIA_KEY_CODE_NEXT;
keyCodeCoreMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_HK_RADIO]=DIA_KEY_CODE_RADIO;
keyCodeCoreMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_HK_INFO]=DIA_KEY_CODE_INFO;
keyCodeCoreMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_HK_SETUP]=DIA_KEY_CODE_SETUP;
keyCodeCoreMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_HK_MAP]= DIA_KEY_CODE_MAP;
keyCodeCoreMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_HK_BACK]=DIA_KEY_CODE_BACK;
keyCodeCoreMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_HK_DAY_NIGHT]=DIA_KEY_CODE_DAY_NIGHT;
keyCodeCoreMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_HK_NAV]=DIA_KEY_CODE_NAV;
keyCodeCoreMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_HK_ENTER]=DIA_KEY_CODE_ENTER;
keyCodeCoreMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_HK_XM]=DIA_KEY_CODE_XM;
keyCodeCoreMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_SYS_KEY_POWER]=DIA_KEY_CODE_POWER;
keyCodeCoreMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_SYS_KEY_EJECT]=DIA_KEY_CODE_EJECT;
keyCodeCoreMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_HK_FM_AM]=DIA_KEY_CODE_AM_FM;
keyCodeCoreMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_HK_MENU]=DIA_KEY_CODE_MENU;
keyCodeCoreMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_HK_APP]=DIA_KEY_CODE_APP;
keyCodeCoreMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_HK_AUDIO]=DIA_KEY_CODE_AUDIO;
keyCodeCoreMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_HK_DISP]=DIA_KEY_CODE_DISP;
keyCodeCoreMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_JOYSTICK_OPTION_LONGPRESS]=DIA_JOYSTICK_KEY_CODE_OPTION_LONGPRESS;
keyCodeCoreMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_JOYSTICK_HOME_LONGPRESS]=DIA_JOYSTICK_KEY_CODE_HOME_LONGPRESS;
keyCodeCoreMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_JOYSTICK_BACK_LONGPRESS]=DIA_JOYSTICK_KEY_CODE_BACK_LONGPRESS;
keyCodeCoreMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_JOYSTICK_ENTER_LONGPRESS]=DIA_JOYSTICK_KEY_CODE_ENTER_LONGPRESS;
keyCodeCoreMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_JOYSTICK_UP]=DIA_JOYSTICK_KEY_CODE_UP;
keyCodeCoreMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_JOYSTICK_DOWN]=DIA_JOYSTICK_KEY_CODE_DOWN;
keyCodeCoreMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_JOYSTICK_LEFT]=DIA_JOYSTICK_KEY_CODE_LEFT;
keyCodeCoreMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_JOYSTICK_RIGHT]=DIA_JOYSTICK_KEY_CODE_RIGHT;
keyCodeCoreMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_JOYSTICK_UPPER_LEFT]=DIA_JOYSTICK_KEY_CODE_UPPER_LEFT;
keyCodeCoreMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_JOYSTICK_UPPER_RIGHT]=DIA_JOYSTICK_KEY_CODE_UPPER_RIGHT;
keyCodeCoreMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_JOYSTICK_LOWER_LEFT]=DIA_JOYSTICK_KEY_CODE_LOWER_LEFT;
keyCodeCoreMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_JOYSTICK_LOWER_RIGHT]=DIA_JOYSTICK_KEY_CODE_LOWER_RIGHT;
keyCodeCoreMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_JOYSTICK_ENTER]=DIA_JOYSTICK_KEY_CODE_ENTER;
keyCodeCoreMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_JOYSTICK_MAP]=DIA_JOYSTICK_KEY_CODE_MAP;
keyCodeCoreMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_JOYSTICK_HOME]=DIA_JOYSTICK_KEY_CODE_HOME;
keyCodeCoreMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_JOYSTICK_BACK]=DIA_JOYSTICK_KEY_CODE_BACK;
keyCodeCoreMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_JOYSTICK_DAY_NIGHT]=DIA_JOYSTICK_KEY_CODE_DAY_NIGHT;
keyCodeCoreMap[input_fi_tcl_e16_KeyCode::FI_EN_INPUT_JOYSTICK_DISP]=DIA_JOYSTICK_KEY_CODE_DISP;
#endif
}
tDiaResult
dia_SAFeatureInputHandling::getPressedKeys ( void )
{
   dia_tclFnctTrace trc("dia_SAFeatureInputHandling::getPressedKeys");

   tDiaResult retVal = DIA_FAILED;

   if ( mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID )
   {
      gm_tclU16Message oMessage (
         mAppID,
         mpSrvPlugin->getClientID(),
         mpSrvPlugin->getRegistrationID(),
         0,
         mpSrvPlugin->getServiceID(),
         INPUT_MAINFI_C_U16_PRESSEDKEYS,
         CCA_C_U8_OPCODE_GET
      );

      if ( mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE )
     {
         retVal = DIA_SUCCESS;
      }
   }

   return retVal;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureInputHandling::getEncoderStatus ( void )
{
   dia_tclFnctTrace trc("dia_SAFeatureInputHandling::getEncoderStatus");

   tDiaResult retVal = DIA_FAILED;

   if ( mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID )
   {
      gm_tclU16Message oMessage (
         mAppID,
         mpSrvPlugin->getClientID(),
         mpSrvPlugin->getRegistrationID(),
         0,
         mpSrvPlugin->getServiceID(),
         INPUT_MAINFI_C_U16_ENCODERSTATUS,
         CCA_C_U8_OPCODE_GET
      );

      if ( mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE )
     {
         retVal = DIA_SUCCESS;
      }
   }

   return retVal;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureInputHandling::getEncoderDirStatus ( void )
{
   dia_tclFnctTrace trc("dia_SAFeatureInputHandling::getEncoderDirStatus");

   tDiaResult retVal = DIA_FAILED;

   if ( mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID )
   {
      gm_tclU16Message oMessage (
         mAppID,
         mpSrvPlugin->getClientID(),
         mpSrvPlugin->getRegistrationID(),
         0,
         mpSrvPlugin->getServiceID(),
         INPUT_MAINFI_C_U16_ENCODERDIRSTATUS,
         CCA_C_U8_OPCODE_GET
      );

      if ( mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE )
     {
         retVal = DIA_SUCCESS;
      }
   }

   return retVal;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureInputHandling::getTouchInfo ( void )
{
   dia_tclFnctTrace trc("dia_SAFeatureInputHandling::getTouchInfo");

   tDiaResult retVal = DIA_FAILED;

   if ( mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID )
   {
      gm_tclU16Message oMessage (
         mAppID,
         mpSrvPlugin->getClientID(),
         mpSrvPlugin->getRegistrationID(),
         0,
         mpSrvPlugin->getServiceID(),
         INPUT_MAINFI_C_U16_TOUCHSTATUS,
         CCA_C_U8_OPCODE_GET
      );

      if ( mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE )
     {
         retVal = DIA_SUCCESS;
      }
   }

   return retVal;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureInputHandling::setKeyDia ( const dia_eInputHandlingKeyCodePrj /*eKeyCode*/, const dia_eInputHandlingKeyInfoPrj /*eKeyInfo*/ )
{
   dia_tclFnctTrace trc("dia_SAFeatureInputHandling::setDiaKey for Prj interface");

#if 0
   midw_fi_tcl_KeyCode::tenType eInternalKeyCode = aInternalKeyCode[eKeyCode];

   return setKeyIntern (eInternalKeyCode, eKeyInfo);
#else
   return DIA_FAILED;
#endif
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureInputHandling::setKeyDia ( const dia_eInputHandlingKeyCode /*eKeyCode*/, const dia_eInputHandlingKeyInfo /*eKeyInfo*/ )
{
   dia_tclFnctTrace trc("dia_SAFeatureInputHandling::setDiaKey");

#if 0
   midw_fi_tcl_KeyCode::tenType eInternalKeyCode = aInternalKeyCode[eKeyCode];

   return setKeyIntern (eInternalKeyCode, eKeyInfo);
#else
   return DIA_FAILED;
#endif
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureInputHandling::setKeyIntern ( const tU16 /*u16KeyCode*/, const dia_eInputHandlingKeyInfoPrj /*eKeyInfo*/ )
{
   dia_tclFnctTrace trc("dia_SAFeatureInputHandling::setInternalKey for Prj interface");

   tDiaResult retVal = DIA_FAILED;

#if 0
   if ( mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID )
   {
      midw_kbdfi_tclMsgKeyEventMethodStart oData;
     oData.KeyCode.enType = (midw_fi_tcl_KeyCode::tenType) u16KeyCode;
      oData.Action.enType = (midw_fi_tcl_KeyAction::tenType) eKeyInfo;
      fi_tclVisitorMessage oMessage(oData);

      mpSrvPlugin->vInitServiceData(oMessage, MIDW_KBDFI_C_U16_KEYEVENT, CCA_C_U8_OPCODE_METHODSTART);

      if ( mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE )
      {
         retVal = DIA_SUCCESS;
      }
   }
#endif

   return retVal;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureInputHandling::setKeyIntern ( const tU16 /*u16KeyCode*/, const dia_eInputHandlingKeyInfo /*eKeyInfo*/ )
{
   dia_tclFnctTrace trc("dia_SAFeatureInputHandling::setInternalKey");

   tDiaResult retVal = DIA_FAILED;

#if 0
   if ( mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID )
   {
      midw_kbdfi_tclMsgKeyEventMethodStart oData;
     oData.KeyCode.enType = (midw_fi_tcl_KeyCode::tenType) u16KeyCode;
      oData.Action.enType = (midw_fi_tcl_KeyAction::tenType) eKeyInfo;
      fi_tclVisitorMessage oMessage(oData);

      mpSrvPlugin->vInitServiceData(oMessage, MIDW_KBDFI_C_U16_KEYEVENT, CCA_C_U8_OPCODE_METHODSTART);

      if ( mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE )
      {
         retVal = DIA_SUCCESS;
      }
   }
#endif

   return retVal;
}

/******************************************************************************
* FUNCTION:    setKeyInternalCode
*
* DESCRIPTION: send CCA MethodStart message to set key
*
* PARAMETER:   dia_eVdInuptHandlingKeyCodePrj - keycode to forward
            dia_eInputHandlingKeyInfoPrj  -  Key status
*
* RETURNVALUE: TRUE  - post message to DiagLog server no error
*              FALSE - post message to DiagLog server failed
*
******************************************************************************/
tDiaResult
dia_SAFeatureInputHandling::setKeyInternalCode ( const dia_eVdInuptHandlingKeyCodePrj KeyID, const dia_eInputHandlingKeyInfoPrj eKeyInfo )
{
   dia_tclFnctTrace trc("dia_SAFeatureInputHandling::setKeyInternalCode for Prj interface");
    tDiaResult retVal = DIA_FAILED;
   //    input_fi_tcl_e16_KeyCode::tenType u16InternalKeyCode = dia_InternalKeyCodeMapping[KeyID];

    input_fi_tcl_e16_KeyCode::tenType u16InternalKeyCode = getPrjInternalKeyCodeMapping(KeyID);
   if ( mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID )
   {
     input_mainfi_tclMsgsimulateKeyInjectionMethodStart oData;
     oData.e16Keycode.enType = u16InternalKeyCode;
     if(eKeyInfo == DIA_EN_PRJ_KEY_INFO_PRESSED)
     {
         oData.u8KeyStatus = (tU8)DIA_PRJ_KEY_TOUCH_PRESSED;
     }
     else
     {
        oData.u8KeyStatus = (tU8)DIA_PRJ_KEY_TOUCH_RELEASED;
     }
      fi_tclVisitorMessage oMessage(oData);
      mpSrvPlugin->vInitServiceData(oMessage, INPUT_MAINFI_C_U16_SIMULATEKEYINJECTION, CCA_C_U8_OPCODE_METHODSTART);
      if ( mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE )
      {
         retVal = DIA_SUCCESS;
      }
   }
   return retVal;
}
//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureInputHandling::setKeyInternalCode ( const dia_eVdInuptHandlingKeyCode KeyID, const dia_eInputHandlingKeyInfo eKeyInfo )
{
   dia_tclFnctTrace trc("dia_SAFeatureInputHandling::setKeyInternalCode");
    tDiaResult retVal = DIA_FAILED;
   //    input_fi_tcl_e16_KeyCode::tenType u16InternalKeyCode = dia_InternalKeyCodeMapping[KeyID];

    input_fi_tcl_e16_KeyCode::tenType u16InternalKeyCode = getInternalKeyCodeMapping(KeyID);
   if ( mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID )
   {
     input_mainfi_tclMsgsimulateKeyInjectionMethodStart oData;
     oData.e16Keycode.enType = u16InternalKeyCode;
     if(eKeyInfo == DIA_EN_KEY_INFO_PRESSED)
     {
         oData.u8KeyStatus = (tU8)DIA_EN_KEY_TOUCH_PRESSED;
     }
     else
     {
        oData.u8KeyStatus = (tU8)DIA_KEY_TOUCH_RELEASED;
     }
      fi_tclVisitorMessage oMessage(oData);
      mpSrvPlugin->vInitServiceData(oMessage, INPUT_MAINFI_C_U16_SIMULATEKEYINJECTION, CCA_C_U8_OPCODE_METHODSTART);
      if ( mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE )
      {
         retVal = DIA_SUCCESS;
      }
   }
   return retVal;
}
//-----------------------------------------------------------------------------


tDiaResult
dia_SAFeatureInputHandling::lockControlUnit ( const dia_eInputHandlingLockInfoControlPrj /*eLock*/ )
{
   dia_tclFnctTrace trc("dia_SAFeatureInputHandling::lockControlUnit for Prj interface");

   tDiaResult retVal = DIA_FAILED;

#if 0
   if ( mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID )
   {
      midw_kbdfi_tclMsgKeyLockMethodStart oData;
     oData.KeyLockOption.enType = aInternalLock[eLock];
      fi_tclVisitorMessage oMessage(oData);

      mpSrvPlugin->vInitServiceData(oMessage, MIDW_KBDFI_C_U16_KEYLOCK, CCA_C_U8_OPCODE_METHODSTART);

      if ( mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE )
      {
         retVal = DIA_SUCCESS;
      }
   }
#endif

   return retVal;
}

//-----------------------------------------------------------------------------
tDiaResult
dia_SAFeatureInputHandling::lockControlUnit ( const dia_eInputHandlingLockInfoControl /*eLock*/ )
{
   dia_tclFnctTrace trc("dia_SAFeatureInputHandling::lockControlUnit");

   tDiaResult retVal = DIA_FAILED;

#if 0
   if ( mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID )
   {
      midw_kbdfi_tclMsgKeyLockMethodStart oData;
     oData.KeyLockOption.enType = aInternalLock[eLock];
      fi_tclVisitorMessage oMessage(oData);

      mpSrvPlugin->vInitServiceData(oMessage, MIDW_KBDFI_C_U16_KEYLOCK, CCA_C_U8_OPCODE_METHODSTART);

      if ( mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE )
      {
         retVal = DIA_SUCCESS;
      }
   }
#endif

   return retVal;
}
//-----------------------------------------------------------------------------

/******************************************************************************
* FUNCTION:    setEncoder
*
* DESCRIPTION: send CCA MethodStart message to set encoder rotation direction
*
* PARAMETER:   dia_eInputHandlingEncoderPrj - encoder type (left or right) to forward
            s8ControlValue           - steps (min. value -128, max. value +127)
*
* RETURNVALUE: DIA_SUCCESS  - post message to vd_input
*              DIA_FAILED   - post message to vd_input failed
*
******************************************************************************/
tDiaResult
dia_SAFeatureInputHandling::setEncoder ( const dia_eInputHandlingEncoderPrj eEncoder, const tS8 s8ControlValue)
{
   dia_tclFnctTrace trc("dia_SAFeatureInputHandling::setEncoder for Prj interface");

   tDiaResult retVal = DIA_FAILED;
   if ( mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID )
   {
       if (eEncoder == DIA_EN_PRJ_ENCODER_UNKNOWN){
         DIA_TR_ERR("dia_SAFeatureInputHandling::setEncoder - supplied eEncoder is DIA_EN_PRJ_ENCODER_UNKNOWN");
         return DIA_FAILED;
      }

	  input_fi_tcl_e8_EncoderType::tenType u8InternalEncoderType = dia_InternalEncoderTypeMapping[eEncoder];

      input_mainfi_tclMsgsimulateEncRotationMethodStart oData;
      oData.e8EncoderType.enType = u8InternalEncoderType;
      oData.s8EncSteps = s8ControlValue;

      fi_tclVisitorMessage oMessage(oData);
      mpSrvPlugin->vInitServiceData(oMessage, INPUT_MAINFI_C_U16_SIMULATEENCROTATION, CCA_C_U8_OPCODE_METHODSTART);
      if ( mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE )
      {
         retVal = DIA_SUCCESS;
      }
   }

   return retVal;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureInputHandling::setEncoder ( const dia_eInputHandlingEncoder eEncoder, const tS8 s8ControlValue)
{
   dia_tclFnctTrace trc("dia_SAFeatureInputHandling::setEncoder");

   tDiaResult retVal = DIA_FAILED;
   if ( mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID )
   {
       if (eEncoder == DIA_EN_ENCODER_UNKNOWN){
         DIA_TR_ERR("dia_SAFeatureInputHandling::setEncoder - supplied eEncoder is DIA_EN_ENCODER_UNKNOWN");
         return DIA_FAILED;
      }

	  input_fi_tcl_e8_EncoderType::tenType u8InternalEncoderType = dia_InternalEncoderTypeMapping[eEncoder];

      input_mainfi_tclMsgsimulateEncRotationMethodStart oData;
      oData.e8EncoderType.enType = u8InternalEncoderType;
      oData.s8EncSteps = s8ControlValue;

      fi_tclVisitorMessage oMessage(oData);
      mpSrvPlugin->vInitServiceData(oMessage, INPUT_MAINFI_C_U16_SIMULATEENCROTATION, CCA_C_U8_OPCODE_METHODSTART);
      if ( mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE )
      {
         retVal = DIA_SUCCESS;
      }
   }

   return retVal;
}

//-----------------------------------------------------------------------------


tDiaResult
dia_SAFeatureInputHandling::startTouchPanelAlignment ( void )
{
// MethodStart: StartTouchScreenCalibration
   dia_tclFnctTrace trc("dia_SAFeatureInputHandling::startTouchPanelAlignment");

   tDiaResult retVal = DIA_FAILED;

#if 0
   if ( mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID )
   {
      gm_tclU16Message oMessage (
         mAppID,
         mpSrvPlugin->getClientID(),
         mpSrvPlugin->getRegistrationID(),
         0,
         mpSrvPlugin->getServiceID(),
         MIDW_KBDFI_C_U16_STARTTOUCHSCREENCALIBRATION,
         CCA_C_U8_OPCODE_METHODSTART
      );

      if ( mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE )
     {
         retVal = DIA_SUCCESS;
      }
   }
#endif

   return retVal;
}

//-----------------------------------------------------------------------------

/******************************************************************************
* FUNCTION:    setTouchIntern
*
* DESCRIPTION: send CCA MethodStart message to start touch simulation
*
* PARAMETER:   u16X: value of X coordinate
*             u16Y: value of Y coordinate
*             eTouchInfo: Enum of touch status touched / not touched
*
* RETURNVALUE: DIA_SUCCESS  - post message to vd_input
*              DIA_FAILED   - post message to vd_input failed
*
******************************************************************************/
tDiaResult
dia_SAFeatureInputHandling::setTouchIntern(const tU16 u16X, const tU16 u16Y, const dia_eInputHandlingTouchInfoPrj eTouchInfo)
{
   dia_tclFnctTrace trc("dia_SAFeatureInputHandling::setTouchIntern for Prj interface");

   if ( mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID )
   {
      input_mainfi_tclMsgsimulateSingleTouchMethodStart oData;
      if(eTouchInfo == DIA_EN_PRJ_TOUCH_INFO_TOUCHED)
      {
         oData.e8TouchStatus.enType =  input_fi_tcl_e8_TouchStatus::FI_EN_TOUCH_PRESSED;
      }
      else if (eTouchInfo == DIA_EN_PRJ_TOUCH_INFO_NOT_TOUCHED)
      {
         oData.e8TouchStatus.enType = input_fi_tcl_e8_TouchStatus::FI_EN_TOUCH_RELEASED;
      }
      else
      {
//         oData.e8TouchStatus.enType = input_fi_tcl_e8_TouchStatus::FI_EN_TOUCH_INVALID;
         return DIA_FAILED;
      }

      oData.s32XCoord = (tS32) u16X;
      oData.s32YCoord = (tS32) u16Y;

      fi_tclVisitorMessage oMessage(oData);
      mpSrvPlugin->vInitServiceData(oMessage, INPUT_MAINFI_C_U16_SIMULATESINGLETOUCH, CCA_C_U8_OPCODE_METHODSTART);
      if ( mpSrvPlugin->bTransmitMessage(&oMessage) != TRUE )
      {
         return DIA_FAILED;
      }
   }

   return DIA_SUCCESS;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureInputHandling::setTouchIntern(const tU16 u16X, const tU16 u16Y, const dia_eInputHandlingTouchInfo eTouchInfo)
{
   dia_tclFnctTrace trc("dia_SAFeatureInputHandling::setTouchIntern");

   if ( mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID )
   {
      input_mainfi_tclMsgsimulateSingleTouchMethodStart oData;
      if(eTouchInfo == DIA_EN_TOUCH_INFO_TOUCHED)
      {
         oData.e8TouchStatus.enType =  input_fi_tcl_e8_TouchStatus::FI_EN_TOUCH_PRESSED;
      }
      else if (eTouchInfo == DIA_EN_TOUCH_INFO_NOT_TOUCHED)
      {
         oData.e8TouchStatus.enType = input_fi_tcl_e8_TouchStatus::FI_EN_TOUCH_RELEASED;
      }
      else
      {
//         oData.e8TouchStatus.enType = input_fi_tcl_e8_TouchStatus::FI_EN_TOUCH_INVALID;
         return DIA_FAILED;
      }

      oData.s32XCoord = (tS32) u16X;
      oData.s32YCoord = (tS32) u16Y;

      fi_tclVisitorMessage oMessage(oData);
      mpSrvPlugin->vInitServiceData(oMessage, INPUT_MAINFI_C_U16_SIMULATESINGLETOUCH, CCA_C_U8_OPCODE_METHODSTART);
      if ( mpSrvPlugin->bTransmitMessage(&oMessage) != TRUE )
      {
         return DIA_FAILED;
      }
   }

   return DIA_SUCCESS;
}

//-----------------------------------------------------------------------------

/******************************************************************************
* FUNCTION:    setTouchSlideIntern
*
* DESCRIPTION: send CCA MethodStart message to start touch slide simulation
*
* PARAMETER:   u16XStart:   start value of X coordinate
*             u16YStart:   start value of Y coordinate
*             u16XEnd:     end value of X coordinate
*             u16YEnd:     end value of Y coordinate
*             u16Duration: duration of touch slide operation in milliseconds
*
* RETURNVALUE: DIA_SUCCESS  - post message to vd_input
*              DIA_FAILED   - post message to vd_input failed
*
******************************************************************************/
tDiaResult
dia_SAFeatureInputHandling::setTouchSlideIntern ( const tU16 u16XStart, const tU16 u16YStart, const tU16 u16XEnd, const tU16 u16YEnd, const tU16 u16Duration )
{
   dia_tclFnctTrace trc("dia_SAFeatureInputHandling::setTouchSlideIntern");

   if ( mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID )
   {
      if (u16Duration == 0)
      {
          DIA_TR_ERR("dia_SAFeatureInputHandling::setTouchSlideIntern - Wrong u16Duration = %d", u16Duration);
          return DIA_FAILED;
      }

      input_mainfi_tclMsgsimulateTouchSlideMethodStart oData;

      oData.s32XStart = (tS32) u16XStart;
      oData.s32YStart = (tS32) u16YStart;
      oData.s32XEnd = (tS32) u16XEnd;
      oData.s32YEnd = (tS32) u16YEnd;
      oData.u16Duration = u16Duration;

      fi_tclVisitorMessage oMessage(oData);
      mpSrvPlugin->vInitServiceData(oMessage, INPUT_MAINFI_C_U16_SIMULATETOUCHSLIDE, CCA_C_U8_OPCODE_METHODSTART);
      if ( mpSrvPlugin->bTransmitMessage(&oMessage) != TRUE )
      {
         return DIA_FAILED;
      }
   }

   return DIA_SUCCESS;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureInputHandling::enableInputEvents ( void  )
{
   dia_tclFnctTrace trc("dia_SAFeatureInputHandling::enableInputEvents");

   tDiaResult retVal = DIA_FAILED;

   if ( mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID )
   {
#if 0
      input_mainfi_tclMsgEnableInputEventsMethodStart oData;
      fi_tclVisitorMessage oMessage(oData);

      mpSrvPlugin->vInitServiceData(oMessage, INPUT_MAINFI_C_U16_ENABLEINPUTEVENTS, CCA_C_U8_OPCODE_METHODSTART);
#else
      gm_tclU16Message oMessage (
         mAppID,
         mpSrvPlugin->getClientID(),
         mpSrvPlugin->getRegistrationID(),
         0,
         mpSrvPlugin->getServiceID(),
         INPUT_MAINFI_C_U16_ENABLEINPUTEVENTS,
         CCA_C_U8_OPCODE_METHODSTART
      );
#endif

      if ( mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE )
      {
         retVal = DIA_SUCCESS;
      }
   }

   return retVal;
}

//-----------------------------------------------------------------------------
/******************************************************************************
* FUNCTION:    recordGesture
*
* DESCRIPTION: send CCA MethodStart message to start recording the gestures
*
* PARAMETER:   eStartStop:    start / stop recording
*             filePath:     path to the gesture file that will be created
*
* RETURNVALUE: DIA_SUCCESS  - post message to vd_input
*              DIA_FAILED   - post message to vd_input failed
*
******************************************************************************/
tDiaResult dia_SAFeatureInputHandling::recordGesture (const dia_eInputHandlingGestureRecordPrj eStartStop, const std::string& filePath)
{
   dia_tclFnctTrace trc("dia_SAFeatureInputHandling::recordGesture for Prj interface");

   if ( mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID )
   {
      input_mainfi_tclMsgGestureRecordMethodStart oData;
      input_fi_tclString filePathStr(filePath.c_str());
      oData.FilePath = filePathStr;
      switch (eStartStop)
      {
         case DIA_EN_PRJ_GESTURE_RECORD_START:
            DIA_TR_INF("dia_SAFeatureInputHandling::recordGesture - DIA_EN_PRJ_GESTURE_RECORD_START");
            oData.u8StartStop = 1;
            break;

         case DIA_EN_PRJ_GESTURE_RECORD_STOP:
            DIA_TR_INF("dia_SAFeatureInputHandling::recordGesture - DIA_EN_PRJ_GESTURE_RECORD_STOP");
            oData.u8StartStop = 0;
            break;

         default: // DIA_EN_PRJ_GESTURE_RECORD_UNKNOWN
            DIA_TR_ERR("dia_SAFeatureInputHandling::recordGesture - Wrong eStartStop = %d", eStartStop);
            return DIA_FAILED;
      }

      fi_tclVisitorMessage oMessage(oData);
      mpSrvPlugin->vInitServiceData(oMessage, INPUT_MAINFI_C_U16_GESTURERECORD, CCA_C_U8_OPCODE_METHODSTART);
      if ( mpSrvPlugin->bTransmitMessage(&oMessage) != TRUE )
      {
         return DIA_FAILED;
      }
   }

   return DIA_SUCCESS;
}

//-----------------------------------------------------------------------------

tDiaResult dia_SAFeatureInputHandling::recordGesture (const dia_eInputHandlingGestureRecord eStartStop, const std::string& filePath)
{
   dia_tclFnctTrace trc("dia_SAFeatureInputHandling::recordGesture");

   if ( mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID )
   {
      input_mainfi_tclMsgGestureRecordMethodStart oData;
      input_fi_tclString filePathStr(filePath.c_str());
      oData.FilePath = filePathStr;
      switch (eStartStop)
      {
         case DIA_EN_PRJ_GESTURE_RECORD_START:
            DIA_TR_INF("dia_SAFeatureInputHandling::recordGesture - DIA_EN_GESTURE_RECORD_START");
            oData.u8StartStop = 1;
            break;

         case DIA_EN_PRJ_GESTURE_RECORD_STOP:
            DIA_TR_INF("dia_SAFeatureInputHandling::recordGesture - DIA_EN_GESTURE_RECORD_STOP");
            oData.u8StartStop = 0;
            break;

         default: // DIA_EN_GESTURE_RECORD_UNKNOWN
            DIA_TR_ERR("dia_SAFeatureInputHandling::recordGesture - Wrong eStartStop = %d", eStartStop);
            return DIA_FAILED;
      }

      fi_tclVisitorMessage oMessage(oData);
      mpSrvPlugin->vInitServiceData(oMessage, INPUT_MAINFI_C_U16_GESTURERECORD, CCA_C_U8_OPCODE_METHODSTART);
      if ( mpSrvPlugin->bTransmitMessage(&oMessage) != TRUE )
      {
         return DIA_FAILED;
      }
   }

   return DIA_SUCCESS;
}

//-----------------------------------------------------------------------------
/******************************************************************************
* FUNCTION:    replayGesture
*
* DESCRIPTION: send CCA MethodStart message to replay the gestures saved in file
*
* PARAMETER:   eStartStop:    start / stop replaying
*             filePath:     path to the gesture file that contains previously saved gestures
*
* RETURNVALUE: DIA_SUCCESS  - post message to vd_input
*              DIA_FAILED   - post message to vd_input failed
*
******************************************************************************/
tDiaResult dia_SAFeatureInputHandling::replayGesture (const dia_eInputHandlingGestureReplayPrj eStartStop, const std::string& filePath)
{
   dia_tclFnctTrace trc("dia_SAFeatureInputHandling::replayGesture for Prj interface");

   if ( mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID )
   {
      input_mainfi_tclMsgGestureReplayMethodStart oData;
      input_fi_tclString filePathStr(filePath.c_str());
      oData.FilePath = filePathStr;
      switch (eStartStop)
      {
         case DIA_EN_PRJ_GESTURE_REPLAY_START:
            DIA_TR_INF("dia_SAFeatureInputHandling::replayGesture - DIA_EN_PRJ_GESTURE_REPLAY_START");
            oData.u8StartStop = 1;
            break;

         case DIA_EN_PRJ_GESTURE_REPLAY_STOP:
            DIA_TR_INF("dia_SAFeatureInputHandling::replayGesture - DIA_EN_PRJ_GESTURE_REPLAY_STOP");
            oData.u8StartStop = 0;
            break;

         default: // DIA_EN_PRJ_GESTURE_REPLAY_UNKNOWN
            DIA_TR_ERR("dia_SAFeatureInputHandling::replayGesture - Wrong eStartStop = %d", eStartStop);
            return DIA_FAILED;
      }

      fi_tclVisitorMessage oMessage(oData);
      mpSrvPlugin->vInitServiceData(oMessage, INPUT_MAINFI_C_U16_GESTUREREPLAY, CCA_C_U8_OPCODE_METHODSTART);
      if ( mpSrvPlugin->bTransmitMessage(&oMessage) != TRUE )
      {
         return DIA_FAILED;
      }
   }

   return DIA_SUCCESS;
}

//-----------------------------------------------------------------------------

tDiaResult dia_SAFeatureInputHandling::replayGesture (const dia_eInputHandlingGestureReplay eStartStop, const std::string& filePath)
{
   dia_tclFnctTrace trc("dia_SAFeatureInputHandling::replayGesture");

   if ( mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID )
   {
      input_mainfi_tclMsgGestureReplayMethodStart oData;
      input_fi_tclString filePathStr(filePath.c_str());
      oData.FilePath = filePathStr;
      switch (eStartStop)
      {
         case DIA_EN_PRJ_GESTURE_REPLAY_START:
            DIA_TR_INF("dia_SAFeatureInputHandling::replayGesture - DIA_EN_GESTURE_REPLAY_START");
            oData.u8StartStop = 1;
            break;

         case DIA_EN_PRJ_GESTURE_REPLAY_STOP:
            DIA_TR_INF("dia_SAFeatureInputHandling::replayGesture - DIA_EN_GESTURE_REPLAY_STOP");
            oData.u8StartStop = 0;
            break;

         default: // DIA_EN_GESTURE_REPLAY_UNKNOWN
            DIA_TR_ERR("dia_SAFeatureInputHandling::replayGesture - Wrong eStartStop = %d", eStartStop);
            return DIA_FAILED;
      }

      fi_tclVisitorMessage oMessage(oData);
      mpSrvPlugin->vInitServiceData(oMessage, INPUT_MAINFI_C_U16_GESTUREREPLAY, CCA_C_U8_OPCODE_METHODSTART);
      if ( mpSrvPlugin->bTransmitMessage(&oMessage) != TRUE )
      {
         return DIA_FAILED;
      }
   }

   return DIA_SUCCESS;
}

//-----------------------------------------------------------------------------
void
dia_SAFeatureInputHandling::vHandleGetPressedKey ( amt_tclServiceData* poMessage ) const
{
   dia_tclFnctTrace trc("dia_SAFeatureInputHandling::vHandleGetPressedKey");

   if ( poMessage )
   {
      DIA_ASSERT(poMessage->bIsServerMessage() == TRUE);

     dia_IInputHandlingPrjListener* pPrjListener = OSAL_NULL;
     dia_IInputHandlingListener* pListener = OSAL_NULL;

     if ( (querySysAdapterListener<dia_IInputHandlingPrjListener>(&pPrjListener) == DIA_SUCCESS) && pPrjListener )
     {
         switch ( poMessage->u8GetOpCode() )
         {
           case AMT_C_U8_CCAMSG_OPCODE_STATUS:
          {

               fi_tclVisitorMessage oResultMsg(poMessage);
               input_mainfi_tclMsgPressedKeysStatus oCompResp;
               (void) oResultMsg.s32GetData(oCompResp);

               tU32 u32ListSize = oCompResp.KeyInfoList.tKeyInfoList.size();

               DIA_TR_INF("dia_SAFeatureInputHandling::vHandleGetPressedKey - u32ListSize = %d", u32ListSize);

               std::vector<tU8> diaKeys;
               dia_eVdInuptHandlingKeyCodePrj diaKeyCode;
               dia_eVdInuptHandlingKeyCodePrj diaSWCKeyCode;
               std::vector<dia_tPressedKeyPrj> diaKeyInfos;

               for(tU32 i = 0; i < u32ListSize; i++)
               {
                  DIA_TR_INF("dia_SAFeatureInputHandling::vHandleGetPressedKey - Code=0x%x, Status=0x%x",
                        oCompResp.KeyInfoList.tKeyInfoList[i].e16KeyCode.enType,
                        oCompResp.KeyInfoList.tKeyInfoList[i].u8KeyStatus);

                  if ((diaKeyCode = getDiaPrjKeyCode(oCompResp.KeyInfoList.tKeyInfoList[i].e16KeyCode.enType)) != DIA_PRJ_KEY_CODE_UNKNOWN)
                  {
                     if (oCompResp.KeyInfoList.tKeyInfoList[i].u8KeyStatus == 1/*Key Press*/)
                     {
                        diaKeys.push_back ((tU8) diaKeyCode);
                     }

                     dia_tPressedKeyPrj keyInfo(diaKeyCode, oCompResp.KeyInfoList.tKeyInfoList[i].u8KeyStatus);
                     diaKeyInfos.push_back(keyInfo);
                  }
                  else if ((diaSWCKeyCode = getDiaPrjSWCKeyCode(oCompResp.KeyInfoList.tKeyInfoList[i].e16KeyCode.enType)) != DIA_PRJ_KEY_CODE_UNKNOWN)
                  {
                     if (oCompResp.KeyInfoList.tKeyInfoList[i].u8KeyStatus == 1/*Key Press*/)
                     {
                        diaKeys.push_back ((tU8) diaSWCKeyCode);
                     }

                     dia_tPressedKeyPrj keyInfo(diaSWCKeyCode, oCompResp.KeyInfoList.tKeyInfoList[i].u8KeyStatus);
                     diaKeyInfos.push_back(keyInfo);
                  }
               }

               pPrjListener->vOnGetPressedKey(diaKeys);
               pPrjListener->vOnGetPressedKey(diaKeyInfos);

       }
         break;

      case AMT_C_U8_CCAMSG_OPCODE_ERROR:
         {
            amt_tclServiceDataError oErrorMsg( poMessage );
            DIA_TR_ERR("dia_SAFeatureInputHandling::vHandleGetPressedKey - opcode error received with error code:%u", ((tU16) oErrorMsg.u16GetErrorData()));
            pPrjListener->vOnGetPressedKeyError();
         }
         break;

      default:
            DIA_TR_ERR("dia_SAFeatureInputHandling::vHandleGetPressedKey - UNKNOWN OPCODE!");
            pPrjListener->vOnGetPressedKeyError();
         break;
      }
     }

    if ( (querySysAdapterListener<dia_IInputHandlingListener>(&pListener) == DIA_SUCCESS) && pListener )
	{
	  switch ( poMessage->u8GetOpCode() )
	  {
		case AMT_C_U8_CCAMSG_OPCODE_STATUS:
	   {

			fi_tclVisitorMessage oResultMsg(poMessage);
			input_mainfi_tclMsgPressedKeysStatus oCompResp;
			(void) oResultMsg.s32GetData(oCompResp);

			tU32 u32ListSize = oCompResp.KeyInfoList.tKeyInfoList.size();

			DIA_TR_INF("dia_SAFeatureInputHandling::vHandleGetPressedKey - u32ListSize = %d", u32ListSize);

			std::vector<tU8> diaKeys;
			dia_eVdInuptHandlingKeyCode diaKeyCode;
			dia_eVdInuptHandlingKeyCode diaSWCKeyCode;
			std::vector<dia_tPressedKey> diaKeyInfos;

			for(tU32 i = 0; i < u32ListSize; i++)
			{
			   DIA_TR_INF("dia_SAFeatureInputHandling::vHandleGetPressedKey - Code=0x%x, Status=0x%x",
					 oCompResp.KeyInfoList.tKeyInfoList[i].e16KeyCode.enType,
					 oCompResp.KeyInfoList.tKeyInfoList[i].u8KeyStatus);

			   if ((diaKeyCode = getDiaKeyCode(oCompResp.KeyInfoList.tKeyInfoList[i].e16KeyCode.enType)) != DIA_KEY_CODE_UNKNOWN)
			   {
				  if (oCompResp.KeyInfoList.tKeyInfoList[i].u8KeyStatus == 1/*Key Press*/)
				  {
					 diaKeys.push_back ((tU8) diaKeyCode);
				  }

				  dia_tPressedKey keyInfo(diaKeyCode, oCompResp.KeyInfoList.tKeyInfoList[i].u8KeyStatus);
				  diaKeyInfos.push_back(keyInfo);
			   }
			   else if ((diaSWCKeyCode = getDiaSWCKeyCode(oCompResp.KeyInfoList.tKeyInfoList[i].e16KeyCode.enType)) != DIA_KEY_CODE_UNKNOWN)
			   {
				  if (oCompResp.KeyInfoList.tKeyInfoList[i].u8KeyStatus == 1/*Key Press*/)
				  {
					 diaKeys.push_back ((tU8) diaSWCKeyCode);
				  }

				  dia_tPressedKey keyInfo(diaSWCKeyCode, oCompResp.KeyInfoList.tKeyInfoList[i].u8KeyStatus);
				  diaKeyInfos.push_back(keyInfo);
			   }
			}

			pListener->vOnGetPressedKey(diaKeys);
			pListener->vOnGetPressedKey(diaKeyInfos);
	   }
	  break;

	case AMT_C_U8_CCAMSG_OPCODE_ERROR:
	  {
		 amt_tclServiceDataError oErrorMsg( poMessage );
		 DIA_TR_ERR("dia_SAFeatureInputHandling::vHandleGetPressedKey - opcode error received with error code:%u", ((tU16) oErrorMsg.u16GetErrorData()));
		 pListener->vOnGetPressedKeyError();
	  }
	  break;

	default:
		 DIA_TR_ERR("dia_SAFeatureInputHandling::vHandleGetPressedKey - UNKNOWN OPCODE!");
		 pListener->vOnGetPressedKeyError();
		 break;
	  }
	}

      (void) poMessage->bDelete();
   }
}

//-----------------------------------------------------------------------------

void
dia_SAFeatureInputHandling::vHandleTouchScreenStatus ( amt_tclServiceData* poMessage ) const
{
   dia_tclFnctTrace trc("dia_SAFeatureInputHandling::vHandleTouchScreenStatus");

   if ( poMessage )
   {
        DIA_TR_INF("dia_SAFeatureInputHandling::vHandleTouchScreenStatus - poMessage OK");
      DIA_ASSERT(poMessage->bIsServerMessage() == TRUE);

     dia_IInputHandlingPrjListener* pPrjListener = OSAL_NULL;
     dia_IInputHandlingListener* pListener = OSAL_NULL;

     if ((querySysAdapterListener<dia_IInputHandlingPrjListener>(&pPrjListener) == DIA_SUCCESS) && pPrjListener )
     {
      std::vector<dia_tTouchPressHistoryInfoPrj> diaTouchPressInfo;
      dia_tTouchPressHistoryInfoPrj diaTouchPressInfoElem;
      switch (poMessage->u8GetOpCode())
      {
      case AMT_C_U8_CCAMSG_OPCODE_STATUS:
      {

         fi_tclVisitorMessage oResultMsg(poMessage);
         input_mainfi_tclMsgTouchStatusStatus oCompResp;
         (void)oResultMsg.s32GetData(oCompResp);

         dia_eInputHandlingTouchInfoPrj eTouchInfo = DIA_EN_PRJ_TOUCH_INFO_NOT_TOUCHED;
         tU16 u16X = 0;
         tU16 u16Y = 0;
         tU16 u16DeltaX = 0;
         tU16 u16DeltaY = 0;
         tU32 lastIndex = oCompResp.tTouchDataList.sTouchInfo.size();

         DIA_TR_INF("dia_SAFeatureInputHandling::vHandleTouchScreenStatus - List size=%d",
            oCompResp.tTouchDataList.sTouchInfo.size());

         for (tU32 i = 0; i < oCompResp.tTouchDataList.sTouchInfo.size(); i++)
         {
            DIA_TR_INF("dia_SAFeatureInputHandling::vHandleTouchScreenStatus - Entry[%d] (%d,%d) = %d", i,
               oCompResp.tTouchDataList.sTouchInfo[i].s32XCoord,
               oCompResp.tTouchDataList.sTouchInfo[i].s32YCoord,
               oCompResp.tTouchDataList.sTouchInfo[i].e8TouchStatus.enType);
               diaTouchPressInfoElem.mXCoord = oCompResp.tTouchDataList.sTouchInfo[i].s32XCoord;
               diaTouchPressInfoElem.mYCoord = oCompResp.tTouchDataList.sTouchInfo[i].s32YCoord;
               diaTouchPressInfoElem.mType = getDiaPrjTouchInfo(oCompResp.tTouchDataList.sTouchInfo[i].e8TouchStatus.enType);
               diaTouchPressInfoElem.mXDelta=u16DeltaX;
               diaTouchPressInfoElem.mYDelta=u16DeltaY;
               diaTouchPressInfo.push_back(diaTouchPressInfoElem);

            if (oCompResp.tTouchDataList.sTouchInfo[i].e8TouchStatus.enType ==
               input_fi_tcl_e8_TouchStatus::FI_EN_TOUCH_PRESSED)
            {
               lastIndex = i;
            }
         }
         if (lastIndex < oCompResp.tTouchDataList.sTouchInfo.size())
         {
            diaTouchPressInfoElem.mXCoord = oCompResp.tTouchDataList.sTouchInfo[lastIndex].s32XCoord;
            diaTouchPressInfoElem.mYCoord = oCompResp.tTouchDataList.sTouchInfo[lastIndex].s32YCoord;
            diaTouchPressInfoElem.mType = getDiaPrjTouchInfo(oCompResp.tTouchDataList.sTouchInfo[lastIndex].e8TouchStatus.enType);
            diaTouchPressInfo.push_back(diaTouchPressInfoElem);
            DIA_TR_INF("dia_SAFeatureInputHandling::vHandleTouchScreenStatus - x-cor-> %x, y-cor -> %x, type -> %d, ", diaTouchPressInfoElem.mXCoord, diaTouchPressInfoElem.mYCoord, diaTouchPressInfoElem.mType);
            if ((1 < oCompResp.tTouchDataList.sTouchInfo.size()) && ((lastIndex )>= 1))
            {
               diaTouchPressInfoElem.mXCoord = oCompResp.tTouchDataList.sTouchInfo[lastIndex - 1].s32XCoord;
               diaTouchPressInfoElem.mYCoord = oCompResp.tTouchDataList.sTouchInfo[lastIndex - 1].s32YCoord;
               diaTouchPressInfoElem.mType = getDiaPrjTouchInfo(oCompResp.tTouchDataList.sTouchInfo[lastIndex - 1].e8TouchStatus.enType);
               diaTouchPressInfo.push_back(diaTouchPressInfoElem);
               DIA_TR_INF("dia_SAFeatureInputHandling::vHandleTouchScreenStatus - x-cor-> %x, y-cor -> %x, type -> %d, ", diaTouchPressInfoElem.mXCoord, diaTouchPressInfoElem.mYCoord, diaTouchPressInfoElem.mType);
            }

            u16X = (tU16)oCompResp.tTouchDataList.sTouchInfo[lastIndex].s32XCoord;
            u16Y = (tU16)oCompResp.tTouchDataList.sTouchInfo[lastIndex].s32YCoord;
            eTouchInfo = getDiaPrjTouchInfo(oCompResp.tTouchDataList.sTouchInfo[lastIndex].e8TouchStatus.enType);
         }
         else
         {
            if (0 < oCompResp.tTouchDataList.sTouchInfo.size())
            {
               u16X = (tU16)oCompResp.tTouchDataList.sTouchInfo[lastIndex-1].s32XCoord;
               u16Y = (tU16)oCompResp.tTouchDataList.sTouchInfo[lastIndex-1].s32YCoord;

            }

         }

         DIA_TR_INF("dia_SAFeatureInputHandling::vHandleTouchScreenStatus - x-cor-> %x, y-cor -> %x, x-delta -> %x,y-delta ->%x, ", u16X, u16Y, u16DeltaX, u16DeltaY);
         DIA_TR_INF("dia_SAFeatureInputHandling::vHandleTouchScreenStatus touch_status -> %x", eTouchInfo);
         pPrjListener->vOnTouchInfo(u16X, u16Y, u16DeltaX, u16DeltaY, eTouchInfo);
         //sending back the operation History to Monitoring and Calibration Module
         pPrjListener->vOnTouchInfohistory(diaTouchPressInfo);
      }
      break;

      case AMT_C_U8_CCAMSG_OPCODE_ERROR:
      {
         amt_tclServiceDataError oErrorMsg(poMessage);
         DIA_TR_INF("dia_SAFeatureInputHandling::vHandleTouchScreenStatus - opcode error received with error code %d.", ((tU16)oErrorMsg.u16GetErrorData()));
         pPrjListener->vOnTouchInfoError();
      }
      break;

      default:
         DIA_TR_ERR("dia_SAFeatureInputHandling::vHandleTouchScreenStatus - UNKNOWN OPCODE!");
         pPrjListener->vOnTouchInfoError();
         break;
      }
     }

     if ((querySysAdapterListener<dia_IInputHandlingListener>(&pListener) == DIA_SUCCESS) && pListener )
     {
      std::vector<dia_tTouchPressHistoryInfo> diaTouchPressInfo;
      dia_tTouchPressHistoryInfo diaTouchPressInfoElem;
      switch (poMessage->u8GetOpCode())
      {
      case AMT_C_U8_CCAMSG_OPCODE_STATUS:
      {

         fi_tclVisitorMessage oResultMsg(poMessage);
         input_mainfi_tclMsgTouchStatusStatus oCompResp;
         (void)oResultMsg.s32GetData(oCompResp);

         dia_eInputHandlingTouchInfo eTouchInfo = DIA_EN_TOUCH_INFO_NOT_TOUCHED;
         tU16 u16X = 0;
         tU16 u16Y = 0;
         tU16 u16DeltaX = 0;
         tU16 u16DeltaY = 0;
         tU32 lastIndex = oCompResp.tTouchDataList.sTouchInfo.size();

         DIA_TR_INF("dia_SAFeatureInputHandling::vHandleTouchScreenStatus - List size=%d",
            oCompResp.tTouchDataList.sTouchInfo.size());

         for (tU32 i = 0; i < oCompResp.tTouchDataList.sTouchInfo.size(); i++)
         {
            DIA_TR_INF("dia_SAFeatureInputHandling::vHandleTouchScreenStatus - Entry[%d] (%d,%d) = %d", i,
               oCompResp.tTouchDataList.sTouchInfo[i].s32XCoord,
               oCompResp.tTouchDataList.sTouchInfo[i].s32YCoord,
               oCompResp.tTouchDataList.sTouchInfo[i].e8TouchStatus.enType);
               diaTouchPressInfoElem.mXCoord = oCompResp.tTouchDataList.sTouchInfo[i].s32XCoord;
               diaTouchPressInfoElem.mYCoord = oCompResp.tTouchDataList.sTouchInfo[i].s32YCoord;
               diaTouchPressInfoElem.mType = getDiaTouchInfo(oCompResp.tTouchDataList.sTouchInfo[i].e8TouchStatus.enType);
               diaTouchPressInfo.push_back(diaTouchPressInfoElem);

            if (oCompResp.tTouchDataList.sTouchInfo[i].e8TouchStatus.enType ==
               input_fi_tcl_e8_TouchStatus::FI_EN_TOUCH_PRESSED)
            {
               lastIndex = i;
            }
         }
         if (lastIndex < oCompResp.tTouchDataList.sTouchInfo.size())
         {
            diaTouchPressInfoElem.mXCoord = oCompResp.tTouchDataList.sTouchInfo[lastIndex].s32XCoord;
            diaTouchPressInfoElem.mYCoord = oCompResp.tTouchDataList.sTouchInfo[lastIndex].s32YCoord;
            diaTouchPressInfoElem.mType = getDiaTouchInfo(oCompResp.tTouchDataList.sTouchInfo[lastIndex].e8TouchStatus.enType);
            diaTouchPressInfo.push_back(diaTouchPressInfoElem);
            DIA_TR_INF("dia_SAFeatureInputHandling::vHandleTouchScreenStatus - x-cor-> %x, y-cor -> %x, type -> %d, ", diaTouchPressInfoElem.mXCoord, diaTouchPressInfoElem.mYCoord, diaTouchPressInfoElem.mType);
            if (1 < oCompResp.tTouchDataList.sTouchInfo.size())
            {
               diaTouchPressInfoElem.mXCoord = oCompResp.tTouchDataList.sTouchInfo[lastIndex - 1].s32XCoord;
               diaTouchPressInfoElem.mYCoord = oCompResp.tTouchDataList.sTouchInfo[lastIndex - 1].s32YCoord;
               diaTouchPressInfoElem.mType = getDiaTouchInfo(oCompResp.tTouchDataList.sTouchInfo[lastIndex - 1].e8TouchStatus.enType);
               diaTouchPressInfo.push_back(diaTouchPressInfoElem);
               DIA_TR_INF("dia_SAFeatureInputHandling::vHandleTouchScreenStatus - x-cor-> %x, y-cor -> %x, type -> %d, ", diaTouchPressInfoElem.mXCoord, diaTouchPressInfoElem.mYCoord, diaTouchPressInfoElem.mType);
            }

            u16X = (tU16)oCompResp.tTouchDataList.sTouchInfo[lastIndex].s32XCoord;
            u16Y = (tU16)oCompResp.tTouchDataList.sTouchInfo[lastIndex].s32YCoord;
            eTouchInfo = getDiaTouchInfo(oCompResp.tTouchDataList.sTouchInfo[lastIndex].e8TouchStatus.enType);
         }
         else
         {
            if (0 < oCompResp.tTouchDataList.sTouchInfo.size())
            {
               u16X = (tU16)oCompResp.tTouchDataList.sTouchInfo[lastIndex-1].s32XCoord;
               u16Y = (tU16)oCompResp.tTouchDataList.sTouchInfo[lastIndex-1].s32YCoord;

            }

         }

         DIA_TR_INF("dia_SAFeatureInputHandling::vHandleTouchScreenStatus - x-cor-> %x, y-cor -> %x, x-delta -> %x,y-delta ->%x, ", u16X, u16Y, u16DeltaX, u16DeltaY);
         DIA_TR_INF("dia_SAFeatureInputHandling::vHandleTouchScreenStatus touch_status -> %x", eTouchInfo);
         pListener->vOnTouchInfo(u16X, u16Y, u16DeltaX, u16DeltaY, eTouchInfo);
         //sending back the operation History to Monitoring and Calibration Module
         pListener->vOnTouchInfohistory(diaTouchPressInfo);
      }
      break;

      case AMT_C_U8_CCAMSG_OPCODE_ERROR:
      {
         amt_tclServiceDataError oErrorMsg(poMessage);
         DIA_TR_INF("dia_SAFeatureInputHandling::vHandleTouchScreenStatus - opcode error received with error code %d.", ((tU16)oErrorMsg.u16GetErrorData()));
         pListener->vOnTouchInfoError();
      }
      break;

      default:
         DIA_TR_ERR("dia_SAFeatureInputHandling::vHandleTouchScreenStatus - UNKNOWN OPCODE!");
         pListener->vOnTouchInfoError();
         break;
      }
     }
      (void) poMessage->bDelete();
   }
}

//-----------------------------------------------------------------------------

void
dia_SAFeatureInputHandling::vHandleEncoderStatus ( amt_tclServiceData* poMessage ) const
{
   dia_tclFnctTrace trc("dia_SAFeatureInputHandling::vHandleEncoderStatus");

   if ( poMessage )
   {
        DIA_TR_INF("dia_SAFeatureInputHandling::vHandleEncoderStatus - poMessage OK");
      DIA_ASSERT(poMessage->bIsServerMessage() == TRUE);

      switch ( poMessage->u8GetOpCode() )
      {
      case AMT_C_U8_CCAMSG_OPCODE_STATUS:
         {
            dia_IInputHandlingPrjListener* pPrjListener = OSAL_NULL;
            dia_IInputHandlingListener* pListener = OSAL_NULL;

            if ((querySysAdapterListener<dia_IInputHandlingPrjListener>(&pPrjListener) == DIA_SUCCESS) && pPrjListener )
            {
               fi_tclVisitorMessage oResultMsg(poMessage);
               input_mainfi_tclMsgEncoderStatusStatus oCompResp;
               (void) oResultMsg.s32GetData(oCompResp);

               std::vector<tU8> statusList;
               tS8 s8Left = oCompResp.tEncoderStatus.s8EncVal_1;
               tS8 s8Right = oCompResp.tEncoderStatus.s8EncVal_2;
			   tS8 s8MSMEncoder = oCompResp.tEncoderStatus.s8EncVal_3;
               tS8 s8JoysticEncoder = oCompResp.tEncoderStatus.s8EncVal_4;
			   tS8 s8Swrc = oCompResp.tEncoderStatus.s8EncVal_5;

               DIA_TR_INF("dia_SAFeatureInputHandling::vHandleEncoderStatus - left=%d right=%d", s8Left, s8Right);

               statusList.push_back((tU8) s8Left);
               statusList.push_back((tU8) s8Right);
			   statusList.push_back((tU8) s8MSMEncoder);
			   statusList.push_back((tU8) s8JoysticEncoder);
			   statusList.push_back((tU8) s8Swrc);

			   pPrjListener->vOnEncoderStatus ( statusList );
            }

            if ((querySysAdapterListener<dia_IInputHandlingListener>(&pListener) == DIA_SUCCESS) && pListener )
			{
			   fi_tclVisitorMessage oResultMsg(poMessage);
			   input_mainfi_tclMsgEncoderStatusStatus oCompResp;
			   (void) oResultMsg.s32GetData(oCompResp);

			   std::vector<tU8> statusList;
			   tS8 s8Left = oCompResp.tEncoderStatus.s8EncVal_1;
			   tS8 s8Right = oCompResp.tEncoderStatus.s8EncVal_2;
			   tS8 s8MSMEncoder = oCompResp.tEncoderStatus.s8EncVal_3;
			   tS8 s8JoysticEncoder = oCompResp.tEncoderStatus.s8EncVal_4;
			   tS8 s8Swrc = oCompResp.tEncoderStatus.s8EncVal_5;

			   DIA_TR_INF("dia_SAFeatureInputHandling::vHandleEncoderStatus - left=%d right=%d", s8Left, s8Right);

			   statusList.push_back((tU8) s8Left);
			   statusList.push_back((tU8) s8Right);
			   statusList.push_back((tU8) s8MSMEncoder);
			   statusList.push_back((tU8) s8JoysticEncoder);
			   statusList.push_back((tU8) s8Swrc);

			   pListener->vOnEncoderStatus ( statusList );
			}
       }
         break;

      case AMT_C_U8_CCAMSG_OPCODE_ERROR:
         {
            amt_tclServiceDataError oErrorMsg( poMessage );
            DIA_TR_INF( "dia_SAFeatureInputHandling::vHandleEncoderStatus - opcode error received with error code %d.", ((tU16) oErrorMsg.u16GetErrorData()));
         }
         break;

      default:
            DIA_TR_ERR("dia_SAFeatureInputHandling::vHandleEncoderStatus - UNKNOWN OPCODE!");
         break;
      }

      (void) poMessage->bDelete();
   }
}

//-----------------------------------------------------------------------------

void
dia_SAFeatureInputHandling::vHandleEncoderDirStatus ( amt_tclServiceData* poMessage ) const
{
   dia_tclFnctTrace trc("dia_SAFeatureInputHandling::vHandleEncoderDirStatus");

   if ( poMessage )
   {
        DIA_TR_INF("dia_SAFeatureInputHandling::vHandleEncoderDirStatus - poMessage OK");
      DIA_ASSERT(poMessage->bIsServerMessage() == TRUE);

      switch ( poMessage->u8GetOpCode() )
      {
      case AMT_C_U8_CCAMSG_OPCODE_STATUS:
         {
            dia_IInputHandlingPrjListener* pPrjListener = OSAL_NULL;
            dia_IInputHandlingListener* pListener = OSAL_NULL;

            if ((querySysAdapterListener<dia_IInputHandlingPrjListener>(&pPrjListener) == DIA_SUCCESS) && pPrjListener )
            {
               fi_tclVisitorMessage oResultMsg(poMessage);
               input_mainfi_tclMsgEncoderDirStatusStatus oCompResp;
               (void) oResultMsg.s32GetData(oCompResp);

               std::vector<tS8> statusList;
               statusList.resize(10, 0);
               dia_tEncoderDirHistoryInfoPrj encoderDirHistoryElems;
               std::vector<dia_tEncoderDirHistoryInfoPrj> encoderDirHistoryList;
               DIA_TR_INF("dia_SAFeatureInputHandling::vHandleEncoderDirStatus - Original encoder List2 size = %d", oCompResp.tEncoderDirectionList.tEncInfoList.size());
               for (tU32 i = 0; i < oCompResp.tEncoderDirectionList.tEncInfoList.size(); i++)
               {
                  tU8 u8EncType = oCompResp.tEncoderDirectionList.tEncInfoList[i].e8EncoderType.enType;
                  tS8 s8EncSteps = oCompResp.tEncoderDirectionList.tEncInfoList[i].s8EncSteps;
                  encoderDirHistoryElems.mType = u8EncType;
                  encoderDirHistoryElems.mSteps = s8EncSteps;
                  DIA_TR_INF("dia_SAFeatureInputHandling::vHandleEncoderDirStatusXXXX - Type=%d Steps=%d", encoderDirHistoryElems.mType, encoderDirHistoryElems.mSteps);
                  encoderDirHistoryList.push_back(encoderDirHistoryElems);
                  DIA_TR_INF("dia_SAFeatureInputHandling::vHandleEncoderDirStatus - Type=%d Steps=%d", u8EncType, s8EncSteps);

                  statusList[u8EncType] = s8EncSteps;
               }

               pPrjListener->vOnEncoderDirStatus ( statusList );
               pPrjListener->vOnEncoderDirHistory(encoderDirHistoryList);
            }

            //not used by any core SH
#if 0
            if ((querySysAdapterListener<dia_IInputHandlingListener>(&pListener) == DIA_SUCCESS) && pListener )
            {
               fi_tclVisitorMessage oResultMsg(poMessage);
               input_mainfi_tclMsgEncoderDirStatusStatus oCompResp;
               (void) oResultMsg.s32GetData(oCompResp);

               std::vector<tS8> statusList;
               statusList.resize(10, 0);
               dia_tEncoderDirHistoryInfo encoderDirHistoryElems;
               std::vector<dia_tEncoderDirHistoryInfo> encoderDirHistoryList;
               DIA_TR_INF("dia_SAFeatureInputHandling::vHandleEncoderDirStatus - Original encoder List2 size = %d", oCompResp.tEncoderDirectionList.tEncInfoList.size());
               for (tU32 i = 0; i < oCompResp.tEncoderDirectionList.tEncInfoList.size(); i++)
               {
                  tU8 u8EncType = oCompResp.tEncoderDirectionList.tEncInfoList[i].e8EncoderType.enType;
                  tS8 s8EncSteps = oCompResp.tEncoderDirectionList.tEncInfoList[i].s8EncSteps;
                  encoderDirHistoryElems.mType = u8EncType;
                  encoderDirHistoryElems.mSteps = s8EncSteps;
                  DIA_TR_INF("dia_SAFeatureInputHandling::vHandleEncoderDirStatusXXXX - Type=%d Steps=%d", encoderDirHistoryElems.mType, encoderDirHistoryElems.mSteps);
                  encoderDirHistoryList.push_back(encoderDirHistoryElems);
                  DIA_TR_INF("dia_SAFeatureInputHandling::vHandleEncoderDirStatus - Type=%d Steps=%d", u8EncType, s8EncSteps);

                  statusList[u8EncType] = s8EncSteps;
               }

               pListener->vOnEncoderDirStatus ( statusList );
               pListener->vOnEncoderDirHistory(encoderDirHistoryList);
            }
#endif
       }
         break;

      case AMT_C_U8_CCAMSG_OPCODE_ERROR:
         {
            amt_tclServiceDataError oErrorMsg( poMessage );
            DIA_TR_INF( "dia_SAFeatureInputHandling::vHandleEncoderDirStatus - opcode error received with error code %d.", ((tU16) oErrorMsg.u16GetErrorData()));
         }
         break;

      default:
            DIA_TR_ERR("dia_SAFeatureInputHandling::vHandleEncoderDirStatus - UNKNOWN OPCODE!");
         break;
      }

      (void) poMessage->bDelete();
   }
}

//-----------------------------------------------------------------------------


void
dia_SAFeatureInputHandling::vHandleSetKey ( amt_tclServiceData* poMessage ) const
{
	dia_tclFnctTrace trc("dia_SAFeatureInputHandling::vHandleSetKey");

	if ( poMessage )
	{
		DIA_ASSERT(poMessage->bIsServerMessage() == TRUE);
		dia_IInputHandlingPrjListener* pPrjListener = OSAL_NULL;
		dia_IInputHandlingListener* pListener = OSAL_NULL;

		tDiaResult status = DIA_FAILED;

		//CID - 86568 Fix
		if ((querySysAdapterListener<dia_IInputHandlingPrjListener>(&pPrjListener) == DIA_SUCCESS) && pPrjListener)
		{
			switch ( poMessage->u8GetOpCode() )
			{
			case AMT_C_U8_CCAMSG_OPCODE_METHODRESULT:
			{
				status = DIA_SUCCESS;
			}
			break;

			case AMT_C_U8_CCAMSG_OPCODE_ERROR:
			{
				amt_tclServiceDataError oErrorMsg( poMessage );
				DIA_TR_ERR("dia_SAFeatureInputHandling::vHandleSetKey - opcode error received with error code:%u", ((tU16) oErrorMsg.u16GetErrorData()));
			}
			break;

			default:
				DIA_TR_ERR("dia_SAFeatureInputHandling::vHandleSetKey - UNKNOWN OPCODE!");
				break;
			}
			pPrjListener->vOnSetKey(DIA_SUCCESS);
		}
		else
		{
			DIA_TR_WRN("dia_SAFeatureInputHandling::vHandleSetKey. querySysAdapterListener dia_IInputHandlingPrjListener NULL");
		}


		if ((querySysAdapterListener<dia_IInputHandlingListener>(&pListener) == DIA_SUCCESS) && pListener)
		{
			switch ( poMessage->u8GetOpCode() )
			{
			case AMT_C_U8_CCAMSG_OPCODE_METHODRESULT:
			{
				status = DIA_SUCCESS;
			}
			break;

			case AMT_C_U8_CCAMSG_OPCODE_ERROR:
			{
				amt_tclServiceDataError oErrorMsg( poMessage );
				DIA_TR_ERR("dia_SAFeatureInputHandling::vHandleSetKey - opcode error received with error code:%u", ((tU16) oErrorMsg.u16GetErrorData()));
			}
			break;

			default:
				DIA_TR_ERR("dia_SAFeatureInputHandling::vHandleSetKey - UNKNOWN OPCODE!");
				break;
			}
			pListener->vOnSetKey(DIA_SUCCESS);
		}
		else
		{
			DIA_TR_WRN("dia_SAFeatureInputHandling::vHandleSetKey. querySysAdapterListener dia_IInputHandlingListener NULL");
		}

		(void) poMessage->bDelete();
	}

}

//-----------------------------------------------------------------------------

#if 0
void
dia_SAFeatureInputHandling::vHandleLockControlUnit ( amt_tclServiceData* poMessage ) const
{
   dia_tclFnctTrace trc("dia_SAFeatureInputHandling::vHandleLockControlUnit");

   if ( poMessage )
   {
      DIA_ASSERT(poMessage->bIsServerMessage() == TRUE);
      dia_IInputHandlingPrjListener* pPrjListener = OSAL_NULL;
      dia_IInputHandlingListener* pListener = OSAL_NULL;

      switch ( poMessage->u8GetOpCode() )
      {
      case AMT_C_U8_CCAMSG_OPCODE_METHODRESULT:
         {
        	 if ((querySysAdapterListener<dia_IInputHandlingPrjListener>(&pPrjListener) == DIA_SUCCESS) && pPrjListener)
             {
            	pPrjListener->vOnLockControlUnit(DIA_SUCCESS);
             }
        	 else if ((querySysAdapterListener<dia_IInputHandlingListener>(&pListener) == DIA_SUCCESS) && pListener)
             {
            	pListener->vOnLockControlUnit(DIA_SUCCESS);
             }
         }
         break;

      case AMT_C_U8_CCAMSG_OPCODE_ERROR:
         {
            amt_tclServiceDataError oErrorMsg( poMessage );
            DIA_TR_ERR("dia_SAFeatureInputHandling::vHandleLockControlUnit - opcode error received with error code:%u", ((tU16) oErrorMsg.u16GetErrorData()));
         }
         break;

      default:
            DIA_TR_ERR("dia_SAFeatureInputHandling::vHandleLockControlUnit - UNKNOWN OPCODE!");
         break;
      }

      (void) poMessage->bDelete();
   }
}
#endif

//-----------------------------------------------------------------------------

#if 0
void
dia_SAFeatureInputHandling::vHandleTouchPanelAlignment ( amt_tclServiceData* poMessage ) const
{
   dia_tclFnctTrace trc("dia_SAFeatureInputHandling::vHandleTouchPanelAlignment");

   tDiaResult eResult = DIA_FAILED;

   if ( poMessage )
   {
      DIA_ASSERT(poMessage->bIsServerMessage() == TRUE);

      switch ( poMessage->u8GetOpCode() )
      {
      case AMT_C_U8_CCAMSG_OPCODE_METHODRESULT:
         {
            dia_IInputHandlingPrjListener* pPrjListener = OSAL_NULL;
            dia_IInputHandlingListener* pListener = OSAL_NULL;

            if ((querySysAdapterListener<dia_IInputHandlingPrjListener>(&pPrjListener) == DIA_SUCCESS) && pPrjListener)
            {
               fi_tclVisitorMessage oResultMsg(poMessage);
               midw_kbdfi_tclMsgStartTouchScreenCalibrationMethodResult oCompResp;
               (void) oResultMsg.s32GetData(oCompResp);

               if ( oCompResp.Result.enType == midw_fi_tcl_Result::FI_EN_PASSED)
				{
					pPrjListener->vOnTouchPanelAlignmentDone(DIA_SUCCESS);
				}
				else
				{
					pPrjListener->vOnTouchPanelAlignmentDone(DIA_FAILED);
				}
            }
            if ((querySysAdapterListener<dia_IInputHandlingListener>(&pListener) == DIA_SUCCESS) && pListener)
            {
               fi_tclVisitorMessage oResultMsg(poMessage);
               midw_kbdfi_tclMsgStartTouchScreenCalibrationMethodResult oCompResp;
               (void) oResultMsg.s32GetData(oCompResp);

               if ( oCompResp.Result.enType == midw_fi_tcl_Result::FI_EN_PASSED)
				{
					pListener->vOnTouchPanelAlignmentDone(DIA_SUCCESS);
				}
				else
				{
					pListener->vOnTouchPanelAlignmentDone(DIA_FAILED);
				}
            }

         }
         break;

      case AMT_C_U8_CCAMSG_OPCODE_ERROR:
         {
            amt_tclServiceDataError oErrorMsg( poMessage );
            DIA_TR_ERR("dia_SAFeatureInputHandling::vHandleTouchPanelAlignment - opcode error received with error code:%u", ((tU16) oErrorMsg.u16GetErrorData()));
         }
         break;

      default:
            DIA_TR_ERR("dia_SAFeatureInputHandling::vHandleTouchPanelAlignment - UNKNOWN OPCODE!");
         break;
      }

      (void) poMessage->bDelete();
   }
}
#endif

//-----------------------------------------------------------------------------

void
dia_SAFeatureInputHandling::vHandleEnableInputEvents ( amt_tclServiceData* poMessage ) const
{
   dia_tclFnctTrace trc("dia_SAFeatureInputHandling::vHandleEnableInputEvents");

   if ( poMessage )
   {
      DIA_ASSERT(poMessage->bIsServerMessage() == TRUE);

      switch ( poMessage->u8GetOpCode() )
      {
      case AMT_C_U8_CCAMSG_OPCODE_METHODRESULT:
         {
            dia_IInputHandlingPrjListener* pPrjListener = OSAL_NULL;
            dia_IInputHandlingListener* pListener = OSAL_NULL;

            if ((querySysAdapterListener<dia_IInputHandlingPrjListener>(&pPrjListener) == DIA_SUCCESS) && pPrjListener )
            {
               fi_tclVisitorMessage oResultMsg(poMessage);
               input_mainfi_tclMsgEnableInputEventsMethodResult oCompResp;
               (void) oResultMsg.s32GetData(oCompResp);

               pPrjListener->vOnEnableInputEvents(oCompResp.SimulationStatus);
            }

            if ((querySysAdapterListener<dia_IInputHandlingListener>(&pListener) == DIA_SUCCESS) && pListener )
			{
			   fi_tclVisitorMessage oResultMsg(poMessage);
			   input_mainfi_tclMsgEnableInputEventsMethodResult oCompResp;
			   (void) oResultMsg.s32GetData(oCompResp);

			   pListener->vOnEnableInputEvents(oCompResp.SimulationStatus);
			}
         }
         break;

      case AMT_C_U8_CCAMSG_OPCODE_ERROR:
         {
            amt_tclServiceDataError oErrorMsg( poMessage );
            DIA_TR_ERR("dia_SAFeatureInputHandling::vHandleEnableInputEvents - opcode error received with error code:%u", ((tU16) oErrorMsg.u16GetErrorData()));
         }
         break;

      default:
            DIA_TR_ERR("dia_SAFeatureInputHandling::vHandleEnableInputEvents - UNKNOWN OPCODE!");
         break;
      }

      (void) poMessage->bDelete();
   }
}


//-----------------------------------------------------------------------------

void
dia_SAFeatureInputHandling::vHandleSetTouch ( amt_tclServiceData* poMessage ) const
{
   dia_tclFnctTrace trc("dia_SAFeatureInputHandling::vHandleSetTouch");

   if ( poMessage )
   {
	   DIA_ASSERT(poMessage->bIsServerMessage() == TRUE);
	   dia_IInputHandlingPrjListener* pPrjListener = OSAL_NULL;
	   dia_IInputHandlingListener* pListener = OSAL_NULL;

	   tDiaResult status = DIA_FAILED;

	   //CID - 86567 Fix
	   if ((querySysAdapterListener<dia_IInputHandlingPrjListener>(&pPrjListener) == DIA_SUCCESS) && pPrjListener)
	   {
		   switch ( poMessage->u8GetOpCode() )
		   {
		   case AMT_C_U8_CCAMSG_OPCODE_METHODRESULT:
		   {
			   status = DIA_SUCCESS;
		   }
		   break;

		   case AMT_C_U8_CCAMSG_OPCODE_ERROR:
		   {
			   amt_tclServiceDataError oErrorMsg( poMessage );
			   DIA_TR_ERR("dia_SAFeatureInputHandling::vHandleSetTouch - opcode error received with error code:%u", ((tU16) oErrorMsg.u16GetErrorData()));
		   }
		   break;

		   default:
			   DIA_TR_ERR("dia_SAFeatureInputHandling::vHandleSetTouch - UNKNOWN OPCODE!");
			   break;
		   }
		   pPrjListener->vOnSetTouch(status);
	   }
	   else
	   {
		   DIA_TR_WRN("dia_SAFeatureInputHandling::vHandleSetTouch. querySysAdapterListener dia_IInputHandlingPrjListener NULL");
	   }

	   //not used in core SH
#if 0
	   if ((querySysAdapterListener<dia_IInputHandlingListener>(&pListener) == DIA_SUCCESS) && pListener)
	   {
		   switch ( poMessage->u8GetOpCode() )
		   {
		   case AMT_C_U8_CCAMSG_OPCODE_METHODRESULT:
		   {
			   status = DIA_SUCCESS;
		   }
		   break;

		   case AMT_C_U8_CCAMSG_OPCODE_ERROR:
		   {
			   amt_tclServiceDataError oErrorMsg( poMessage );
			   DIA_TR_ERR("dia_SAFeatureInputHandling::vHandleSetTouch - opcode error received with error code:%u", ((tU16) oErrorMsg.u16GetErrorData()));
		   }
		   break;

		   default:
			   DIA_TR_ERR("dia_SAFeatureInputHandling::vHandleSetTouch - UNKNOWN OPCODE!");
			   break;
		   }
		   pListener->vOnSetTouch(status);
	   }
	   else
	   {
		   DIA_TR_WRN("dia_SAFeatureInputHandling::vHandleSetTouch. querySysAdapterListener dia_IInputHandlingListener NULL");
	   }
	   (void) poMessage->bDelete();
#endif
   }
}

//-----------------------------------------------------------------------------

void dia_SAFeatureInputHandling::vHandleSetTouchSlide ( amt_tclServiceData* poMessage ) const
{
   dia_tclFnctTrace trc("dia_SAFeatureInputHandling::vHandleSetTouchSlide");

   if ( poMessage )
   {
     DIA_ASSERT(poMessage->bIsServerMessage() == TRUE);
     dia_IInputHandlingPrjListener* pPrjListener = OSAL_NULL;
     dia_IInputHandlingListener* pListener = OSAL_NULL;

     tDiaResult status = DIA_FAILED;

     //CID - 86566 Fix
     if ((querySysAdapterListener<dia_IInputHandlingPrjListener>(&pPrjListener) == DIA_SUCCESS) && pPrjListener)
     {
    	 switch ( poMessage->u8GetOpCode() )
    	 {
    	 case AMT_C_U8_CCAMSG_OPCODE_METHODRESULT:
    	 {
    		 status = DIA_SUCCESS;
    	 }
    	 break;

    	 case AMT_C_U8_CCAMSG_OPCODE_ERROR:
    	 {
    		 amt_tclServiceDataError oErrorMsg( poMessage );
    		 DIA_TR_ERR("dia_SAFeatureInputHandling::vHandleSetTouchSlide - opcode error received with error code:%u", ((tU16) oErrorMsg.u16GetErrorData()));
    	 }
    	 break;

    	 default:
    		 DIA_TR_ERR("dia_SAFeatureInputHandling::vHandleSetTouchSlide - UNKNOWN OPCODE!");
    		 break;
    	 }
    	 pPrjListener->vOnSetTouchSlide(status);
     }
     else
     {
    	 DIA_TR_WRN("dia_SAFeatureInputHandling::vHandleSetTouchSlide. querySysAdapterListener dia_IInputHandlingPrjListener NULL");
     }

	   //not used in core SH
#if 0
     if ((querySysAdapterListener<dia_IInputHandlingListener>(&pListener) == DIA_SUCCESS) && pListener)
     {
    	 switch ( poMessage->u8GetOpCode() )
    	 {
    	 case AMT_C_U8_CCAMSG_OPCODE_METHODRESULT:
    	 {
    		 status = DIA_SUCCESS;
    	 }
    	 break;

    	 case AMT_C_U8_CCAMSG_OPCODE_ERROR:
    	 {
    		 amt_tclServiceDataError oErrorMsg( poMessage );
    		 DIA_TR_ERR("dia_SAFeatureInputHandling::vHandleSetTouchSlide - opcode error received with error code:%u", ((tU16) oErrorMsg.u16GetErrorData()));
    	 }
    	 break;

    	 default:
    		 DIA_TR_ERR("dia_SAFeatureInputHandling::vHandleSetTouchSlide - UNKNOWN OPCODE!");
    		 break;
    	 }
    	 pListener->vOnSetTouchSlide(status);
     }
     else
     {
    	 DIA_TR_WRN("dia_SAFeatureInputHandling::vHandleSetTouchSlide. querySysAdapterListener dia_IInputHandlingListener NULL");
     }
#endif
     (void) poMessage->bDelete();
   }
}

void dia_SAFeatureInputHandling::vHandleRecordGesture ( amt_tclServiceData* poMessage ) const
{
   dia_tclFnctTrace trc("dia_SAFeatureInputHandling::vHandleRecordGesture");

   if ( poMessage )
   {
     DIA_ASSERT(poMessage->bIsServerMessage() == TRUE);

     dia_IInputHandlingPrjListener* pPrjListener = OSAL_NULL;
     dia_IInputHandlingListener* pListener = OSAL_NULL;

     tDiaResult status = DIA_FAILED;

     if ((querySysAdapterListener<dia_IInputHandlingPrjListener>(&pPrjListener) == DIA_SUCCESS) && pPrjListener)
     {
    	 switch ( poMessage->u8GetOpCode() )
    	 {
    	 case AMT_C_U8_CCAMSG_OPCODE_METHODRESULT:
    	 {
    		 status = DIA_SUCCESS;
    	 }
    	 break;

    	 case AMT_C_U8_CCAMSG_OPCODE_ERROR:
    	 {
    		 amt_tclServiceDataError oErrorMsg( poMessage );
    		 DIA_TR_ERR("dia_SAFeatureInputHandling::vHandleRecordGesture - opcode error received with error code:%u", ((tU16) oErrorMsg.u16GetErrorData()));
    	 }
    	 break;

    	 default:
    		 DIA_TR_ERR("dia_SAFeatureInputHandling::vHandleRecordGesture - UNKNOWN OPCODE!");
    		 break;
    	 }
    	 pPrjListener->vOnRecordGesture(status);
     }
     else
     {
    	 DIA_TR_WRN("dia_SAFeatureInputHandling::vHandleRecordGesture. querySysAdapterListener dia_IInputHandlingPrjListener NULL");
     }

	   //not used in core SH
#if 0
     if ((querySysAdapterListener<dia_IInputHandlingListener>(&pListener) == DIA_SUCCESS) && pListener)
	{
		switch ( poMessage->u8GetOpCode() )
		{
			case AMT_C_U8_CCAMSG_OPCODE_METHODRESULT:
			{
			 status = DIA_SUCCESS;
			}
			break;

			case AMT_C_U8_CCAMSG_OPCODE_ERROR:
			{
			 amt_tclServiceDataError oErrorMsg( poMessage );
			 DIA_TR_ERR("dia_SAFeatureInputHandling::vHandleRecordGesture - opcode error received with error code:%u", ((tU16) oErrorMsg.u16GetErrorData()));
			}
			break;

			default:
			 DIA_TR_ERR("dia_SAFeatureInputHandling::vHandleRecordGesture - UNKNOWN OPCODE!");
			 break;
		}
		pListener->vOnRecordGesture(status);
	}
	else
	{
		DIA_TR_WRN("dia_SAFeatureInputHandling::vHandleRecordGesture. querySysAdapterListener dia_IInputHandlingListener NULL");
	}
#endif
     (void) poMessage->bDelete();
   }
}

void dia_SAFeatureInputHandling::vHandleReplayGesture ( amt_tclServiceData* poMessage ) const
{
   dia_tclFnctTrace trc("dia_SAFeatureInputHandling::vHandleReplayGesture");

   if ( poMessage )
   {
     DIA_ASSERT(poMessage->bIsServerMessage() == TRUE);

     dia_IInputHandlingPrjListener* pPrjListener = OSAL_NULL;
     dia_IInputHandlingListener* pListener = OSAL_NULL;

     tDiaResult status = DIA_FAILED;

     if ((querySysAdapterListener<dia_IInputHandlingPrjListener>(&pPrjListener) == DIA_SUCCESS) && pPrjListener)
     {
    	 switch ( poMessage->u8GetOpCode() )
    	 {
    	 case AMT_C_U8_CCAMSG_OPCODE_METHODRESULT:
    	 {
    		 status = DIA_SUCCESS;
    	 }
    	 break;

    	 case AMT_C_U8_CCAMSG_OPCODE_ERROR:
    	 {
    		 amt_tclServiceDataError oErrorMsg( poMessage );
    		 DIA_TR_ERR("dia_SAFeatureInputHandling::vHandleReplayGesture - opcode error received with error code:%u", ((tU16) oErrorMsg.u16GetErrorData()));
    	 }
    	 break;

    	 default:
    		 DIA_TR_ERR("dia_SAFeatureInputHandling::vHandleReplayGesture - UNKNOWN OPCODE!");
    		 break;
    	 }
    	 pPrjListener->vOnReplayGesture(status);
     }
     else
     {
    	 DIA_TR_WRN("dia_SAFeatureInputHandling::vHandleReplayGesture. querySysAdapterListener dia_IInputHandlingPrjListener NULL");
     }
	   //not used in core SH
#if 0
     if ((querySysAdapterListener<dia_IInputHandlingListener>(&pListener) == DIA_SUCCESS) && pListener)
	  {
		 switch ( poMessage->u8GetOpCode() )
		 {
		 case AMT_C_U8_CCAMSG_OPCODE_METHODRESULT:
		 {
			 status = DIA_SUCCESS;
		 }
		 break;

		 case AMT_C_U8_CCAMSG_OPCODE_ERROR:
		 {
			 amt_tclServiceDataError oErrorMsg( poMessage );
			 DIA_TR_ERR("dia_SAFeatureInputHandling::vHandleReplayGesture - opcode error received with error code:%u", ((tU16) oErrorMsg.u16GetErrorData()));
		 }
		 break;

		 default:
			 DIA_TR_ERR("dia_SAFeatureInputHandling::vHandleReplayGesture - UNKNOWN OPCODE!");
			 break;
		 }
		 pListener->vOnReplayGesture(status);
	  }
	  else
	  {
		 DIA_TR_WRN("dia_SAFeatureInputHandling::vHandleReplayGesture. querySysAdapterListener dia_IInputHandlingListener NULL");
	  }

#endif
     (void) poMessage->bDelete();
   }
}

//-----------------------------------------------------------------------------

dia_eInputHandlingTouchInfoPrj
dia_SAFeatureInputHandling::getDiaPrjTouchInfo ( input_fi_tcl_e8_TouchStatus::tenType eTouchStatus ) const
{
   dia_eInputHandlingTouchInfoPrj eTouchInfo = DIA_EN_PRJ_TOUCH_INFO_UNKNOWN;

   switch (eTouchStatus)
   {
   case input_fi_tcl_e8_TouchStatus::FI_EN_TOUCH_PRESSED:
     eTouchInfo = DIA_EN_PRJ_TOUCH_INFO_TOUCHED;
      break;

   case input_fi_tcl_e8_TouchStatus::FI_EN_TOUCH_RELEASED:
     eTouchInfo = DIA_EN_PRJ_TOUCH_INFO_NOT_TOUCHED;
     break;

   default:
      break;
   }

   return eTouchInfo;
}

//-----------------------------------------------------------------------------

dia_eInputHandlingTouchInfo
dia_SAFeatureInputHandling::getDiaTouchInfo ( input_fi_tcl_e8_TouchStatus::tenType eTouchStatus ) const
{
   dia_eInputHandlingTouchInfo eTouchInfo = DIA_EN_TOUCH_INFO_UNKNOWN;

   switch (eTouchStatus)
   {
   case input_fi_tcl_e8_TouchStatus::FI_EN_TOUCH_PRESSED:
     eTouchInfo = DIA_EN_TOUCH_INFO_TOUCHED;
      break;

   case input_fi_tcl_e8_TouchStatus::FI_EN_TOUCH_RELEASED:
     eTouchInfo = DIA_EN_TOUCH_INFO_NOT_TOUCHED;
     break;

   default:
      break;
   }

   return eTouchInfo;
}

#if 0

//-----------------------------------------------------------------------------

dia_eInputHandlingKeyInfoPrj
dia_SAFeatureInputHandling::getDiaKeyInfo ( midw_fi_tcl_KeyAction::tenType eKeyAct ) const
{
   dia_eInputHandlingKeyInfoPrj eKeyInfo = DIA_EN_PRJ_KEY_INFO_UNKNOWN;

   switch (eKeyAct)
   {
   case midw_fi_tcl_KeyAction::FI_EN_KEY_ACTION_PRESSED:
     eKeyInfo = DIA_EN_PRJ_KEY_INFO_PRESSED;
      break;

   case midw_fi_tcl_KeyAction::FI_EN_KEY_ACTION_RELEASED:
     eKeyInfo = DIA_EN_PRJ_KEY_INFO_RELEASED;
     break;

   default:
      break;
   }

   return eKeyInfo;
}

#endif

//-----------------------------------------------------------------------------

dia_eVdInuptHandlingKeyCodePrj
dia_SAFeatureInputHandling::getDiaPrjKeyCode ( input_fi_tcl_e16_KeyCode::tenType eKeyCode ) const
{
   dia_eVdInuptHandlingKeyCodePrj eDiaKeyCode = DIA_PRJ_KEY_CODE_UNKNOWN;
   std::map<input_fi_tcl_e16_KeyCode::tenType,dia_eVdInuptHandlingKeyCodePrj>::iterator keyCodeMapIterator;

   keyCodeMapIterator = keyCodeMap.find(eKeyCode);
   if(keyCodeMapIterator==keyCodeMap.end())
   {
	   DIA_TR_ERR("dia_SAFeatureInputHandling::getDiaPrjKeyCode -> Key Code Not found");
   }
   else
   {
	   eDiaKeyCode = keyCodeMapIterator->second;
	   DIA_TR_INF("dia_SAFeatureInputHandling::getDiaPrjKeyCode--> Diag specific KeyCode Found");
   }

   DIA_TR_INF("dia_SAFeatureInputHandling::getDiaPrjKeyCode eDiaKeyCode=%d", eDiaKeyCode);
   return eDiaKeyCode;
}


//-----------------------------------------------------------------------------

dia_eVdInuptHandlingKeyCode
dia_SAFeatureInputHandling::getDiaKeyCode ( input_fi_tcl_e16_KeyCode::tenType eKeyCode ) const
{
   dia_eVdInuptHandlingKeyCode eDiaKeyCode = DIA_KEY_CODE_UNKNOWN;

   std::map<input_fi_tcl_e16_KeyCode::tenType,dia_eVdInuptHandlingKeyCode>::iterator keyCodeCoreMapIterator;
   keyCodeCoreMapIterator = keyCodeCoreMap.find(eKeyCode);

      if(keyCodeCoreMapIterator==keyCodeCoreMap.end())
      {
      DIA_TR_ERR("dia_SAFeatureInputHandling::getDiaKeyCode --> Key Code Not found");
      }
      else
      {
   	   eDiaKeyCode = keyCodeCoreMapIterator->second;
   	   DIA_TR_INF("dia_SAFeatureInputHandling::getDiaKeyCode --> Diag specific KeyCode Found");
      }

   DIA_TR_INF("dia_SAFeatureInputHandling::getDiaKeyCode eDiaKeyCode=%d", eDiaKeyCode);
   return eDiaKeyCode;
}

//-----------------------------------------------------------------------------

dia_eVdInuptHandlingKeyCodePrj
dia_SAFeatureInputHandling::getDiaPrjSWCKeyCode ( input_fi_tcl_e16_KeyCode::tenType eKeyCode ) const
{
   dia_eVdInuptHandlingKeyCodePrj eDiaKeyCode = DIA_PRJ_KEY_CODE_UNKNOWN;

   std::map<input_fi_tcl_e16_KeyCode::tenType,dia_eVdInuptHandlingKeyCodePrj>::iterator keyCodeMapIterator;
   keyCodeMapIterator = keyCodeMap.find(eKeyCode);

      if(keyCodeMapIterator==keyCodeMap.end())
      {
    	  DIA_TR_ERR("dia_SAFeatureInputHandling::getDiaPrjSWCKeyCode --> Key Code Not found");
      }
      else
      {
   	   eDiaKeyCode = keyCodeMapIterator->second;
   	   DIA_TR_INF("dia_SAFeatureInputHandling::getDiaPrjSWCKeyCode --> Diag specific KeyCode Found");
      }

   DIA_TR_INF("dia_SAFeatureInputHandling::getDiaPrjSWCKeyCode eDiaKeyCode=%d", eDiaKeyCode);
   return eDiaKeyCode;
}

//-----------------------------------------------------------------------------

dia_eVdInuptHandlingKeyCode
dia_SAFeatureInputHandling::getDiaSWCKeyCode ( input_fi_tcl_e16_KeyCode::tenType eKeyCode ) const
{
   dia_eVdInuptHandlingKeyCode eDiaKeyCode = DIA_KEY_CODE_UNKNOWN;
   std::map<input_fi_tcl_e16_KeyCode::tenType,dia_eVdInuptHandlingKeyCode>::iterator keyCodeCoreMapIterator;

   keyCodeCoreMapIterator = keyCodeCoreMap.find(eKeyCode);
         if(keyCodeCoreMapIterator==keyCodeCoreMap.end())
         {
        	 DIA_TR_ERR("dia_SAFeatureInputHandling::getDiaSWCKeyCode --> Key Code Not found");
         }
         else
         {
      	   eDiaKeyCode = keyCodeCoreMapIterator->second;
      	   DIA_TR_INF("dia_SAFeatureInputHandling::getDiaSWCKeyCode --> Diag specific KeyCode Found");
         }

   DIA_TR_INF("dia_SAFeatureInputHandling::getDiaSWCKeyCode eDiaKeyCode=%d", eDiaKeyCode);
   return eDiaKeyCode;
}

//-----------------------------------------------------------------------------

input_fi_tcl_e16_KeyCode::tenType
dia_SAFeatureInputHandling::getPrjInternalKeyCodeMapping(dia_eVdInuptHandlingKeyCodePrj KeyID) const
{
	input_fi_tcl_e16_KeyCode::tenType eIntKeyCode = (input_fi_tcl_e16_KeyCode::tenType) UNKNOWN_INTERNAL_KEY_CODE;;

	for(auto iterate : keyCodeMap)
	   {
		   if(iterate.second==KeyID)
		   {
			   eIntKeyCode = iterate.first;
			   DIA_TR_INF("dia_SAFeatureInputHandling::getPrjInternalKeyCodeMapping -->  FI KeyCode Found");
			   break;
		   }
	   }
	DIA_TR_INF("dia_SAFeatureInputHandling::getPrjInternalKeyCodeMapping eIntKeyCode=%d", eIntKeyCode);
	return eIntKeyCode;
}

//-----------------------------------------------------------------------------

input_fi_tcl_e16_KeyCode::tenType
dia_SAFeatureInputHandling::getInternalKeyCodeMapping(dia_eVdInuptHandlingKeyCode KeyID) const
{
	input_fi_tcl_e16_KeyCode::tenType eIntKeyCode = (input_fi_tcl_e16_KeyCode::tenType) UNKNOWN_INTERNAL_KEY_CODE;;

	for(auto iterate : keyCodeCoreMap)
		   {
			   if(iterate.second==KeyID)
			   {
				   eIntKeyCode = iterate.first;
				   DIA_TR_INF("dia_SAFeatureInputHandling::getInternalKeyCodeMapping-->  FI KeyCode Found");
				   break;
			   }
		   }

	DIA_TR_INF("dia_SAFeatureInputHandling::getInternalKeyCodeMapping eIntKeyCode=%d", eIntKeyCode);
	return eIntKeyCode;
}

//-----------------------------------------------------------------------------

void
dia_SAFeatureInputHandling::vHandleSetEncoder ( amt_tclServiceData* poMessage ) const
{
   dia_tclFnctTrace trc("dia_SAFeatureInputHandling::vHandleSetEncoder");

   if ( poMessage )
   {
      DIA_ASSERT(poMessage->bIsServerMessage() == TRUE);
      dia_IInputHandlingPrjListener* pPrjListener = OSAL_NULL;
      dia_IInputHandlingListener* pListener = OSAL_NULL;

      tDiaResult status = DIA_FAILED;

      //CID - 86569 Fix
      if ((querySysAdapterListener<dia_IInputHandlingPrjListener>(&pPrjListener) == DIA_SUCCESS) && pPrjListener)
      {
    	  switch ( poMessage->u8GetOpCode() )
    	  {
    	  case AMT_C_U8_CCAMSG_OPCODE_METHODRESULT:
    	  {
    		  status = DIA_SUCCESS;
    	  }
    	  break;

    	  case AMT_C_U8_CCAMSG_OPCODE_ERROR:
    	  {
    		  amt_tclServiceDataError oErrorMsg( poMessage );
    		  DIA_TR_ERR("dia_SAFeatureInputHandling::vHandleSetEncoder - opcode error received with error code:%u", ((tU16) oErrorMsg.u16GetErrorData()));
    	  }
    	  break;

    	  default:
    		  DIA_TR_ERR("dia_SAFeatureInputHandling::vHandleSetEncoder - UNKNOWN OPCODE!");
    		  break;
    	  }
    	  pPrjListener->vOnSetEncoder(status);
      }
      else
      {
    	  DIA_TR_WRN("dia_SAFeatureInputHandling::vHandleSetEncoder. querySysAdapterListener dia_IInputHandlingPrjListener NULL");
      }
	   //not used in core SH
#if 0
      if ((querySysAdapterListener<dia_IInputHandlingListener>(&pListener) == DIA_SUCCESS) && pListener)
		{
		  switch ( poMessage->u8GetOpCode() )
		  {
		  case AMT_C_U8_CCAMSG_OPCODE_METHODRESULT:
		  {
			  status = DIA_SUCCESS;
		  }
		  break;

		  case AMT_C_U8_CCAMSG_OPCODE_ERROR:
		  {
			  amt_tclServiceDataError oErrorMsg( poMessage );
			  DIA_TR_ERR("dia_SAFeatureInputHandling::vHandleSetEncoder - opcode error received with error code:%u", ((tU16) oErrorMsg.u16GetErrorData()));
		  }
		  break;

		  default:
			  DIA_TR_ERR("dia_SAFeatureInputHandling::vHandleSetEncoder - UNKNOWN OPCODE!");
			  break;
		  }
		  pListener->vOnSetEncoder(status);
		}
		else
		{
		  DIA_TR_WRN("dia_SAFeatureInputHandling::vHandleSetEncoder. querySysAdapterListener dia_IInputHandlingListener NULL");
		}
#endif
      (void) poMessage->bDelete();
   }
}


 /******************************************************************************
* FUNCTION:    setPIVITouchIntern
*
* DESCRIPTION: send CCA MethodStart message to start touch simulation
*
* PARAMETER:   u16X: value of X coordinate
*             u16Y: value of Y coordinate
*             eTouchInfo: Enum of touch status touched / not touched
*
* RETURNVALUE: DIA_SUCCESS  - post message to vd_input
*              DIA_FAILED   - post message to vd_input failed
*
******************************************************************************/
tDiaResult
dia_SAFeatureInputHandling::setPIVITouchIntern(const tU16 u16X, const tU16 u16Y, const tU16 u16ScreenNumber, const dia_eInputHandlingTouchInfoPrj eTouchInfo)
{
   dia_tclFnctTrace trc("dia_SAFeatureInputHandling::setPIVITouchIntern");

   if ( mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID )
   {
      input_mainfi_tclMsgsimulatePIVITouchMethodStart oData;
      if(eTouchInfo == DIA_EN_PRJ_TOUCH_INFO_TOUCHED)
      {
         oData.e8TouchStatus.enType =  input_fi_tcl_e8_TouchStatus::FI_EN_TOUCH_PRESSED;
      }
      else if (eTouchInfo == DIA_EN_PRJ_TOUCH_INFO_NOT_TOUCHED)
      {
         oData.e8TouchStatus.enType = input_fi_tcl_e8_TouchStatus::FI_EN_TOUCH_RELEASED;
      }
      else
      {
//         oData.e8TouchStatus.enType = input_fi_tcl_e8_TouchStatus::FI_EN_TOUCH_INVALID;
         return DIA_FAILED;
      }

      oData.s32XCoord = (tS32) u16X;
      oData.s32YCoord = (tS32) u16Y;
        oData.s32ScreenNumber = (tS32) u16ScreenNumber;
      fi_tclVisitorMessage oMessage(oData);
      mpSrvPlugin->vInitServiceData(oMessage, INPUT_MAINFI_C_U16_SIMULATEPIVITOUCH, CCA_C_U8_OPCODE_METHODSTART);
      if ( mpSrvPlugin->bTransmitMessage(&oMessage) != TRUE )
      {
         return DIA_FAILED;
      }
   }

   return DIA_SUCCESS;
}


//-----------------------------------------------------------------------------

void
dia_SAFeatureInputHandling::vHandlePIVISetTouch ( amt_tclServiceData* poMessage ) const
{
   dia_tclFnctTrace trc("dia_SAFeatureInputHandling::vHandlePIVISetTouch");

   if ( poMessage )
   {
      DIA_ASSERT(poMessage->bIsServerMessage() == TRUE);
      dia_IPIVIInputHandlingListener* pListener = OSAL_NULL;
      tDiaResult status = DIA_FAILED;

      //CID - 96384 Fix
      if ((querySysAdapterListener<dia_IPIVIInputHandlingListener>(&pListener) == DIA_SUCCESS) && pListener)
      {
    	  switch ( poMessage->u8GetOpCode() )
    	  {
    	  case AMT_C_U8_CCAMSG_OPCODE_METHODRESULT:
    	  {
    		  status = DIA_SUCCESS;
    	  }
    	  break;
    	  case AMT_C_U8_CCAMSG_OPCODE_ERROR:
    	  {
    		  amt_tclServiceDataError oErrorMsg( poMessage );
    		  DIA_TR_ERR("dia_SAFeatureInputHandling::vHandlePIVISetTouch - opcode error received with error code:%u", ((tU16) oErrorMsg.u16GetErrorData()));
    	  }
    	  break;
    	  default:
    		  DIA_TR_ERR("dia_SAFeatureInputHandling::vHandlePIVISetTouch - UNKNOWN OPCODE!");
    		  break;
    	  }
    	  pListener->vOnSetPIVITouch(status);
      }
      else
      {
    	  DIA_TR_WRN("dia_SAFeatureInputHandling::vHandlePIVISetTouch. querySysAdapterListener dia_IPIVIInputHandlingListener NULL");
      }
      (void) poMessage->bDelete();
   }
}

//-----------------------------------------------------------------------------


//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureInputHandling::getTouchPIVISecondaryInfo ( void )
{
   dia_tclFnctTrace trc("dia_SAFeatureInputHandling::getTouchPIVISecondaryInfo");

   tDiaResult retVal = DIA_FAILED;

   if ( mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID )
   {
      gm_tclU16Message oMessage (
         mAppID,
         mpSrvPlugin->getClientID(),
         mpSrvPlugin->getRegistrationID(),
         0,
         mpSrvPlugin->getServiceID(),
         INPUT_MAINFI_C_U16_TOUCHSTATUSPIVISECONDARY,
         CCA_C_U8_OPCODE_GET
      );

      if ( mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE )
     {
         retVal = DIA_SUCCESS;
      }
   }

   return retVal;
}


//-----------------------------------------------------------------------------

void
dia_SAFeatureInputHandling::vHandlePIVITouchScreenStatus ( amt_tclServiceData* poMessage ) const
{
   dia_tclFnctTrace trc("dia_SAFeatureInputHandling::vHandlePIVITouchScreenStatus");

   if ( poMessage )
   {
        DIA_TR_INF("dia_SAFeatureInputHandling::vHandlePIVITouchScreenStatus - poMessage OK");
      DIA_ASSERT(poMessage->bIsServerMessage() == TRUE);

     dia_IPIVIInputHandlingListener* pListener = OSAL_NULL;

     if ((querySysAdapterListener<dia_IPIVIInputHandlingListener>(&pListener) == DIA_SUCCESS) && pListener )
     {
      std::vector<dia_tTouchPressHistoryInfoPrj> diaPIVITouchPressInfo;
      dia_tTouchPressHistoryInfoPrj diaPIVITouchPressInfoElem;
      switch (poMessage->u8GetOpCode())
      {
      case AMT_C_U8_CCAMSG_OPCODE_STATUS:
      {

         fi_tclVisitorMessage oResultMsg(poMessage);
         input_mainfi_tclMsgTouchStatusPIVISecondaryStatus oCompResp;
         (void)oResultMsg.s32GetData(oCompResp);

         dia_eInputHandlingTouchInfoPrj eTouchPIVIInfo = DIA_EN_PRJ_TOUCH_INFO_UNKNOWN;
         tU16 u16X = 0;
         tU16 u16Y = 0;
         tU16 u16DeltaX = 0;
         tU16 u16DeltaY = 0;
         tU32 lastIndex = oCompResp.tSecondaryTouchDataList.sTouchInfo.size();

         DIA_TR_INF("dia_SAFeatureInputHandling::vHandlePIVITouchScreenStatus - List size=%d",
            oCompResp.tSecondaryTouchDataList.sTouchInfo.size());

         for (tU32 i = 0; i < oCompResp.tSecondaryTouchDataList.sTouchInfo.size(); i++)
         {
            DIA_TR_INF("dia_SAFeatureInputHandling::vHandlePIVITouchScreenStatus - Entry[%d] (%d,%d) = %d", i,
               oCompResp.tSecondaryTouchDataList.sTouchInfo[i].s32XCoord,
               oCompResp.tSecondaryTouchDataList.sTouchInfo[i].s32YCoord,
               oCompResp.tSecondaryTouchDataList.sTouchInfo[i].e8TouchStatus.enType);
               diaPIVITouchPressInfoElem.mXCoord = oCompResp.tSecondaryTouchDataList.sTouchInfo[i].s32XCoord;
               diaPIVITouchPressInfoElem.mYCoord = oCompResp.tSecondaryTouchDataList.sTouchInfo[i].s32YCoord;
               diaPIVITouchPressInfoElem.mType = getDiaPrjTouchInfo(oCompResp.tSecondaryTouchDataList.sTouchInfo[i].e8TouchStatus.enType);
               diaPIVITouchPressInfoElem.mXDelta=u16DeltaX;
               diaPIVITouchPressInfoElem.mYDelta=u16DeltaY;
               diaPIVITouchPressInfo.push_back(diaPIVITouchPressInfoElem);

            if (oCompResp.tSecondaryTouchDataList.sTouchInfo[i].e8TouchStatus.enType ==
               input_fi_tcl_e8_TouchStatus::FI_EN_TOUCH_PRESSED)
            {
               lastIndex = i;
            }
         }







            if (0 < ((oCompResp.tSecondaryTouchDataList.sTouchInfo.size()) && ((lastIndex)>= 1)))
            {
               u16X = (tU16)oCompResp.tSecondaryTouchDataList.sTouchInfo[lastIndex-1].s32XCoord;
               u16Y = (tU16)oCompResp.tSecondaryTouchDataList.sTouchInfo[lastIndex-1].s32YCoord;

            }


         DIA_TR_INF("dia_SAFeatureInputHandling::vHandlePIVITouchScreenStatus - x-cor-> %x, y-cor -> %x, x-delta -> %x,y-delta ->%x, ", u16X, u16Y, u16DeltaX, u16DeltaY);
         DIA_TR_INF("dia_SAFeatureInputHandling::vHandlePIVITouchScreenStatus touch_status -> %x", eTouchPIVIInfo);
         //pListener->vOnTouchInfo(u16X, u16Y, u16DeltaX, u16DeltaY, eTouchPIVIInfo);
         //sending back the operation History to Monitoring and Calibration Module
         pListener->vOnPIVITouchInfohistory(diaPIVITouchPressInfo);
      }
      break;

      case AMT_C_U8_CCAMSG_OPCODE_ERROR:
      {
         amt_tclServiceDataError oErrorMsg(poMessage);
         DIA_TR_INF("dia_SAFeatureInputHandling::vHandlePIVITouchScreenStatus - opcode error received with error code %d.", ((tU16)oErrorMsg.u16GetErrorData()));
         pListener->vOnTouchInfoError();
      }
      break;

      default:
         DIA_TR_ERR("dia_SAFeatureInputHandling::vHandlePIVITouchScreenStatus - UNKNOWN OPCODE!");
         pListener->vOnTouchInfoError();
         break;
      }
     }
      (void) poMessage->bDelete();
   }
}

//-----------------------------------------------------------------------------
