/*
 * dia_SAFeatureHeatControl.cpp
 *
 *  Created on: 10.01.2012
 *      Author: gib2hi
 * 	--------------------------------------------------------------------------------------------------------------------------------------------
 * 	Date 	        Author	           Modification
 * 	8.3.16			bsu9kor			   ID for Panel temperature changed and Header guards added for dia_SAFeatureHeatControl.h (NCG3D-5303).
 *  9.7.16			dvd5kor			   Adapted the Fan related diagnostic services (Get and set) - AIVI-23253
 * 	--------------------------------------------------------------------------------------------------------------------------------------------
 */

#ifndef __INCLUDED_DIA_COMMON_CORE__
#include "common/depricated/dia_common_core.h"
#endif

#ifndef __INCLUDED_DIA_MAIN__
#include "common/depricated/dia_main.h"
#endif

#include "common/interfaces/dia_IHeatControlListener.h"

#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include "generic_msgs_if.h" //lint !e451 !e537 repeatedly included header file without standard include guard

#if 0 //Nandeesh
#define FC_HEATCTRL_S_IMPORT_INTERFACE_GENERIC
#define FC_HEATCTRL_S_IMPORT_INTERFACE_MSG
#include "fc_HeatCtrl_if.h" //lint !e451 !e537 repeatedly included header file without standard include guard
#endif

#define FC_HEATCTRL_S_IMPORT_INTERFACE_GENERIC
#define FC_HEATCTRL_S_IMPORT_INTERFACE_MSG

#define SYSTEM_S_IMPORT_INTERFACE_VECTOR
#define HEATCTRL_FI_S_IMPORT_INTERFACE_FI_TYPES

/*
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_HEATCTRLFI_STDVISITORS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_HEATCTRLFI_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_HEATCTRLFI_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_HEATCTRLFI_FUNCTIONIDS
*/
#define HEATCTRL_FI_S_IMPORT_INTERFACE_HEATCTRL_MAINFI_STDVISITORS
#define HEATCTRL_FI_S_IMPORT_INTERFACE_HEATCTRL_MAINFI_TYPES
#define HEATCTRL_FI_S_IMPORT_INTERFACE_HEATCTRL_MAINFI_FUNCTIONIDS
#define HEATCTRL_FI_S_IMPORT_INTERFACE_HEATCTRL_MAINFI_SERVICEINFO
#include "heatctrl_fi_if.h"

/*#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "midw_fi_if.h" *///lint !e451 !e537 repeatedly included header file without standard include guard

#ifndef DIA_SAFEATUREHEATCONTROL_H_
#include "dia_SAFeatureHeatControl.h"
#endif

// MESSAGE MAP: the function will be called when a message with the
// corresponding FID arrives
BEGIN_MSG_MAP(dia_SAFeatureHeatControl,dia_SystemAdapterFeature)
   ON_MESSAGE(HEATCTRL_MAINFI_C_U16_REALSENSORTEMPERATURES, vHandleRealTemperature)
   ON_MESSAGE(HEATCTRL_MAINFI_C_U16_ABSTRACTSENSORTEMPERATURES, vHandleAbstractTemperature)
   ON_MESSAGE(HEATCTRL_MAINFI_C_U16_REALSENSORSTATES, vHandleRealSensorState)
   ON_MESSAGE(HEATCTRL_MAINFI_C_U16_ABSTRACTSENSORSTATES, vHandleAbstractSensorState)
#if 0
   ON_MESSAGE(MIDW_HEATCTRLFI_C_U16_MODEOFOPERATION, vHandleFANMode)
#endif
   ON_MESSAGE(HEATCTRL_MAINFI_C_U16_EMERGENCYFUNCTIONS, vHandleEmergencyFunction)
   ON_MESSAGE(HEATCTRL_MAINFI_C_U16_FANCONTROL, vHandleFANMode)


END_MSG_MAP()

#define FANMODE_ON     ((tU8) 100)
#define FANMODE_OFF    ((tU8)   0)

//------------------------------------------------------------------------------

dia_SAFeatureHeatControl::dia_SAFeatureHeatControl (
      tCString name,    // feature name
      dia_SystemAdapterServicePlugin& pSrvPlugin
   )
    : dia_SystemAdapterFeature(name,pSrvPlugin)
{
   dia_tclFnctTrace trc("dia_SAFeatureHeatControl::dia_SAFeatureHeatControl");
}

//-----------------------------------------------------------------------------

dia_SAFeatureHeatControl::~dia_SAFeatureHeatControl ( tVoid )
{}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureHeatControl::getTemperatures ( dia_eHeatCtrlTemperatureClass tempClass )
{
    dia_tclFnctTrace trc("dia_SAFeatureHeatControl::getTemperatures()");

    tDiaResult retCode = DIA_FAILED;

#if 1
    if ( mpSrvPlugin->getRegistrationID() == AMT_C_U16_REGID_INVALID )
    {
       DIA_TR_INF("dia_SAFeatureHeatControl::getTemperatures: registration failed.");
       return retCode;
    }

    tU16 top = 0;
    tU16 ccaFuncIDs[DIA_EN_HEATCTRL_TEMPERATURE_CLASS_COUNT] = { 0 };

    switch ( tempClass )
    {
    case DIA_EN_HEATCTRL_TEMPERATURE_CLASS_ESTIMATED:
       ccaFuncIDs[top++] = HEATCTRL_MAINFI_C_U16_ABSTRACTSENSORTEMPERATURES;
       break;

    case DIA_EN_HEATCTRL_TEMPERATURE_CLASS_REAL:
       ccaFuncIDs[top++] = HEATCTRL_MAINFI_C_U16_REALSENSORTEMPERATURES;
       break;

    default:
       ccaFuncIDs[top++] = HEATCTRL_MAINFI_C_U16_ABSTRACTSENSORTEMPERATURES;
       ccaFuncIDs[top++] = HEATCTRL_MAINFI_C_U16_REALSENSORTEMPERATURES;
       break;
    }

    for ( tU16 i=0; i<top; i++ )
    {
       gm_tclEmptyMessage oMessage (
             mAppID,
             mpSrvPlugin->getClientID(),
             mpSrvPlugin->getRegistrationID(),
             0,
             mpSrvPlugin->getServiceID(),
             ccaFuncIDs[i],
             CCA_C_U8_OPCODE_GET
       );

       DIA_TR_INF("dia_SAFeatureHeatControl::getTemperatures: Try to send message (0x%04x).", ccaFuncIDs[i]);

       if ( mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE )
       {
          retCode = DIA_SUCCESS;
          DIA_TR_INF("dia_SAFeatureHeatControl::getTemperatures  (0x%04x): message send.", ccaFuncIDs[i]);
       }
       else
       {
          DIA_TR_INF("dia_SAFeatureHeatControl::getTemperatures  (0x%04x): message NOT send.", ccaFuncIDs[i]);
          retCode = DIA_FAILED;
          break;
       }
    }
#endif
    return retCode;
}

//-----------------------------------------------------------------------------
tDiaResult
dia_SAFeatureHeatControl::getSensorState ( dia_eHeatCtrlTemperatureClass /*tempClass */ )
{
    dia_tclFnctTrace trc("dia_SAFeatureHeatControl::getSensorState()");

    tDiaResult retCode = DIA_FAILED;
#if 0
    if ( mpSrvPlugin->getRegistrationID() == AMT_C_U16_REGID_INVALID )
    {
       DIA_TR_INF("dia_SAFeatureHeatControl::getSensorState: registration failed.");
       return retCode;
    }

    tU16 top = 0;
    tU16 ccaFuncIDs[DIA_EN_HEATCTRL_TEMPERATURE_CLASS_COUNT] = { 0 };

    switch ( tempClass )
    {
    case DIA_EN_HEATCTRL_TEMPERATURE_CLASS_ESTIMATED:
       ccaFuncIDs[top++] = MIDW_HEATCTRLFI_C_U16_ABSTRACTSENSORSTATES;
       break;

    case DIA_EN_HEATCTRL_TEMPERATURE_CLASS_REAL:
       ccaFuncIDs[top++] = MIDW_HEATCTRLFI_C_U16_REALSENSORSTATES;
       break;

    default:
       ccaFuncIDs[top++] = MIDW_HEATCTRLFI_C_U16_ABSTRACTSENSORSTATES;
       ccaFuncIDs[top++] = MIDW_HEATCTRLFI_C_U16_REALSENSORSTATES;
       break;
    }

    for ( tU16 i=0; i<top; i++ )
    {
       gm_tclEmptyMessage oMessage (
             mAppID,
             mpSrvPlugin->getClientID(),
             mpSrvPlugin->getRegistrationID(),
             0,
             mpSrvPlugin->getServiceID(),
             ccaFuncIDs[i],
             CCA_C_U8_OPCODE_GET
       );

       DIA_TR_INF("dia_SAFeatureHeatControl::getSensorState: Try to send message (0x%04x).", ccaFuncIDs[i]);

       if ( mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE )
       {
          retCode = DIA_SUCCESS;
          DIA_TR_INF("dia_SAFeatureHeatControl::getSensorState  (0x%04x): message send.", ccaFuncIDs[i]);
       }
       else
       {
          DIA_TR_INF("dia_SAFeatureHeatControl::getSensorState  (0x%04x): message NOT send.", ccaFuncIDs[i]);
          retCode = DIA_FAILED;
          break;
       }
    }
#endif
    return retCode;
}
//-----------------------------------------------------------------------------
tDiaResult
dia_SAFeatureHeatControl::getFuncState( tVoid )
{
   dia_tclFnctTrace trc("dia_SAFeatureHeatControl::getFuncState()");

   tDiaResult retCode = DIA_FAILED;
#if 0
   if ( mpSrvPlugin->getRegistrationID() == AMT_C_U16_REGID_INVALID )
   {
      DIA_TR_INF("dia_SAFeatureHeatControl::getFuncState: registration failed.");
      return retCode;
   }

   gm_tclEmptyMessage oMessage (
         mAppID,
         mpSrvPlugin->getClientID(),
         mpSrvPlugin->getRegistrationID(),
         0,
         mpSrvPlugin->getServiceID(),
         MIDW_HEATCTRLFI_C_U16_EMERGENCYFUNCTIONS,
         CCA_C_U8_OPCODE_GET
   );

   DIA_TR_INF("dia_SAFeatureHeatControl::getFuncState: Try to send message (0x%04x).", MIDW_HEATCTRLFI_C_U16_EMERGENCYFUNCTIONS);

   if ( mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE )
   {
      retCode = DIA_SUCCESS;
      DIA_TR_INF("dia_SAFeatureHeatControl::getFuncState  (0x%04x): message send.", MIDW_HEATCTRLFI_C_U16_EMERGENCYFUNCTIONS);
   }
   else
   {
      DIA_TR_INF("dia_SAFeatureHeatControl::getFuncState  (0x%04x): message NOT send.", MIDW_HEATCTRLFI_C_U16_EMERGENCYFUNCTIONS);
      retCode = DIA_FAILED;
   }
#endif
    return retCode;
}

//-----------------------------------------------------------------------------
tDiaResult
dia_SAFeatureHeatControl::setFanSpeed ( dia_eFanState fanState, tU8 const fanSpeed, dia_eFanCtrlMode fanEvent )
{
	dia_tclFnctTrace trc("dia_SAFeatureHeatControl::setFanSpeed()");
    tDiaResult retCode = DIA_FAILED;
    tBool inputFailure = FALSE;

    if ( mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID ) {
       heatctrl_mainfi_tclMsgFANControlSet oFANModeCtrlData;
       
	   oFANModeCtrlData.FAN.Speed.u8Value = fanSpeed;
       switch(fanState){
          case DIA_EN_HEATCTRL_FANPWRSTATE_INIT:
             oFANModeCtrlData.FAN.State.enType = heatctrl_fi_tcl_e8_FANPowerState::FI_EN_FC_HEATCTRL_FANPWRSTATE_INIT;
             DIA_TR_INF("dia_SAFeatureHeatControl::setFanSpeed fan state = INIT .");
             break;
          case DIA_EN_HEATCTRL_FANPWRSTATE_ON:
             oFANModeCtrlData.FAN.State.enType = heatctrl_fi_tcl_e8_FANPowerState::FI_EN_FC_HEATCTRL_FANPWRSTATE_ON;
             DIA_TR_INF("dia_SAFeatureHeatControl::setFanSpeed fan state = ON .");
             break;
          case DIA_EN_HEATCTRL_FANPWRSTATE_OFF:
             oFANModeCtrlData.FAN.State.enType = heatctrl_fi_tcl_e8_FANPowerState::FI_EN_FC_HEATCTRL_FANPWRSTATE_OFF;
             DIA_TR_INF("dia_SAFeatureHeatControl::setFanSpeed fan state = OFF .");
             break;
          case DIA_EN_HEATCTRL_FANPWRSTATE_UNDEF:
             oFANModeCtrlData.FAN.State.enType = heatctrl_fi_tcl_e8_FANPowerState::FI_EN_FC_HEATCTRL_FANPWRSTATE_UNDEF;
             DIA_TR_INF("dia_SAFeatureHeatControl::setFanSpeed fan state = UNDEF .");
             break;
          default:
             DIA_TR_INF("dia_SAFeatureHeatControl::setFanSpeed fan state unknown: %d .", fanState);
             inputFailure = TRUE;
             break;
       }

       switch(fanEvent){
          case DIA_EN_FAN_CTRL_MODE_ON:
             oFANModeCtrlData.FANCtrl.Event.enType = heatctrl_fi_tcl_e8_FANCtrlEvent::FI_EN_FC_HEATCTRL_FANCTRLEVENT_DONTCARE;
             break;
          case DIA_EN_FAN_CTRL_MODE_OFF:
             oFANModeCtrlData.FANCtrl.Event.enType = heatctrl_fi_tcl_e8_FANCtrlEvent::FI_EN_FC_HEATCTRL_FANCTRLEVENT_MANUAL_END;
             break;
          default:
             DIA_TR_INF("dia_SAFeatureHeatControl::setFanSpeed fanCtrlMode/fanEvent unknown: %d .", fanEvent);
             inputFailure = TRUE;
             break;
       }

       if (inputFailure == FALSE) {
         fi_tclVisitorMessage oFANModeCtrlMessage(oFANModeCtrlData);
         mpSrvPlugin->vInitServiceData(oFANModeCtrlMessage, HEATCTRL_MAINFI_C_U16_FANCONTROL, AMT_C_U8_CCAMSG_OPCODE_SET);
         if (mpSrvPlugin->bTransmitMessage(&oFANModeCtrlMessage) == TRUE) {
            retCode = DIA_SUCCESS;
            DIA_TR_INF("dia_SAFeatureHeatControl::setFanSpeed - transmitMessage success.");
         } else {
            DIA_TR_ERR("dia_SAFeatureHeatControl::setFanSpeed - transmitMessage failed.");
         }
      } else {
         DIA_TR_ERR("dia_SAFeatureHeatControl::setFanSpeed - nothing sent due to incorrect input value!");
      }
   }

   return retCode;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureHeatControl::getFanSpeed ( tVoid )
{
    dia_tclFnctTrace trc("dia_SAFeatureHeatControl::getFanSpeed()");

    tDiaResult retCode = DIA_FAILED;

//#if 0
//    if ( mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID )
//    {
//       midw_heatctrlfi_tclMsgModeOfOperationSet oData;
//       fi_tclVisitorMessage oMsg(oData);
//       mpSrvPlugin->vInitServiceData(oMsg,MIDW_HEATCTRLFI_C_U16_DEVICETEMPERATURES,CCA_C_U8_OPCODE_GET);
//       if ( mpSrvPlugin->bTransmitMessage(&oMsg) == TRUE ) retCode = DIA_SUCCESS;
//    }
//#endif

	if ( mpSrvPlugin->getRegistrationID() == AMT_C_U16_REGID_INVALID )
	{
	  DIA_TR_INF("dia_SAFeatureHeatControl::getFanSpeed: registration failed.");
	  return retCode;
	}

	gm_tclEmptyMessage oMessage (
		mAppID,
		mpSrvPlugin->getClientID(),
		mpSrvPlugin->getRegistrationID(),
		0,
		mpSrvPlugin->getServiceID(),
		HEATCTRL_MAINFI_C_U16_FANCONTROL,
		CCA_C_U8_OPCODE_GET
	);

	if ( mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE )
	{
		retCode = DIA_SUCCESS;
		DIA_TR_INF("dia_SAFeatureHeatControl::getFanSpeed  (0x%04x): message send.", HEATCTRL_MAINFI_C_U16_FANCONTROL);
	}
	else
	{
		DIA_TR_ERR("dia_SAFeatureHeatControl::getFanSpeed  (0x%04x): message NOT send.", HEATCTRL_MAINFI_C_U16_FANCONTROL);
		retCode = DIA_FAILED;
	}

    return retCode;
}

//=============================================================================
//=============================================================================

tVoid
dia_SAFeatureHeatControl::vHandleRealTemperature ( amt_tclServiceData* poMessage ) const
{
   dia_tclFnctTrace trc("dia_SAFeatureHeatControl::vHandleRealTemperature");
#if 1
   std::list<dia_tHeatCtrlTemperature> temperatures;

   if ( poMessage )
   {
      DIA_ASSERT(poMessage->bIsServerMessage() == TRUE);

      dia_IHeatControlListener* pListener = OSAL_NULL;
      querySysAdapterListener<dia_IHeatControlListener>(&pListener);
      if ( pListener )
      {
         switch ( poMessage->u8GetOpCode() )
         {
         case AMT_C_U8_CCAMSG_OPCODE_STATUS:
            {
               fi_tclVisitorMessage oResultMsg(poMessage);
               heatctrl_mainfi_tclMsgRealSensorTemperaturesStatus oCompResp;
               (tVoid) oResultMsg.s32GetData(oCompResp);

               std::vector<heatctrl_fi_tcl_SensorTemperature>::iterator it = oCompResp.List.SensorTemperatureList.begin();
                for ( ; it != oCompResp.List.SensorTemperatureList.end(); ++it )
                {
                   DIA_TR_INF("ID: %d => temperature=%d, qual=%d minTemp=%d maxTemp=%d", it->ID.enType, it->Temperature.s16Value, it->Quality.enType,it->TemperatureMin.s16Value,it->TemperatureMax.s16Value);
                  temperatures.push_back(dia_tHeatCtrlTemperature(getTemperatureID(it->ID.enType), it->Temperature.s16Value, it->TemperatureMin.s16Value, it->TemperatureMax.s16Value, (tU8) (it->Quality.enType), getDiaQuality(it->Quality.enType)));
                }

               pListener->vOnTemperatureInfo(temperatures);
            }
            break;

         case AMT_C_U8_CCAMSG_OPCODE_ERROR:
            {
               amt_tclServiceDataError oErrorMsg( poMessage );
               DIA_TR_INF( "dia_SAFeatureHeatControl --- opcode error received with error code:%u", ((tU16) oErrorMsg.u16GetErrorData()));
               pListener->vOnTemperatureInfo(temperatures);
            }
            break;

         default:
            break;
         }
      }

      (tVoid) poMessage->bDelete();
   }
#endif
}

//-----------------------------------------------------------------------------
tVoid
dia_SAFeatureHeatControl::vHandleAbstractTemperature ( amt_tclServiceData* poMessage ) const
{
      dia_tclFnctTrace trc("dia_SAFeatureHeatControl::vHandleAbstractTemperature");

      std::list<dia_tHeatCtrlTemperature> temperatures;

   if (poMessage)
   {
      DIA_ASSERT(poMessage->bIsServerMessage() == TRUE);

      dia_IHeatControlListener* pListener = OSAL_NULL;
      querySysAdapterListener<dia_IHeatControlListener>(&pListener);
      if (pListener)
     {
         switch (poMessage->u8GetOpCode())
       {
            case AMT_C_U8_CCAMSG_OPCODE_STATUS:
            {
               fi_tclVisitorMessage oResultMsg(poMessage);
               heatctrl_mainfi_tclMsgAbstractSensorTemperaturesStatus oCompResp;
               (tVoid) oResultMsg.s32GetData(oCompResp);

               std::vector<heatctrl_fi_tcl_SensorTemperature>::iterator it = oCompResp.List.SensorTemperatureList.begin();
               for (; it != oCompResp.List.SensorTemperatureList.end(); ++it)
            {
				  DIA_TR_INF("dia_SAFeatureHeatControl::vHandleAbstractTemperature ID: 0x%02x  Temperature = %d .", it->ID.enType, it->Temperature.s16Value);
                  DIA_TR_INF("dia_SAFeatureHeatControl::vHandleAbstractTemperature Quality = 0x%02x .", it->Quality.enType);
                  DIA_TR_INF("dia_SAFeatureHeatControl::vHandleAbstractTemperature Min Temperature = %d .", it->TemperatureMin.s16Value);
                  DIA_TR_INF("dia_SAFeatureHeatControl::vHandleAbstractTemperature Max Temperature = %d .", it->TemperatureMax.s16Value);

                  temperatures.push_back(dia_tHeatCtrlTemperature(getTemperatureID(it->ID.enType), it->Temperature.s16Value, it->TemperatureMin.s16Value, it->TemperatureMax.s16Value, (tU8) (it->Quality.enType), getDiaQuality(it->Quality.enType)));
               }

               pListener->vOnTemperatureInfo(temperatures);
            }
               break;

            case AMT_C_U8_CCAMSG_OPCODE_ERROR:
            {
               amt_tclServiceDataError oErrorMsg(poMessage);
               DIA_TR_INF("dia_SAFeatureHeatControl --- opcode error received with error code:%u", ((tU16) oErrorMsg.u16GetErrorData()));
               pListener->vOnTemperatureInfo(temperatures);
            }
               break;

            default:
               break;
         }
      }

      (tVoid) poMessage->bDelete();
   }
}
//-----------------------------------------------------------------------------
tVoid
dia_SAFeatureHeatControl::vHandleRealSensorState ( amt_tclServiceData* /*poMessage*/ ) const
{
   dia_tclFnctTrace trc("dia_SAFeatureHeatControl::vHandleRealSensorState");
#if 0
   std::list<dia_tHeatCtrlSensorState> stateList;

   if (poMessage)
   {
      DIA_ASSERT(poMessage->bIsServerMessage() == TRUE);

      dia_IHeatControlListener* pListener = OSAL_NULL;
      querySysAdapterListener<dia_IHeatControlListener>(&pListener);
      if (pListener)
     {
         switch (poMessage->u8GetOpCode())
       {
            case AMT_C_U8_CCAMSG_OPCODE_STATUS:
            {
               fi_tclVisitorMessage oResultMsg(poMessage);
               midw_heatctrlfi_tclMsgRealSensorStatesStatus oCompResp;
               (tVoid) oResultMsg.s32GetData(oCompResp);

               std::vector<midw_fi_tcl_SensorState>::iterator it = oCompResp.List.SensorStateList.begin();
               for (; it != oCompResp.List.SensorStateList.end(); ++it)
               {
                  DIA_TR_INF("dia_SAFeatureHeatControl::vHandleRealSensorState ID: 0x%02x  State = %d .", it->ID.enType, it->State.enType);
                  //stateList.push_back(dia_tHeatCtrlSensorState(getTemperatureID(it->ID.enType), tU8 (it->State.enType))); nandeesh
               }

               pListener->vOnSensorStateInfo(stateList);
            }
               break;

            case AMT_C_U8_CCAMSG_OPCODE_ERROR:
            {
               amt_tclServiceDataError oErrorMsg(poMessage);
               DIA_TR_INF("dia_SAFeatureHeatControl::vHandleRealSensorState --- opcode error received with error code:%u", ((tU16) oErrorMsg.u16GetErrorData()));
               pListener->vOnSensorStateInfo(stateList);
            }
               break;

            default:
               break;
         }
      }

      (tVoid) poMessage->bDelete();
   }
#endif
}

//-----------------------------------------------------------------------------
tVoid
dia_SAFeatureHeatControl::vHandleAbstractSensorState ( amt_tclServiceData* /*poMessage*/ ) const
{
   dia_tclFnctTrace trc("dia_SAFeatureHeatControl::vHandleAbstractSensorState");
#if 0
   std::list<dia_tHeatCtrlSensorState> stateList;

   if (poMessage)
   {
      DIA_ASSERT(poMessage->bIsServerMessage() == TRUE);

      dia_IHeatControlListener* pListener = OSAL_NULL;
      querySysAdapterListener<dia_IHeatControlListener>(&pListener);
      if (pListener)
     {
         switch (poMessage->u8GetOpCode())
       {
            case AMT_C_U8_CCAMSG_OPCODE_STATUS:
            {
               fi_tclVisitorMessage oResultMsg(poMessage);
               midw_heatctrlfi_tclMsgAbstractSensorStatesStatus oCompResp;
               (tVoid) oResultMsg.s32GetData(oCompResp);

               std::vector<midw_fi_tcl_SensorState>::iterator it = oCompResp.List.SensorStateList.begin();
               for (; it != oCompResp.List.SensorStateList.end(); ++it)
            {
                  DIA_TR_INF("dia_SAFeatureHeatControl::vHandleAbstractSensorState ID: 0x%02x  State = %d .", it->ID.enType, it->State.enType);
                  //stateList.push_back(dia_tHeatCtrlSensorState(getTemperatureID(it->ID.enType), tU8 (it->State.enType))); Nandeesh
               }

               pListener->vOnSensorStateInfo(stateList);
            }
               break;

            case AMT_C_U8_CCAMSG_OPCODE_ERROR:
            {
               amt_tclServiceDataError oErrorMsg(poMessage);
               DIA_TR_INF("dia_SAFeatureHeatControl::vHandleAbstractSensorState --- opcode error received with error code:%u", ((tU16) oErrorMsg.u16GetErrorData()));
               pListener->vOnSensorStateInfo(stateList);
            }
               break;

            default:
               break;
         }
      }

      (tVoid) poMessage->bDelete();
   }
#endif
}

//-----------------------------------------------------------------------------
tVoid
dia_SAFeatureHeatControl::vHandleEmergencyFunction ( amt_tclServiceData* /*poMessage*/ ) const
{
   dia_tclFnctTrace trc("dia_SAFeatureHeatControl::vHandleEmergencyFunction");
#if 0
   std::list<dia_tHeatCtrlEmergencyFunc> funcList;

   if (poMessage)
   {
      DIA_ASSERT(poMessage->bIsServerMessage() == TRUE);

      dia_IHeatControlListener* pListener = OSAL_NULL;
      querySysAdapterListener<dia_IHeatControlListener>(&pListener);
      if (pListener)
     {
         switch (poMessage->u8GetOpCode())
       {
            case AMT_C_U8_CCAMSG_OPCODE_STATUS:
            {
               fi_tclVisitorMessage oResultMsg(poMessage);
               midw_heatctrlfi_tclMsgEmergencyFunctionsStatus oCompResp;
               (tVoid) oResultMsg.s32GetData(oCompResp);

               std::vector<midw_fi_tcl_EmergencyFunction>::iterator it = oCompResp.List.EmergencyFunctionList.begin();
               for (; it != oCompResp.List.EmergencyFunctionList.end(); ++it)
            {
                  DIA_TR_INF("dia_SAFeatureHeatControl::vHandleEmergencyFunction ID: 0x%02x  State = %d .", it->ID.enType, it->State.enType);
                  //funcList.push_back(dia_tHeatCtrlEmergencyFunc(getDiaEmergencyFuncID(it->ID.enType), getDiaEmergencyFuncState(it->State.enType))); nandeesh
               }

               pListener->vOnEmergencyFunc(funcList);
            }
               break;

            case AMT_C_U8_CCAMSG_OPCODE_ERROR:
            {
               amt_tclServiceDataError oErrorMsg(poMessage);
               DIA_TR_INF("dia_SAFeatureHeatControl::vHandleEmergencyFunction --- opcode error received with error code:%u", ((tU16) oErrorMsg.u16GetErrorData()));
               pListener->vOnEmergencyFunc(funcList);
            }
               break;

            default:
               break;
         }
      }

      (tVoid) poMessage->bDelete();
   }
#endif
}

//-----------------------------------------------------------------------------
tVoid
dia_SAFeatureHeatControl::vHandleFANMode ( amt_tclServiceData* poMessage ) const
{
   dia_tclFnctTrace trc("dia_SAFeatureHeatControl::vHandleFANMode");

   if ( poMessage )
   {
      DIA_ASSERT(poMessage->bIsServerMessage() == TRUE);

      dia_IHeatControlListener* pListener = OSAL_NULL;
      querySysAdapterListener<dia_IHeatControlListener>(&pListener);
      if ( pListener )
      {
         DIA_TR_INF("dia_SAFeatureHeatControl::vHandleFANMode OpCode = %d (0x%02x).", poMessage->u8GetOpCode(), poMessage->u8GetOpCode());
		 switch ( poMessage->u8GetOpCode() )
         {
         case AMT_C_U8_CCAMSG_OPCODE_STATUS:
            {
               fi_tclVisitorMessage oResultMsg(poMessage);
               heatctrl_mainfi_tclMsgFANControlStatus oCompResp;
               (tVoid) oResultMsg.s32GetData(oCompResp);
			   DIA_TR_INF("dia_SAFeatureHeatControl::vHandleFANMode FanSpeed = %d .", oCompResp.FAN.Speed.u8Value);
			   
			   pListener->vOnFanSpeed(DIA_EN_HEATCTRL_FAN_ID_CASE, (tU16) oCompResp.FAN.Speed.u8Value, TRUE);
			   //used by for diag response handling for fanSpeed Set
			   pListener->vOnFanSpeedSet(DIA_SUCCESS);
            }
            break;

         case AMT_C_U8_CCAMSG_OPCODE_ERROR:
            {
               amt_tclServiceDataError oErrorMsg( poMessage );
			   DIA_TR_INF( "dia_SAFeatureHeatControl::vHandleFANMode --- opcode error received with error code:%u", ((tU16) oErrorMsg.u16GetErrorData()));
			   pListener->vOnFanSpeedSet(DIA_FAILED);
            }
            break;

         default:
            break;
         }
      }

      (tVoid) poMessage->bDelete();
   }
}

//-----------------------------------------------------------------------------
//Nandeesh
#if 1
dia_eHeatCtrlTemperatureID
dia_SAFeatureHeatControl::getTemperatureID ( heatctrl_fi_tcl_e8_SensorID::tenType heatCtrlID ) const
{
   dia_eHeatCtrlTemperatureID temperatureID = DIA_EN_HEATCTRL_TEMPERATURE_ID_UNKNOWN;

   switch ( heatCtrlID )
   {
   case heatctrl_fi_tcl_e8_SensorID::FI_EN_FC_HEATCTRL_SENSORID_V850:
      temperatureID = DIA_EN_HEATCTRL_TEMPERATURE_ID_V850;
      break;

   case heatctrl_fi_tcl_e8_SensorID::FI_EN_FC_HEATCTRL_SENSORID_PANEL:
      temperatureID = DIA_EN_HEATCTRL_TEMPERATURE_ID_PANEL; // SUZUKI-13581, changed according to HeatCtrl team ///NCG3D-5303
      break;

   case heatctrl_fi_tcl_e8_SensorID::FI_EN_FC_HEATCTRL_SENSORID_CDDRIVE:
      temperatureID = DIA_EN_HEATCTRL_TEMPERATURE_ID_CDDRIVE;
      break;

   case heatctrl_fi_tcl_e8_SensorID::FI_EN_FC_HEATCTRL_SENSORID_DVDDRIVE:
      temperatureID = DIA_EN_HEATCTRL_TEMPERATURE_ID_DVDDRIVE;
      break;

   case heatctrl_fi_tcl_e8_SensorID::FI_EN_FC_HEATCTRL_SENSORID_GPS:
      temperatureID = DIA_EN_HEATCTRL_TEMPERATURE_ID_GPS;
      break;

   case heatctrl_fi_tcl_e8_SensorID::FI_EN_FC_HEATCTRL_SENSORID_GYRO:
      temperatureID = DIA_EN_HEATCTRL_TEMPERATURE_ID_GYRO;
      break;

   case heatctrl_fi_tcl_e8_SensorID::FI_EN_FC_HEATCTRL_SENSORID_EMMC:
      temperatureID = DIA_EN_HEATCTRL_TEMPERATURE_ID_EMMC;
      break;

   case heatctrl_fi_tcl_e8_SensorID::FI_EN_FC_HEATCTRL_SENSORID_AMP:
      temperatureID = DIA_EN_HEATCTRL_TEMPERATURE_ID_AMP;
      break;

   case heatctrl_fi_tcl_e8_SensorID::FI_EN_FC_HEATCTRL_SENSORID_IMX:
      temperatureID = DIA_EN_HEATCTRL_TEMPERATURE_ID_IMX;
      break;

   case heatctrl_fi_tcl_e8_SensorID::FI_EN_FC_HEATCTRL_SENSORID_HEATSINK:
      temperatureID = DIA_EN_HEATCTRL_TEMPERATURE_ID_HEATSINK;
      break;

   case heatctrl_fi_tcl_e8_SensorID::FI_EN_FC_HEATCTRL_SENSORID_AMPLIFIER:
      temperatureID = DIA_EN_HEATCTRL_TEMPERATURE_ID_AMPLIFIER;
      break;

   case heatctrl_fi_tcl_e8_SensorID::FI_EN_FC_HEATCTRL_SENSORID_CPU:
      temperatureID = DIA_EN_HEATCTRL_TEMPERATURE_ID_CPU;
      break;

   case heatctrl_fi_tcl_e8_SensorID::FI_EN_FC_HEATCTRL_SENSORID_EXPBOARD:
      temperatureID = DIA_EN_HEATCTRL_TEMPERATURE_ID_EXPBOARD;
      break;

   case heatctrl_fi_tcl_e8_SensorID::FI_EN_FC_HEATCTRL_SENSORID_BOARD:
      temperatureID = DIA_EN_HEATCTRL_TEMPERATURE_ID_BOARD;
      break;

   case heatctrl_fi_tcl_e8_SensorID::FI_EN_FC_HEATCTRL_SENSORID_DISPLAY:
      temperatureID = DIA_EN_HEATCTRL_TEMPERATURE_ID_DISPLAY;
      break;

   case heatctrl_fi_tcl_e8_SensorID::FI_EN_FC_HEATCTRL_SENSORID_DRIVE:
      temperatureID = DIA_EN_HEATCTRL_TEMPERATURE_ID_DRIVE;
      break;

   case heatctrl_fi_tcl_e8_SensorID::FI_EN_FC_HEATCTRL_SENSORID_SYSTEM:
      temperatureID = DIA_EN_HEATCTRL_TEMPERATURE_ID_SYSTEM;
      break;

   case heatctrl_fi_tcl_e8_SensorID::FI_EN_FC_HEATCTRL_SENSORID_MAIN:
      temperatureID = DIA_EN_HEATCTRL_TEMPERATURE_ID_MAIN;
      break;

   case 12: //heatctrl_fi_tcl_e8_SensorID::FI_EN_FC_HEATCTRL_SENSORID_XMMODULE: //12
      temperatureID = DIA_EN_HEATCTRL_TEMPERATURE_ID_XMMODULE;
      break;

   case 13: //heatctrl_fi_tcl_e8_SensorID::FI_EN_FC_HEATCTRL_SENSORID_TVMODULE: //13
      temperatureID = DIA_EN_HEATCTRL_TEMPERATURE_ID_TVMODULE;
      break;

   case 14: //heatctrl_fi_tcl_e8_SensorID::FI_EN_FC_HEATCTRL_SENSORID_TVMODULESLAVE: //14
      temperatureID = DIA_EN_HEATCTRL_TEMPERATURE_ID_TVMODULESLAVE;
      break;

   case 15: //heatctrl_fi_tcl_e8_SensorID::FI_EN_FC_HEATCTRL_SENSORID_PANEL2: //15
      temperatureID = DIA_EN_HEATCTRL_TEMPERATURE_ID_PANEL2;
      break;

   default:
      break;
   };

   return temperatureID;
}
#endif

//-----------------------------------------------------------------------------

//Nandeesh
#if 1
dia_eHeatCtrlTemperatureQuality
dia_SAFeatureHeatControl::getDiaQuality (heatctrl_fi_tcl_e8_TemperatureQualityType::tenType heatCtrlQuality) const
{
   dia_eHeatCtrlTemperatureQuality temperatureState = DIA_EN_HEATCTRL_TEMPERATURE_QUALITY_UNKNOWN;

   switch ( heatCtrlQuality )
   {
   case heatctrl_fi_tcl_e8_TemperatureQualityType::FI_EN_FC_HEATCTRL_TEMPQUALITY_INVALID:
      temperatureState = DIA_EN_HEATCTRL_TEMPERATURE_QUALITY_INVALID;
      break;

   case heatctrl_fi_tcl_e8_TemperatureQualityType::FI_EN_FC_HEATCTRL_TEMPQUALITY_UNSUPPORTED:
      temperatureState = DIA_EN_HEATCTRL_TEMPERATURE_QUALITY_UNSUPPORTED;
      break;


   case heatctrl_fi_tcl_e8_TemperatureQualityType::FI_EN_FC_HEATCTRL_TEMPQUALITY_ESTIMATED:
   case heatctrl_fi_tcl_e8_TemperatureQualityType::FI_EN_FC_HEATCTRL_TEMPQUALITY_CALCULATED:
   case heatctrl_fi_tcl_e8_TemperatureQualityType::FI_EN_FC_HEATCTRL_TEMPQUALITY_REAL:
      temperatureState = DIA_EN_HEATCTRL_TEMPERATURE_QUALITY_VALID;
      break;

   default:
      break;
   };

//   DIA_TR_INF( "dia_SAFeatureHeatControl::getDiaQuality: Internal Quality = %d DIA quality = %d", heatCtrlQuality, temperatureState);

   return temperatureState;
}
#endif

//-----------------------------------------------------------------------------
//Nandeesh
#if 0
dia_eHeatCtrlEmergencyFuncState
dia_SAFeatureHeatControl::getDiaEmergencyFuncState ( midw_fi_tcl_e8_EmergncyFunctionState::tenType emergencyFunctState ) const
{
   dia_eHeatCtrlEmergencyFuncState diaEmergencyFuncState = DIA_EN_HEATCTRL_EMERGENCY_FUNC_STATE_INACTIVE;

   if ( emergencyFunctState == midw_fi_tcl_e8_EmergncyFunctionState::FI_EN_FC_HEATCTRL_EMERGENCYFUNCTION_STATE_ACTIVE)
   {
      diaEmergencyFuncState = DIA_EN_HEATCTRL_EMERGENCY_FUNC_STATE_ACTIVE;
   }

   return diaEmergencyFuncState;
}
#endif
//-----------------------------------------------------------------------------

//Nandeesh
#if 0
dia_eHeatCtrlEmergencyFuncID
dia_SAFeatureHeatControl::getDiaEmergencyFuncID ( midw_fi_tcl_e8_EmergncyFunctionID::tenType heatCtrlEmergencyFuncID ) const
{
   dia_eHeatCtrlEmergencyFuncID diaEergncyFuncID = DIA_EN_HEATCTRL_EMERGENCY_FUNC_ID_UNKNOWN;

   switch ( heatCtrlEmergencyFuncID )
   {
   case midw_fi_tcl_e8_EmergncyFunctionID::FI_EN_FC_HEATCTRL_EMERGENCYFUNCTION_SYSTEMSHUTDOWN:
      diaEergncyFuncID = DIA_EN_HEATCTRL_EMERGENCY_FUNC_ID_SYSTEMSHUTDOWN;
      break;

   case midw_fi_tcl_e8_EmergncyFunctionID::FI_EN_FC_HEATCTRL_EMERGENCYFUNCTION_ATTENUATION:
      diaEergncyFuncID = DIA_EN_HEATCTRL_EMERGENCY_FUNC_ID_ATTENUATION;
      break;

   case midw_fi_tcl_e8_EmergncyFunctionID::FI_EN_FC_HEATCTRL_EMERGENCYFUNCTION_CDDRIVEOFF:
      diaEergncyFuncID = DIA_EN_HEATCTRL_EMERGENCY_FUNC_ID_CDDRIVEROFF;
      break;

   case midw_fi_tcl_e8_EmergncyFunctionID::FI_EN_FC_HEATCTRL_EMERGENCYFUNCTION_BACKLIGHTOFF:
      diaEergncyFuncID = DIA_EN_HEATCTRL_EMERGENCY_FUNC_ID_BACKLIGHTOFF;
      break;

   default:
      break;
   };

   return diaEergncyFuncID;
}
#endif

