/*
 * dia_SAFeatureHMINavigationDataUpdate.cpp
 *
 *  Created on: March 28, 2017
 *      Author: kaa1hi
 */

#include "dia_SAFeatureHMINavigationDataUpdate.h"

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_SERVICE_PLUGIN_ASF__
#include <common/framework/platform/asf/dia_SystemAdapterServicePluginASF.h>
#endif

#include <asf/core/Proxy.h>

using namespace ::boost;
using namespace ::asf::core;

dia_SAFeatureHMINavigationDataUpdate::dia_SAFeatureHMINavigationDataUpdate(dia_SystemAdapterServicePluginASF<NavigationDataUpdateServiceProxy>& pSrvPlugin)
   : dia_SystemAdapterFeatureASF<NavigationDataUpdateServiceProxy>(pSrvPlugin)
{
}

dia_SAFeatureHMINavigationDataUpdate::~dia_SAFeatureHMINavigationDataUpdate() {
   // TODO Auto-generated destructor stub
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureHMINavigationDataUpdate::startMonitoring()
{
   dia_tclFnctTrace trc("dia_SAFeatureHMINavigationDataUpdate::startMonitoring");

   if( (mpSrvPlugin) && (mpSrvPlugin->getProxy())    )
   {
     // Register to properties
   }
   return DIA_SUCCESS;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureHMINavigationDataUpdate::stopMonitoring()
{
   dia_tclFnctTrace trc("dia_SAFeatureHMINavigationDataUpdate::stopMonitoring");

   if( (mpSrvPlugin) && (mpSrvPlugin->getProxy()))
   {
     // DeRegister properties
   }
   return DIA_SUCCESS;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureHMINavigationDataUpdate::performFullUpdateViaUSB ( void )
{
   dia_tclFnctTrace trc("dia_SAFeatureHMINavigationDataUpdate::performFullUpdateViaUSB");

   tDiaResult retCode = DIA_FAILED;

   if (mpSrvPlugin)
   {
      NavigationDataUpdateServiceProxy* proxy = mpSrvPlugin->getProxy();

      if (proxy)
      {
         DIA_TR_INF("dia_SAFeatureHMINavigationDataUpdate::performFullUpdateViaUSB got proxy.");

         act_t token = proxy->sendDiagPerformFullUpdateViaUSBRequest(*this);
         if (0!=token)
         {
            retCode = DIA_SUCCESS;
         }
      }
      else
      {
         DIA_TR_ERR("dia_SAFeatureHMINavigationDataUpdate::performFullUpdateViaUSB proxy is NULL.");
      }
   }
   else
   {
      DIA_TR_ERR("dia_SAFeatureHMINavigationDataUpdate::performFullUpdateViaUSB mpSrvPlugin is NULL.");
   }

   DIA_TR_INF("dia_SAFeatureHMINavigationDataUpdate::performFullUpdateViaUSB returned %s", (DIA_SUCCESS==retCode? "SUCCESS": "FAILED"));

   return retCode;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureHMINavigationDataUpdate::getNavDataUpdateStatus ( void )
{
   dia_tclFnctTrace trc("dia_SAFeatureHMINavigationDataUpdate::getNavDataUpdateStatus");

   tDiaResult retCode = DIA_FAILED;

   if (mpSrvPlugin)
   {
      NavigationDataUpdateServiceProxy* proxy = mpSrvPlugin->getProxy();

      if (proxy)
      {
         DIA_TR_INF("dia_SAFeatureHMINavigationDataUpdate::getNavDataUpdateStatus got proxy.");

         act_t token = proxy->sendNavigationDataUpdateStatusInfoGet(*this);
         if (0!=token)
         {
            retCode = DIA_SUCCESS;
         }
      }
      else
      {
         DIA_TR_ERR("dia_SAFeatureHMINavigationDataUpdate::getNavDataUpdateStatus proxy is NULL.");
      }
   }
   else
   {
      DIA_TR_ERR("dia_SAFeatureHMINavigationDataUpdate::getNavDataUpdateStatus mpSrvPlugin is NULL.");
   }

   DIA_TR_INF("dia_SAFeatureHMINavigationDataUpdate::getNavDataUpdateStatus returned %s", (DIA_SUCCESS==retCode? "SUCCESS": "FAILED"));

   return retCode;
}

//=============================================================================
//=============================================================================

void
dia_SAFeatureHMINavigationDataUpdate::onDiagPerformFullUpdateViaUSBError(const ::boost::shared_ptr< NavigationDataUpdateServiceProxy >& proxy, const ::boost::shared_ptr< DiagPerformFullUpdateViaUSBError >& error)
{
    dia_tclFnctTrace trc("dia_SAFeatureHMINavigationDataUpdate::onDiagPerformFullUpdateViaUSBError");

    DIA_TR_ERR( "onDiagPerformFullUpdateViaUSBError. ErrorName     = \"%s\"", error->getName().c_str() );
    DIA_TR_ERR( "onDiagPerformFullUpdateViaUSBError. ErrorMessage  = \"%s\"", error->getMessage().c_str() );
}

//-----------------------------------------------------------------------------

void
dia_SAFeatureHMINavigationDataUpdate::onDiagPerformFullUpdateViaUSBResponse(const ::boost::shared_ptr< NavigationDataUpdateServiceProxy >& proxy, const ::boost::shared_ptr< DiagPerformFullUpdateViaUSBResponse >& response)
{
   dia_tclFnctTrace trc("dia_SAFeatureHMINavigationDataUpdate::onDiagPerformFullUpdateViaUSBResponse");

   const NavigationDataUpdateServiceAck ack = response->getAck();

   //to have thread synchronization (we have no impact on ASF thread here)
   getInstanceOfApplication()->postMessage (
       OSAL_NEW dia_tclDiagSession::tclEventIntMsgRxGeneric (
             OSAL_NEW dia_FunctorOneArgNoReturnValue<dia_SAFeatureHMINavigationDataUpdate, const NavigationDataUpdateServiceAck>(this, &dia_SAFeatureHMINavigationDataUpdate::diagPerformFullUpdateViaUSBResponse, ack)
      )
   );
}

//-----------------------------------------------------------------------------

void
dia_SAFeatureHMINavigationDataUpdate::diagPerformFullUpdateViaUSBResponse(const NavigationDataUpdateServiceAck ack)
{
   dia_tclFnctTrace trc("dia_SAFeatureHMINavigationDataUpdate::diagPerformFullUpdateViaUSBResponse");

   dia_eFullUpdateViaUSBConfirmation confirmation = DIA_EN_FULL_UPDATE_CONFIRMATION_UNKNOWN;

   switch(ack)
   {
      case NavigationDataUpdateServiceAck__ACCEPTED:
         DIA_TR_INF("diagPerformFullUpdateViaUSBResponse NavigationDataUpdateServiceAck__ACCEPTED");
         confirmation = DIA_EN_FULL_UPDATE_CONFIRMATION_ACCEPTED;
      break;

      case NavigationDataUpdateServiceAck__DECLINED__CANNOT_PROCESS:
         DIA_TR_INF("diagPerformFullUpdateViaUSBResponse NavigationDataUpdateServiceAck__DECLINED__CANNOT_PROCESS");
         confirmation = DIA_EN_FULL_UPDATE_CONFIRMATION_DECLINED_CANNOT_PROCESS;
      break;

      case NavigationDataUpdateServiceAck__DECLINED__REQUEST_ACTIVE:
         DIA_TR_INF("diagPerformFullUpdateViaUSBResponse NavigationDataUpdateServiceAck__DECLINED__REQUEST_ACTIVE");
         confirmation = DIA_EN_FULL_UPDATE_CONFIRMATION_DECLINED_REQUEST_ACTIVE;
      break;

      default:
         DIA_TR_INF("diagPerformFullUpdateViaUSBResponse unknown value (%d)", ack);
      break;
   }

   dia_IHMINavigationDataUpdateListener* pListener = 0;
   if ((querySysAdapterListener<dia_IHMINavigationDataUpdateListener>(&pListener) == DIA_SUCCESS) && pListener)
   {
      pListener->vOnPerformFullUpdateViaUSB( confirmation );
   }
   else
   {
     DIA_TR_WRN("diagPerformFullUpdateViaUSBResponse. querySysAdapterListener dia_IHMINavigationListener NULL");
   }
}

void
dia_SAFeatureHMINavigationDataUpdate::onNavigationDataUpdateStatusInfoError(const ::boost::shared_ptr< NavigationDataUpdateServiceProxy >& proxy, const ::boost::shared_ptr< NavigationDataUpdateStatusInfoError >& error)
{
    dia_tclFnctTrace trc("dia_SAFeatureHMINavigationDataUpdate::onNavigationDataUpdateStatusInfoError");

    DIA_TR_ERR( "ErrorName     = \"%s\"", error->getName().c_str() );
    DIA_TR_ERR( "ErrorMessage  = \"%s\"", error->getMessage().c_str() );

    NavigationDataUpdateStatusInfo info;
    info.setStatus(NavigationDataUpdateStatus__UNKNOWN);
    info.setProgressValue(0);

    //to have thread synchronization (we have no impact on ASF thread here)
    getInstanceOfApplication()->postMessage (
        OSAL_NEW dia_tclDiagSession::tclEventIntMsgRxGeneric (
              OSAL_NEW dia_FunctorOneArgNoReturnValue<dia_SAFeatureHMINavigationDataUpdate, const NavigationDataUpdateStatusInfo>(this, &dia_SAFeatureHMINavigationDataUpdate::navigationDataUpdateStatusInfoUpdate, info)
       )
    );
}

//-----------------------------------------------------------------------------

void
dia_SAFeatureHMINavigationDataUpdate::onNavigationDataUpdateStatusInfoUpdate(const ::boost::shared_ptr< NavigationDataUpdateServiceProxy >& proxy, const ::boost::shared_ptr< NavigationDataUpdateStatusInfoUpdate >& update)
{
   dia_tclFnctTrace trc("dia_SAFeatureHMINavigationDataUpdate::onNavigationDataUpdateStatusInfoUpdate");

   const NavigationDataUpdateStatusInfo info = update->getNavigationDataUpdateStatusInfo();

   //to have thread synchronization (we have no impact on ASF thread here)
   getInstanceOfApplication()->postMessage (
       OSAL_NEW dia_tclDiagSession::tclEventIntMsgRxGeneric (
             OSAL_NEW dia_FunctorOneArgNoReturnValue<dia_SAFeatureHMINavigationDataUpdate, const NavigationDataUpdateStatusInfo>(this, &dia_SAFeatureHMINavigationDataUpdate::navigationDataUpdateStatusInfoUpdate, info)
      )
   );
}

//-----------------------------------------------------------------------------

void
dia_SAFeatureHMINavigationDataUpdate::navigationDataUpdateStatusInfoUpdate(const NavigationDataUpdateStatusInfo info)
{
   dia_tclFnctTrace trc("dia_SAFeatureHMINavigationDataUpdate::navigationDataUpdateStatusInfoUpdate");

   bool statusIsAvailable = info.hasStatus();
   if (statusIsAvailable)
   {
      dia_eMapUpdateStatus status = DIA_EN_MAP_UPDATE_STATUS_UNKNOWN;
      const NavigationDataUpdateStatus updateStatus = info.getStatus();
      const tU8 progress = info.getProgressValue();
      const tU32 remainingTimeInSecond = info.getRemainingTimeInSecond();
      const std::string regionName = info.getRegionName();
      const std::string productName = info.getProductName();

      DIA_TR_INF("updateStatus (decimal) is %d, (string) '%s'.", updateStatus, NavigationDataUpdateStatus_Name(updateStatus));
      DIA_TR_INF("progress is %d.", progress);
      DIA_TR_INF("remainingTimeInSecond is %d (0x%02X).", remainingTimeInSecond, remainingTimeInSecond);
      DIA_TR_INF("regionName is '%s'. (StrLen is %d).",     regionName.c_str(),  regionName.size());
      DIA_TR_INF("productName is '%s'. (StrLen is %d).",    productName.c_str(), productName.size());

      switch(updateStatus)
      {
         case NavigationDataUpdateStatus__DOWNLOAD_UPDATE_SUCCESSFULLY_FINISHED:
         case NavigationDataUpdateStatus__INSTALLATION_FINISHED:
            status = DIA_EN_MAP_UPDATE_STATUS_COMPLETED_OK;
            DIA_TR_INF("navigationDataUpdateStatusInfoUpdate: DIA_EN_MAP_UPDATE_STATUS_COMPLETED_OK.");
         break;

         case NavigationDataUpdateStatus__DOWNLOAD_ABORTED_BY_ERROR:
         case NavigationDataUpdateStatus__AVAILABLE_UPDATES_ABORTED_BY_ERROR:
            status = DIA_EN_MAP_UPDATE_STATUS_COMPLETED_NOK;
            DIA_TR_INF("navigationDataUpdateStatusInfoUpdate: DIA_EN_MAP_UPDATE_STATUS_COMPLETED_NOK.");
         break;

         case NavigationDataUpdateStatus__AVAILABLE_UPDATES_STARTED:
         case NavigationDataUpdateStatus__AVAILABLE_UPDATES_IN_PROGRESS:
         case NavigationDataUpdateStatus__AVAILABLE_UPDATES_FINISHED:
         case NavigationDataUpdateStatus__INSTALLATION_IN_PROGRESS:
         case NavigationDataUpdateStatus__DOWNLOAD_STARTED:
         case NavigationDataUpdateStatus__DOWNLOAD_IN_PROGRESS:
         case NavigationDataUpdateStatus__DOWNLOAD_FINISHED:
            status = DIA_EN_MAP_UPDATE_STATUS_RUNNING;
            DIA_TR_INF("navigationDataUpdateStatusInfoUpdate: DIA_EN_MAP_UPDATE_STATUS_RUNNING.");
         break;

         case NavigationDataUpdateStatus__AVAILABLE_UPDATES_ABORTED_BY_USER:
         case NavigationDataUpdateStatus__DOWNLOAD_STOPPED:
            status = DIA_EN_MAP_UPDATE_STATUS_STOPPED;
            DIA_TR_INF("navigationDataUpdateStatusInfoUpdate: DIA_EN_MAP_UPDATE_STATUS_STOPPED.");
         break;

         case NavigationDataUpdateStatus__INSTALLATION_STOPPED:
         case NavigationDataUpdateStatus__FAILED__INVALID_USB_DATA:
         case NavigationDataUpdateStatus__FAILED__OTHERS:
         case NavigationDataUpdateStatus__TIMEOUT__NO_USB:
            status = DIA_EN_MAP_UPDATE_STATUS_ABORTED;
            DIA_TR_INF("navigationDataUpdateStatusInfoUpdate: DIA_EN_MAP_UPDATE_STATUS_ABORTED.");
         break;

         case NavigationDataUpdateStatus__IDLE:
         case NavigationDataUpdateStatus__UNKNOWN:
            status = DIA_EN_MAP_UPDATE_STATUS_NOT_RUN;
            DIA_TR_INF("navigationDataUpdateStatusInfoUpdate: DIA_EN_MAP_UPDATE_STATUS_NOT_RUN.");
         break;

         default:
            status = DIA_EN_MAP_UPDATE_STATUS_NOT_RUN;
            DIA_TR_INF("navigationDataUpdateStatusInfoUpdate: DIA_EN_MAP_UPDATE_STATUS_NOT_RUN default.");
         break;
      }

      dia_IHMINavigationDataUpdateListener* pListener = 0;
      tDiaResult queryResult = querySysAdapterListener<dia_IHMINavigationDataUpdateListener>(&pListener);
      if ((DIA_SUCCESS==queryResult) && pListener)
      {
         //get only status
         pListener->vOnGetNavDataUpdateStatus( progress, status );
      }
      else
      {
        DIA_TR_WRN("navigationDataUpdateStatusInfoUpdate. querySysAdapterListener queryResult=0x%08X", queryResult);
      }
   }
   else
   {
      DIA_TR_ERR("navigationDataUpdateStatusInfoUpdate: status is NOT available.");
   }
}
