/*
 * dia_SAFeatureFanStatistics.cpp
 *
 *  Created on: 15.12.2016
 *      Author: stc2hi
 */

 #ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#ifndef __INCLUDED_DIA_COMMON_SYSTEM_ADAPTERS__
#include "common/framework/sysadapters/dia_common_system_adapters.h"
#endif

#ifndef __INCLUDED_DIAGLIB_ID_SPEC__
#include "common/depricated/SystemAdapter/dia_IdSpec.h"
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_DIAGLIB__
#include "project/framework/sysadapters/dia_SAFeatureDiaglib.h"
#endif

#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGLIBFI_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGLIBFI_FUNCTIONIDS
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "midw_fi_if.h" //lint !e451 !e537 repeatedly included header file without standard include guard


#include "dia_SAFeatureFanStatistics.h"

/// MESSAGE MAP:
// The message map maps IDs of incoming CCA messages to proper handle methods
BEGIN_MSG_MAP(dia_SAFeatureFanStatistics,dia_SystemAdapterFeature)
   ON_MESSAGE(MIDW_DIAGLIBFI_C_U16_DIAGNOSISDATA, vHandleDiagnosisData)
END_MSG_MAP()

//------------------------------------------------------------------------------

dia_SAFeatureFanStatistics::dia_SAFeatureFanStatistics (
      tCString name,    // feature name
      dia_SystemAdapterServicePluginDiaglib& pSrvPlugin
   )
    : dia_SystemAdapterFeatureDiaglib(name,pSrvPlugin)
{
   dia_tclFnctTrace trc("dia_SAFeatureFanStatistics::dia_SAFeatureFanStatistics");
}

//-----------------------------------------------------------------------------

dia_SAFeatureFanStatistics::~dia_SAFeatureFanStatistics ( void )
{}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureFanStatistics::getDiaglibIDs ( std::list<tU32>& results ) const
{
   results.push_back(DATAID_FAN_STATISTICS);
   return DIA_SUCCESS;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureFanStatistics::getFanActivationStatistics( void )
{
    dia_tclFnctTrace oTrace("dia_SAFeatureFanStatistics::getFanActivationStatistics");

    tDiaResult retCode = DIA_FAILED;

    if (dia_SAFeatureDiaglib::bDiagDataReadStart(DATAID_FAN_STATISTICS, mpSrvPlugin) == TRUE)
    {
       retCode = DIA_SUCCESS;
       DIA_TR_INF("dia_SAFeatureFanStatistics::getFanActivationStatistics - bDiagDataReadStart - SUCCESS.");
    }
    else
    {
       DIA_TR_ERR("dia_SAFeatureFanStatistics::getFanActivationStatistics - bDiagDataReadStart - FAILED.");
    }

   return retCode;
}

//-----------------------------------------------------------------------------

void
dia_SAFeatureFanStatistics::vHandleDiagnosisData ( amt_tclServiceData* poMessage )
{
   dia_tclFnctTrace trc("dia_SAFeatureFanStatistics::vHandleDiagnosisData()");

   dia_SAFeatureDiaglib::u32EvalDiagnosisDataCtrlMessage( poMessage, this );
}

//-----------------------------------------------------------------------------

void dia_SAFeatureFanStatistics::vOnDiagnosisDataResult (
                                                        tU32 u32DiagnosisDataId,
                                                        tenDiagDataResult enResult,
                                                        const tDiaglibParamVector& oResult
                                                      )
{
   dia_tclFnctTrace trc("dia_SAFeatureFanStatistics::vOnDiagnosisDataResult");
   
   switch (u32DiagnosisDataId)
   {
	 case DATAID_FAN_STATISTICS:
	 {
		DIA_TR_INF("dia_SAFeatureFanStatistics::vOnDiagnosisDataResult => case: DATAID_FAN_STATISTICS");
		if ( enResult == EN_DIAGDATA_OK )
		{
		   DIA_TR_INF("dia_SAFeatureFanStatistics::vOnDiagnosisDataResult => enResult == EN_DIAGDATA_OK");
		   if( oResult.size() >= DATAID_FAN_STATISTICS_READ_RESULT_LEN)
		   {
			  tU16 u16FanActivationCounter = oResult[DATAID_FAN_STATISTICS_READ_RESULT_u16FanActivationCounter].u16Value;
			  tU16 u16FanActivationDuration = oResult[DATAID_FAN_STATISTICS_READ_RESULT_u16FanActivationDuration].u16Value;

			  dia_IFanStatisticsListener* pListener = OSAL_NULL;
			  if ((querySysAdapterListener<dia_IFanStatisticsListener>(&pListener) == DIA_SUCCESS) && pListener)
			  {
				 DIA_TR_INF("dia_SAFeatureFanStatistics::vOnDiagnosisDataResult => Call dia_IFanStatisticsListener");
			  
				 pListener->vOnFanActivationCounter(u16FanActivationCounter);
				 pListener->vOnFanActivationDuration(u16FanActivationDuration);				  
			  }
		   }
		   else
		   {
			  DIA_TR_ERR("!!! dia_SAFeatureFanStatistics::vOnDiagnosisDataResult => ERROR: Not Enough Data Available");
		   }
		}//if(enResult == EN_DIAGDATA_OK)
		else
		{
		   DIA_TR_INF("dia_SAFeatureFanStatistics::vOnDiagnosisDataResult => enResult != EN_DIAGDATA_OK");
		}// else //if(enRoutineStatus == EN_ROUTINE_CONTROL_NOT_OK)

		break;
	 }// case DATAID_FAN_STATISTICS:

	 default:
	 {
		DIA_TR_ERR("!!! dia_SAFeatureFanStatistics::vOnDiagnosisDataResult => ERROR: Unknown u32DiagnosisDataId=0x%x", u32DiagnosisDataId);
		DIA_ASSERT_ALWAYS();
		break;
	 }
   }// switch (u32DiagnosisDataId)
}

