/*!
 * \file       dia_SAFeatureErrorLogASF.h
 *
 * \brief      header file for dia_ASFComponentErrorLog
 *
 * \details    ASF component for Diaglog
 *
 * \component  Diagnosis
 *
 * \ingroup    diaASFComponents
 *
 * \copyright  (c) 2016 Robert Bosch GmbH
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */

#ifndef DIA_SAFEATUREERRORLOGASF_H_
#define DIA_SAFEATUREERRORLOGASF_H_


#ifndef ORG_BOSCH_CM_DIAGNOSIS_DBUS_DIAGLOGPROXY_H
#include <org/bosch/cm/diagnosis/dbus/DiaglogProxy.h>
#endif
#ifndef ORG_BOSCH_CM_DIAGNOSIS_DBUS_DIAGLOGCLIENTBASE_H
#include "org/bosch/cm/diagnosis/dbus/DiaglogClientBase.h"
#endif
#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FEATURE_ASF__
#include <common/framework/platform/asf/dia_SystemAdapterFeatureASF.h>
#endif

#ifndef __INCLUDED_DIA_INTERFACE_ERRORLOGASF_LISTENER__
#include <project/interfaces/dia_IErrorLogASFListener.h>
#endif

using namespace org::bosch::cm::diagnosis::dbus::Diaglog;



class dia_SAFeatureErrorLogASF
  : public dia_SystemAdapterFeatureASF<DiaglogProxy>,
	public DiaglogClientBase,
	public dia_IErrorLogASF
{
public:
	//! constructor
	dia_SAFeatureErrorLogASF (dia_SystemAdapterServicePluginASF<DiaglogProxy>& pSrvPlugin );

	//! destructor
	virtual ~dia_SAFeatureErrorLogASF();

	//! start monitoring of properties
	virtual tDiaResult startMonitoring();
	//! stop monitoring of properties
	virtual tDiaResult stopMonitoring();

	//-------------------------------------------------------------------------
	//
	// Overloaded dia_IPhoneConnectionSetting methods
	//
	//-------------------------------------------------------------------------
	virtual tDiaResult sendClearDTCRequest( tU8, tU32 );

	//-------------------------------------------------------------------------
	//
	// Overloaded PhoneConnectionDurationClientBase methods
	//
	//-------------------------------------------------------------------------
	virtual void onClearDTCError(const ::boost::shared_ptr< DiaglogProxy >& proxy, const ::boost::shared_ptr< ClearDTCError >& error);
	virtual void onClearDTCResponse(const ::boost::shared_ptr< DiaglogProxy >& proxy, const ::boost::shared_ptr< ClearDTCResponse >& response);
	virtual void onClearDTCResponse( tU8 status );

protected:
   //! deprecated default constructor
	dia_SAFeatureErrorLogASF ();
};

#endif /* DIA_SAFEATUREERRORLOGASF_H_ */
