/*!
 * \file       dia_SAFeatureErrorLogASF.cpp
 *
 * \brief      ASF component for Diaglog
 *
 * \details    ASF component for Diaglog
 *
 * \component  Diagnosis
 *
 * \ingroup    diaASFComponents
 *
 * \copyright  (c) 2016 Robert Bosch GmbH
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */

#include "dia_SAFeatureErrorLogASF.h"

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_SERVICE_PLUGIN_ASF__
#include <common/framework/platform/asf/dia_SystemAdapterServicePluginASF.h>
#endif


dia_SAFeatureErrorLogASF::dia_SAFeatureErrorLogASF (dia_SystemAdapterServicePluginASF<DiaglogProxy>& pSrvPlugin )
	: dia_SystemAdapterFeatureASF<DiaglogProxy>(pSrvPlugin)
{

}

//-----------------------------------------------------------------------------

dia_SAFeatureErrorLogASF::~dia_SAFeatureErrorLogASF()
{
	// TODO Auto-generated destructor stub
}

//-----------------------------------------------------------------------------


tDiaResult dia_SAFeatureErrorLogASF::startMonitoring()
{
   dia_tclFnctTrace trc("dia_SAFeatureErrorLogASF::startMonitoring");

   if( (mpSrvPlugin) && (mpSrvPlugin->getProxy())    )
   {
     // Register to properties
   }
   return DIA_SUCCESS;
}

//-----------------------------------------------------------------------------


tDiaResult dia_SAFeatureErrorLogASF::stopMonitoring()
{
   dia_tclFnctTrace trc("dia_SAFeatureErrorLogASF::stopMonitoring");

   if( (mpSrvPlugin) && (mpSrvPlugin->getProxy()))
   {
     // DeRegister properties
   }
   return DIA_SUCCESS;
}

//-----------------------------------------------------------------------------

tDiaResult dia_SAFeatureErrorLogASF::sendClearDTCRequest( tU8 group, tU32 DTCMask )
{
	dia_tclFnctTrace trc("dia_SAFeatureErrorLogASF::sendClearDTCRequest");

	tDiaResult retCode = DIA_FAILED;

	if ((mpSrvPlugin) && (mpSrvPlugin->getProxy()))
	{
	  act_t token = mpSrvPlugin->getProxy()->sendClearDTCRequest(*this, group, DTCMask); 
	  if (0!=token)
	  {
		 retCode = DIA_SUCCESS;
	  }
	}
	else
	{
	  DIA_TR_ERR("dia_SAFeatureErrorLogASF::sendClearDTCRequest. mpSrvPlugin or mpSrvPlugin->getProxy is NULL.");
	}

	DIA_TR_INF("dia_SAFeatureErrorLogASF::sendClearDTCRequest. returned %s", (DIA_SUCCESS==retCode? "SUCCESS": "FAILED"));

	return retCode;
}



//=============================================================================
//=============================================================================

tVoid dia_SAFeatureErrorLogASF::onClearDTCError(const ::boost::shared_ptr< DiaglogProxy >& proxy, const ::boost::shared_ptr< ClearDTCError >& error)
{
	 dia_tclFnctTrace trc("dia_SAFeatureErrorLogASF::onClearDTCError");

	 DIA_TR_ERR( "dia_SAFeatureErrorLogASF::onClearDTCError. ErrorName     = \"%s\"", error->getName().c_str() );
	 DIA_TR_ERR( "dia_SAFeatureErrorLogASF::onClearDTCError. ErrorMessage  = \"%s\"", error->getMessage().c_str() );
}

//-----------------------------------------------------------------------------

void dia_SAFeatureErrorLogASF::onClearDTCResponse(const ::boost::shared_ptr< DiaglogProxy >& proxy, const ::boost::shared_ptr< ClearDTCResponse >& response)
{
	dia_tclFnctTrace trc("dia_SAFeatureErrorLogASF::onClearDTCResponse");

	tU8 status = response->getStatus();
	DIA_TR_INF("dia_SAFeatureErrorLogASF::onClearDTCResponse status '%d'", status);

	getInstanceOfApplication()->postMessage(
		 OSAL_NEW dia_tclDiagSession::tclEventIntMsgRxGeneric (
			   OSAL_NEW dia_FunctorOneArgNoReturnValue<dia_SAFeatureErrorLogASF, tU8>(this, &dia_SAFeatureErrorLogASF::onClearDTCResponse, status)
		 )
	);
}

//-----------------------------------------------------------------------------

void dia_SAFeatureErrorLogASF::onClearDTCResponse( tU8 status )
{
	dia_tclFnctTrace trc("dia_SAFeatureErrorLogASF::onClearDTCResponse(tU8)");

	DIA_TR_INF("dia_SAFeatureErrorLogASF::onClearDTCResponse(tU8): status: '%d'", status);
	dia_IErrorLogASFListener* pListener = 0;
	if ((querySysAdapterListener<dia_IErrorLogASFListener>(&pListener) == DIA_SUCCESS) && pListener)
	{
		pListener->vOnClearDTCResp(status);
	}
	else
	{
	  DIA_TR_WRN("dia_SAFeatureErrorLogASF::onClearDTCResponse. querySysAdapterListener dia_IErrorLogASFListener NULL");
	}
}

