/*
 * dia_SAFeatureDimmingControl.h
 *
 *  Created on: 09.01.2012
 *      Author: gib2hi
 *
 *
 * -----------------------------------------------------------------------------------
 * Date 			| Author			 | Modification                               |
 * 01.12.15    		| sbr5kor	  		 | AIVI-12208 & CMG3G-8222                    |
 * ------------------------------------------------------------------------------------
 */

#ifndef __INCLUDED_DIA_SAFEATURE_DIMMING_CONTROL__
#define __INCLUDED_DIA_SAFEATURE_DIMMING_CONTROL__

#ifndef __INCLUDED_DIA_DIAGLIB_IOCONTROL_LISTENER__
#include "common/depricated/SystemAdapter/dia_IDiaglibIoControlListener.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_DIMMING_CONTROL_LISTENER__
#include "common/interfaces/dia_IDimmingControlListener.h"
#endif

using namespace std;

//-----------------------------------------------------------------------------
// class definition
//-----------------------------------------------------------------------------

class dia_SAFeatureDimmingControl
   : public dia_SystemAdapterFeatureDiaglib,
     public dia_IDimmingControl,
     public dia_IDiaglibIoControlListener
{
public:
   //! constructor
   dia_SAFeatureDimmingControl ( tCString name, dia_SystemAdapterServicePluginDiaglib& pSrvPlugin );

   //! destructor
   virtual ~dia_SAFeatureDimmingControl ( void );

   //! return the diaglib IDs managed by this feature
   virtual tDiaResult getDiaglibIDs ( std::list<tU32>& results ) const;

   // receive functions
   virtual tVoid vOnIoCtrlResult(tU32 u32IoCtrlId, tenIoCtrlResult enResult, tenIoControlAction enActionId, const tDiaglibParamVector& oStartResult);

   //-------------------------------------------------------------------------
   //
   // Overloaded dia_IDimming methods
   //
   //-------------------------------------------------------------------------

   //! Asynchronous request to set key illumination brightness
   virtual tDiaResult setKeyIlluminationBrightness ( const tU16 brightness );
   virtual tDiaResult freezeKeyIlluminationBrightness(tBool bFreeze);

   //! set display brightness
   virtual tDiaResult setDisplayBrightness ( tU16 pwmValue );
   virtual tDiaResult freezeDisplayBrightness(tBool bFreeze);

    /**
    * \brief   Asynchronous request to set key illumination brightness pwm
    *          param u16Brightness key illumination brightness to set
    *          return tDiaResult DIA_SUCCESS or DIA_FAILED depending on message was sent successfully			   
    *          */
   virtual tDiaResult setKeyIlluminationPWM ( const tU16 brightness );
   virtual tDiaResult freezeKeyIlluminationPWM(tBool bFreeze);

protected:
   //! deprecated default constructor
   dia_SAFeatureDimmingControl ( void );

   //! handle incoming CCA message
   tVoid vHandleIOControl ( amt_tclServiceData* poMessage );

   // declare message map data structures
   DECLARE_MSG_MAP(dia_SAFeatureDimmingControl)
};

#endif /* __INCLUDED_DIA_SAFEATURE_DIMMING_CONTROL__ */
