/*
 * dia_SAFeatureDimming.cpp
 *
 *  Created on: 09.01.2012
 *      Author: gib2hi
 */
/*-----------------------------------------------------------------------------------------------------
* Date           | Author                              | Modification
* 18.06.2014     | Jeba Satheesh (jse5kor )            | Implementation changed from property to method
*
* 01.12.15    	 | sbr5kor	  		                   | AIVI-12208 & CMG3G-8222                      |
*******************************************************************************************************/
#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#ifndef __INCLUDED_DIA_COMMON_SYSTEM_ADAPTERS__
#include "common/framework/sysadapters/dia_common_system_adapters.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_DIMMING_LISTENER__
#include "common/interfaces/dia_IDimmingListener.h"
#endif

#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include "generic_msgs_if.h" //lint !e451 !e537 repeatedly included header file without standard include guard

#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIMMINGFI_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIMMINGFI_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIMMINGFI_SERVICEINFO
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "midw_fi_if.h" //lint !e451 !e537 repeatedly included header file without standard include guard

#define DIMMING_FI_S_IMPORT_INTERFACE_DIMMING_MAINFI_TYPES
#define DIMMING_FI_S_IMPORT_INTERFACE_DIMMING_MAINFI_FUNCTIONIDS
#define DIMMING_FI_S_IMPORT_INTERFACE_DIMMING_MAINFI_SERVICEINFO
#include "dimming_fi_if.h"

#include "dia_SAFeatureDimming.h"

/// MESSAGE MAP:
// The message map maps IDs of incoming CCA messages to proper handle methods
BEGIN_MSG_MAP(dia_SAFeatureDimming,dia_SystemAdapterFeature)
   //ON_MESSAGE(MIDW_DIMMINGFI_C_U16_DIM_DIAG_GETBUTTONILLUMINATIONVALUE,vHandleDimmingInformation) // Not required for Gen3
   ON_MESSAGE(MIDW_DIMMINGFI_C_U16_DIM_KEYB_BRIGHTNESS,vHandleKeyBBrightnessInformation)
   ON_MESSAGE(MIDW_DIMMINGFI_C_U16_DIM_INFO_GETDIMMINGBRIGHTNESS,vHandleDispBrightnessInformation)
  // ON_MESSAGE(MIDW_DIMMINGFI_C_U16_DIM_DISP_PANELTEMPERATURE,vHandleDispPanelTempInformation)
  // ON_MESSAGE(MIDW_DIMMINGFI_C_U16_DIM_KEYB_HALFCLASS,vHandleDimmingHalfClassInformation)
  // ON_MESSAGE(MIDW_DIMMINGFI_C_U16_FI_VD_DIMMING_LIGHT_SENSOR,vHandleLightSensorStatus)
  // ON_MESSAGE(MIDW_DIMMINGFI_C_U16_FI_VD_DIMMING_MODE,vHandleDayNightMode)
   ON_MESSAGE(MIDW_DIMMINGFI_C_U16_DIM_KEYB_SETDIMMING,vHandleSetKeyIllumBrightnessInfo)
   ON_MESSAGE(MIDW_DIMMINGFI_C_U16_DIM_KEYB_SETDIMMINGPWM,vHandleSetKeyIllumPwmBrightnessInfo)
   ON_MESSAGE(MIDW_DIMMINGFI_C_U16_DIM_INFO_SETDIMMINGBRIGHTNESS,vHandleSetBrightnessStatus)
   ON_MESSAGE(MIDW_DIMMINGFI_C_U16_DIM_INFO_SETEMULATIONMODE,vHandleEmulationModeResult)
   //ON_MESSAGE(MIDW_DIMMINGFI_C_U16_DIM_DISP_BRIGHTNESSLEVEL,vHandleDispBrightnessLevelInformation)
   //ON_MESSAGE(MIDW_DIMMINGFI_C_U16_DIM_DISP_SETBRIGHTNESSLEVEL,vHandleSetBrightnessLevelStatus)
//   ON_MESSAGE(MIDW_DIMMINGFI_C_U16_DIM_INFO_PWMBRIGHTNESS,vHandlePWMBrightness)
   ON_MESSAGE(MIDW_DIMMINGFI_C_U16_DIM_INFO_DIMMINGMODE, vHandleDimmingState)
   ON_MESSAGE(MIDW_DIMMINGFI_C_U16_DIM_INFO_CARILLUMINATIONDATA,vHandleIlluminationData)
   ON_MESSAGE(MIDW_DIMMINGFI_C_U16_DIM_DISP_BRIGHTNESS,vHandleReadBackLightIllumination)
   ON_MESSAGE(MIDW_DIMMINGFI_C_U16_DIM_DISP_SETDIMMING,vHandleSetBackLightIllumination)
   ON_MESSAGE(DIMMING_MAINFI_C_U16_DIM_INFO_GETPWMBRIGHTNESS,vHandlePWMBrightness)
END_MSG_MAP()

//------------------------------------------------------------------------------

dia_SAFeatureDimming::dia_SAFeatureDimming (
      tCString name,    // feature name
      dia_SystemAdapterServicePlugin& pSrvPlugin
   )
    : dia_SystemAdapterFeature(name,pSrvPlugin)
{
   dia_tclFnctTrace trc("dia_SAFeatureDimming::dia_SAFeatureDimming");
}

//-----------------------------------------------------------------------------

dia_SAFeatureDimming::~dia_SAFeatureDimming ( void )
{}

//-----------------------------------------------------------------------------
#if 0 // not supported in Gen3
tDiaResult
dia_SAFeatureDimming::getWireDimmingInformation ( void )
{
    dia_tclFnctTrace trc("dia_SAFeatureDimming::getWireDimmingInformation()");

    tDiaResult retCode = DIA_FAILED;

    if ( mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID )
    {
   	 DIA_TR_INF("dia_SAFeatureDimming::getWireDimmingInformation - send message.");

	  midw_dimmingfi_tclMsgDIM_DIAG_GetButtonIlluminationValueMethodStart oMsgData;
      fi_tclVisitorMessage oMessage(oMsgData);
	  mpSrvPlugin->vInitServiceData(oMessage, MIDW_DIMMINGFI_C_U16_DIM_DIAG_GETBUTTONILLUMINATIONVALUE, AMT_C_U8_CCAMSG_OPCODE_METHODSTART);

       if ( mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE ){
      	 retCode = DIA_SUCCESS;
      	 DIA_TR_INF("dia_SAFeatureDimming::getWireDimmingInformation - transmitMessage success.");
       } else {
      	 DIA_TR_INF("dia_SAFeatureDimming::getWireDimmingInformation - transmitMessage failed.");
       }
    } else {
   	 DIA_TR_INF("dia_SAFeatureDimming::getWireDimmingInformation - getRegistrationID failed.");
   	 DIA_TR_INF("dia_SAFeatureDimming::getWireDimmingInformation - getRegistrationID == AMT_C_U16_REGID_INVALID.");
    }

    return retCode;
}
#endif
//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureDimming::getKeyBBrightnessInformation ( void )
{
    dia_tclFnctTrace trc("dia_SAFeatureDimming::getKeyBBrightnessInformation()");

    tDiaResult retCode = DIA_FAILED;

    if ( mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID )
    {
   	 DIA_TR_INF("dia_SAFeatureDimming::getKeyBBrightnessInformation - send message.");
   	 gm_tclEmptyMessage oMessage (
          mAppID,
          mpSrvPlugin->getClientID(),
          mpSrvPlugin->getRegistrationID(),
          0,
          mpSrvPlugin->getServiceID(),
          MIDW_DIMMINGFI_C_U16_DIM_KEYB_BRIGHTNESS,
          CCA_C_U8_OPCODE_GET
       );

       if ( mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE ){
      	 retCode = DIA_SUCCESS;
      	 DIA_TR_INF("dia_SAFeatureDimming::getKeyBBrightnessInformation - transmitMessage success.");
       } else {
      	 DIA_TR_INF("dia_SAFeatureDimming::getKeyBBrightnessInformation - transmitMessage failed.");
       }
    } else {
   	 DIA_TR_INF("dia_SAFeatureDimming::getKeyBBrightnessInformation - getRegistrationID failed.");
   	 DIA_TR_INF("dia_SAFeatureDimming::getKeyBBrightnessInformation - getRegistrationID == AMT_C_U16_REGID_INVALID.");
    }

    return retCode;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureDimming::getDisplIlluminationMode ( void )
{
    dia_tclFnctTrace trc("dia_SAFeatureDimming::getDisplIlluminationMode()");

    tDiaResult retCode = DIA_FAILED;

    if ( mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID )
    {
       DIA_TR_INF("dia_SAFeatureDimming::getDisplIlluminationMode - send message.");
       gm_tclEmptyMessage oMessage (
          mAppID,
          mpSrvPlugin->getClientID(),
          mpSrvPlugin->getRegistrationID(),
          0,
          mpSrvPlugin->getServiceID(),
          MIDW_DIMMINGFI_C_U16_DIM_INFO_DIMMINGMODE,
          CCA_C_U8_OPCODE_GET
       );

       if ( mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE ){
          retCode = DIA_SUCCESS;
          DIA_TR_INF("dia_SAFeatureDimming::getDisplIlluminationMode - transmitMessage success.");
       } else {
          DIA_TR_INF("dia_SAFeatureDimming::getDisplIlluminationMode - transmitMessage failed.");
       }
    } else {
       DIA_TR_INF("dia_SAFeatureDimming::getDisplIlluminationMode - getRegistrationID failed.");
       DIA_TR_INF("dia_SAFeatureDimming::getDisplIlluminationMode - getRegistrationID == AMT_C_U16_REGID_INVALID.");
    }

    return retCode;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureDimming::getDispBrightnessInformation ( void )
{
    dia_tclFnctTrace trc("dia_SAFeatureDimming::getDispBrightnessInformation()");

    tDiaResult retCode = DIA_FAILED;

    if ( mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID )
    {
   	 DIA_TR_INF("dia_SAFeatureDimming::getDispBrightnessInformation - send message.");
       gm_tclEmptyMessage oMessage (
          mAppID,
          mpSrvPlugin->getClientID(),
          mpSrvPlugin->getRegistrationID(),
          0,
          mpSrvPlugin->getServiceID(),
          MIDW_DIMMINGFI_C_U16_DIM_DISP_BRIGHTNESS,
          CCA_C_U8_OPCODE_GET
       );

       if ( mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE ){
      	 retCode = DIA_SUCCESS;
      	 DIA_TR_INF("dia_SAFeatureDimming::getDispBrightnessInformation - transmitMessage success.");
       } else {
      	 DIA_TR_INF("dia_SAFeatureDimming::getDispBrightnessInformation - transmitMessage failed.");
       }
    } else {
   	 DIA_TR_INF("dia_SAFeatureDimming::getDispBrightnessInformation - getRegistrationID failed.");
   	 DIA_TR_INF("dia_SAFeatureDimming::getDispBrightnessInformation - getRegistrationID == AMT_C_U16_REGID_INVALID.");
    }

    return retCode;
}

/*//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureDimming::getDispBrightnessInformation ( void )
{
    dia_tclFnctTrace trc("dia_SAFeatureDimming::getDispBrightnessInformation()");

    tDiaResult retCode = DIA_FAILED;

    if ( mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID )
    {
   	 DIA_TR_INF("dia_SAFeatureDimming::getDispBrightnessInformation - send message.");

	  midw_dimmingfi_tclMsgDIM_INFO_GetDimmingBrightnessMethodStart oMsgData;
      fi_tclVisitorMessage oMessage(oMsgData);
	  mpSrvPlugin->vInitServiceData(oMessage, MIDW_DIMMINGFI_C_U16_DIM_INFO_GETDIMMINGBRIGHTNESS, AMT_C_U8_CCAMSG_OPCODE_METHODSTART);


       if ( mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE ){
      	 retCode = DIA_SUCCESS;
      	 DIA_TR_INF("dia_SAFeatureDimming::getDispBrightnessInformation - transmitMessage success.");
       } else {
      	 DIA_TR_INF("dia_SAFeatureDimming::getDispBrightnessInformation - transmitMessage failed.");
       }
    } else {
   	 DIA_TR_INF("dia_SAFeatureDimming::getDispBrightnessInformation - getRegistrationID failed.");
   	 DIA_TR_INF("dia_SAFeatureDimming::getDispBrightnessInformation - getRegistrationID == AMT_C_U16_REGID_INVALID.");
    }

    return retCode;
}*/

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureDimming::getDimmingPWM ( void )
{
    dia_tclFnctTrace trc("dia_SAFeatureDimming::getDimmingPWM()");

    tDiaResult retCode = DIA_FAILED;

    if ( mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID )
    {
       DIA_TR_INF("dia_SAFeatureDimming::getDimmingPWM - send message.");
       gm_tclEmptyMessage oMessage (
          mAppID,
          mpSrvPlugin->getClientID(),
          mpSrvPlugin->getRegistrationID(),
          0,
          mpSrvPlugin->getServiceID(),
          DIMMING_MAINFI_C_U16_DIM_INFO_GETPWMBRIGHTNESS,
          AMT_C_U8_CCAMSG_OPCODE_METHODSTART
       );

       if ( mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE ){
          retCode = DIA_SUCCESS;
          DIA_TR_INF("dia_SAFeatureDimming::getDimmingPWM - transmitMessage success.");
       } else {
          DIA_TR_INF("dia_SAFeatureDimming::getDimmingPWM - transmitMessage failed.");
       }
    } else {
       DIA_TR_INF("dia_SAFeatureDimming::getDimmingPWM - getRegistrationID failed.");
       DIA_TR_INF("dia_SAFeatureDimming::getDimmingPWM - getRegistrationID == AMT_C_U16_REGID_INVALID.");
    }

    return retCode;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureDimming::getIlluminationStatus ( void )
{
    dia_tclFnctTrace trc("dia_SAFeatureDimming::getIlluminationStatus()");

    tDiaResult retCode = DIA_FAILED;

    if ( mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID )
    {
       DIA_TR_INF("dia_SAFeatureDimming::getIlluminationStatus - send message.");
       gm_tclEmptyMessage oMessage (
          mAppID,
          mpSrvPlugin->getClientID(),
          mpSrvPlugin->getRegistrationID(),
          0,
          mpSrvPlugin->getServiceID(),
          MIDW_DIMMINGFI_C_U16_DIM_INFO_CARILLUMINATIONDATA,
          CCA_C_U8_OPCODE_GET
       );

       if ( mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE ){
          retCode = DIA_SUCCESS;
          DIA_TR_INF("dia_SAFeatureDimming::getIlluminationStatus - transmitMessage success.");
       } else {
          DIA_TR_INF("dia_SAFeatureDimming::getIlluminationStatus - transmitMessage failed.");
       }
    } else {
       DIA_TR_INF("dia_SAFeatureDimming::getIlluminationStatus - getRegistrationID failed.");
       DIA_TR_INF("dia_SAFeatureDimming::getIlluminationStatus - getRegistrationID == AMT_C_U16_REGID_INVALID.");
    }

    return retCode;
}


//-----------------------------------------------------------------------------
#if 0 //function needs to be removed
tDiaResult
dia_SAFeatureDimming::getDispPanelTempInformation ( void )
{
    dia_tclFnctTrace trc("dia_SAFeatureDimming::getDispPanelTempInformation()");

    tDiaResult retCode = DIA_FAILED;

    if ( mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID )
    {
   	 DIA_TR_INF("dia_SAFeatureDimming::getDispPanelTempInformation - send message.");
   	 gm_tclEmptyMessage oMessage (
          mAppID,
          mpSrvPlugin->getClientID(),
          mpSrvPlugin->getRegistrationID(),
          0,
          mpSrvPlugin->getServiceID(),
          MIDW_DIMMINGFI_C_U16_DIM_DISP_PANELTEMPERATURE,
          CCA_C_U8_OPCODE_GET
       );

       if ( mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE ){
      	 retCode = DIA_SUCCESS;
      	 DIA_TR_INF("dia_SAFeatureDimming::getDispPanelTempInformation - transmitMessage success.");
       } else {
      	 DIA_TR_INF("dia_SAFeatureDimming::getDispPanelTempInformation - transmitMessage failed.");
       }
    } else {
   	 DIA_TR_INF("dia_SAFeatureDimming::getDispPanelTempInformation - getRegistrationID failed.");
   	 DIA_TR_INF("dia_SAFeatureDimming::getDispPanelTempInformation - getRegistrationID == AMT_C_U16_REGID_INVALID.");
    }

    return retCode;
}
#endif
//-----------------------------------------------------------------------------

#if 0 //function needs to be removed
tDiaResult
dia_SAFeatureDimming::getDimmingHalfClassInformation ( void )
{
    dia_tclFnctTrace trc("dia_SAFeatureDimming::getDimmingHalfClassInformation()");

    tDiaResult retCode = DIA_FAILED;

    if ( mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID )
    {
   	 DIA_TR_INF("dia_SAFeatureDimming::getDimmingHalfClassInformation - send message.");
   	 gm_tclEmptyMessage oMessage (
          mAppID,
          mpSrvPlugin->getClientID(),
          mpSrvPlugin->getRegistrationID(),
          0,
          mpSrvPlugin->getServiceID(),
          MIDW_DIMMINGFI_C_U16_DIM_KEYB_HALFCLASS,
          CCA_C_U8_OPCODE_GET
       );

       if ( mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE ){
      	 retCode = DIA_SUCCESS;
      	 DIA_TR_INF("dia_SAFeatureDimming::getDimmingHalfClassInformation - transmitMessage success.");
       } else {
      	 DIA_TR_INF("dia_SAFeatureDimming::getDimmingHalfClassInformation - transmitMessage failed.");
       }
    } else {
   	 DIA_TR_INF("dia_SAFeatureDimming::getDimmingHalfClassInformation - getRegistrationID failed.");
   	 DIA_TR_INF("dia_SAFeatureDimming::getDimmingHalfClassInformation - getRegistrationID == AMT_C_U16_REGID_INVALID.");
    }

    return retCode;
}
#endif
//-----------------------------------------------------------------------------

#if 0 //function needs to be removed
tDiaResult
dia_SAFeatureDimming::getDimmingStatus ( void )
{
    dia_tclFnctTrace trc("dia_SAFeatureDimming::getDimmingStatus()");

    tDiaResult retCode = DIA_FAILED;

    if ( mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID )
    {
   	 DIA_TR_INF("dia_SAFeatureDimming::getDimmingStatus - send message.");
   	 gm_tclEmptyMessage oMessage (
          mAppID,
          mpSrvPlugin->getClientID(),
          mpSrvPlugin->getRegistrationID(),
          0,
          mpSrvPlugin->getServiceID(),
          MIDW_DIMMINGFI_C_U16_FI_VD_DIMMING_STATE,
          CCA_C_U8_OPCODE_GET
       );

       if ( mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE ){
      	 retCode = DIA_SUCCESS;
      	 DIA_TR_INF("dia_SAFeatureDimming::getDimmingStatus - transmitMessage success.");
       } else {
      	 DIA_TR_INF("dia_SAFeatureDimming::getDimmingStatus - transmitMessage failed.");
       }
    } else {
   	 DIA_TR_INF("dia_SAFeatureDimming::getDimmingStatus - getRegistrationID failed.");
   	 DIA_TR_INF("dia_SAFeatureDimming::getDimmingStatus - getRegistrationID == AMT_C_U16_REGID_INVALID.");
    }

    return retCode;
}
#endif
//-----------------------------------------------------------------------------
#if 0 //function needs to be removed
tDiaResult
dia_SAFeatureDimming::getLightSensorStatus ( void )
{
   dia_tclFnctTrace trc("dia_SAFeatureDimming::getLightSensorStatus");

   tDiaResult retCode = DIA_FAILED;

   if ( mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID )
   {
      gm_tclEmptyMessage oMessage (
         mAppID,
         mpSrvPlugin->getClientID(),
         mpSrvPlugin->getRegistrationID(),
         0,
         mpSrvPlugin->getServiceID(),
         MIDW_DIMMINGFI_C_U16_FI_VD_DIMMING_LIGHT_SENSOR,
         CCA_C_U8_OPCODE_GET
      );

      if ( mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE ) retCode = DIA_SUCCESS;
   }

   return retCode;
}
#endif
//else if(CCA_C_U8_OPCODE_SET == _u8OpCode )
//{
//    gm_tclU32Message oMessage(  DIA_USED_APP_ID,
//                                CCA_C_U16_APP_VD_DIMMING,
//                                _u16RegID,
//                                0,
//                                CCA_C_U16_SRV_VD_DIMMING,
//                                _u16FID,
//                                CCA_C_U8_OPCODE_SET);
//
//    oMessage.vSetDWord(u32Data);
//
//    bRetVal = bTransmitMessage(&oMessage);
//}

//-----------------------------------------------------------------------------
#if 0 //function needs to be removed
tDiaResult
dia_SAFeatureDimming::setDayAndNightMode ( tU8 mode )
{
   dia_tclFnctTrace trc("dia_SAFeatureDimming::setDayAndNightMode");

   tDiaResult retCode = DIA_FAILED;

   if ( mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID )
   {
      gm_tclU8Message oMessage (
         mAppID,
         mpSrvPlugin->getClientID(),
         mpSrvPlugin->getRegistrationID(),
         0,
         mpSrvPlugin->getServiceID(),
         MIDW_DIMMINGFI_C_U16_FI_VD_DIMMING_MODE,
         CCA_C_U8_OPCODE_SET
      );
      oMessage.vSetByte(mode);

      if ( mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE ) retCode = DIA_SUCCESS;
   }

   return retCode;
}
#endif
//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureDimming::dia_setKeyIlluminationBrightness( const tU16 brightness )
{
    dia_tclFnctTrace oTrace("dia_SAFeatureDimming::dia_setKeyIlluminationBrightness");

    tDiaResult retCode = DIA_FAILED;

    if ( mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID )
    {
       midw_dimmingfi_tclMsgDIM_KEYB_SetDimmingMethodStart oData;
       oData.Brightness.u16Value = brightness;

       // put the data in message
       fi_tclVisitorMessage oMsg(oData);
       mpSrvPlugin->vInitServiceData(oMsg, MIDW_DIMMINGFI_C_U16_DIM_KEYB_SETDIMMING, AMT_C_U8_CCAMSG_OPCODE_METHODSTART);

       if ( mpSrvPlugin->bTransmitMessage(&oMsg) == TRUE ){
      	 retCode = DIA_SUCCESS;
      	 DIA_TR_INF("dia_SAFeatureDimming::dia_setKeyIlluminationBrightness - DIA_SUCCESS");
       } else {
      	 DIA_TR_INF("dia_SAFeatureDimming::dia_setKeyIlluminationBrightness - DIA_FAILED");
       }
    } else {
   	 DIA_TR_INF("mpSrvPlugin->getRegistrationID() FAILED.");
    }

    return retCode;
}

//-----------------------------------------------------------------------------

tDiaResult 
dia_SAFeatureDimming::setEmulationMode ( tU8 u8Mode )
{
   dia_tclFnctTrace trc("dia_SAFeatureDimming::setEmulationMode");

   static midw_fi_tcl_e8_DIM_EmulationMode::tenType sModeMapping[DIA_EN_DIM_EMULATION_MODE_COUNT] = {
         midw_fi_tcl_e8_DIM_EmulationMode::FI_EN_OFF,          // DIA_EN_DIM_EMULATION_MODE_UNKNOWN
         midw_fi_tcl_e8_DIM_EmulationMode::FI_EN_OFF,          // DIA_EN_DIM_EMULATION_MODE_OFF
         midw_fi_tcl_e8_DIM_EmulationMode::FI_EN_KEYBFREEZE,   // DIA_EN_DIM_EMULATION_MODE_KEYBFREEZE
         midw_fi_tcl_e8_DIM_EmulationMode::FI_EN_DISPFREEZE,   // DIA_EN_DIM_EMULATION_MODE_DISPFREEZE
         midw_fi_tcl_e8_DIM_EmulationMode::FI_EN_SETUP,        // DIA_EN_DIM_EMULATION_MODE_SETUP
         midw_fi_tcl_e8_DIM_EmulationMode::FI_EN_VERIFY        // DIA_EN_DIM_EMULATION_MODE_VERIFY
   };

   tDiaResult retCode = DIA_FAILED;

   if ( mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID )
   {
      midw_dimmingfi_tclMsgDIM_INFO_SetEmulationModeMethodStart oData;
      oData.EmulationMode.enType = sModeMapping[u8Mode]; //(midw_fi_tcl_e8_DIM_EmulationMode::tenType) u8Mode;

      //put the data in message
      fi_tclVisitorMessage oMsg(oData);
      mpSrvPlugin->vInitServiceData(oMsg, MIDW_DIMMINGFI_C_U16_DIM_INFO_SETEMULATIONMODE, AMT_C_U8_CCAMSG_OPCODE_METHODSTART);

      if ( mpSrvPlugin->bTransmitMessage(&oMsg) == TRUE ){
         retCode = DIA_SUCCESS;
         DIA_TR_INF("dia_SAFeatureDimming::::setEmulationMode - DIA_SUCCESS");
      }
      else {
         DIA_TR_INF("dia_SAFeatureDimming::::setEmulationMode - DIA_FAILED");
      }
   }
   else {
      DIA_TR_INF("mpSrvPlugin->getRegistrationID() FAILED.");
   }

   return retCode;
}

//-----------------------------------------------------------------------------

tDiaResult 
dia_SAFeatureDimming::setDisplayBrightness ( tU16 pwmValue )
{
	dia_tclFnctTrace trc("dia_SAFeatureDimming::setDisplayBrightness");

	tDiaResult retCode = DIA_FAILED;

	if ( mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID )
    {
		midw_dimmingfi_tclMsgDIM_DISP_SetDimmingMethodStart oData;
       oData.Brightness.u16Value = pwmValue;

       //put the data in message
       fi_tclVisitorMessage oMsg(oData);
       mpSrvPlugin->vInitServiceData(oMsg, MIDW_DIMMINGFI_C_U16_DIM_DISP_SETDIMMING, AMT_C_U8_CCAMSG_OPCODE_METHODSTART);

       if ( mpSrvPlugin->bTransmitMessage(&oMsg) == TRUE ){
      	 retCode = DIA_SUCCESS;
      	 DIA_TR_INF("dia_SAFeatureDimming::::setDisplayBrightness - DIA_SUCCESS");
       } else {
      	 DIA_TR_INF("dia_SAFeatureDimming::::setDisplayBrightness - DIA_FAILED");
       }
    } else {
   	 DIA_TR_INF("mpSrvPlugin->getRegistrationID() FAILED.");
    }

	return retCode;
}
/*//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureDimming::setDisplayBrightness ( tU16 pwmValue )
{
	dia_tclFnctTrace trc("dia_SAFeatureDimming::setDisplayBrightness");

	tDiaResult retCode = DIA_FAILED;

	if ( mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID )
    {
       midw_dimmingfi_tclMsgDIM_INFO_SetDimmingBrightnessMethodStart oData;
       oData.Brightness.u16Value = pwmValue;

       //put the data in message
       fi_tclVisitorMessage oMsg(oData);
       mpSrvPlugin->vInitServiceData(oMsg, MIDW_DIMMINGFI_C_U16_DIM_INFO_SETDIMMINGBRIGHTNESS, AMT_C_U8_CCAMSG_OPCODE_METHODSTART);

       if ( mpSrvPlugin->bTransmitMessage(&oMsg) == TRUE ){
      	 retCode = DIA_SUCCESS;
      	 DIA_TR_INF("dia_SAFeatureDimming::::setDisplayBrightness - DIA_SUCCESS");
       } else {
      	 DIA_TR_INF("dia_SAFeatureDimming::::setDisplayBrightness - DIA_FAILED");
       }
    } else {
   	 DIA_TR_INF("mpSrvPlugin->getRegistrationID() FAILED.");
    }

	return retCode;
}*/


//-----------------------------------------------------------------------------
#if 0 //function needs to be removed
tDiaResult
dia_SAFeatureDimming::getDayAndNightMode ( void )
{
   dia_tclFnctTrace trc("dia_SAFeatureDimming::getDayAndNightMode");

   tDiaResult retCode = DIA_FAILED;

   if ( mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID )
   {
      gm_tclEmptyMessage oMessage (
         mAppID,
         mpSrvPlugin->getClientID(),
         mpSrvPlugin->getRegistrationID(),
         0,
         mpSrvPlugin->getServiceID(),
         MIDW_DIMMINGFI_C_U16_FI_VD_DIMMING_MODE,
         CCA_C_U8_OPCODE_GET
      );

      if ( mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE ) retCode = DIA_SUCCESS;
   }

   return retCode;
}
#endif
/*ADDED: rva5cob*/
//! get the current active keyboard illumination pwm
tDiaResult
dia_SAFeatureDimming::getKeyBPwmInformation ( void  )
{
	return DIA_FAILED;
}

/******************************************************************************
* FUNCTION:    dia_setKeyIlluminationPWM
*
* DESCRIPTION: send CCA MethodStart message to set key illumination
*
* PARAMETER:   const tU16 - brightness level
*
* RETURNVALUE: TRUE  - post message to Dimming without error
*              FALSE - post message to Dimming server failed
*
******************************************************************************/

tDiaResult
dia_SAFeatureDimming::dia_setKeyIlluminationPWM ( const tU16 brightness )
{
    dia_tclFnctTrace oTrace("dia_SAFeatureDimming::dia_setKeyIlluminationPWM");

    tDiaResult retCode = DIA_FAILED;

    if ( mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID )
    {
       midw_dimmingfi_tclMsgDIM_KEYB_SetDimmingPWMMethodStart oData;
       oData.Brightness.u16Value = brightness;

       // put the data in message
       fi_tclVisitorMessage oMsg(oData);
       mpSrvPlugin->vInitServiceData(oMsg, MIDW_DIMMINGFI_C_U16_DIM_KEYB_SETDIMMINGPWM, AMT_C_U8_CCAMSG_OPCODE_METHODSTART);

       if ( mpSrvPlugin->bTransmitMessage(&oMsg) == TRUE ){
      	 retCode = DIA_SUCCESS;
      	 DIA_TR_INF("dia_SAFeatureDimming::dia_setKeyIlluminationPWM - DIA_SUCCESS");
       } else {
      	 DIA_TR_INF("dia_SAFeatureDimming::dia_setKeyIlluminationPWM - DIA_FAILED");
       }
    } else {
   	 DIA_TR_INF("mpSrvPlugin->getRegistrationID() FAILED.");
    }

    return retCode;
}


//-----------------------------------------------------------------------------
#if 0
void
dia_SAFeatureDimming::vHandleLightSensorStatus ( amt_tclServiceData* poMessage ) const
{
   dia_tclFnctTrace trc("dia_SAFeatureDimming::getLightSensorStatus");

   if ( poMessage )
   {
      DIA_ASSERT(poMessage->bIsServerMessage() == TRUE);

      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS )
      {
         dia_IDimmingListener* pListener = OSAL_NULL;
         querySysAdapterListener<dia_IDimmingListener>(&pListener);
         if ( pListener )
         {
            fi_tclVisitorMessage oResultMsg(poMessage);
            midw_dimmingfi_tclMsgFI_VD_DIMMING_LIGHT_SENSORStatus oCompResp;
            (void) oResultMsg.s32GetData(oCompResp);
            pListener->vOnLightSensorStatus((tU16) oCompResp.LightSensor);
         }
      }
      else if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_ERROR )
      {
           amt_tclServiceDataError oErrorMsg( poMessage );
           tU16 u16ErrorCode = oErrorMsg.u16GetErrorData();
           DIA_TR_ERR( "---opcode error recievd with error code: 0x%04x", u16ErrorCode);
      }

      (void) poMessage->bDelete();
   }
}
#endif
//-----------------------------------------------------------------------------
#if 0
void
dia_SAFeatureDimming::vHandleDayNightMode ( amt_tclServiceData* poMessage ) const
{
   dia_tclFnctTrace trc("dia_SAFeatureDimming::vHandleDayNightMode");

   if ( poMessage )
   {
      DIA_ASSERT(poMessage->bIsServerMessage() == TRUE);

      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS )
      {
         dia_IDimmingListener* pListener = OSAL_NULL;
         querySysAdapterListener<dia_IDimmingListener>(&pListener);
         if ( pListener )
         {
            fi_tclVisitorMessage oResultMsg(poMessage);
            midw_fi_tcl_e8_DimmingMode oCompResp;
            (void) oResultMsg.s32GetData(oCompResp);
            tU8 u8Data = (tU8) (oCompResp.enType);
            DIA_TR_INF("mode: %d", u8Data);
            pListener->vOnDayAndNightModeStatus(u8Data);
         }
      }
      else if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_ERROR )
      {
           amt_tclServiceDataError oErrorMsg( poMessage );
           tU16 u16ErrorCode = oErrorMsg.u16GetErrorData();
           DIA_TR_ERR( "---opcode error recievd with error code: 0x%04x", u16ErrorCode);
      }

      (void) poMessage->bDelete();
   }
}
#endif
//------------------------------------------------------------------------------

void
dia_SAFeatureDimming::vHandleSetKeyIllumBrightnessInfo(amt_tclServiceData* poMessage) const
{
	dia_tclFnctTrace trc("dia_SAFeatureDimming::vHandleSetKeyIllumBrightnessInfo");

    if ( poMessage )
    {
       // Msg must come from a server
       DIA_ASSERT(poMessage->bIsServerMessage() == TRUE);

       // Switch on the OpCode received
       switch ( poMessage->u8GetOpCode() )
       {
           case AMT_C_U8_CCAMSG_OPCODE_METHODRESULT:
           {
               dia_IDimmingListener* pDimmingListener = OSAL_NULL;
               querySysAdapterListener<dia_IDimmingListener>(&pDimmingListener);
               if(pDimmingListener)
               {
                  midw_dimmingfi_tclMsgDIM_KEYB_SetDimmingMethodResult oResultData;
                  fi_tclVisitorMessage oResultMsg(poMessage);
                  (void) oResultMsg.s32GetData(oResultData);
                  pDimmingListener->vOnKeyBrightnessChangeResult ( /*(tU16)*/ oResultData.Brightness.u16Value );
                  DIA_TR_INF(("dia_SAFeatureDimming::vHandleSetKeyIllumBrightnessInfo - Information forwarded to listener"));
               }
               else
               {
                   DIA_TR_INF(("dia_SAFeatureDimming::vHandleSetKeyIllumBrightnessInfo - No listener registered. Discarded!"));
               }
               break;
           }
           case AMT_C_U8_CCAMSG_OPCODE_ERROR:
           {
		      amt_tclServiceDataError oErrorMsg( poMessage );
			  tU16 u16ErrorCode = oErrorMsg.u16GetErrorData();
              DIA_TR_INF( "dia_SAFeatureDimming::vHandleSetKeyIllumBrightnessInfo - opcode error recievd with error code:%u", u16ErrorCode);
              break;
           }
           default: // Catch all unsupported OpCodes
           {
		   DIA_TR_INF( "dia_SAFeatureDimming::vHandleSetKeyIllumBrightnessInfo - Message with unhandled/unknown opcode received" );
               break;
           }
      }

       (void) poMessage->bDelete();
    }
}
/******************************************************************************
* FUNCTION:    vHandleSetKeyIllumPwmBrightnessInfo
*
* DESCRIPTION: Receive CCA MethodResult message to from Dimming
*
* PARAMETER:   amt_tclServiceData - message
*
* RETURNVALUE: VOID
*
******************************************************************************/

void
dia_SAFeatureDimming::vHandleSetKeyIllumPwmBrightnessInfo(amt_tclServiceData* poMessage) const
{
	dia_tclFnctTrace trc("dia_SAFeatureDimming::vHandleSetKeyIllumPwmBrightnessInfo");

    if ( poMessage )
    {
       // Msg must come from a server
       DIA_ASSERT(poMessage->bIsServerMessage() == TRUE);

       // Switch on the OpCode received
       switch ( poMessage->u8GetOpCode() )
       {
           case AMT_C_U8_CCAMSG_OPCODE_METHODRESULT:
           {
               dia_IDimmingListener* pDimmingListener = OSAL_NULL;
               querySysAdapterListener<dia_IDimmingListener>(&pDimmingListener);
               if(pDimmingListener)
               {
            	   midw_dimmingfi_tclMsgDIM_KEYB_SetDimmingPWMMethodResult oResultData;
                  fi_tclVisitorMessage oResultMsg(poMessage);
                  (void) oResultMsg.s32GetData(oResultData);
                  pDimmingListener->vOnKeyPWMChangeResult ( /*(tU16)*/ oResultData.Brightness.u16Value );
                  DIA_TR_INF(("dia_SAFeatureDimming::vHandleSetKeyIllumPwmBrightnessInfo - Information forwarded to listener"));
               }
               else
               {
                   DIA_TR_INF(("dia_SAFeatureDimming::vHandleSetKeyIllumPwmBrightnessInfo - No listener registered. Discarded!"));
               }
               break;
           }
           case AMT_C_U8_CCAMSG_OPCODE_ERROR:
           {
		      amt_tclServiceDataError oErrorMsg( poMessage );
			  tU16 u16ErrorCode = oErrorMsg.u16GetErrorData();
              DIA_TR_INF( "dia_SAFeatureDimming::vHandleSetKeyIllumPwmBrightnessInfo - opcode error recievd with error code:%u", u16ErrorCode);
              break;
           }
           default: // Catch all unsupported OpCodes
           {
		   DIA_TR_INF( "dia_SAFeatureDimming::vHandleSetKeyIllumPwmBrightnessInfo - Message with unhandled/unknown opcode received" );
               break;
           }
      }

       (void) poMessage->bDelete();
    }
}
//-----------------------------------------------------------------------------

void
dia_SAFeatureDimming::vHandleEmulationModeResult ( amt_tclServiceData* poMessage ) const
{
   dia_tclFnctTrace trc("dia_SAFeatureDimming::vHandleEmulationModeResult");

   static dia_eDimEmulationMode sModeMapping[DIA_EN_DIM_EMULATION_MODE_COUNT] = {
         DIA_EN_DIM_EMULATION_MODE_OFF,        // midw_fi_tcl_e8_DIM_EmulationMode::FI_EN_OFF
         DIA_EN_DIM_EMULATION_MODE_KEYBFREEZE, // midw_fi_tcl_e8_DIM_EmulationMode::FI_EN_KEYBFREEZE
         DIA_EN_DIM_EMULATION_MODE_DISPFREEZE, // midw_fi_tcl_e8_DIM_EmulationMode::FI_EN_DISPFREEZE
         DIA_EN_DIM_EMULATION_MODE_SETUP,      // midw_fi_tcl_e8_DIM_EmulationMode::FI_EN_SETUP
         DIA_EN_DIM_EMULATION_MODE_VERIFY,     // midw_fi_tcl_e8_DIM_EmulationMode::FI_EN_VERIFY
         DIA_EN_DIM_EMULATION_MODE_UNKNOWN
   };

   if ( poMessage )
   {
      DIA_ASSERT(poMessage->bIsServerMessage() == TRUE);

      switch( poMessage->u8GetOpCode() )
      {
      case AMT_C_U8_CCAMSG_OPCODE_METHODRESULT:
         {
            dia_IDimmingListener* pListener = OSAL_NULL;
            querySysAdapterListener<dia_IDimmingListener>(&pListener);
            if ( pListener )
            {
               fi_tclVisitorMessage oResultMsg(poMessage);
               midw_dimmingfi_tclMsgDIM_INFO_SetEmulationModeMethodResult oResultData;
               (void) oResultMsg.s32GetData(oResultData);
               pListener->vOnEmulationModeStatus((tU8) sModeMapping[oResultData.EmulationMode.enType]);
            }
         }
         break;

      case AMT_C_U8_CCAMSG_OPCODE_ERROR:
         {
            amt_tclServiceDataError oErrorMsg( poMessage );
            tU16 u16ErrorCode = oErrorMsg.u16GetErrorData();
            DIA_TR_ERR( "---opcode error recievd with error code: 0x%04x", u16ErrorCode);
         }
         break;

      default:
         DIA_TR_INF( "--- Unexpected Opcode ---");
         break;
      }

      (void) poMessage->bDelete();
   }
}

////-----------------------------------------------------------------------------
//
//void
//dia_SAFeatureDimming::vHandlePWMBrightness(amt_tclServiceData* poMessage) const
//{
//   dia_tclFnctTrace trc("dia_SAFeatureDimming::vHandlePWMBrightness");
//
//   if (poMessage) {
//      DIA_ASSERT(poMessage->bIsServerMessage() == TRUE);
//
//      switch (poMessage->u8GetOpCode()) {
//         case AMT_C_U8_CCAMSG_OPCODE_STATUS: {
//            dia_IDimmingListener* pListener = OSAL_NULL;
//            querySysAdapterListener<dia_IDimmingListener>(&pListener);
//            if (pListener) {
//               fi_tclVisitorMessage oResultMsg(poMessage);
//               midw_dimmingfi_tclMsgDIM_INFO_PWMBrightnessStatus oResultData;
//               (void) oResultMsg.s32GetData(oResultData);
//
//               tU16 pwm = oResultData.PWMBrightness.u16Value;
//               DIA_TR_INF("dia_SAFeatureDimming::vHandlePWMBrightness - received PWM: 0x%04x, %d", pwm, pwm);
//
//               pListener->vOnDimmingPWM(pwm);
//            }
//         }
//            break;
//
//         case AMT_C_U8_CCAMSG_OPCODE_ERROR: {
//            amt_tclServiceDataError oErrorMsg(poMessage);
//            tU16 u16ErrorCode = oErrorMsg.u16GetErrorData();
//            DIA_TR_INF("dia_SAFeatureDimming::vHandlePWMBrightness - opcode error received with error code: 0x%04x", u16ErrorCode);
//         }
//            break;
//
//         default:
//            DIA_TR_INF("dia_SAFeatureDimming::vHandlePWMBrightness --- Unexpected Opcode ---");
//            break;
//      }
//
//      (void) poMessage->bDelete();
//   }
//}
//-----------------------------------------------------------------------------

void
dia_SAFeatureDimming::vHandlePWMBrightness(amt_tclServiceData* poMessage) const
{
   dia_tclFnctTrace trc("dia_SAFeatureDimming::vHandlePWMBrightness");

   if (poMessage) {
      DIA_ASSERT(poMessage->bIsServerMessage() == TRUE);

      switch (poMessage->u8GetOpCode()) 
	  {
         case CCA_C_U8_OPCODE_METHODRESULT: 
	    {
            dia_IDimmingListener* pListener = OSAL_NULL;
            querySysAdapterListener<dia_IDimmingListener>(&pListener);
            if (pListener) 
			{
               fi_tclVisitorMessage oResultMsg(poMessage);
               dimming_mainfi_tclMsgDIM_INFO_GetPWMBrightnessMethodResult oResultData;
               (void) oResultMsg.s32GetData(oResultData);
               tU16 pwm = oResultData.Brightness.u16Value;
               DIA_TR_INF("dia_SAFeatureDimming::vHandlePWMBrightness - received PWM: 0x%04x, %d", pwm, pwm);

               pListener->vOnDimmingPWM(pwm);
            }
         }
            break;

         case AMT_C_U8_CCAMSG_OPCODE_ERROR: 
		{
            amt_tclServiceDataError oErrorMsg(poMessage);
            tU16 u16ErrorCode = oErrorMsg.u16GetErrorData();
            DIA_TR_INF("dia_SAFeatureDimming::vHandlePWMBrightness - opcode error received with error code: 0x%04x", u16ErrorCode);
         }
            break;

         default:
            DIA_TR_INF("dia_SAFeatureDimming::vHandlePWMBrightness --- Unexpected Opcode ---");
            break;
      }

      (void) poMessage->bDelete();
   }
}
//-----------------------------------------------------------------------------

void
dia_SAFeatureDimming::vHandleDimmingState(amt_tclServiceData* poMessage) const
{
   dia_tclFnctTrace trc("dia_SAFeatureDimming::vHandleDimmingState");

   if (poMessage) {
      DIA_ASSERT(poMessage->bIsServerMessage() == TRUE);

      switch (poMessage->u8GetOpCode()) {
         case AMT_C_U8_CCAMSG_OPCODE_STATUS: {
            dia_IDimmingListener* pListener = OSAL_NULL;
            querySysAdapterListener<dia_IDimmingListener>(&pListener);
            if (pListener) {
               fi_tclVisitorMessage oResultMsg(poMessage);
               midw_dimmingfi_tclMsgDIM_INFO_DimmingModeStatus oResultData;
               (void) oResultMsg.s32GetData(oResultData);

               tU8 state = oResultData.Status.enType;
               DIA_TR_INF("dia_SAFeatureDimming::vHandleDimmingState - received STATUS state: 0x%04x, %d", state, state);
               dia_eDimmingStatus inputLineMROut = DIA_EN_DIMMING_STATUS_UNKNOWN;

               switch (oResultData.Car.enType) {
                  case midw_fi_tcl_e8_DIM_Mode::FI_EN_DAY:
                     DIA_TR_INF("dia_SAFeatureDimming::vHandleDimmingState - CAR state is FI_EN_DAY.");

                     DIA_TR_INF("dia_SAFeatureDimming::vHandleDimmingState - MR_OUTPUT line is ON.");
                     inputLineMROut = DIA_EN_DIMMING_STATUS_ON;
                     break;
                  case midw_fi_tcl_e8_DIM_Mode::FI_EN_NIGHT:
                     DIA_TR_INF("dia_SAFeatureDimming::vHandleDimmingState - CAR state is FI_EN_NIGHT.");

                     DIA_TR_INF("dia_SAFeatureDimming::vHandleDimmingState - MR_OUTPUT line is OFF.");
                     inputLineMROut = DIA_EN_DIMMING_STATUS_OFF;
                     break;
                  default:
                     DIA_TR_ERR("dia_SAFeatureDimming::vHandleDimmingState - NOT HANDLED TYPE 0x%02x !", oResultData.Car.enType);
                     break;
               }

               pListener->vOnDimmingMode(inputLineMROut);
            }
         }
            break;

         case AMT_C_U8_CCAMSG_OPCODE_ERROR: {
            amt_tclServiceDataError oErrorMsg(poMessage);
            tU16 u16ErrorCode = oErrorMsg.u16GetErrorData();
            DIA_TR_INF("dia_SAFeatureDimming::vHandleDimmingState - opcode error received with error code: 0x%04x", u16ErrorCode);
         }
            break;

         default:
            DIA_TR_INF("dia_SAFeatureDimming::vHandleDimmingState --- Unexpected Opcode ---");
            break;
      }

      (void) poMessage->bDelete();
   }
}

//-----------------------------------------------------------------------------

void
dia_SAFeatureDimming::vHandleIlluminationData(amt_tclServiceData* poMessage) const
{
   dia_tclFnctTrace trc("dia_SAFeatureDimming::vHandleIlluminationData");

   if (poMessage) {
      DIA_ASSERT(poMessage->bIsServerMessage() == TRUE);

      switch (poMessage->u8GetOpCode()) {
         case AMT_C_U8_CCAMSG_OPCODE_STATUS: {
            dia_IDimmingListener* pListener = OSAL_NULL;
            querySysAdapterListener<dia_IDimmingListener>(&pListener);
            if (pListener) {
               fi_tclVisitorMessage oResultMsg(poMessage);
               midw_dimmingfi_tclMsgDIM_INFO_CarIlluminationDataStatus oResultData;
               (void) oResultMsg.s32GetData(oResultData);

               DIA_TR_INF("dia_SAFeatureDimming::vHandleIlluminationData - received Illum. Status: 0x%04x, %d", oResultData.IlluminationSwitch.enType, oResultData.IlluminationSwitch.enType);
               dia_eDimmingStatus dimmStatus = DIA_EN_DIMMING_STATUS_UNKNOWN;
               switch(oResultData.IlluminationSwitch.enType){
                  case midw_fi_tcl_e8_DIM_Status::FI_EN_OFF:
                     DIA_TR_INF("dia_SAFeatureDimming::vHandleIlluminationData - Status OFF.");
                     dimmStatus = DIA_EN_DIMMING_STATUS_OFF;
                     break;
                  case midw_fi_tcl_e8_DIM_Status::FI_EN_ON:
                     DIA_TR_INF("dia_SAFeatureDimming::vHandleIlluminationData - Status ON.");
                     dimmStatus = DIA_EN_DIMMING_STATUS_ON;
                     break;
                  default:
                     DIA_TR_ERR("dia_SAFeatureDimming::vHandleIlluminationData - NOT HANDLED SWITCH 0x%02x / %d !", oResultData.IlluminationSwitch.enType, oResultData.IlluminationSwitch.enType);
                     break;
               }

               tU16 pwm = oResultData.IlluminationBrightness.u16Value;
               DIA_TR_INF("dia_SAFeatureDimming::vHandleIlluminationData - IlluminationBrightness=%d (0x%04x).", pwm, pwm);

               pListener->vOnDimmingPWM(pwm);
			   pListener->vOnKeyBBrightnessInformation(pwm);
               pListener->vOnDimmingIllStatus(dimmStatus);
            }
         }
            break;

         case AMT_C_U8_CCAMSG_OPCODE_ERROR: {
            amt_tclServiceDataError oErrorMsg(poMessage);
            tU16 u16ErrorCode = oErrorMsg.u16GetErrorData();
            DIA_TR_INF("dia_SAFeatureDimming::vHandleIlluminationData - opcode error received with error code: 0x%04x", u16ErrorCode);
         }
            break;

         default:
            DIA_TR_INF("dia_SAFeatureDimming::vHandleIlluminationData --- Unexpected Opcode 0x%02x ---", poMessage->u8GetOpCode());
            break;
      }

      (void) poMessage->bDelete();
   }
}

//-----------------------------------------------------------------------------

void
dia_SAFeatureDimming::vHandleSetBrightnessStatus ( amt_tclServiceData* poMessage ) const
{
   dia_tclFnctTrace trc("dia_SAFeatureDimming::vHandleSetBrightnessStatus");

   if ( poMessage )
   {
      DIA_ASSERT(poMessage->bIsServerMessage() == TRUE);

	  switch( poMessage->u8GetOpCode() )
	  {
	  case AMT_C_U8_CCAMSG_OPCODE_METHODRESULT:
		  {
			  dia_IDimmingListener* pListener = OSAL_NULL;
			  querySysAdapterListener<dia_IDimmingListener>(&pListener);
			  if ( pListener )
			  {
				  fi_tclVisitorMessage oResultMsg(poMessage);
				  midw_dimmingfi_tclMsgDIM_DISP_SetDimmingMethodResult oResultData;
				  (void) oResultMsg.s32GetData(oResultData);
				  pListener->vOnDispBrightnessAck(/*(tU16)*/ oResultData.Brightness.u16Value);
			  }
              break;
		  }
	  case AMT_C_U8_CCAMSG_OPCODE_ERROR:
		  {
			  amt_tclServiceDataError oErrorMsg( poMessage );
			  tU16 u16ErrorCode = oErrorMsg.u16GetErrorData();
			  DIA_TR_ERR( "---opcode error recievd with error code: 0x%04x", u16ErrorCode);
              break;
		  }
	  default:
		  {
			  DIA_TR_INF( "Unexpected Opcode Received");
              break;
		  }
	  }

	  (void) poMessage->bDelete();
   }
}
//-----------------------------------------------------------------------------

void
dia_SAFeatureDimming::vHandleSetBackLightIllumination ( amt_tclServiceData* poMessage ) const
{
   dia_tclFnctTrace trc("dia_SAFeatureDimming::vHandleSetBackLightIllumination");

   if ( poMessage )
   {
      DIA_ASSERT(poMessage->bIsServerMessage() == TRUE);

	  switch( poMessage->u8GetOpCode() )
	  {
	  case AMT_C_U8_CCAMSG_OPCODE_METHODRESULT:
		  {
			  dia_IDimmingListener* pListener = OSAL_NULL;
			  querySysAdapterListener<dia_IDimmingListener>(&pListener);
			  if ( pListener )
			  {
				  fi_tclVisitorMessage oResultMsg(poMessage);
				  midw_dimmingfi_tclMsgDIM_DISP_SetDimmingMethodResult oResultData;
				  (void) oResultMsg.s32GetData(oResultData);
				  pListener->vOnDispBrightnessAck(/*(tU16)*/ oResultData.Brightness.u16Value);
			  }
              break;
		  }
	  case AMT_C_U8_CCAMSG_OPCODE_ERROR:
		  {
			  amt_tclServiceDataError oErrorMsg( poMessage );
			  tU16 u16ErrorCode = oErrorMsg.u16GetErrorData();
			  DIA_TR_ERR( "---opcode error recievd with error code: 0x%04x", u16ErrorCode);
              break;
		  }
	  default:
		  {
			  DIA_TR_INF( "Unexpected Opcode Received");
              break;
		  }
	  }

	  (void) poMessage->bDelete();
   }
}


//-----------------------------------------------------------------------------

void
dia_SAFeatureDimming::vHandleDimmingStatus ( amt_tclServiceData* poMessage ) const
{
   dia_tclFnctTrace trc("dia_SAFeatureDimming::vHandleDimmingStatus()");

   if ( poMessage )
   {
      DIA_ASSERT(poMessage->bIsServerMessage() == TRUE);

      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS )
      {
         dia_IDimmingListener* pListener = OSAL_NULL;
         querySysAdapterListener<dia_IDimmingListener>(&pListener);
         if ( pListener )
         {
            fi_tclVisitorMessage oReceivedMsg(poMessage);
            midw_dimmingfi_tclMsgFI_VD_DIMMING_STATEStatus oReceivedData;
            (void) oReceivedMsg.s32GetData(oReceivedData);

            DIA_TR_INF("DimmingState - Status = %d", oReceivedData.DimmingState.enType);

            dia_eDimmingStatus status = DIA_EN_DIMMING_STATUS_UNKNOWN;

            if ( oReceivedData.DimmingState.enType == midw_fi_tcl_e8_DimmingState::FI_EN_VD_DIMMING_STATE_ON )
            {
                DIA_TR_INF("DIMMING STATUS IS ON !!");
                status = DIA_EN_DIMMING_STATUS_ON;
            }
            else
            {
                DIA_TR_INF("DIMMING STATUS IS OFF !!");
                status = DIA_EN_DIMMING_STATUS_OFF;
            }

            pListener->vOnDimmingStatus(status);
         }
      }
      else if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_ERROR )
      {
           amt_tclServiceDataError oErrorMsg( poMessage );
           tU16 u16ErrorCode = oErrorMsg.u16GetErrorData();
           DIA_TR_ERR( "---opcode error recievd with error code: 0x%04x", u16ErrorCode);
      }

      (void) poMessage->bDelete();
   }
}


////! set display brightness
//virtual tDiaResult setDisplayBrightness ( tU16 pwmValue ) = 0;
////! get display brightness
//virtual tDiaResult getDisplayBrightness ( void ) = 0;

//-----------------------------------------------------------------------------
#if 0
void
dia_SAFeatureDimming::vHandleDimmingInformation ( amt_tclServiceData* poMessage ) const
{
   dia_tclFnctTrace trc("dia_SAFeatureDimming::vHandleDimmingInformation()");

   if ( poMessage )
   {
      DIA_ASSERT(poMessage->bIsServerMessage() == TRUE);

      if ( poMessage->u8GetOpCode() == CCA_C_U8_OPCODE_METHODRESULT )
      {
         dia_IDimmingListener* pListener = OSAL_NULL;
         querySysAdapterListener<dia_IDimmingListener>(&pListener);
         if ( pListener )
         {
            fi_tclVisitorMessage oReceivedMsg(poMessage);
            midw_dimmingfi_tclMsgDIM_DIAG_GetButtonIlluminationValueMethodResult oReceivedData;
            (void) oReceivedMsg.s32GetData(oReceivedData);

            DIA_TR_INF("dia_SAFeatureDimming::vHandleDimmingInformation Brightness = %d", oReceivedData.ButtonIllumination.u16Value);

            // Dimming pwm Brightness
            tU16 brightness = oReceivedData.ButtonIllumination.u16Value;

            pListener->vOnDimmingInformation ( brightness );
         }
      }
      else if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_ERROR )
      {
           amt_tclServiceDataError oErrorMsg( poMessage );
           tU16 u16ErrorCode = oErrorMsg.u16GetErrorData();
           DIA_TR_ERR( "---opcode error recievd with error code: 0x%04x", u16ErrorCode);
      }

      (void) poMessage->bDelete();
   }
}
#endif
//-----------------------------------------------------------------------------

void
dia_SAFeatureDimming::vHandleKeyBBrightnessInformation ( amt_tclServiceData* poMessage ) const
{
   dia_tclFnctTrace trc("dia_SAFeatureDimming::vHandleKeyBBrightnessInformation()");

   if ( poMessage )
   {
      DIA_ASSERT(poMessage->bIsServerMessage() == TRUE);

      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS )
      {
         dia_IDimmingListener* pListener = OSAL_NULL;
         querySysAdapterListener<dia_IDimmingListener>(&pListener);
         if ( pListener )
         {
            fi_tclVisitorMessage oReceivedMsg(poMessage);
            midw_dimmingfi_tclMsgDIM_KEYB_BrightnessStatus oReceivedData;
            (void) oReceivedMsg.s32GetData(oReceivedData);

            DIA_TR_INF("dia_SAFeatureDimming::vHandleKeyBBrightnessInformation Brightness = %d", oReceivedData.Brightness.u16Value);

            // KeyB Brightness
            tU16 brightness = oReceivedData.Brightness.u16Value;

            pListener->vOnKeyBBrightnessInformation ( brightness );
         }
      }
      else if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_ERROR )
      {
           amt_tclServiceDataError oErrorMsg( poMessage );
           tU16 u16ErrorCode = oErrorMsg.u16GetErrorData();
           DIA_TR_ERR( "---opcode error recievd with error code: 0x%04x", u16ErrorCode);
      }

      (void) poMessage->bDelete();
   }
}
//-----------------------------------------------------------------------------

void
dia_SAFeatureDimming::vHandleReadBackLightIllumination ( amt_tclServiceData* poMessage ) const
{
   dia_tclFnctTrace trc("dia_SAFeatureDimming::vHandleReadBackLightIllumination()");

   if ( poMessage )
   {
      DIA_ASSERT(poMessage->bIsServerMessage() == TRUE);

      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS )
      {
         dia_IDimmingListener* pListener = OSAL_NULL;
         querySysAdapterListener<dia_IDimmingListener>(&pListener);
         if ( pListener )
         {
            fi_tclVisitorMessage oReceivedMsg(poMessage);
            midw_dimmingfi_tclMsgDIM_DISP_BrightnessStatus oReceivedData;
            (void) oReceivedMsg.s32GetData(oReceivedData);

            DIA_TR_INF("dia_SAFeatureDimming::vHandleReadBackLightIllumination Brightness = %d", oReceivedData.Brightness.u16Value);

            // display Brightness
            tU16 brightness = oReceivedData.Brightness.u16Value;

            pListener->vOnDispBrightnessInformation ( brightness );
         }
      }
      else if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_ERROR )
      {
           amt_tclServiceDataError oErrorMsg( poMessage );
           tU16 u16ErrorCode = oErrorMsg.u16GetErrorData();
           DIA_TR_ERR( "---opcode error recievd with error code: 0x%04x", u16ErrorCode);
      }

      (void) poMessage->bDelete();
   }
}

//-----------------------------------------------------------------------------
void
dia_SAFeatureDimming::vHandleDispBrightnessInformation ( amt_tclServiceData* poMessage ) const
{
   dia_tclFnctTrace trc("dia_SAFeatureDimming::vHandleDispBrightnessInformation()");

   if ( poMessage )
   {
      DIA_ASSERT(poMessage->bIsServerMessage() == TRUE);

      if ( poMessage->u8GetOpCode() == CCA_C_U8_OPCODE_METHODRESULT )
      {
         dia_IDimmingListener* pListener = OSAL_NULL;
         querySysAdapterListener<dia_IDimmingListener>(&pListener);
         if ( pListener )
         {
            fi_tclVisitorMessage oReceivedMsg(poMessage);
            midw_dimmingfi_tclMsgDIM_INFO_GetDimmingBrightnessMethodResult oReceivedData;
		//	midw_dimmingfi_tclMsgDIM_INFO_GetDimmingBrightnessMethodStart oReceivedData;
            (void) oReceivedMsg.s32GetData(oReceivedData);

            DIA_TR_INF("dia_SAFeatureDimming::vHandleDispBrightnessInformation Brightness = %d", oReceivedData.Brightness.u16Value);

            // Display Brightness
            tU16 brightness = oReceivedData.Brightness.u16Value;

            pListener->vOnDispBrightnessInformation ( brightness );
         }
      }
      else if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_ERROR )
      {
           amt_tclServiceDataError oErrorMsg( poMessage );
           tU16 u16ErrorCode = oErrorMsg.u16GetErrorData();
           DIA_TR_ERR( "---opcode error recievd with error code: 0x%04x", u16ErrorCode);
      }

      (void) poMessage->bDelete();
   }
}
//-----------------------------------------------------------------------------
#if 0 //function needs to be removed
void
dia_SAFeatureDimming::vHandleDispPanelTempInformation ( amt_tclServiceData* poMessage ) const
{
   dia_tclFnctTrace trc("dia_SAFeatureDimming::vHandleDispPanelTempInformation()");

   if ( poMessage )
   {
      DIA_ASSERT(poMessage->bIsServerMessage() == TRUE);

      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS )
      {
         dia_IDimmingListener* pListener = OSAL_NULL;
         querySysAdapterListener<dia_IDimmingListener>(&pListener);
         if ( pListener )
         {
            fi_tclVisitorMessage oReceivedMsg(poMessage);
            midw_dimmingfi_tclMsgDIM_DISP_PanelTemperatureStatus oReceivedData;
            (void) oReceivedMsg.s32GetData(oReceivedData);

            DIA_TR_INF("dia_SAFeatureDimming::vHandleDispPanelTempInformation Temperature = %d", oReceivedData.Temperature.s16Value);

            // Display panel temperature
            tS16 temperature = oReceivedData.Temperature.s16Value;

            pListener->vOnDispPanelTempInformation ( temperature );
         }
      }
      else if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_ERROR )
      {
           amt_tclServiceDataError oErrorMsg( poMessage );
           tU16 u16ErrorCode = oErrorMsg.u16GetErrorData();
           DIA_TR_ERR( "---opcode error recievd with error code: 0x%04x", u16ErrorCode);
      }

      (void) poMessage->bDelete();
   }
}
#endif
//-----------------------------------------------------------------------------
#if 0 //function needs to be removed
void
dia_SAFeatureDimming::vHandleDimmingHalfClassInformation ( amt_tclServiceData* poMessage ) const
{
   dia_tclFnctTrace trc("dia_SAFeatureDimming::vHandleDimmingHalfClassInformation()");

   if ( poMessage )
   {
      DIA_ASSERT(poMessage->bIsServerMessage() == TRUE);

      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS )
      {
         dia_IDimmingListener* pListener = OSAL_NULL;
         querySysAdapterListener<dia_IDimmingListener>(&pListener);
         if ( pListener )
         {
            fi_tclVisitorMessage oReceivedMsg(poMessage);
            midw_dimmingfi_tclMsgDIM_KEYB_HalfclassStatus oReceivedData;
            (void) oReceivedMsg.s32GetData(oReceivedData);

            DIA_TR_INF("dia_SAFeatureDimming::vHandleDimmingHalfClassInformation Halfclass_A = %d", oReceivedData.Halfclass_A.u8Value);
            DIA_TR_INF("dia_SAFeatureDimming::vHandleDimmingHalfClassInformation Halfclass_B = %d", oReceivedData.Halfclass_B.u8Value);

		    // Try setting LED half class info.
			vector<tU8> bHalfClassInfo(2,0);
			bHalfClassInfo[HALF_CLASS_A_ID] = oReceivedData.Halfclass_A.u8Value;
			bHalfClassInfo[HALF_CLASS_B_ID] = oReceivedData.Halfclass_B.u8Value;

            // KeyB half class information
            pListener->vOnDimmingHalfClassInformation ( bHalfClassInfo );
         }
      }
      else if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_ERROR )
      {
           amt_tclServiceDataError oErrorMsg( poMessage );
           tU16 u16ErrorCode = oErrorMsg.u16GetErrorData();
           DIA_TR_ERR( "---opcode error recievd with error code: 0x%04x", u16ErrorCode);
      }

      (void) poMessage->bDelete();
   }
}
#endif
//-----------------------------------------------------------------------------
//void
//dia_SAFeatureDimming::vHandleDispBrightnessLevelInformation ( amt_tclServiceData* poMessage ) const
//{
//   dia_tclFnctTrace trc("dia_SAFeatureDimming::vHandleDispBrightnessLevelInformation()");
//
//   if ( poMessage )
//   {
//      DIA_ASSERT(poMessage->bIsServerMessage() == TRUE);
//
//      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS )
//      {
//         dia_IDimmingListener* pListener = OSAL_NULL;
//         querySysAdapterListener<dia_IDimmingListener>(&pListener);
//         if ( pListener )
//         {
//            fi_tclVisitorMessage oReceivedMsg(poMessage);
//            midw_dimmingfi_tclMsgDIM_DISP_BrightnessLevelStatus oReceivedData;
//            (void) oReceivedMsg.s32GetData(oReceivedData);
//
//            DIA_TR_INF("dia_SAFeatureDimming::vHandleDispBrightnessLevelInformation BrightnessLevel = %d", oReceivedData.BrightnessLevel.enType);
//
//            // Display Brightness
//            tU8 brightnessLevel =(tU8)oReceivedData.BrightnessLevel.enType;
//
//            pListener->vOnDispBrightnessInformation ( brightnessLevel );
//         }
//      }
//      else if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_ERROR )
//      {
//           amt_tclServiceDataError oErrorMsg( poMessage );
//           tU16 u16ErrorCode = oErrorMsg.u16GetErrorData();
//           DIA_TR_ERR( "---opcode error recievd with error code: 0x%04x", u16ErrorCode);
//      }
//
//      (void) poMessage->bDelete();
//   }
//}
//
////-----------------------------------------------------------------------------
//
//void
//dia_SAFeatureDimming::vHandleSetBrightnessLevelStatus ( amt_tclServiceData* poMessage ) const
//{
//   dia_tclFnctTrace trc("dia_SAFeatureDimming::vHandleSetBrightnessLevelStatus");
//
//   if ( poMessage )
//   {
//      DIA_ASSERT(poMessage->bIsServerMessage() == TRUE);
//
//	  switch( poMessage->u8GetOpCode() )
//	  {
//	  case AMT_C_U8_CCAMSG_OPCODE_METHODRESULT:
//		  {
//			  dia_IDimmingListener* pListener = OSAL_NULL;
//			  querySysAdapterListener<dia_IDimmingListener>(&pListener);
//			  if ( pListener )
//			  {
//				  fi_tclVisitorMessage oResultMsg(poMessage);
//				  midw_dimmingfi_tclMsgDIM_DISP_SetBrightnessLevelMethodResult oResultData;
//				  (void) oResultMsg.s32GetData(oResultData);
//				  pListener->vOnDispBrightnessAck(/*(tU16)*/ (dia_eDimmingLevel)oResultData.BrightnessLevel.enType);
//			  }
//              break;
//		  }
//	  case AMT_C_U8_CCAMSG_OPCODE_ERROR:
//		  {
//			  amt_tclServiceDataError oErrorMsg( poMessage );
//			  tU16 u16ErrorCode = oErrorMsg.u16GetErrorData();
//			  DIA_TR_ERR( "---opcode error recievd with error code: 0x%04x", u16ErrorCode);
//              break;
//		  }
//	  default:
//		  {
//			  DIA_TR_INF( "Unexpected Opcode Received");
//              break;
//		  }
//	  }
//
//	  (void) poMessage->bDelete();
//   }
//}

