#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_DIAGLIB__
#define __INCLUDED_DIA_SYSTEM_ADAPTER_DIAGLIB__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

class amt_tclServiceData;
class dia_IDiaglibSysSetListener;
class dia_IDiaglibIoControlListener;
class dia_IDiaglibRoutineControlListener;
class dia_IDiaglibDiagnosisDataListener;
class dia_SystemAdapterServicePlugin;

class dia_SAFeatureDiaglib
{
public:
   // constructor
   dia_SAFeatureDiaglib ();

   // destructor
   ~dia_SAFeatureDiaglib ( tVoid );

   static tBool isDiaglibMessage ( const amt_tclServiceData* poMessage );
   static tU32  getDiaglibID ( amt_tclServiceData* poMessage );

   // fc_diagnosis => Component

   // SystemSet requests
   static tBool bPrepareForSysSet (const tU32 u32SysSetId, const tenSystemSetType enSysSetType, dia_SystemAdapterServicePlugin* poSender );
   static tBool bExecuteSysSet (const tU32 u32SysSetId, const tenSystemSetType enSysSetType, dia_SystemAdapterServicePlugin* poSender );
   static tBool bEndOfSysSet (const tU32 u32SysSetId, const tenSystemSetType enSysSetType, dia_SystemAdapterServicePlugin* poSender );

   // RoutineControl requests
   static tBool bRoutineControlStart  (const tU32 u32RoutineId, const tU32 u32Bitmask, const tDiaglibParamVector& oParamVector, dia_SystemAdapterServicePlugin* poSender );
   static tBool bRoutineControlAbort  (const tU32 u32RoutineId, dia_SystemAdapterServicePlugin* poSender );
   static tBool bGetRoutineResult     (const tU32 u32RoutineId, dia_SystemAdapterServicePlugin* poSender );

   // IOControl requests
   static tBool bIOControlStart  (const tU32 u32ControlId, const tenIoControlAction enActionId, const tDiaglibParamVector& oParamVector, dia_SystemAdapterServicePlugin* poSender );

   // DiagData requests
   static tBool bDiagDataReadStart   (const tU32 u32DiagDataId, dia_SystemAdapterServicePlugin* poSender );
   static tBool bDiagDataWriteStart  (const tU32 u32DiagDataId, const tDiaglibParamVector& oParamVector, dia_SystemAdapterServicePlugin* poSender );

   // Component => fc_diagnosis
   static tBool bIsSysSetMessage          (const amt_tclServiceData* poMessage);
   static tBool bIsDiagDataMessage        (const amt_tclServiceData* poMessage);
   static tBool bIsRoutineControlMessage  (const amt_tclServiceData* poMessage);
   static tBool bIsIoControlMessage       (const amt_tclServiceData* poMessage);

   static tU32 u32EvalSysSetMessage           ( amt_tclServiceData* poMessage, dia_IDiaglibSysSetListener* poListener );
   static tU32 u32EvalRoutineCtrlMessage      ( amt_tclServiceData* poMessage, dia_IDiaglibRoutineControlListener* poListener );
   static tU32 u32EvalIoCtrlMessage           ( amt_tclServiceData* poMessage, dia_IDiaglibIoControlListener* poListener );
   static tU32 u32EvalDiagnosisDataCtrlMessage( amt_tclServiceData* poMessage, dia_IDiaglibDiagnosisDataListener* poListener );
// static tU32 u32EvalDiagDatMessage          ( amt_tclServiceData* poMessage, dia_IDiaglibDiagDataListener* poListener );

protected:
   static tU32 u32HandleError ( amt_tclServiceData* poMessage );
   static tU32 u32EvalSysSetPrepareMessage    ( amt_tclServiceData* poMessage, dia_IDiaglibSysSetListener* poListener );
   static tU32 u32EvalSysSetFinishedMessage   ( amt_tclServiceData* poMessage, dia_IDiaglibSysSetListener* poListener );
   static tU32 u32EvalSysSetExecuteMessage    ( amt_tclServiceData* poMessage, dia_IDiaglibSysSetListener* poListener );

   static tU32 u32EvalRoutineResultMessage    ( amt_tclServiceData* poMessage, dia_IDiaglibRoutineControlListener* poListener );
   static tU32 u32EvalRoutineControlMessage   ( amt_tclServiceData* poMessage, dia_IDiaglibRoutineControlListener* poListener );

// static tU32 u32EvalDiagReadMessage         ( amt_tclServiceData* poMessage, dia_IDiaglibDiagDataListener* poListener );
// static tU32 u32EvalDiagWriteMessage        ( amt_tclServiceData* poMessage, dia_IDiaglibDiagDataListener* poListener );

   static tU32 u32EvalIoControlMessage        ( amt_tclServiceData* poMessage, dia_IDiaglibIoControlListener* poListener );
   static tU32 u32EvalDiagnosisDataControlMessage  ( amt_tclServiceData* poMessage, dia_IDiaglibDiagnosisDataListener* poListener );

};

#endif // __INCLUDED_DIA_SYSTEM_ADAPTER_DIAGLIB__
