#ifndef __INCLUDED_DIA_COMMON_SYSTEM_ADAPTERS__
#include "common/framework/sysadapters/dia_common_system_adapters.h"
#endif

#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include "generic_msgs_if.h" //lint !e451 !e537 repeatedly included header file without standard include guard

#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGLIBFI_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGLIBFI_FUNCTIONIDS
#include "midw_fi_if.h" //lint !e451 !e537 repeatedly included header file without standard include guard

#ifndef __INCLUDED_DIA_INTERFACE_SYSTEM_SETTINGS_DIAGLIB_LISTENER__
#include <common/depricated/SystemAdapter/dia_IDiaglibSysSetListener.h>
#endif
#ifndef __INCLUDED_DIA_INTERFACE_DIAGLIB_ROUTINE_CONTROL_LISTENER__
#include <common/depricated/SystemAdapter/dia_IDiaglibRoutineControlListener.h>
#endif

#ifndef __INCLUDED_DIA_DIAGLIB_IOCONTROL_LISTENER__
#include <common/depricated/SystemAdapter/dia_IDiaglibIoControlListener.h>
#endif

#ifndef __INCLUDED_DIA_INTERFACE_DIAGLIB_DIAGNOSIS_DATA_LISTENER__
#include <common/depricated/SystemAdapter/dia_IDiaglibDiagnosisDataListener.h>
#endif

//#ifndef __INCLUDED_DIA_REMOTE_CONTROL_PLUGIN__
//#include "common/framework/application/dia_RemoteControlPlugin.h"
//#endif

//#include "../dia_ISystemAdapterPlugPoint.h"

#ifndef __INCLUDED_DIA_DIAGLIB_CCA_HELPER__
#include <common/depricated/SystemAdapter/dia_DiaglibCcaHelper.h>
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_DIAGLIB__
#include "dia_SAFeatureDiaglib.h"
#endif

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_DIAGNOSTICS_SYSADAPT
#include "trcGenProj/Header/dia_SAFeatureDiaglib.cpp.trc.h"
#endif

#undef  DIA_FILE_CURRENT
#define DIA_FILE_CURRENT   DIA_FILE_U16_SA_DIAGLIB

//-----------------------------------------------------------------------------

tBool
dia_SAFeatureDiaglib::isDiaglibMessage ( const amt_tclServiceData* poMessage )
{
   tBool bCheckResult = FALSE;

   if ( poMessage )
   {
      if ( dia_SAFeatureDiaglib::bIsSysSetMessage(poMessage) == TRUE ) bCheckResult = TRUE;
      if ( dia_SAFeatureDiaglib::bIsIoControlMessage(poMessage) == TRUE ) bCheckResult = TRUE;
      if ( dia_SAFeatureDiaglib::bIsRoutineControlMessage(poMessage) == TRUE ) bCheckResult = TRUE;
      if ( dia_SAFeatureDiaglib::bIsDiagDataMessage(poMessage) == TRUE ) bCheckResult = TRUE;
   }

   return ( bCheckResult == TRUE ) ? TRUE : FALSE;
}

//-----------------------------------------------------------------------------

tU32
dia_SAFeatureDiaglib::getDiaglibID ( amt_tclServiceData* poMessage )
{
   tU32 id = 0;

   if ( !poMessage ) return 0;

   // Msg must come from a server
   DIA_ASSERT(poMessage->bIsServerMessage() == TRUE);

   tU16 funcID = poMessage->u16GetFunctionID();

   // Extract the op code of the message called
   tU8  opCode = poMessage->u8GetOpCode();

   fi_tclVisitorMessage oResultMsg(poMessage);

   switch ( funcID )
   {
   case MIDW_DIAGLIBFI_C_U16_SYSTEMSETPREPARE:
      if ( opCode == AMT_C_U8_CCAMSG_OPCODE_METHODRESULT)
      {
         midw_diaglibfi_tclMsgSystemSetPrepareMethodResult oResultData;
         (tVoid) oResultMsg.s32GetData(oResultData);
         id = oResultData.SystemSetId;
      }
      break;

   case MIDW_DIAGLIBFI_C_U16_SYSTEMSETFINISHED:
      if ( opCode == AMT_C_U8_CCAMSG_OPCODE_METHODRESULT)
      {
         midw_diaglibfi_tclMsgSystemSetFinishedMethodResult oResultData;
         (tVoid) oResultMsg.s32GetData(oResultData);
         id = oResultData.SystemSetId;
      }
      break;

   case MIDW_DIAGLIBFI_C_U16_SYSTEMSET:
      if ( opCode == AMT_C_U8_CCAMSG_OPCODE_METHODRESULT)
      {
         midw_diaglibfi_tclMsgSystemSetMethodResult oResultData;
         (tVoid) oResultMsg.s32GetData(oResultData);
         id = oResultData.SystemSetId;
      }
      break;

   case MIDW_DIAGLIBFI_C_U16_IOCONTROL:
      if ( opCode == AMT_C_U8_CCAMSG_OPCODE_METHODRESULT)
      {
         midw_diaglibfi_tclMsgIOControlMethodResult oResultData;
         (tVoid) oResultMsg.s32GetData(oResultData);
         id = oResultData.ControlId;
      }
      break;

//   case MIDW_DIAGLIBFI_C_U16_DIAGNOSISREAD:
//      if ( opCode == AMT_C_U8_CCAMSG_OPCODE_METHODRESULT)
//      {
//         midw_diaglibfi_tclMsgSystemSetMethodResult oResultData;
//         (tVoid) oResultMsg.s32GetData(oResultData);
//         id = oResultMsg.SystemSetId;
//      }
//      break;
//
//   case MIDW_DIAGLIBFI_C_U16_DIAGNOSISWRITE:
//      if ( opCode == AMT_C_U8_CCAMSG_OPCODE_METHODRESULT)
//      {
//         midw_diaglibfi_tclMsgSystemSetMethodResult oResultData;
//         (tVoid) oResultMsg.s32GetData(oResultData);
//         id = oResultMsg.SystemSetId;
//      }
//      break;
//

   case MIDW_DIAGLIBFI_C_U16_DIAGNOSISDATA:
      if (opCode == AMT_C_U8_CCAMSG_OPCODE_STATUS)
      {
         midw_diaglibfi_tclMsgDiagnosisDataStatus oResultData;
         (tVoid) oResultMsg.s32GetData(oResultData);
         id = oResultData.DiagnosisDataId;
      }
      break;

   case MIDW_DIAGLIBFI_C_U16_ROUTINECONTROL:
      if ( opCode == AMT_C_U8_CCAMSG_OPCODE_METHODRESULT)
      {
         midw_diaglibfi_tclMsgRoutineControlMethodResult oResultData;
         (tVoid) oResultMsg.s32GetData(oResultData);
         id = oResultData.RoutineId;
      }
      break;

   case MIDW_DIAGLIBFI_C_U16_GETROUTINERESULT:
      if ( opCode == AMT_C_U8_CCAMSG_OPCODE_METHODRESULT)
      {
         midw_diaglibfi_tclMsgGetRoutineResultMethodResult oResultData;
         (tVoid) oResultMsg.s32GetData(oResultData);
         id = oResultData.RoutineId;
      }
      break;

   default:
      break;
   }

   return id;
}

//-----------------------------------------------------------------------------

tBool
dia_SAFeatureDiaglib::bIsSysSetMessage(const amt_tclServiceData* poMessage)
{
   dia_tclFnctTrace oTrace("dia_SAFeatureDiaglib::bIsSysSetMessage");

   if ( !poMessage ) return FALSE;

   tBool bResult = FALSE;
   tU16 u16FuncId = poMessage->u16GetFunctionID();

   switch (u16FuncId)
   {
   case MIDW_DIAGLIBFI_C_U16_SYSTEMSETPREPARE:
   case MIDW_DIAGLIBFI_C_U16_SYSTEMSETFINISHED:
   case MIDW_DIAGLIBFI_C_U16_SYSTEMSET:
      bResult = TRUE;
      break;

   default:
      bResult = FALSE;
     break;
   }
   return bResult;
}

//-----------------------------------------------------------------------------

tBool
dia_SAFeatureDiaglib::bIsIoControlMessage(const amt_tclServiceData* poMessage)
{
   dia_tclFnctTrace oTrace("dia_SAFeatureDiaglib::bIsIoControlMessage");

   if ( !poMessage ) return FALSE;

   tBool bResult = FALSE;
   tU16 u16FuncId = poMessage->u16GetFunctionID();

   switch (u16FuncId)
   {
   case MIDW_DIAGLIBFI_C_U16_IOCONTROL:
      bResult = TRUE;
      break;

   default:
       bResult = FALSE;
      break;
   }
   return bResult;
}

//-----------------------------------------------------------------------------

tBool
dia_SAFeatureDiaglib::bIsDiagDataMessage(const amt_tclServiceData* poMessage)
{
   dia_tclFnctTrace oTrace("dia_SAFeatureDiaglib::bIsDiagDataMessage");
   if ( !poMessage ) return FALSE;

   tBool bResult = FALSE;
   tU16 u16FuncId = poMessage->u16GetFunctionID();

   switch (u16FuncId)
   {
#if 0 //STC2HI: TODO
   case MIDW_DIAGLIBFI_C_U16_DIAGNOSISREAD:
   case MIDW_DIAGLIBFI_C_U16_DIAGNOSISWRITE:
#else
   case MIDW_DIAGLIBFI_C_U16_DIAGNOSISDATA:
#endif
      bResult = TRUE;
      break;

   default:
      bResult = FALSE;
     break;
   }
   return bResult;
}

//-----------------------------------------------------------------------------

tBool
dia_SAFeatureDiaglib::bIsRoutineControlMessage(const amt_tclServiceData* poMessage)
{
   dia_tclFnctTrace oTrace("dia_SAFeatureDiaglib::bIsRoutineControlMessage");

   if ( !poMessage ) return FALSE;

   tBool bResult = FALSE;
   tU16 u16FuncId = poMessage->u16GetFunctionID();

   switch (u16FuncId)
   {
   case MIDW_DIAGLIBFI_C_U16_ROUTINECONTROL:
   case MIDW_DIAGLIBFI_C_U16_GETROUTINERESULT:
      bResult = TRUE;
      break;

   default:
      bResult = FALSE;
     break;
   }
   return bResult;
}

//-----------------------------------------------------------------------------

tU32
dia_SAFeatureDiaglib::u32EvalSysSetMessage ( amt_tclServiceData* poMessage, dia_IDiaglibSysSetListener* poListener )
{
   dia_tclFnctTrace oTrace("dia_SAFeatureDiaglib::u32EvalSysSetMessage");

   if ( !poMessage ) return FALSE;

   tU32 u32Result = DIA_SUCCESS;
   tU16 u16FuncId = poMessage->u16GetFunctionID();

   if(FALSE == bIsSysSetMessage(poMessage))
   {
      u32Result = DIA_E_INVALID_MESSAGE;
      return u32Result;
   }

   switch (u16FuncId)
   {
   case MIDW_DIAGLIBFI_C_U16_SYSTEMSETPREPARE:
      u32Result = u32EvalSysSetPrepareMessage (poMessage, poListener );
      break;
   case MIDW_DIAGLIBFI_C_U16_SYSTEMSETFINISHED:
      u32Result = u32EvalSysSetFinishedMessage (poMessage, poListener );
      break;
   case MIDW_DIAGLIBFI_C_U16_SYSTEMSET:
      u32Result = u32EvalSysSetExecuteMessage (poMessage, poListener );
      break;
   default:
      u32Result = DIA_E_INVALID_MESSAGE;
      break;
   }

   return u32Result;
}

//-----------------------------------------------------------------------------

tU32
dia_SAFeatureDiaglib::u32EvalRoutineCtrlMessage ( amt_tclServiceData* poMessage, dia_IDiaglibRoutineControlListener* poListener )
{
   dia_tclFnctTrace oTrace("dia_SAFeatureDiaglib::u32EvalRoutineCtrlMessage");

   if ( !poMessage ) return DIA_E_INVALID_MESSAGE;

   tU32 u32Result = DIA_SUCCESS;
   tU16 u16FuncId = poMessage->u16GetFunctionID();

   if(FALSE == bIsRoutineControlMessage(poMessage))
   {
      u32Result = DIA_E_INVALID_MESSAGE;
      return u32Result;
   }

   switch (u16FuncId)
   {
   case MIDW_DIAGLIBFI_C_U16_ROUTINECONTROL:
      u32Result = u32EvalRoutineControlMessage (poMessage, poListener );
      break;
   case MIDW_DIAGLIBFI_C_U16_GETROUTINERESULT:
      u32Result = u32EvalRoutineResultMessage (poMessage, poListener );
      break;

   default:
      u32Result = DIA_E_INVALID_MESSAGE;
      break;
   }

   return u32Result;
}

//-----------------------------------------------------------------------------

tU32
dia_SAFeatureDiaglib::u32EvalSysSetPrepareMessage ( amt_tclServiceData* poMessage, dia_IDiaglibSysSetListener* poListener )
{
   dia_tclFnctTrace oTrace("dia_SAFeatureDiaglib::u32EvalSysSetPrepareMessage");

   if ( !poMessage ) return DIA_E_INVALID_MESSAGE;

   tU32 u32Result = DIA_SUCCESS;
   // Msg must come from a server
   DIA_ASSERT(poMessage->bIsServerMessage() == TRUE);

   // Extract the op code of the message called
   tU8 u8OpCode = poMessage->u8GetOpCode();

   switch (u8OpCode)
   {
      case AMT_C_U8_CCAMSG_OPCODE_METHODRESULT:
      {
         DIA_TR_INF("--- In CASE: AMT_C_U8_CCAMSG_OPCODE_METHODRESULT");

         if(poListener == OSAL_NULL)
         {
            u32Result = DIA_E_INVALID_POINTER;
            ET_TRACE_INFO(DIA_TRACE_CLASS_DIAGNOSTICS_STRING, "Unexpected null pointer");
         }
         else
         {
            fi_tclVisitorMessage oResultMsg(poMessage);
            midw_diaglibfi_tclMsgSystemSetPrepareMethodResult oResultData;
            (tVoid) oResultMsg.s32GetData(oResultData);

            tDiaglibParamVector vectorError;
            tenSystemSetResult enResult = static_cast<tenSystemSetResult>(oResultData.SystemSetResult.enType);

            dia_DiaglibCcaHelper::vFillVectorFromCcaValueList(oResultData.ErrorList, vectorError);

            poListener->vOnSystemSetPrepareResult(enResult, vectorError);
         }
         break;
      }

      case AMT_C_U8_CCAMSG_OPCODE_ERROR:
      default:
      {
         DIA_TR_INF("--- In CASE: AMT_C_U8_CCAMSG_OPCODE_ERROR");
         u32Result = u32HandleError(poMessage);

         break;
      }
   }

   return u32Result;
}

//-----------------------------------------------------------------------------

tU32
dia_SAFeatureDiaglib::u32EvalSysSetFinishedMessage   ( amt_tclServiceData* poMessage, dia_IDiaglibSysSetListener* poListener )
{
   dia_tclFnctTrace oTrace("dia_SAFeatureDiaglib::u32EvalSysSetFinishedMessage");

   if ( !poMessage ) return DIA_E_INVALID_MESSAGE;

   tU32 u32Result = DIA_SUCCESS;
   // Msg must come from a server
   DIA_ASSERT(poMessage->bIsServerMessage() == TRUE);

   // Extract the op code of the message called
   tU8 u8OpCode = poMessage->u8GetOpCode();

   switch (u8OpCode)
   {
      case AMT_C_U8_CCAMSG_OPCODE_METHODRESULT:
      {
         DIA_TR_INF("--- In CASE: AMT_C_U8_CCAMSG_OPCODE_METHODRESULT");

         if(poListener == OSAL_NULL)
         {
            u32Result = DIA_E_INVALID_POINTER;
            DIA_TR_INF("Unexpected null pointer");
         }
         else
         {
            poListener->vOnSystemSetFinished();
         }
         break;
      }

      case AMT_C_U8_CCAMSG_OPCODE_ERROR:
      default:
      {
         DIA_TR_INF("--- In CASE: AMT_C_U8_CCAMSG_OPCODE_ERROR");
         u32Result = u32HandleError(poMessage);

         break;
      }
   }

   return u32Result;
}

//-----------------------------------------------------------------------------

tU32
dia_SAFeatureDiaglib::u32EvalSysSetExecuteMessage    ( amt_tclServiceData* poMessage, dia_IDiaglibSysSetListener* poListener )
{
   dia_tclFnctTrace oTrace("dia_SAFeatureDiaglib::u32EvalSysSetExecuteMessage");

   if ( !poMessage ) return DIA_E_INVALID_MESSAGE;

   tU32 u32Result = DIA_SUCCESS;
   // Msg must come from a server
   DIA_ASSERT(poMessage->bIsServerMessage() == TRUE);

   // Extract the op code of the message called
   tU8 u8OpCode = poMessage->u8GetOpCode();

   switch (u8OpCode)
   {
      case AMT_C_U8_CCAMSG_OPCODE_METHODRESULT:
      {
         DIA_TR_INF("--- In CASE: AMT_C_U8_CCAMSG_OPCODE_METHODRESULT");

         if(poListener == OSAL_NULL)
         {
            u32Result = DIA_E_INVALID_POINTER;
            DIA_TR_INF("Unexpected null pointer");
         }
         else
         {
            fi_tclVisitorMessage oResultMsg(poMessage);
            midw_diaglibfi_tclMsgSystemSetMethodResult oResultData;
            (tVoid) oResultMsg.s32GetData(oResultData);

            tenSystemSetType enType =  static_cast<tenSystemSetType>(oResultData.SystemSetMode.enType);
            tenSystemSetResult enResult = static_cast<tenSystemSetResult>(oResultData.SystemSetResult.enType);

            tDiaglibParamVector vectorError;
            dia_DiaglibCcaHelper::vFillVectorFromCcaValueList(oResultData.ErrorList, vectorError);

            poListener->vOnSystemSetResult(oResultData.SystemSetId, enType, enResult, vectorError);
         }
         break;
      }

      case AMT_C_U8_CCAMSG_OPCODE_ERROR:
      default:
      {
         DIA_TR_INF("--- In CASE: AMT_C_U8_CCAMSG_OPCODE_ERROR");
         u32Result = u32HandleError(poMessage);

         break;
      }
   }

   return u32Result;
}

//-----------------------------------------------------------------------------

tU32
dia_SAFeatureDiaglib::u32EvalRoutineResultMessage    ( amt_tclServiceData* poMessage, dia_IDiaglibRoutineControlListener* poListener )
{
   dia_tclFnctTrace oTrace("dia_SAFeatureDiaglib::u32EvalRoutineResultMessage");

   if ( !poMessage ) return DIA_E_INVALID_MESSAGE;

   tU32 u32Result = DIA_SUCCESS;
   // Msg must come from a server
   DIA_ASSERT(poMessage->bIsServerMessage() == TRUE);

   // Extract the op code of the message called
   tU8 u8OpCode = poMessage->u8GetOpCode();

   switch (u8OpCode)
   {
      case AMT_C_U8_CCAMSG_OPCODE_METHODRESULT:
      {
         DIA_TR_INF("--- In CASE: AMT_C_U8_CCAMSG_OPCODE_METHODRESULT");

         if(poListener == OSAL_NULL)
         {
            u32Result = DIA_E_INVALID_POINTER;
            ET_TRACE_INFO(DIA_TRACE_CLASS_DIAGNOSTICS_STRING, "Unexpected null pointer");
         }
         else
         {
            fi_tclVisitorMessage oResultMsg(poMessage);
            midw_diaglibfi_tclMsgGetRoutineResultMethodResult oResultData;
            (tVoid) oResultMsg.s32GetData(oResultData);

            tDiaglibParamVector vectorResult;
            tenRoutineCtrlResult enResult = static_cast<tenRoutineCtrlResult>(oResultData.RoutineStatus.enType);

            dia_DiaglibCcaHelper::vFillVectorFromCcaValueList(oResultData.RoutineResult, vectorResult);

            poListener->vOnGetRoutineResult(oResultData.RoutineId, enResult, vectorResult);
         }
         break;
      }

      case AMT_C_U8_CCAMSG_OPCODE_ERROR:
      default:
      {
         DIA_TR_INF("--- In CASE: AMT_C_U8_CCAMSG_OPCODE_ERROR");
         u32Result = u32HandleError(poMessage);

         break;
      }
   }

   return u32Result;
}

//-----------------------------------------------------------------------------

tU32
dia_SAFeatureDiaglib::u32EvalRoutineControlMessage   ( amt_tclServiceData* poMessage, dia_IDiaglibRoutineControlListener* poListener )
{
   dia_tclFnctTrace oTrace("dia_SAFeatureDiaglib::u32EvalRoutineControlMessage");

   if ( !poMessage ) return DIA_E_INVALID_MESSAGE;

   tU32 u32Result = DIA_SUCCESS;
   // Msg must come from a server
   DIA_ASSERT(poMessage->bIsServerMessage() == TRUE);

   // Extract the op code of the message called
   tU8 u8OpCode = poMessage->u8GetOpCode();

   switch (u8OpCode)
   {
      case AMT_C_U8_CCAMSG_OPCODE_METHODRESULT:
      {
         DIA_TR_INF("--- In CASE: AMT_C_U8_CCAMSG_OPCODE_METHODRESULT");

         if(poListener == OSAL_NULL)
         {
            u32Result = DIA_E_INVALID_POINTER;
            ET_TRACE_INFO(DIA_TRACE_CLASS_DIAGNOSTICS_STRING, "Unexpected null pointer");
         }
         else
         {
            fi_tclVisitorMessage oResultMsg(poMessage);
            midw_diaglibfi_tclMsgRoutineControlMethodResult oResultData;
            (tVoid) oResultMsg.s32GetData(oResultData);

            tDiaglibParamVector vectorResult;
            tenRoutineCtrlResult enResult = static_cast<tenRoutineCtrlResult>(oResultData.RoutineStatus.enType);

            dia_DiaglibCcaHelper::vFillVectorFromCcaValueList(oResultData.RoutineResult, vectorResult);

            poListener->vOnRoutineCtrlResult(oResultData.RoutineId, enResult, vectorResult);
         }
         break;
      }

      case AMT_C_U8_CCAMSG_OPCODE_ERROR:
      default:
      {
         DIA_TR_INF("--- In CASE: AMT_C_U8_CCAMSG_OPCODE_ERROR");
         u32Result = u32HandleError(poMessage);

         break;
      }
   }

   return u32Result;
}

//-----------------------------------------------------------------------------

tU32
dia_SAFeatureDiaglib::u32HandleError ( amt_tclServiceData* poMessage )
{
   dia_tclFnctTrace oTrace("dia_SAFeatureDiaglib::u32HandleError");

   if ( !poMessage ) return DIA_E_INVALID_MESSAGE;
   if (  poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_ERROR ) return DIA_E_INVALID_POINTER;

   tU32 u32Result = DIA_SUCCESS;

   amt_tclServiceDataError oErrorMsg( poMessage );
   tU16 u16ErrorCode = oErrorMsg.u16GetErrorData();

   switch ( u16ErrorCode )
   {
      case AMT_C_U16_ERROR_FUNCTION_BUSY: //The function is available, but is busy (there is no queueing for this function)
      case AMT_C_U16_ERROR_INTERNAL_FAILURE: //The execution of the function failed
      {
         DIA_TR_INF("--- In CASE: AMT_C_U16_ERROR_FUNCTION_BUSY and AMT_C_U16_ERROR_INTERNAL_FAILURE");
         u32Result = DIA_FAILED;

         // Too much clients which are already registered or you tried to register twice.

         // set the corresponding register in progress and done status to FALSE

         break;
      }

      case AMT_C_U16_ERROR_UNKNOWN_REG_ID:
      {
         DIA_TR_INF("--- In CASE: AMT_C_U16_ERROR_UNKNOWN_REG_ID");
         u32Result = DIA_FAILED;

         // This code is used by AIL, if connection is no longer accessible
         // set register in progress ans done status to FALSE

         break;
      }

      default:
      {
         DIA_TR_INF("--- In CASE: default");
         u32Result = DIA_FAILED;
         // refer to your message catalogue of possible other error codes


         if ( u16ErrorCode == AMT_C_U16_ERROR_TEMPORARY_NOT_AVAILABLE )
         {
            // At the moment, the service not available. Do some error handling, if required
         }

         break;
      }
   }

   return u32Result;
}

//-----------------------------------------------------------------------------

tBool
dia_SAFeatureDiaglib::bPrepareForSysSet(const tU32 u32SysSetId, const tenSystemSetType enSysSetType, dia_SystemAdapterServicePlugin* poSender )
{
   dia_tclFnctTrace oTrace("dia_SAFeatureDiaglib::bPrepareForSysSet");

   if ( !poSender ) return FALSE;

   midw_diaglibfi_tclMsgSystemSetPrepareMethodStart data;
   DIA_TR_INF("SysSet Adapter: Send Prepare with SysSetID: %d",u32SysSetId);

   DIA_TR_INF("APP=0x%04x, SRV=0x%04x, REG=0x%04x", poSender->getClientID(), poSender->getServiceID(), poSender->getRegistrationID()); //lint !e864
   data.SystemSetId = u32SysSetId;
   data.SystemSetMode.enType = static_cast<midw_fi_tcl_e8_SystemSetType::tenType>(enSysSetType);

   fi_tclVisitorMessage oRequest(data);

   poSender->vInitServiceData(oRequest, MIDW_DIAGLIBFI_C_U16_SYSTEMSETPREPARE, AMT_C_U8_CCAMSG_OPCODE_METHODSTART);

   return ( TRUE == poSender->bTransmitMessage(&oRequest) ) ? TRUE :FALSE;
}

//-----------------------------------------------------------------------------

tBool
dia_SAFeatureDiaglib::bExecuteSysSet(const tU32 u32SysSetId, const tenSystemSetType enSysSetType, dia_SystemAdapterServicePlugin* poSender )
{
   dia_tclFnctTrace oTrace("dia_SAFeatureDiaglib::bExecuteSysSet");

   if ( !poSender ) return FALSE;

   midw_diaglibfi_tclMsgSystemSetMethodStart data;
   DIA_TR_INF("SysSet Adapter: Send Execute with SysSetID: %d",u32SysSetId);
   DIA_TR_INF("APP=0x%04x, SRV=0x%04x, REG=0x%04x", poSender->getClientID(), poSender->getServiceID(), poSender->getRegistrationID()); //lint !e864

   data.SystemSetId = u32SysSetId;
   data.SystemSetMode.enType = static_cast<midw_fi_tcl_e8_SystemSetType::tenType>(enSysSetType);

   fi_tclVisitorMessage oRequest(data);

   poSender->vInitServiceData(oRequest, MIDW_DIAGLIBFI_C_U16_SYSTEMSET, AMT_C_U8_CCAMSG_OPCODE_METHODSTART);

   return ( TRUE == poSender->bTransmitMessage(&oRequest) ) ? TRUE :FALSE;
}

//-----------------------------------------------------------------------------

tBool
dia_SAFeatureDiaglib::bEndOfSysSet(const tU32 u32SysSetId, const tenSystemSetType enSysSetType, dia_SystemAdapterServicePlugin* poSender )
{
   dia_tclFnctTrace oTrace("dia_SAFeatureDiaglib::bEndOfSysSet");

   if ( !poSender ) return FALSE;

   midw_diaglibfi_tclMsgSystemSetFinishedMethodStart data;
   DIA_TR_INF("SysSet Adapter: Send Finished with SysSetID: %d",u32SysSetId);
   DIA_TR_INF("APP=0x%04x, SRV=0x%04x, REG=0x%04x", poSender->getClientID(), poSender->getServiceID(), poSender->getRegistrationID()); //lint !e864

   data.SystemSetId = u32SysSetId;
   data.SystemSetMode.enType = static_cast<midw_fi_tcl_e8_SystemSetType::tenType>(enSysSetType);

   fi_tclVisitorMessage oRequest(data);

   poSender->vInitServiceData(oRequest, MIDW_DIAGLIBFI_C_U16_SYSTEMSETFINISHED, AMT_C_U8_CCAMSG_OPCODE_METHODSTART);

   return ( TRUE == poSender->bTransmitMessage(&oRequest) ) ? TRUE :FALSE;
}

//-----------------------------------------------------------------------------

tBool
dia_SAFeatureDiaglib::bRoutineControlStart  (const tU32 u32RoutineId, const tU32 u32Bitmask, const tDiaglibParamVector& oParamVector, dia_SystemAdapterServicePlugin* poSender )
{
   dia_tclFnctTrace oTrace("dia_SAFeatureDiaglib::bRoutineControlStart");

   if ( !poSender ) return FALSE;

   midw_diaglibfi_tclMsgRoutineControlMethodStart data;
   DIA_TR_INF("RoutineControl: Send Start with Routine Id: %d",u32RoutineId);
   DIA_TR_INF("APP=0x%04x, SRV=0x%04x, REG=0x%04x", poSender->getClientID(), poSender->getServiceID(), poSender->getRegistrationID()); //lint !e864

   data.RoutineId = u32RoutineId;
   data.RoutineBitMask.u32Value = u32Bitmask;
   dia_DiaglibCcaHelper::vFillCcaValueListFromVector(oParamVector, data.RoutineParameterList);

   fi_tclVisitorMessage oRequest(data);

   poSender->vInitServiceData(oRequest, MIDW_DIAGLIBFI_C_U16_ROUTINECONTROL, AMT_C_U8_CCAMSG_OPCODE_METHODSTART);

   return ( TRUE == poSender->bTransmitMessage(&oRequest) ) ? TRUE :FALSE;
}

//-----------------------------------------------------------------------------

tBool
dia_SAFeatureDiaglib::bRoutineControlAbort  (const tU32 u32RoutineId, dia_SystemAdapterServicePlugin* poSender )
{
   dia_tclFnctTrace oTrace("dia_SAFeatureDiaglib::bRoutineControlAbort");

   if ( !poSender ) return FALSE;

   midw_diaglibfi_tclMsgRoutineControlMethodAbort data;
   DIA_TR_INF("RoutineControl: Send Abort with Routine Id: %d", u32RoutineId);
   DIA_TR_INF("APP=0x%04x, SRV=0x%04x, REG=0x%04x", poSender->getClientID(), poSender->getServiceID(), poSender->getRegistrationID()); //lint !e864

   data.RoutineId = u32RoutineId;

   fi_tclVisitorMessage oRequest(data);

   poSender->vInitServiceData(oRequest, MIDW_DIAGLIBFI_C_U16_ROUTINECONTROL, AMT_C_U8_CCAMSG_OPCODE_METHODABORT);

   return ( TRUE == poSender->bTransmitMessage(&oRequest) ) ? TRUE :FALSE;
}

//-----------------------------------------------------------------------------

tBool
dia_SAFeatureDiaglib::bGetRoutineResult     (const tU32 u32RoutineId, dia_SystemAdapterServicePlugin* poSender )
{
   dia_tclFnctTrace oTrace("dia_SAFeatureDiaglib::bGetRoutineResult");

   if ( !poSender ) return FALSE;

   midw_diaglibfi_tclMsgGetRoutineResultMethodStart data;
   DIA_TR_INF("GetRoutineResult: Send Start with Routine Id: %d", u32RoutineId);
   DIA_TR_INF("APP=0x%04x, SRV=0x%04x, REG=0x%04x", poSender->getClientID(), poSender->getServiceID(), poSender->getRegistrationID()); //lint !e864

   data.RoutineId = u32RoutineId;

   fi_tclVisitorMessage oRequest(data);

   poSender->vInitServiceData(oRequest, MIDW_DIAGLIBFI_C_U16_GETROUTINERESULT, AMT_C_U8_CCAMSG_OPCODE_METHODSTART);

   return ( TRUE == poSender->bTransmitMessage(&oRequest) ) ? TRUE :FALSE;
}

//-----------------------------------------------------------------------------

tU32
dia_SAFeatureDiaglib::u32EvalIoCtrlMessage ( amt_tclServiceData* poMessage, dia_IDiaglibIoControlListener* poListener )
{
   if ( !poMessage ) return DIA_E_INVALID_MESSAGE;

   dia_tclFnctTrace oTrace("--> dia_SAFeatureDiaglib::u32EvalIoCtrlMessage");
   tU32 u32Result = DIA_SUCCESS;
   tU16 u16FuncId = poMessage->u16GetFunctionID();

   if(FALSE == bIsIoControlMessage(poMessage))
   {
      u32Result = DIA_E_INVALID_MESSAGE;
      return u32Result;
   }

   switch (u16FuncId)
   {
      case MIDW_DIAGLIBFI_C_U16_IOCONTROL:
         u32Result = u32EvalIoControlMessage (poMessage, poListener );
         break;
      default:
         u32Result = DIA_E_INVALID_MESSAGE;
         break;
   }
   return u32Result;
}

//-----------------------------------------------------------------------------

tBool
dia_SAFeatureDiaglib::bIOControlStart (const tU32 u32ControlId, const tenIoControlAction enActionId, const tDiaglibParamVector& oParamVector, dia_SystemAdapterServicePlugin* poSender )
{
   dia_tclFnctTrace oTrace("dia_SAFeatureDiaglib::bIOControlStart");

   if ( !poSender )
   {
      DIA_TR_INF("!!! dia_SAFeatureDiaglib::bIOControlStart => ERROR: poSender != OSAL_NULL");
      return FALSE;
   }

   tBool bRetVal = FALSE;

   midw_diaglibfi_tclMsgIOControlMethodStart data;

   data.ControlId = u32ControlId;
   data.ActionId.enType = static_cast<midw_fi_tcl_e8_IOControlActionId::tenType> (enActionId);
   dia_DiaglibCcaHelper::vFillCcaValueListFromVector(oParamVector, data.IOParameterList);

   fi_tclVisitorMessage oRequest(data);

   poSender->vInitServiceData(oRequest, MIDW_DIAGLIBFI_C_U16_IOCONTROL, AMT_C_U8_CCAMSG_OPCODE_METHODSTART);

   if( TRUE == poSender->bTransmitMessage(&oRequest) )
   {
      DIA_TR_INF("--- dia_SAFeatureDiaglib::bIOControlStart => Transmitted succesfully");
      bRetVal = TRUE;
   }
   else
   {
      DIA_TR_INF("!!! dia_SAFeatureDiaglib::bIOControlStart => ERROR: bTransmitMessage failed");
      bRetVal = FALSE;
   }

   return bRetVal;
}

//-----------------------------------------------------------------------------

tU32
dia_SAFeatureDiaglib::u32EvalIoControlMessage ( amt_tclServiceData* poMessage, dia_IDiaglibIoControlListener* poListener )
{
   dia_tclFnctTrace oTrace("--> dia_SAFeatureDiaglib::u32EvalIoControlMessage");

   if ( !poMessage ) return DIA_E_INVALID_MESSAGE;

   tU32 u32Result = DIA_SUCCESS;
   // Msg must come from a server
   DIA_ASSERT(poMessage->bIsServerMessage() == TRUE);


   // Extract the op code of the message called
   tU8 u8OpCode = poMessage->u8GetOpCode();

   switch (u8OpCode)
   {
      case AMT_C_U8_CCAMSG_OPCODE_METHODRESULT:
      {
         DIA_TR_INF("--- dia_SAFeatureDiaglib::u32EvalIoControlMessage=> u8OpCode = AMT_C_U8_CCAMSG_OPCODE_METHODRESULT");

         if(OSAL_NULL == poListener)
         {
            u32Result = DIA_E_INVALID_POINTER;
            DIA_TR_INF("!!! dia_SAFeatureDiaglib::u32EvalIoControlMessage => ERROR: OSAL_NULL == poListener");
         }
         else
         {
            fi_tclVisitorMessage oResultMsg(poMessage);
            midw_diaglibfi_tclMsgIOControlMethodResult oResultData;
            (tVoid) oResultMsg.s32GetData(oResultData);

            tDiaglibParamVector vectorResult;
            tenIoControlAction enAction = static_cast<tenIoControlAction>(oResultData.ActionId.enType);
            tenIoCtrlResult enResult =  static_cast<tenIoCtrlResult>(oResultData.IOResult.enType);
            dia_DiaglibCcaHelper::vFillVectorFromCcaValueList(oResultData.IOResultList, vectorResult);
            DIA_TR_INF("--- dia_SAFeatureDiaglib::u32EvalIoControlMessage => CtrlId:%d Res:%d Act:%d", oResultData.ControlId, enResult, enAction);

            poListener->vOnIoCtrlResult(oResultData.ControlId, enResult, enAction, vectorResult);
            u32Result = DIA_SUCCESS;
         }
         break;
      }

      case AMT_C_U8_CCAMSG_OPCODE_ERROR:
      default:
      {
         DIA_TR_INF("!!! dia_SAFeatureDiaglib::u32EvalIoControlMessage => ERROR: u8OpCode = AMT_C_U8_CCAMSG_OPCODE_ERROR");
         u32Result = u32HandleError(poMessage);

         break;
      }
   }

   return u32Result;
}

//-----------------------------------------------------------------------------

tBool
dia_SAFeatureDiaglib::bDiagDataReadStart (const tU32 u32DiagDataId,  dia_SystemAdapterServicePlugin* poSender)
{
   dia_tclFnctTrace oTrace("dia_SAFeatureDiaglib::bDiagDataReadStart");

   tBool bRetVal = FALSE;

   midw_diaglibfi_tclMsgDiagnosisReadMethodStart data;

   data.DiagnosisDataId = u32DiagDataId;

   fi_tclVisitorMessage oRequest(data);

   if(poSender != OSAL_NULL)
   {
      poSender->vInitServiceData(oRequest, MIDW_DIAGLIBFI_C_U16_DIAGNOSISDATA, AMT_C_U8_CCAMSG_OPCODE_GET);

      if( TRUE == poSender->bTransmitMessage(&oRequest) )
      {
//         ETG_TRACE_COMP_THR(( "--- dia_SAFeatureDiaglib::bDiagDataReadStart => Transmitted succesfully"));
         DIA_TR_INF("--- dia_SAFeatureDiaglib::bDiagDataReadStart => Transmitted succesfully");
         bRetVal = TRUE;
      }
      else
      {
//         ETG_TRACE_ERR_THR(( "!!! dia_SAFeatureDiaglib::bDiagDataReadStart => ERROR: bTransmitMessage failed"));
         DIA_TR_ERR("!!! dia_SAFeatureDiaglib::bDiagDataReadStart => ERROR: bTransmitMessage failed");
         bRetVal = FALSE;
      }
   }
   else
   {
//      ETG_TRACE_ERR_THR(( "!!! dia_SAFeatureDiaglib::bDiagDataReadStart => ERROR: poSender != OSAL_NULL"));
      DIA_TR_ERR("!!! dia_SAFeatureDiaglib::bDiagDataReadStart => ERROR: poSender != OSAL_NULL");
      bRetVal = FALSE;
   }

   return bRetVal;
}

//-----------------------------------------------------------------------------

tU32 dia_SAFeatureDiaglib::u32EvalDiagnosisDataCtrlMessage ( amt_tclServiceData* poMessage, dia_IDiaglibDiagnosisDataListener* poListener )
{
   dia_tclFnctTrace oTrace("dia_SAFeatureDiaglib::u32EvalDiagnosisDataCtrlMessage");
   tU32 u32Result = DIA_SUCCESS;

   if(poMessage == NULL)
   {
//      ETG_TRACE_ERR_THR(("!!! dia_SAFeatureDiaglib::u32EvalDiagnosisDataCtrlMessage => ERROR: poMessage == NULL" ));
      DIA_TR_ERR("!!! dia_SAFeatureDiaglib::u32EvalDiagnosisDataCtrlMessage => ERROR: poMessage == NULL");
      u32Result = DIA_E_INVALID_POINTER;
   }// if(poMessage == NULL)
   else
   {
      tU16 u16FuncId = poMessage->u16GetFunctionID();

      if(FALSE == bIsDiagDataMessage(poMessage))
      {
//         ETG_TRACE_ERR_THR(("!!! dia_SAFeatureDiaglib::u32EvalDiagnosisDataCtrlMessage => ERROR: bIsDiagDataMessage == FALSE" ));
         DIA_TR_ERR("!!! dia_SAFeatureDiaglib::u32EvalDiagnosisDataCtrlMessage => ERROR: bIsDiagDataMessage == FALSE" );
         u32Result = DIA_E_INVALID_MESSAGE;
         return u32Result;
      }

      switch (u16FuncId)
      {
         case MIDW_DIAGLIBFI_C_U16_DIAGNOSISDATA:
         {
            if(poListener == NULL)
            {
               DIA_TR_ERR("!!! dia_SAFeatureDiaglib::u32EvalDiagnosisDataCtrlMessage => ERROR: poListener == NULL" );
               u32Result = DIA_E_INVALID_POINTER;
            }
            else
            {
               u32Result = u32EvalDiagnosisDataControlMessage (poMessage, poListener );
            }
            break;
         }// case MIDW_DIAGLIBFI_C_U16_DIAGNOSISDATA:

         default:
         {
            u32Result = DIA_E_INVALID_MESSAGE;
            break;
         }// default:
      }// switch (u16FuncId)
   }// else // if(poMessage == NULL)

   return u32Result;
}

//-----------------------------------------------------------------------------

tU32 dia_SAFeatureDiaglib::u32EvalDiagnosisDataControlMessage ( amt_tclServiceData* poMessage, dia_IDiaglibDiagnosisDataListener* poListener )
{
   dia_tclFnctTrace oTrace("dia_SAFeatureDiaglib::u32EvalDiagnosisDataControlMessage");

   tU32 u32Result = DIA_SUCCESS;
   // Msg must come from a server
   DIA_ASSERT(poMessage->bIsServerMessage() == TRUE);


   // Extract the op code of the message called
   tU8 u8OpCode = poMessage->u8GetOpCode();

   switch (u8OpCode)
   {
      case AMT_C_U8_CCAMSG_OPCODE_STATUS:
      {
         DIA_TR_INF( "--- dia_SAFeatureDiaglib::u32EvalDiagnosisDataControlMessage=> u8OpCode = AMT_C_U8_CCAMSG_OPCODE_STATUS");

         if(OSAL_NULL == poListener)
         {
            u32Result = DIA_E_INVALID_POINTER;
            DIA_TR_ERR( "!!! dia_SAFeatureDiaglib::u32EvalDiagnosisDataControlMessage => ERROR: OSAL_NULL == poListener");
         }
         else
         {
            fi_tclVisitorMessage oResultMsg(poMessage);
            midw_diaglibfi_tclMsgDiagnosisDataStatus oResultData;
            (tVoid) oResultMsg.s32GetData(oResultData);

            tDiaglibParamVector vectorResult;
            tenDiagDataResult enResult =  static_cast<tenDiagDataResult>(oResultData.DiagnosisDataResult.enType);
            dia_DiaglibCcaHelper::vFillVectorFromCcaValueList(oResultData.DiagnosisDataValues, vectorResult);
            DIA_TR_INF( "--- dia_SAFeatureDiaglib::u32EvalDiagnosisDataControlMessage => DataId:%d Res:%d",oResultData.DiagnosisDataId,enResult);

            poListener->vOnDiagnosisDataResult(oResultData.DiagnosisDataId, enResult, vectorResult);
         }
         break;
      }

      case AMT_C_U8_CCAMSG_OPCODE_ERROR:
      default:
      {
         DIA_TR_ERR( "!!! dia_SAFeatureDiaglib::u32EvalDiagnosisDataControlMessage => ERROR: u8OpCode = AMT_C_U8_CCAMSG_OPCODE_ERROR");
         u32Result = u32HandleError(poMessage);

         break;
      }
   }

   return u32Result;
}

