/*
 * dia_SAFeatureClearMCANHistory.h
 *
 *  Created on: 30.11.2015
 *      Author: shw2abt
 *
 *  Framework to handle clear of all MCAN histories. Due to the number of components and their names are unknown we have this flexible framework.
 *  This class is derived from the system settings framework which already exists and is proofed. The super-class functions prepare and finalize are implemented
 *  in that way that they have no function for this usecase. We only need the execute command where we have the chance to clear all histories.
 */

#ifndef __INCLUDED_DIA_SAFEATURE_CLEAR_MCAN_HISTORY__
#define __INCLUDED_DIA_SAFEATURE_CLEAR_MCAN_HISTORY__

#ifndef __INCLUDED_DIA_COMMON_CONFIG__
#include "common/framework/config/dia_common_config.h"
#endif

#ifndef __INCLUDED_DIA_SYSTEM_SETTINGS_MODULE__
#include <common/framework/sysset/dia_SystemSettingsModule.h>
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FEATURE__
#include <common/framework/sysadapters/dia_SystemAdapterFeature.h>
#endif

class amt_tclServiceData;
class dia_SystemAdapterServicePlugin;

class dia_SAFeatureClearMCANHistory
   : public dia_SystemAdapterFeature,
     public dia_SystemSettingsModule
{
public:
   dia_SAFeatureClearMCANHistory (
         tCString name,
         tU32 u32SystemSetId,
         tU32 u32SystemSetTypes,
         dia_SystemAdapterServicePlugin& pSrvPlugin
   );

   // destructor
   virtual ~dia_SAFeatureClearMCANHistory ( void );

   //--------------------------------------------------------------------------
   // Methods inherited from dia_SystemSettingsModule
   //--------------------------------------------------------------------------

   //! prepare the module for the system setting
   virtual tDiaResult prepareSystemSetting ( dia_UID sysSetTypeUID, const dia_SystemSettingExtendedData& extData );
   //! execute the system setting
   virtual tDiaResult executeSystemSetting ( dia_UID sysSetTypeUID, const dia_SystemSettingExtendedData& extData ) = 0;
   //! finalize the system setting
   virtual tDiaResult finalizeSystemSetting ( dia_UID sysSetTypeUID, const dia_SystemSettingExtendedData& extData );

protected:
   // constructor
   dia_SAFeatureClearMCANHistory ( void ); // Not implemented, do not use

   dia_UID mSystemSettingTypeUID;
   tU32 mu32SystemSetId;
   tU32 mu32SystemSetTypes;
};

#endif /* __INCLUDED_DIA_SAFEATURE_CLEAR_MCAN_HISTORY__ */
