/*
 * dia_SAFeatureClearClockHistory.h
 *
 *  Created on: 30.06.2016
 *      Author: stc2hi
 *
 *  Framework to handle clear of all MCAN histories. Due to the number of components and their names are unknown we have this flexible framework.
 *  This class is derived from the system settings framework which already exists and is proofed. The super-class functions prepare and finalize are implemented
 *  in that way that they have no function for this usecase. We only need the execute command where we have the chance to clear all histories.
 */

#ifndef __INCLUDED_DIA_SAFEATURE_CLEAR_CLOCK_HISTORY__
#define __INCLUDED_DIA_SAFEATURE_CLEAR_CLOCK_HISTORY__

#ifndef __INCLUDED_DIA_SAFEATURE_CLEAR_MCAN_HISTORY__
#include "project/framework/sysadapters/dia_SAFeatureClearMCANHistory.h"
#endif


class dia_SAFeatureClearClockHistory
   : public dia_SAFeatureClearMCANHistory
{
public:
   dia_SAFeatureClearClockHistory (
         tCString name,
         tU32 u32SystemSetId,
         tU32 u32SystemSetTypes,
         dia_SystemAdapterServicePlugin& pSrvPlugin
   );

   // destructor
   virtual ~dia_SAFeatureClearClockHistory ( void );

   //--------------------------------------------------------------------------
   // Methods inherited from dia_SAFeatureClearMCANHistory
   //--------------------------------------------------------------------------

   //! execute the system setting
   virtual tDiaResult executeSystemSetting ( dia_UID sysSetTypeUID, const dia_SystemSettingExtendedData& extData );

protected:
   // constructor
   dia_SAFeatureClearClockHistory ( void ); // Not implemented, do not use

   void vHandleResetHistory ( amt_tclServiceData* poMessage );

   // declare message map data structures
   DECLARE_MSG_MAP(dia_SAFeatureClearClockHistory)
};

#endif /* __INCLUDED_DIA_SAFEATURE_CLEAR_CLOCK_HISTORY__ */
