/*
 * dia_SAFeatureClearClockHistory.h
 *
 *  Created on: 30.06.2016
 *      Author: stc2hi
 */

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#define CLOCK_FI_S_IMPORT_INTERFACE_CLOCK_MAINFI_TYPES
#define CLOCK_FI_S_IMPORT_INTERFACE_CLOCK_MAINFI_FUNCTIONIDS
#define CLOCK_FI_S_IMPORT_INTERFACE_CLOCK_MAINFI_SERVICEINFO
#include "clock_fi_if.h" //lint !e451 !e537 repeatedly included header file without standard include guard

#ifndef __INCLUDED_DIA_SAFEATURE_SYSTEM_SETTINGS__
#include <common/framework/sysadapters/dia_SAFeatureSystemSettings.h>
#endif

#ifndef __INCLUDED_DIA_SAFEATURE_CLEAR_CLOCK_HISTORY__
#include "dia_SAFeatureClearClockHistory.h"
#endif

#ifndef __INCLUDED_DIA_SYSTEM_SETTINGS_MANAGER__
#include <common/framework/sysset/dia_SystemSettingsManager.h>
#endif


// MESSAGE MAP:
// The message map maps IDs of incoming CCA messages to proper handle methods
BEGIN_MSG_MAP( dia_SAFeatureClearClockHistory, dia_SystemAdapterFeature )
    ON_MESSAGE(CLOCK_MAINFI_C_U16_RESETHISTORY,    vHandleResetHistory)
END_MSG_MAP()

//-----------------------------------------------------------------------------

dia_SAFeatureClearClockHistory::dia_SAFeatureClearClockHistory (
   tCString name,
   tU32 u32SystemSetId,
   tU32 u32SystemSetTypes,
   dia_SystemAdapterServicePlugin& pSrvPlugin
   )
    : dia_SAFeatureClearMCANHistory(name,u32SystemSetId,u32SystemSetTypes,pSrvPlugin)
{
}

//-----------------------------------------------------------------------------

dia_SAFeatureClearClockHistory::~dia_SAFeatureClearClockHistory ( void )
{}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureClearClockHistory::executeSystemSetting ( dia_UID typeUID, const dia_SystemSettingExtendedData& /*extData*/ )
{
   dia_tclFnctTrace trc("dia_SAFeatureClearClockHistory::executeSystemSetting()");
   tDiaResult retCode = DIA_FAILED;

   DIA_TR_INF("dia_SAFeatureClearClockHistory::executeSystemSetting Execute Clear History (system setting) (module=\"%s\", typeUID=0x%08x) .", getName(), typeUID);
   mSystemSettingTypeUID = typeUID;

   if (isSystemSettingTypeSupported(typeUID))
   {
      if (OSAL_NULL != mpSrvPlugin)
      {
         clock_mainfi_tclMsgResetHistoryMethodStart oMethodStart;   //lint !e1502 shw2abt: oMethodStart is given by component and has no own variable
         fi_tclVisitorMessage oResultMsg(oMethodStart);

         mpSrvPlugin->vInitServiceData(oResultMsg, CLOCK_MAINFI_C_U16_RESETHISTORY, AMT_C_U8_CCAMSG_OPCODE_METHODSTART);
         if (mpSrvPlugin->bTransmitMessage(&oResultMsg) == TRUE)
         {
            DIA_TR_INF("dia_SAFeatureClearClockHistory::executeSystemSetting bTransmitMessage SUCCESS.");
            retCode = DIA_SUCCESS;
         }
         else
         {
            DIA_TR_ERR("dia_SAFeatureClearClockHistory::executeSystemSetting bTransmitMessage FAILED!");
         }
      }

   }
   else
   {
      DIA_TR_ERR("dia_SAFeatureClearClockHistory::executeSystemSetting System setting type is not supported !");
      getInstanceOfSystemSettingsManager()->onSystemSettingsModuleUpdate(*this, typeUID, DIA_EN_SYSTEM_SETTING_LEVEL_EXECUTE, DIA_SUCCESS);
   }

   return retCode;
}

//-----------------------------------------------------------------------------

void
dia_SAFeatureClearClockHistory::vHandleResetHistory ( amt_tclServiceData* poMessage )
{
   dia_tclFnctTrace trc("dia_SAFeatureClearClockHistory::vHandleResetHistory()");

   if (poMessage) {
      DIA_ASSERT(poMessage->bIsServerMessage() == TRUE);

      if (poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODRESULT) {
         DIA_TR_INF("dia_SAFeatureClearClockHistory::vHandleResetHistory methodresult response received.");
         getInstanceOfSystemSettingsManager()->onSystemSettingsModuleUpdate(*this, mSystemSettingTypeUID, DIA_EN_SYSTEM_SETTING_LEVEL_EXECUTE, DIA_SUCCESS);
      } else if (poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_ERROR) {
         amt_tclServiceDataError oErrorMsg(poMessage);
         DIA_TR_ERR("dia_SAFeatureClearClockHistory::vHandleResetHistory - opcode error received with error code: 0x%04x", oErrorMsg.u16GetErrorData());
      } else {
         amt_tclServiceDataError oErrorMsg(poMessage);
         DIA_TR_ERR("dia_SAFeatureClearClockHistory::vHandleResetHistory - UNKNOWN opcode error received: 0x%04x", oErrorMsg.u16GetErrorData());
      }

      (void) poMessage->bDelete();
   }
}
