/*****************************************************************************************
*
* \file    dia_SAFeatureBluetoothMost.h
*
* \brief   System Adapter for CCA communication with BT componenet
*
* \author  nce5kor	
*
* \date    02.12.2015
*
* (c) 2014 Robert Bosch Car Multimedia GmbH
*--------------------------------------------------------
* Date 		   | Author  	          | Modification
* 30-12-2015   | nce5kor			  | Code changes to support the new interface for BTSignalQuality
* 28-11-2016   | jas1hi			      | Code changes to support the new interface dia_IWifiMost
****************************************************************************************/

#ifndef DIA_SAFEATUREBLUETOOTH_MOST_H_
#define DIA_SAFEATUREBLUETOOTH_MOST_H_

#ifndef __INCLUDED_DIA_INTERFACE_BLUETOOTH_MOST_LISTENER__
#include <project/interfaces/dia_IBluetoothMostListener.h>
#endif

#ifndef __INCLUDED_DIA_INTERFACE_WIFIMOST__
#include <project/interfaces/dia_IWifiMostListener.h>
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FEATURE__
#include "common/framework/sysadapters/dia_SystemAdapterFeature.h"
#endif


//-----------------------------------------------------------------------------
// class definition
//-----------------------------------------------------------------------------

class dia_SAFeatureBluetoothMost
   : public dia_SystemAdapterFeature,
     public dia_IBluetoothMost,
     public dia_IWifiMost
{
public:
   //! constructor
   dia_SAFeatureBluetoothMost ( tCString name, dia_SystemAdapterServicePlugin& pSrvPlugin );

   //! destructor
   virtual ~dia_SAFeatureBluetoothMost ( void );

   //-------------------------------------------------------------------------
   //
   // Overloaded dia_IBluetoothMost methods
   //
   //-------------------------------------------------------------------------
  
   virtual tDiaResult getBTMostDeviceList ( void  );

   virtual tDiaResult getBTSignalQuality ( void );
   virtual tDiaResult registerToBTConnectionStatus(void);

   //-------------------------------------------------------------------------
   //
   // Overloaded dia_IWifiMost methods
   //
   //-------------------------------------------------------------------------

   virtual tDiaResult vChangeWifiTransmitPower ( const tU8 wifiPowerAttenuation );

private:
   tU8 totalBTdevices;

protected:
   //! deprecated default constructor
   dia_SAFeatureBluetoothMost ( void );

   //! handler CCA message returning information on all BT devices
   void vHandleBTDeviceList ( amt_tclServiceData*  ) const;
   //! handler CCA message returning signal strength of all connected BT devices
   void vHandleBTSignalQuality ( amt_tclServiceData*  ) const;

   void vHandleChangeWifiTransmitPower ( amt_tclServiceData*  ) const;

   // declare message map data structures
   DECLARE_MSG_MAP(dia_SAFeatureBluetoothMost)
};

#endif /* DIA_SAFEATUREBLUETOOTH_MOST_H_ */
