/*
 * dia_SAFeatureBluetooth.h
 *
 *  Created on: 09.02.2012
 *      Author: gib2hi
 * * * * * * * * * * * * * * * * * * * * *
 *  Last Changed on: 20.05.2014
 *  Changed by: GPU2KOR
 *  Change Desc: Implementation changed to Type-I routine control from Type-II routine control.
 *               BT MAC address removed from vStartConnectBluetoothDeviceAddress function argument list.
 *--------------------------------------------------------
 * Date 	       | Author	          | Modification
 * 28.05.14        | GPU2KOR          | vStartConnectBluetoothDeviceAddress changed to extract 6 byte BT address.
 *                                             AntennaField strength functon modified.
 * 13.06.14        | GPU2KOR          | Updated BT mode set.
 * 28-12-2015      | nce5kor		  | Commented the code for customer bt signal quality.
										New CCA implementation will be provided with next release.
 *************************************************************************/

#ifndef DIA_SAFEATUREBLUETOOTH_H_
#define DIA_SAFEATUREBLUETOOTH_H_

#ifndef __INCLUDED_DIA_INTERFACE_BLUETOOTH_LISTENER__
#include <project/interfaces/dia_IBluetoothListener.h>
#endif

#ifndef __INCLUDED_DIA_INTERFACE_WIFI_LISTENER__
#include <common/interfaces/dia_IWifiListener.h>
#endif

#ifndef __INCLUDED_DIA_INTERFACE_DIAGLIB_ROUTINE_CONTROL_LISTENER__
#include "common/depricated/SystemAdapter/dia_IDiaglibRoutineControlListener.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_DIAGLIB_DIAGNOSIS_DATA_LISTENER__
#include "common/depricated/SystemAdapter/dia_IDiaglibDiagnosisDataListener.h"
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FEATURE_DIAGLIB__
#include "common/framework/sysadapters/dia_SystemAdapterFeatureDiaglib.h"
#endif

//-----------------------------------------------------------------------------
// class definition
//-----------------------------------------------------------------------------

class dia_SAFeatureBluetooth
   : public dia_SystemAdapterFeatureDiaglib,
     public dia_IBluetooth,
     public dia_IWifi,
     public dia_IDiaglibRoutineControlListener,
     public dia_IDiaglibDiagnosisDataListener
{
public:
   //! constructor
   dia_SAFeatureBluetooth ( tCString name, dia_SystemAdapterServicePluginDiaglib& pSrvPlugin );

   //! destructor
   virtual ~dia_SAFeatureBluetooth ( void );

   //! return the diaglib IDs managed by this feature
   virtual tDiaResult getDiaglibIDs ( std::list<tU32>& results ) const;

   // receive functions
   virtual void vOnRoutineCtrlResult(
         tU32 u32RoutineId,
         tenRoutineCtrlResult enRoutineStatus,
         const tDiaglibParamVector& oStartResult
   );

   virtual void vOnGetRoutineResult(
         tU32 u32RoutineId,
         tenRoutineCtrlResult enRoutineStatus,
         const tDiaglibParamVector& oRoutineResult
   );

   virtual void vOnDiagnosisDataResult (
        tU32 u32DiagnosisDataId,
        tenDiagDataResult enResult,
        const tDiaglibParamVector& oResult
   );
         //! handle incoming CCA message
   void vHandleIOControl ( amt_tclServiceData* poMessage );

    // receive functions
//   virtual void vOnIoCtrlResult(amt_tclServiceData* poMessage);
   //-------------------------------------------------------------------------
   //
   // Overloaded dia_IBluetooth methods
   //
   //-------------------------------------------------------------------------
   //Get Bluetooth MAC Address
   virtual tDiaResult vGetBluetoothMacAddress ( void );
   //Get WIFI MAC address   
   virtual tDiaResult vGetWifiMacAddress ( void );

   virtual tDiaResult vGetBluetoothDeviceAddress ( void ){ return DIA_E_NOT_IMPLEMENTED; }
#if 0 //STC2HI: TODO
   virtual tDiaResult vSelftestBluetooth( void )= 0;
   virtual tDiaResult vSelftestBluetoothWIFI ( void )= 0;
   virtual tDiaResult vTestmodeBluetooth(const tU8* const pabMacAddress, const tU8* const pabBDAddress)= 0;
   virtual tDiaResult vTestmodeBluetoothWIFI (const tU8* const pabMacAddress, const tU8* const pabBDAddress)= 0;
#endif
   virtual tDiaResult vGetBluetoothFieldstrength ( const tU8* const pabBDAddress);
   virtual tDiaResult vGetBluetoothWifiFieldstrength ( const tU8* const /*pabBDAddress */) { return DIA_E_NOT_IMPLEMENTED; }
   virtual tDiaResult vStartConnectBluetoothDeviceAddress ( const tBool bType, const tU8* const pabBDAddress);
#if 0
   virtual tDiaResult vGetBTLinkQuality ( void );
#endif
#if 0 //STC2HI: TODO
   virtual tDiaResult vAbortConnectBluetoothDeviceAddress (void) = 0;
#endif //STC2HI: TODO
   virtual tDiaResult vGetStatusConnectBluetoothDeviceAddress (void);
   virtual tDiaResult vGetConnectedDeviceStatus(const tU8 /*u8Device */) { return DIA_E_NOT_IMPLEMENTED; } 
   virtual tDiaResult vGetDeviceLinkQuality(const tU8 /*u8Device */) { return DIA_E_NOT_IMPLEMENTED; } 
   virtual tDiaResult vGetAuthenticatedDevicesPresent(void) { return DIA_E_NOT_IMPLEMENTED; } 
   virtual tDiaResult attachNotification ( dia_eBTNotification id ) ;
   
   
   //-------------------------------------------------------------------------
   //
   // Overloaded dia_IWifi methods
   //
   //-------------------------------------------------------------------------

   //virtual tDiaResult getWifiStatus ( void );
   virtual tDiaResult getWifiSNR ( const tU8* pabAddress);
   //virtual tDiaResult setWifiAddress ( tU8* );
   
   
   //! unregister for status notifications
   virtual tDiaResult detachNotification ( dia_eBTNotification id ) ;

   //! request the given action to be executed in the BT module
   virtual tDiaResult executeAction ( dia_eBTAction actionID ) ;
   virtual tDiaResult setMode ( dia_eBTMode mode );
   static tU8 reqBDAddress[6];
protected:
   //! deprecated default constructor
   dia_SAFeatureBluetooth ( void );

   //! handle incoming CCA message
   void vHandleRoutineControl ( amt_tclServiceData* poMessage );
   void vHandleDiagnosisData ( amt_tclServiceData* poMessage ) ;

#if 1 //STC2HI: TODO  // gib2hi: reactivated, but only signatures
   //! handler function which reacts to incomming msgs with  FID_TEL_G_BT_TEST_MODE
   void vHandleBlueToothModeStatus ( amt_tclServiceData*  ) const;
   //! handler function which reacts to incomming msgs with  FID_TEL_S_SET_BT_TEST_MODE
   void vHandleBlueToothModeResult ( amt_tclServiceData*  ) const;
   //! handler incoming ACK that the connect request was accepted
   void vHandleBlueToothConnectResult ( amt_tclServiceData*  ) const;
   //! handler incoming connection status
   void vHandleBlueToothConnectionStatus ( amt_tclServiceData*  ) const;
   //! handler incoming ACK that the disconnect request was accepted
   void vHandleBlueToothDisconnectResult ( amt_tclServiceData*  ) const;
   //! handler incoming disconnection status
   void vHandleBlueToothDisconnectionStatus ( amt_tclServiceData*  ) const;
   //! handler function which reacts to incomming msgs with  FID_TEL_S_DIAGNOSIS_BT_RSSI_AND_LINK_QUALITY
   void vHandleBTLinkQualityResult ( amt_tclServiceData*  ) const;
//   //! handler function which reacts to incomming msgs with  FID_TEL_G_DIAGNOSIS_BT_RSSI_AND_LINK_QUALITY_RESULT
//   void vHandleBTLinkQualityStatus ( amt_tclServiceData*  ) const;
//   //!
//   void vHandleBTLinkInfo ( amt_tclServiceData*  ) const;
   //! handler function which reacts to incomming msgs with  FID_TEL_S_BTM_TEST_ACTION
   void vHandleBTTestActionResult ( amt_tclServiceData*  ) const;
   //! handler function which reacts to incomming msgs with  FID_TEL_G_BTM_TEST_ACTION
   void vHandleBTTestActionStatus ( amt_tclServiceData*  ) const;
   //! handle incoming acknowledge for the BT internal loopback request
   void vHandleBTLocalLoopbackResult ( amt_tclServiceData* poMessage ) const;
   //! handle telephone mute
   void vHandleTelephoneMuteIndication ( amt_tclServiceData* poMessage ) const;
   //! reply on faciaID ans Bluetooth MAC-Address request
   void vHandleBlueToothDeviceVersion ( amt_tclServiceData* poMessage ) const;
   //! handle CCA message returning information on the connected devices
   void vHandleBlueToothConnectedDevices (amt_tclServiceData* poMessage) const;
   //! handle CCA message returning information on module reset
   void vHandleBlueToothModuleResetResult (amt_tclServiceData* poMessage) const;
#endif //STC2HI: TODO

   // declare message map data structures
   DECLARE_MSG_MAP(dia_SAFeatureBluetooth)
protected:
   tU8 u8BDAddress[6];
};

#endif /* DIA_SAFEATUREBLUETOOTH_H_ */
