/*
 * dia_SAFeatureAudioTest.h
 *
 *  Created on: 14.09.2015
 *      Author: shw2abt
 */

#ifndef DIA_SAFEATURE_AUDIO_TEST_H_
#define DIA_SAFEATURE_AUDIO_TEST_H_

#ifndef __INCLUDED_DIA_INTERFACE_AUDIOTESTCONTROL_LISTENER__
#include "common/interfaces/dia_IAudioTestListener.h"
#endif

//-----------------------------------------------------------------------------
// class definition
//-----------------------------------------------------------------------------

class dia_SAFeatureAudioTest
   : public dia_SystemAdapterFeature,
     public dia_IAudioTest
{
public:
   //! constructor
   dia_SAFeatureAudioTest ( tCString name, dia_SystemAdapterServicePlugin& pSrvPlugin );

   //! destructor
   virtual ~dia_SAFeatureAudioTest ( void );

   //-------------------------------------------------------------------------
   //
   // Overloaded dia_IAudio methods
   //
   //-------------------------------------------------------------------------

   //! function to start/stop tweeter test (AC)
   virtual tDiaResult startTweeterTest ( dia_eAudioTestMode testMode );
   //! function to start/stop loudspeaker test (DC)
   virtual tDiaResult startLoudspeakerTest ( dia_eAudioTestMode testMode );
   
protected:
   //! deprecated default constructor
   dia_SAFeatureAudioTest ( void );

   //! covers all audio speaker test functions
   void vHandleSpeakerTest ( amt_tclServiceData* poMessage ) const;

   // declare message map data structures
   DECLARE_MSG_MAP(dia_SAFeatureAudioTest)
};


#endif /* DIA_SAFEATURE_AUDIO_TEST_H_ */
