/*
 * dia_SAFeatureAudioControl.h
 *
 *  Created on: 17.01.2013
 *      Author: shw2abt
 *--------------------------------------------------------------------------------
 * Date				|	User ID		|	Modification
 * 27/5/2016		|	bma9kor		|	Audio balance and fader functions moved to dia_SAFeatureAudioControl for facilitating Diaglib communication  (CMG3G-10183)
 *--------------------------------------------------------------------------------
 */

#ifndef DIA_SAFEATUREAUDIOCONTROL_H_
#define DIA_SAFEATUREAUDIOCONTROL_H_

#ifndef __INCLUDED_DIA_INTERFACE_AUDIOCONTROL_LISTENER__
#include "common/interfaces/dia_IAudioControlListener.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_AUDIOBALFADER_LISTENER__
#include "common/interfaces/dia_IAudioBalFaderListener.h"
#endif

#ifndef __INCLUDED_DIA_DIAGLIB_IOCONTROL_LISTENER__
#include "common/depricated/SystemAdapter/dia_IDiaglibIoControlListener.h"
#endif

#ifndef __INCLUDED_DIA_COMMON_SYSTEM_ADAPTERS__
#include "common/framework/sysadapters/dia_common_system_adapters.h"
#endif

//-----------------------------------------------------------------------------
// class definition
//-----------------------------------------------------------------------------

class dia_SAFeatureAudioControl
   : public dia_SystemAdapterFeatureDiaglib,
     public dia_IAudioControl,
     public dia_IDiaglibIoControlListener,
     public dia_IAudioBalFader
{
public:
   //! constructor
   dia_SAFeatureAudioControl ( tCString name, dia_SystemAdapterServicePluginDiaglib& pSrvPlugin );

   //! destructor
   virtual ~dia_SAFeatureAudioControl ( tVoid );

   //! return the diaglib IDs managed by this feature
   virtual tDiaResult getDiaglibIDs ( std::list<tU32>& results ) const;

   // receive functions
   virtual tVoid vOnIoCtrlResult(tU32 u32IoCtrlId, tenIoCtrlResult enResult, tenIoControlAction enActionId, const tDiaglibParamVector& oStartResult);

   //-------------------------------------------------------------------------
   //
   // Overloaded dia_IAudio methods
   //
   //-------------------------------------------------------------------------

   //! set the audio gain
   virtual tDiaResult dia_setAudioGain ( tU8 gain );
   //! set the linear mode
   virtual tDiaResult dia_setAudioLinearMode ( tBool linearMode_active );
   //! freeze/unfreeze audio control line
   virtual tDiaResult freezeAudioControl_ControlLine ( dia_eAudioControlFreeze /*mode */ ) { return DIA_E_NOT_IMPLEMENTED; } 
   //! set the control line mode
   virtual tDiaResult dia_setAudioControlLine ( tU8 /*clMode*/ ) { return DIA_E_NOT_IMPLEMENTED; } 
   //! set the audio balance
   virtual tDiaResult dia_setAudioBalance ( tS8 balance );
   //! set the audio fader
   virtual tDiaResult dia_setAudioFader ( tS8 fader );
protected:
   //! deprecated default constructor
   dia_SAFeatureAudioControl ( tVoid );

   //! handle incoming CCA message
   tVoid vHandleIOControl ( amt_tclServiceData* poMessage );

   // declare message map data structures
   DECLARE_MSG_MAP(dia_SAFeatureAudioControl)
};


#endif /* DIA_SAFEATUREAUDIOCONTROL_H_ */
