/*
 * dia_SAFeatureAudioControl.cpp
 *
 *  Created on: 17.01.2013
 *      Author: shw2abt
 *--------------------------------------------------------------------------------
 * Date				|	User ID		|	Modification
 * 15/4/2016		|	bma9kor		|	Audio balance and fader functions added for facilitating Diaglib communication  (CMG3G-10183)
 *--------------------------------------------------------------------------------
 */

#ifndef __INCLUDED_DIAGLIB_ID_SPEC__
#include "common/depricated/SystemAdapter/dia_IdSpec.h"
#endif

#include "dia_SAFeatureAudioControl.h"

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_DIAGLIB__
#include "project/framework/sysadapters/dia_SAFeatureDiaglib.h"
#endif

#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include "generic_msgs_if.h" //lint !e451 !e537 repeatedly included header file without standard include guard

#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_MASCFFI_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_MASCFFI_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_MASCFFI_SERVICEINFO
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGLIBFI_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGLIBFI_FUNCTIONIDS
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "midw_fi_if.h" //lint !e451 !e537 repeatedly included header file without standard include guard

/// MESSAGE MAP:
// The message map maps IDs of incoming CCA messages to proper handle methods
BEGIN_MSG_MAP(dia_SAFeatureAudioControl,dia_SystemAdapterFeatureDiaglib)
   ON_MESSAGE( MIDW_DIAGLIBFI_C_U16_IOCONTROL, vHandleIOControl )
END_MSG_MAP()

//------------------------------------------------------------------------------

dia_SAFeatureAudioControl::dia_SAFeatureAudioControl (
      tCString name,    // feature name
      dia_SystemAdapterServicePluginDiaglib& pSrvPlugin
   )
    : dia_SystemAdapterFeatureDiaglib(name,pSrvPlugin)
{
   dia_tclFnctTrace trc("dia_SAFeatureAudioControl::dia_SAFeatureAudioControl");
}


//-----------------------------------------------------------------------------

dia_SAFeatureAudioControl::~dia_SAFeatureAudioControl ( tVoid )
{}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureAudioControl::getDiaglibIDs ( std::list<tU32>& results ) const
{
   results.push_back(IOCONTROLID_AUDIO_GAIN);
   results.push_back(IOCONTROLID_AUDIO_LINEAR_MODE);
   results.push_back(IOCONTROLID_AUDIO_EXT_AMPLIFIER);
   results.push_back(IOCONTROLID_AUDIO_FADER);
   results.push_back(IOCONTROLID_AUDIO_BALANCE);
   return DIA_SUCCESS;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureAudioControl::dia_setAudioGain ( tU8 gain )
{
   dia_tclFnctTrace trc("dia_SAFeatureAudioControl::dia_setAudioGain()");
   tDiaResult retCode = DIA_FAILED;

   tDiaglibParamVector vecRequest;
   trParameter paramAudioGain;
   paramAudioGain.enType  = static_cast<tenParameterType>(IOCONTROLID_AUDIO_GAIN_SET_PARAM1);
   paramAudioGain.s8Value = (tS8)gain;   // old way: .u8Value, now we use s8value according Audio team

   DIA_TR_INF("dia_SAFeatureAudioControl::dia_setAudioGain - sending gain = 0x%02x (%d).",(tS8)paramAudioGain.s8Value,(tS8)paramAudioGain.s8Value);

   vecRequest.push_back(paramAudioGain);

   if ( dia_SAFeatureDiaglib::bIOControlStart(IOCONTROLID_AUDIO_GAIN, EN_ACTION_SET, vecRequest, mpSrvPlugin) == TRUE ) {
      retCode = DIA_SUCCESS;
      DIA_TR_INF("dia_SAFeatureAudioControl::dia_setAudioGain - bIOControlStart - SUCCESS.");
   } else {
      DIA_TR_INF("dia_SAFeatureAudioControl::dia_setAudioGain - bIOControlStart - FAILED.");
   }

   return retCode;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureAudioControl::dia_setAudioLinearMode ( tU8 linearMode )
{
    dia_tclFnctTrace trc("dia_SAFeatureAudioControl::dia_setAudioLinearMode()");
    tDiaResult retCode = DIA_FAILED;

    tBool linearMode_active = FALSE;
    if (linearMode == 0x00) {
       linearMode_active = FALSE;
       DIA_TR_INF("dia_SAFeatureAudioControl::dia_setAudioLinearMode - Diaglib: LinearMode FALSE.");
    } else if (linearMode == 0x01) {
       linearMode_active = TRUE;
       DIA_TR_INF("dia_SAFeatureAudioControl::dia_setAudioLinearMode - Diaglib: LinearMode TRUE.");
    } else {
       DIA_TR_ERR("dia_SAFeatureAudioControl::dia_setAudioLinearMode - LinearMode doesn't fit.");
       return retCode;
    }

    tDiaglibParamVector vecRequest;
    trParameter paramLinearMode;

    paramLinearMode.enType = static_cast<tenParameterType>(IOCONTROLID_AUDIO_LINEAR_MODE_SET_PARAM1);
    paramLinearMode.bValue = linearMode_active;

    vecRequest.push_back(paramLinearMode);

    if(dia_SAFeatureDiaglib::bIOControlStart(IOCONTROLID_AUDIO_LINEAR_MODE, EN_ACTION_SET, vecRequest, mpSrvPlugin /*this*/) == TRUE) {
       retCode = DIA_SUCCESS;
       DIA_TR_INF("dia_SAFeatureAudioControl::dia_setAudioLinearMode - bIOControlStart - SUCCESS.");
    } else {
       DIA_TR_INF("dia_SAFeatureAudioControl::dia_setAudioLinearMode - bIOControlStart - FAILED.");
    }

    return retCode;
}

//-----------------------------------------------------------------------------
#if 0 // Function can be deleted.
tDiaResult
dia_SAFeatureAudioControl::freezeAudioControl_ControlLine ( dia_eAudioControlFreeze mode )
{
    dia_tclFnctTrace trc("dia_SAFeatureAudioControl::freezeRVCControl_ControlLine()");
    tDiaResult retCode = DIA_FAILED;

    tDiaglibParamVector vecRequest;
    // nothing to fill in

    tenIoControlAction ioAction;
    if(mode==DIA_EN_AUDIOCONTROL_FREEZE){
       DIA_TR_INF("dia_SAFeatureAudioControl::freezeRVCControl_ControlLine - SET EN_ACTION_FREEZE.");
       ioAction = EN_ACTION_FREEZE;
    } else {
       DIA_TR_INF("dia_SAFeatureAudioControl::freezeRVCControl_ControlLine - SET EN_ACTION_UNFREEZE.");
       ioAction = EN_ACTION_UNFREEZE;
    }

    if(dia_SAFeatureDiaglib::bIOControlStart(IOCONTROLID_AUDIO_EXT_AMPLIFIER, ioAction, vecRequest, mpSrvPlugin /*this*/) == TRUE) {
       retCode = DIA_SUCCESS;
       DIA_TR_INF("dia_SAFeatureAudioControl::freezeRVCControl_ControlLine - bIOControlStart - SUCCESS.");
    } else {
       DIA_TR_INF("dia_SAFeatureAudioControl::freezeRVCControl_ControlLine - bIOControlStart - FAILED.");
    }

   return retCode;
}
#endif
//-----------------------------------------------------------------------------
#if 0 // Function can be deleted.
tDiaResult
dia_SAFeatureAudioControl::dia_setAudioControlLine ( tU8 clMode )
{
   dia_tclFnctTrace trc("dia_SAFeatureAudioControl::dia_setAudioControlLine()");
   tDiaResult retCode = DIA_FAILED;

   tDiaglibParamVector vecRequest;
   trParameter paramLinearMode;

   paramLinearMode.enType = static_cast<tenParameterType>(IOCONTROLID_AUDIO_EXT_AMPLIFIER_SET_PARAM1);
   paramLinearMode.u8Value = clMode;

   vecRequest.push_back(paramLinearMode);

   if (dia_SAFeatureDiaglib::bIOControlStart(IOCONTROLID_AUDIO_EXT_AMPLIFIER, EN_ACTION_SET, vecRequest, mpSrvPlugin /*this*/) == TRUE) {
      retCode = DIA_SUCCESS;
      DIA_TR_INF("dia_SAFeatureAudioControl::dia_setAudioControlLine - bIOControlStart - SUCCESS.");
   } else {
      DIA_TR_INF("dia_SAFeatureAudioControl::dia_setAudioControlLine - bIOControlStart - FAILED.");
   }

   return retCode;
}
#endif

/******************************************************************************
* FUNCTION:    dia_setAudioBalance
*
* DESCRIPTION: set the Balance value of the audio component
*
* PARAMETER: tS8
*
* RETURNVALUE: tDiaResult
*
******************************************************************************/

tDiaResult
dia_SAFeatureAudioControl::dia_setAudioBalance ( tS8 balance )
{
   dia_tclFnctTrace trc("dia_SAFeatureAudioControl::dia_setAudioBalance()");
   tDiaResult retCode = DIA_FAILED;

   tDiaglibParamVector vecRequest;
   trParameter paramAudioBalance;
   paramAudioBalance.enType  = static_cast<tenParameterType>(IOCONTROLID_AUDIO_BALANCE_SET_PARAM1);
   paramAudioBalance.s8Value = (tS8)balance;   // old way: .u8Value, now we use s8value according Audio team

   DIA_TR_INF("dia_SAFeatureAudioControl::dia_setAudioBalance - sending Balance = 0x%02x (%d).",(tS8)paramAudioBalance.s8Value,(tS8)paramAudioBalance.s8Value);

   vecRequest.push_back(paramAudioBalance);

   if ( dia_SAFeatureDiaglib::bIOControlStart(IOCONTROLID_AUDIO_BALANCE, EN_ACTION_SET, vecRequest, mpSrvPlugin) == TRUE ) {
	  retCode = DIA_SUCCESS;
	  DIA_TR_INF("dia_SAFeatureAudioControl::dia_setAudioBalance - bIOControlStart - SUCCESS.");
   } else {
	  DIA_TR_INF("dia_SAFeatureAudioControl::dia_setAudioBalance - bIOControlStart - FAILED.");
   }

   return retCode;
}

//-----------------------------------------------------------------------------

/******************************************************************************
* FUNCTION:    dia_setAudioFader
*
* DESCRIPTION: set the Fader value of the audio component
*
* PARAMETER: tS8
*
* RETURNVALUE: tDiaResult
*
******************************************************************************/

tDiaResult
dia_SAFeatureAudioControl::dia_setAudioFader ( tS8 fader )
{
   dia_tclFnctTrace trc("dia_SAFeatureAudioControl::dia_setAudioFader()");
   tDiaResult retCode = DIA_FAILED;

   tDiaglibParamVector vecRequest;
   trParameter paramAudioFader;
   paramAudioFader.enType  = static_cast<tenParameterType>(IOCONTROLID_AUDIO_FADER_SET_PARAM1);
   paramAudioFader.s8Value = (tS8)fader;   // old way: .u8Value, now we use s8value according Audio team

   DIA_TR_INF("dia_SAFeatureAudioControl::dia_setAudioFader - sending Fader = 0x%02x (%d).",(tS8)paramAudioFader.s8Value,(tS8)paramAudioFader.s8Value);

   vecRequest.push_back(paramAudioFader);

   if ( dia_SAFeatureDiaglib::bIOControlStart(IOCONTROLID_AUDIO_FADER, EN_ACTION_SET, vecRequest, mpSrvPlugin) == TRUE ) {
	  retCode = DIA_SUCCESS;
	  DIA_TR_INF("dia_SAFeatureAudioControl::dia_setAudioFader - bIOControlStart - SUCCESS.");
   } else {
	  DIA_TR_INF("dia_SAFeatureAudioControl::dia_setAudioFader - bIOControlStart - FAILED.");
   }

   return retCode;
}

//-----------------------------------------------------------------------------
// .... HANDLER ...............................................................
//-----------------------------------------------------------------------------

tVoid
dia_SAFeatureAudioControl::vHandleIOControl ( amt_tclServiceData* poMessage ){
   dia_tclFnctTrace trc("dia_SAFeatureAudioControl::vHandleIOControl()");

   dia_SAFeatureDiaglib::u32EvalIoCtrlMessage( poMessage, this );
}

//-----------------------------------------------------------------------------

tVoid
dia_SAFeatureAudioControl::vOnIoCtrlResult(tU32 u32IoCtrlId, tenIoCtrlResult enResult, tenIoControlAction /*enActionId*/, const tDiaglibParamVector& /*oStartResult*/){
   dia_tclFnctTrace trc("dia_SAFeatureAudioControl::vOnIoCtrlResult()");
   DIA_PARAMETER_INTENTIONALLY_UNUSED(u32IoCtrlId);

   dia_IAudioControlListener* pTunerAudioListener = OSAL_NULL;
   querySysAdapterListener<dia_IAudioControlListener>(&pTunerAudioListener);

   if (pTunerAudioListener) {
      switch (u32IoCtrlId) {
         case IOCONTROLID_AUDIO_GAIN:
            DIA_TR_INF("dia_SAFeatureAudioControl::vOnIoCtrlResult - u32IoCtrlId = IOCONTROLID_AUDIO_GAIN.");
            if (enResult == EN_IO_CONTROL_OK) {
               DIA_TR_INF("dia_SAFeatureAudioControl::vOnIoCtrlResult - EN_IO_CONTROL_ OK !!");
         pTunerAudioListener->vOnAudioGain(DIA_SUCCESS);
      } else {
               DIA_TR_ERR("dia_SAFeatureAudioControl::vOnIoCtrlResult - EN_IO_CONTROL_NOK !!");
         pTunerAudioListener->vOnAudioGain(DIA_FAILED);
      }
            break;
         case IOCONTROLID_AUDIO_LINEAR_MODE:
            DIA_TR_INF("dia_SAFeatureAudioControl::vOnIoCtrlResult - u32IoCtrlId = IOCONTROLID_AUDIO_LINEAR_MODE.");
            if (enResult == EN_IO_CONTROL_OK) {
               DIA_TR_INF("dia_SAFeatureAudioControl::vOnIoCtrlResult - EN_IO_CONTROL_ OK !!");
               pTunerAudioListener->vOnAudioLinearMode(DIA_SUCCESS);
            } else {
               DIA_TR_ERR("dia_SAFeatureAudioControl::vOnIoCtrlResult - EN_IO_CONTROL_NOK !!");
               pTunerAudioListener->vOnAudioLinearMode(DIA_FAILED);
            }
            break;
        /* case IOCONTROLID_AUDIO_EXT_AMPLIFIER:
            DIA_TR_INF("dia_SAFeatureAudioControl::vOnIoCtrlResult - u32IoCtrlId = IOCONTROLID_AUDIO_EXT_AMPLIFIER.");

            tDiaResult ioControlOK = DIA_FAILED;
            if (enResult == EN_IO_CONTROL_OK) {
               DIA_TR_INF("dia_SAFeatureAudioControl::vOnIoCtrlResult - EN_IO_CONTROL_ OK !!");
               ioControlOK = DIA_SUCCESS;
            } else {
               DIA_TR_INF("dia_SAFeatureAudioControl::vOnIoCtrlResult - EN_IO_CONTROL_NOK !!");
            }

            switch (enActionId) {
               case EN_ACTION_FREEZE:
                  DIA_TR_INF("dia_SAFeatureAudioControl::vOnIoCtrlResult - ActionID = EN_ACTION_FREEZE.");
                  pTunerAudioListener->vOnAudioExtAmplControlFreezeMode(ioControlOK, DIA_EN_AUDIOCONTROL_FREEZE);
                  break;
               case EN_ACTION_SET:
                  DIA_TR_INF("dia_SAFeatureAudioControl::vOnIoCtrlResult - ActionID = EN_ACTION_SET.");
                  pTunerAudioListener->vOnAudioExtAmplControlLine(ioControlOK);
                  break;
               case EN_ACTION_UNFREEZE:
                  DIA_TR_INF("dia_SAFeatureAudioControl::vOnIoCtrlResult - ActionID = EN_ACTION_UNFREEZE.");
                  pTunerAudioListener->vOnAudioExtAmplControlFreezeMode(ioControlOK, DIA_EN_AUDIOCONTROL_UNFREEZE);
                  break;
               default:
                  DIA_TR_ERR("dia_SAFeatureAudioControl::vOnIoCtrlResult - ACTIONID = UNKNOWN.");
                  break;
            }
            break;*/ //--GPU2KOR
         default:
            DIA_TR_ERR("dia_SAFeatureAudioControl::vOnIoCtrlResult - u32IoCtrlId = u32IoCtrlId UNKNOWN.");
            break;
      }
   } else {
      DIA_TR_ERR("dia_SAFeatureAudioControl::vOnIoCtrlResult - No listener registered");
   }
   
   //handling audio balance and fader
   dia_IAudioBalFaderListener* pTunerAudioBalFaderListener = OSAL_NULL;
   querySysAdapterListener<dia_IAudioBalFaderListener>(&pTunerAudioBalFaderListener);
	  
   if (pTunerAudioBalFaderListener) {
      switch (u32IoCtrlId) {
	     case IOCONTROLID_AUDIO_BALANCE:
            DIA_TR_INF("dia_SAFeatureAudioControl::vOnIoCtrlResult - u32IoCtrlId = IOCONTROLID_AUDIO_BALANCE.");
            if (enResult == EN_IO_CONTROL_OK)
            {
               DIA_TR_INF("dia_SAFeatureAudioControl::vOnIoCtrlResult - EN_IO_CONTROL_ OK !!");
               pTunerAudioBalFaderListener->vOnAudioBalance(DIA_SUCCESS);
            }
            else
            {
               DIA_TR_ERR("dia_SAFeatureAudioControl::vOnIoCtrlResult - EN_IO_CONTROL_NOK !!");
               pTunerAudioBalFaderListener->vOnAudioBalance(DIA_FAILED);
            }
            break;

         case IOCONTROLID_AUDIO_FADER:
		    DIA_TR_INF("dia_SAFeatureAudioControl::vOnIoCtrlResult - u32IoCtrlId = IOCONTROLID_AUDIO_FADER.");
            if (enResult == EN_IO_CONTROL_OK)
			{
			   DIA_TR_INF("dia_SAFeatureAudioControl::vOnIoCtrlResult - EN_IO_CONTROL_ OK !!");
			   pTunerAudioBalFaderListener->vOnAudioFader(DIA_SUCCESS);
			}
			else
			{
			   DIA_TR_ERR("dia_SAFeatureAudioControl::vOnIoCtrlResult - EN_IO_CONTROL_NOK !!");
			   pTunerAudioBalFaderListener->vOnAudioFader(DIA_FAILED);
			}
			break;

         default:
            DIA_TR_ERR("dia_SAFeatureAudioControl::vOnIoCtrlResult - u32IoCtrlId = u32IoCtrlId UNKNOWN.");
            break;
      }
   } else {
      DIA_TR_ERR("dia_SAFeatureAudioControl::vOnIoCtrlResult - No listener registered");
   }
}
