/*
 * dia_SAFeatureAudio.h
 *
 *  Created on: 03.08.2012
 *      Author: shw2abt
 *--------------------------------------------------------------------------------
 * Date				|	User ID		|	Modification
 * 27/5/2016		|	bma9kor		|	Audio balance and fader functions moved to dia_SAFeatureAudioControl for facilitating Diaglib communication  (CMG3G-10183)
 *--------------------------------------------------------------------------------------------------------------------												
 * 18.08.2017       | 2.2	| NLK1KOR (RBEI  )	| Implemented     AIVI-58793 Worker class for Bose Amplifier ANC and ASC SW Version.

 *--------------------------------------------------------------------------------
 */

#ifndef DIA_SAFEATUREAUDIO_H_
#define DIA_SAFEATUREAUDIO_H_

#ifndef __INCLUDED_DIA_INTERFACE_AUDIO_LISTENER__
#include "common/interfaces/dia_IAudioListener.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_MICROPHONE_LISTENER__
#include "common/interfaces/dia_IMicrophoneListener.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_AUDIOBALFADER_LISTENER__
#include "common/interfaces/dia_IAudioBalFaderListener.h"
#endif

//-----------------------------------------------------------------------------
// class definition
//-----------------------------------------------------------------------------

class dia_SAFeatureAudio
   : public dia_SystemAdapterFeature,
     public dia_IAudio,
     public dia_IMicrophone,
 	 public dia_IAudioBalFader
{
public:
   //! constructor
   dia_SAFeatureAudio ( tCString name, dia_SystemAdapterServicePlugin& pSrvPlugin );

   //! destructor
   virtual ~dia_SAFeatureAudio ( void );

   //-------------------------------------------------------------------------
   //
   // Overloaded dia_IAudio methods
   //
   //-------------------------------------------------------------------------

   //! obsolete function - don't use anymore. Activates the test tone with a certain frequency and volume
   virtual tDiaResult dia_setAudioTestTone ( tU32 frequency, tU8 volume, tU8 channelMask );
   //! activates the test tone with a certain frequency and volume for certain channel with DBV
   virtual tDiaResult setAudioTestToneDBV ( tU32 frequency, tS16 volume, tU32 channelMask );
   //! activates the test tone with a certain frequency and volume for certain channel with DB
   virtual tDiaResult setAudioTestToneDB ( tU32 frequency, tS16 volume, tU32 channelMask );
   //! activates the test tone with a certain frequency and volume for certain channel with increment steps
   virtual tDiaResult setAudioTestToneIncrement ( tU32 frequency /* in Hz */, tS16 volume /* in dB */, tU32 channelMask );
   //! activates Audio Test Tone directly / no handling via volume level functions
   virtual tDiaResult setAudioTestTone ( tU32 frequency /* in Hz */, tS16 volume, tU32 channelMask, dia_eAudioVolumeType volumetype );
   //! activates the test tone mute DBV
   virtual tDiaResult setAudioTestToneMute ( dia_eAudioVolumeType volumetype );
   //! set the audio balance
   virtual tDiaResult dia_setAudioBalance ( tS8 balance );
   //! set the audio fader
   virtual tDiaResult dia_setAudioFader ( tS8 fader );
   //! get the microphone power supply info
   virtual tDiaResult micPowerSuppyInfo_Get ( tU8 /*mMicNo*/ );

   //-------------------------------------------------------------------------
   //
   // Overloaded dia_IMicrophone methods
   //
   //-------------------------------------------------------------------------
   virtual tDiaResult getMicrophoneConnectionInfo ( tU16 /*micID*/ ) { /* A-IVI: RVC is responsible for microphones, please see dia_SAFeatureRVC */ return DIA_FAILED; };

   //DEPRECATED! PLEASE DO NOT USE IN THE FUTURE. IT WAS KEPT DUE TO BACKWARD COMPATIBILITY REQUIREMENT.
   virtual tDiaResult getMicrophoneConnectionStatus ( void ) { return DIA_FAILED; };
   
   virtual tDiaResult regToANCSWVersion ( void );
   virtual tDiaResult regToASCSWVersion ( void );


protected:
   tDiaResult dia_setAudioX_sendUPREQ(tU16 u16FktID, std::string fctString) const;
   tDiaResult dia_setAudioX_sendRELUPREQ(tU16 u16FktID, std::string fctString) const;
   tDiaResult dia_setAudioBalance_METHODSTART() const;
   tDiaResult dia_setAudioFader_METHODSTART() const;

   //! deprecated default constructor
   dia_SAFeatureAudio ( void );

   //! handle incoming CCA message
   void vHandleIOControl ( amt_tclServiceData* poMessage );

   void vHandleAudioTestTone      ( amt_tclServiceData* poMessage ) const;
   void vHandleAudioBalance       ( amt_tclServiceData* poMessage ) const;
   void vHandleAudioFader         ( amt_tclServiceData* poMessage ) const;
   void vHandleAudioBalanceStatus ( amt_tclServiceData* poMessage ) const;
   void vHandleAudioFaderStatus   ( amt_tclServiceData* poMessage ) const;
   void vHandleMicrophoneConnectionInfo ( amt_tclServiceData* poMessage ) const;
   //! handle incoming CCA message
   tVoid vHandleANCSWVersion ( amt_tclServiceData* poMessage );
   //! handle incoming CCA message
   tVoid vHandleASCSWVersion ( amt_tclServiceData* poMessage );
   // declare message map data structures
   DECLARE_MSG_MAP(dia_SAFeatureAudio)
};


#endif /* DIA_SAFEATUREAUDIO_H_ */
