/*
 * dia_SAFeatureAudio.cpp
 *
 *  Created on: 03.08.2012
 *      Author: shw2abt
 *--------------------------------------------------------------------------------
 * Date				|	User ID		|	Modification
 * 15/4/2016		|	bma9kor		|	Audio balance and fader function moved to dia_SAFeatureAudioControl.h for facilitating Diaglib communication  (CMG3G-10183)
*--------------------------------------------------------------------------------------------------------------------												
* 18.08.2017       | 2.2	| NLK1KOR (RBEI  )	| Implemented     AIVI-58793 Worker class for Bose Amplifier ANC and ASC SW Version.

 *--------------------------------------------------------------------------------
 */
// Audio FI: di_middleware_server\components\midw_fi\midw_mascd_fi\midw_mascd_fi.pdf

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#ifndef __INCLUDED_DIA_COMMON_SYSTEM_ADAPTERS__
#include "common/framework/sysadapters/dia_common_system_adapters.h"
#endif

#include "dia_SAFeatureAudio.h"

#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include "generic_msgs_if.h" //lint !e451 !e537 repeatedly included header file without standard include guard

#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_MASCFFI_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_MASCFFI_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_MASCFFI_SERVICEINFO
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGLIBFI_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGLIBFI_FUNCTIONIDS
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "midw_fi_if.h" //lint !e451 !e537 repeatedly included header file without standard include guard


/// MESSAGE MAP:
// The message map maps IDs of incoming CCA messages to proper handle methods
BEGIN_MSG_MAP(dia_SAFeatureAudio,dia_SystemAdapterFeature)
   ON_MESSAGE(MIDW_MASCFFI_C_U16_BALANCE,       vHandleAudioBalance)
	ON_MESSAGE(MIDW_MASCFFI_C_U16_FADER,         vHandleAudioFader)
	ON_MESSAGE(MIDW_MASCFFI_C_U16_AUDIOTESTTONE, vHandleAudioTestTone)
	ON_MESSAGE(MIDW_MASCFFI_C_U16_MICROPHONECONNECTIONSTATUS, vHandleMicrophoneConnectionInfo)
	ON_MESSAGE( MIDW_MASCFFI_C_U16_ANCSWVERSION, vHandleANCSWVersion )
   ON_MESSAGE( MIDW_MASCFFI_C_U16_ASCSWVERSION, vHandleASCSWVersion )
END_MSG_MAP()

//------------------------------------------------------------------------------

dia_SAFeatureAudio::dia_SAFeatureAudio (
      tCString name,    // feature name
      dia_SystemAdapterServicePlugin& pSrvPlugin
   )
    : dia_SystemAdapterFeature(name,pSrvPlugin)
{
   dia_tclFnctTrace trc("dia_SAFeatureAudio::dia_SAFeatureAudio");
}

//-----------------------------------------------------------------------------

dia_SAFeatureAudio::~dia_SAFeatureAudio ( void )
{}

//-----------------------------------------------------------------------------

// shw2abt: TestTone functions are reworked below. This function is left if some projects still use the old way. But they shouldn't.
tDiaResult
dia_SAFeatureAudio::dia_setAudioTestTone ( tU32 frequency, tU8 volume, tU8 channelMask )
{
   dia_tclFnctTrace trc("dia_SAFeatureAudio::dia_setAudioTestTone()");
   tDiaResult retCode = DIA_FAILED;

   if (mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID) {
      DIA_TR_INF("dia_SAFeatureAudio::dia_setAudioTestTone - send message.");

      midw_mascffi_tclMsgAudioTestToneMethodStart oData;

      if (frequency != 0x00 || volume != 0x00) {
         DIA_TR_INF("dia_SAFeatureAudio::dia_setAudioTestTone - Active Channel Mode (for mask 0x%02x).", channelMask);
         oData.ChannelSelect.bits.CHANNEL_LF  = ((DIA_AUDIO_CHANNEL_MASK_FRONT_LEFT  == (DIA_AUDIO_CHANNEL_MASK_FRONT_LEFT & channelMask)) ? 1 : 0);
         oData.ChannelSelect.bits.CHANNEL_RF  = ((DIA_AUDIO_CHANNEL_MASK_FRONT_RIGHT == (DIA_AUDIO_CHANNEL_MASK_FRONT_RIGHT & channelMask)) ? 1 : 0);
         oData.ChannelSelect.bits.CHANNEL_LR  = ((DIA_AUDIO_CHANNEL_MASK_REAR_LEFT   == (DIA_AUDIO_CHANNEL_MASK_REAR_LEFT & channelMask)) ? 1 : 0);
         oData.ChannelSelect.bits.CHANNEL_RR  = ((DIA_AUDIO_CHANNEL_MASK_REAR_RIGHT  == (DIA_AUDIO_CHANNEL_MASK_REAR_RIGHT & channelMask)) ? 1 : 0);
         oData.ChannelSelect.bits.CHANNEL_CENT= ((DIA_AUDIO_CHANNEL_MASK_CENTER      == (DIA_AUDIO_CHANNEL_MASK_CENTER & channelMask)) ? 1 : 0);
         oData.ChannelSelect.bits.CHANNEL_SUB = ((DIA_AUDIO_CHANNEL_MASK_SUBWOOFER   == (DIA_AUDIO_CHANNEL_MASK_SUBWOOFER & channelMask)) ? 1 : 0);
         oData.ChannelSelect.bits.dummy6 = 0;
         oData.ChannelSelect.bits.dummy7 = 0;
      } else {
         DIA_TR_INF("dia_SAFeatureAudio::dia_setAudioTestTone - All Channels OFF.");
         oData.ChannelSelect.bits.CHANNEL_LF = 0;
         oData.ChannelSelect.bits.CHANNEL_RF = 0;
         oData.ChannelSelect.bits.CHANNEL_LR = 0;
         oData.ChannelSelect.bits.CHANNEL_RR = 0;
         oData.ChannelSelect.bits.CHANNEL_CENT = 0;
         oData.ChannelSelect.bits.CHANNEL_SUB = 0;
         oData.ChannelSelect.bits.dummy6 = 0;
         oData.ChannelSelect.bits.dummy7 = 0;
      }

      oData.Frequency = frequency;

      if( (channelMask == DIA_AUDIO_CHANNEL_MASK_ALL) || (channelMask == DIA_AUDIO_CHANNEL_MASK_NONE) )
      {
         //Production Diagnosis - Set volume in dBV
         DIA_TR_INF("dia_SAFeatureAudio::dia_setAudioTestTone - Set Volume in DBV Level.");
         oData.Volume.e8VolType.enType = midw_fi_tcl_e8_VolumeType::FI_EN_DBV_LEVEL;
         oData.Volume.s16Volume = (tS8)volume;
      }
      else
      {
         //Customer Diagnosis - Set volume in dB
         DIA_TR_INF("dia_SAFeatureAudio::dia_setAudioTestTone - Set Volume in DB Level.");
         oData.Volume.e8VolType.enType = midw_fi_tcl_e8_VolumeType::FI_EN_DB_LEVEL;

         //The expected range for volume gain is 0 to (-120) dB, which ADR supports.
         //At -90, volume is muted. And at 0, volume is high.
         //So according to PSA requirement, add the value -90 to volume, so that at 0dBA volume is muted and 90dBA volume is high.
         oData.Volume.s16Volume = (tS16)(volume - 90);
         DIA_TR_INF("dia_SAFeatureAudio::dia_setAudioTestTone - s16Volume (%d) - volume (%d).", oData.Volume.s16Volume, volume );
      }

      DIA_TR_INF("dia_SAFeatureAudio::dia_setAudioTestTone - Channel   %d."     , oData.ChannelSelect.u8Value );
      DIA_TR_INF("dia_SAFeatureAudio::dia_setAudioTestTone - Frequency %d."     , oData.Frequency );
      DIA_TR_INF("dia_SAFeatureAudio::dia_setAudioTestTone - Frequency 0x%08x." , oData.Frequency );
      DIA_TR_INF("dia_SAFeatureAudio::dia_setAudioTestTone - e8VolType %d."     , oData.Volume.e8VolType.enType );
      DIA_TR_INF("dia_SAFeatureAudio::dia_setAudioTestTone - s16Volume %d."     , oData.Volume.s16Volume );

      //put the data in message
      fi_tclVisitorMessage oMessage(oData);
      mpSrvPlugin->vInitServiceData(oMessage, MIDW_MASCFFI_C_U16_AUDIOTESTTONE, AMT_C_U8_CCAMSG_OPCODE_METHODSTART);

      if (mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE) {
         retCode = DIA_SUCCESS;
         DIA_TR_INF("dia_SAFeatureAudio::dia_setAudioTestTone - transmitMessage success.");
      } else {
         DIA_TR_ERR("dia_SAFeatureAudio::dia_setAudioTestTone - transmitMessage failed.");
      }
   } else {
      DIA_TR_ERR("dia_SAFeatureAudio::dia_setAudioTestTone - getRegistrationID failed.");
      DIA_TR_ERR("dia_SAFeatureAudio::dia_setAudioTestTone - getRegistrationID == AMT_C_U16_REGID_INVALID.");
   }

   return retCode;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureAudio::setAudioTestToneDBV ( tU32 frequency /* in Hz */, tS16 volume /* dbV */, tU32 channelMask )
{
   dia_tclFnctTrace trc("dia_SAFeatureAudio::setAudioTestToneDBV()");

   DIA_TR_INF("dia_SAFeatureAudio::setAudioTestToneDB - s16Volume type = DBV Level.");
   DIA_TR_INF("dia_SAFeatureAudio::setAudioTestToneDB - forward to generic handling.");
   tDiaResult retCode = setAudioTestTone (frequency, volume, channelMask, DIA_EN_AUDIO_VOLUME_TYPE_DBV);

   return retCode;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureAudio::setAudioTestToneDB ( tU32 frequency /* in Hz */, tS16 volume /* in dB */, tU32 channelMask )
{
   dia_tclFnctTrace trc("dia_SAFeatureAudio::setAudioTestToneDB()");

   DIA_TR_INF("dia_SAFeatureAudio::setAudioTestToneDB - s16Volume type = DB Level.");
   DIA_TR_INF("dia_SAFeatureAudio::setAudioTestToneDB - forward to generic handling.");
   tDiaResult retCode = setAudioTestTone (frequency, volume, channelMask, DIA_EN_AUDIO_VOLUME_TYPE_DB);

   return retCode;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureAudio::setAudioTestToneIncrement ( tU32 frequency /* in Hz */, tS16 volume /* in increment */, tU32 channelMask )
{
   dia_tclFnctTrace trc("dia_SAFeatureAudio::setAudioTestToneIncrement()");

   DIA_TR_INF("dia_SAFeatureAudio::setAudioTestToneIncrement - s16Volume type = INCREMENT Level.");
   DIA_TR_INF("dia_SAFeatureAudio::setAudioTestToneDB - forward to generic handling.");
   tDiaResult retCode = setAudioTestTone (frequency, volume, channelMask, DIA_EN_AUDIO_VOLUME_TYPE_INCREMENT);

   return retCode;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureAudio::setAudioTestTone ( tU32 frequency /* in Hz */, tS16 volume, tU32 channelMask, dia_eAudioVolumeType volumetype )
{
   dia_tclFnctTrace trc("dia_SAFeatureAudio::setAudioTestTone(...,dia_eAudioVolumeType)");
   tDiaResult retCode = DIA_FAILED;

   if (mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID)
   {
      DIA_TR_INF("dia_SAFeatureAudio::setAudioTestTone - registration ID OK - verify data.");

      midw_mascffi_tclMsgAudioTestToneMethodStart oData;

      /* ** SET CHANNEL BITS ** */
      if (frequency != 0x00 || volume != 0x00)
      {
         DIA_TR_INF("dia_SAFeatureAudio::dia_setAudioTestTone - Active Channel Mode (for mask 0x%02x).", channelMask);
         oData.ChannelSelect.bits.CHANNEL_LF = ((DIA_AUDIO_CHANNEL_MASK_FRONT_LEFT == (DIA_AUDIO_CHANNEL_MASK_FRONT_LEFT & channelMask)) ? 1 : 0);
         oData.ChannelSelect.bits.CHANNEL_RF = ((DIA_AUDIO_CHANNEL_MASK_FRONT_RIGHT == (DIA_AUDIO_CHANNEL_MASK_FRONT_RIGHT & channelMask)) ? 1 : 0);
         oData.ChannelSelect.bits.CHANNEL_LR = ((DIA_AUDIO_CHANNEL_MASK_REAR_LEFT == (DIA_AUDIO_CHANNEL_MASK_REAR_LEFT & channelMask)) ? 1 : 0);
         oData.ChannelSelect.bits.CHANNEL_RR = ((DIA_AUDIO_CHANNEL_MASK_REAR_RIGHT == (DIA_AUDIO_CHANNEL_MASK_REAR_RIGHT & channelMask)) ? 1 : 0);
         oData.ChannelSelect.bits.CHANNEL_CENT = ((DIA_AUDIO_CHANNEL_MASK_CENTER == (DIA_AUDIO_CHANNEL_MASK_CENTER & channelMask)) ? 1 : 0);
         oData.ChannelSelect.bits.CHANNEL_SUB = ((DIA_AUDIO_CHANNEL_MASK_SUBWOOFER == (DIA_AUDIO_CHANNEL_MASK_SUBWOOFER & channelMask)) ? 1 : 0);
         oData.ChannelSelect.bits.dummy6 = 0;
         oData.ChannelSelect.bits.dummy7 = 0;
      } else {
         DIA_TR_INF("dia_SAFeatureAudio::setAudioTestTone - All Channels OFF.");
         oData.ChannelSelect.bits.CHANNEL_LF = 0;
         oData.ChannelSelect.bits.CHANNEL_RF = 0;
         oData.ChannelSelect.bits.CHANNEL_LR = 0;
         oData.ChannelSelect.bits.CHANNEL_RR = 0;
         oData.ChannelSelect.bits.CHANNEL_CENT = 0;
         oData.ChannelSelect.bits.CHANNEL_SUB = 0;
         oData.ChannelSelect.bits.dummy6 = 0;
         oData.ChannelSelect.bits.dummy7 = 0;
      }

      /* ** SET FREQUENCY ** */
      oData.Frequency = frequency;

      /* ** CHECK VOLUME TYPE VARIABLE ** */
      tBool volumeTypeError = FALSE;
      switch (volumetype) {
         case DIA_EN_AUDIO_VOLUME_TYPE_DBV:
            DIA_TR_INF("dia_SAFeatureAudio::setAudioTestToneIncrement - Set e8VolType to DBV.");
            oData.Volume.e8VolType.enType = midw_fi_tcl_e8_VolumeType::FI_EN_DBV_LEVEL;
            volume = (tS8)volume;
            break;
         case DIA_EN_AUDIO_VOLUME_TYPE_DB:
            DIA_TR_INF("dia_SAFeatureAudio::setAudioTestToneIncrement - Set e8VolType to DB.");
            oData.Volume.e8VolType.enType = midw_fi_tcl_e8_VolumeType::FI_EN_DB_LEVEL;
            break;
         case DIA_EN_AUDIO_VOLUME_TYPE_INCREMENT:
            if (volume <= 40) {
               DIA_TR_INF("dia_SAFeatureAudio::setAudioTestToneIncrement - Set e8VolType to INC.");
               oData.Volume.e8VolType.enType = midw_fi_tcl_e8_VolumeType::FI_EN_INCREMENT;
            } else {
               DIA_TR_ERR("dia_SAFeatureAudio::setAudioTestToneIncrement - VOLUME %d out of RANGE!", volume);
               volumeTypeError = TRUE;
            }
            break;
         default:
            DIA_TR_ERR("dia_SAFeatureAudio::setAudioTestTone - INVALID OR UNKNOWN Volume Type!");
            volumeTypeError = TRUE;
            break;
      }

      if (volumeTypeError == FALSE) {

         /* ** SET VOLUME - CONTENT VERIFIED IN VOLUME_TYPE ** */
         oData.Volume.s16Volume = volume;

         // Data-Check complete and now print and send data
         DIA_TR_INF("dia_SAFeatureAudio::setAudioTestTone - Channel   %d ; 0x%02x .", oData.ChannelSelect.u8Value, oData.ChannelSelect.u8Value);
         DIA_TR_INF("dia_SAFeatureAudio::setAudioTestTone - Frequency %d ; 0x%08x .", oData.Frequency, oData.Frequency);
         DIA_TR_INF("dia_SAFeatureAudio::setAudioTestTone - VolType   %d ; 0x%02x .", oData.Volume.e8VolType.enType, oData.Volume.e8VolType.enType);
         DIA_TR_INF("dia_SAFeatureAudio::setAudioTestTone - Volume    %d ; 0x%02x .", oData.Volume.s16Volume, oData.Volume.s16Volume);

         //put the data in message
         fi_tclVisitorMessage oMessage(oData);
         mpSrvPlugin->vInitServiceData(oMessage, MIDW_MASCFFI_C_U16_AUDIOTESTTONE, AMT_C_U8_CCAMSG_OPCODE_METHODSTART);

         if (mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE) {
            retCode = DIA_SUCCESS;
            DIA_TR_INF("dia_SAFeatureAudio::setAudioTestTone - transmitMessage success.");
         } else {
            DIA_TR_ERR("dia_SAFeatureAudio::setAudioTestTone - transmitMessage failed.");
         }
      } else {
         DIA_TR_ERR("dia_SAFeatureAudio::setAudioTestTone - END without sending!");
      }
   } else {
      DIA_TR_ERR("dia_SAFeatureAudio::setAudioTestTone - getRegistrationID failed.");
      DIA_TR_ERR("dia_SAFeatureAudio::setAudioTestTone - getRegistrationID == AMT_C_U16_REGID_INVALID.");
   }

   return retCode;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureAudio::setAudioTestToneMute ( dia_eAudioVolumeType volumetype )
{
   dia_tclFnctTrace trc("dia_SAFeatureAudio::setAudioTestToneMute()");

   tDiaResult retCode = DIA_FAILED;

   if (mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID)
   {
      DIA_TR_INF("dia_SAFeatureAudio::setAudioTestToneMute - send message.");

      midw_mascffi_tclMsgAudioTestToneMethodStart oData;

	  oData.ChannelSelect.bits.CHANNEL_LF   = 0;
	  oData.ChannelSelect.bits.CHANNEL_RF   = 0;
	  oData.ChannelSelect.bits.CHANNEL_LR   = 0;
	  oData.ChannelSelect.bits.CHANNEL_RR   = 0;
	  oData.ChannelSelect.bits.CHANNEL_CENT = 0;
	  oData.ChannelSelect.bits.CHANNEL_SUB  = 0;
	  oData.ChannelSelect.bits.dummy6       = 0;
	  oData.ChannelSelect.bits.dummy7       = 0;

      oData.Frequency = 1000; // any valid default value

      if (volumetype == DIA_EN_AUDIO_VOLUME_TYPE_DBV) {
         DIA_TR_INF("dia_SAFeatureAudio::setAudioTestToneMute - MUTE Volume in DBV Level.");
         oData.Volume.e8VolType.enType = midw_fi_tcl_e8_VolumeType::FI_EN_DBV_LEVEL;
         oData.Volume.s16Volume = -128;
      } else if (volumetype == DIA_EN_AUDIO_VOLUME_TYPE_DB) {
         DIA_TR_INF("dia_SAFeatureAudio::setAudioTestToneMute - MUTE Volume in DB Level.");
         //The expected range for volume gain is 0 to (-120) dB, which ADR supports.
         //At -90, volume is muted. And at 0, volume is high.
         //So according to PSA requirement, add the value -90 to volume, so that at 0dBA volume is muted and 90dBA volume is high.
         oData.Volume.e8VolType.enType = midw_fi_tcl_e8_VolumeType::FI_EN_DB_LEVEL;
         oData.Volume.s16Volume = -90;
      } else if (volumetype == DIA_EN_AUDIO_VOLUME_TYPE_INCREMENT) {
         DIA_TR_INF("dia_SAFeatureAudio::setAudioTestToneMute - Mute Volume in INCREMENT Level.");
         oData.Volume.e8VolType.enType = midw_fi_tcl_e8_VolumeType::FI_EN_INCREMENT;
         oData.Volume.s16Volume = 0;
      } else {
         DIA_TR_INF("dia_SAFeatureAudio::setAudioTestToneMute - UNKNOWN VOLUME TYPE");
      }

      DIA_TR_INF("dia_SAFeatureAudio::setAudioTestToneMute - Channel   %d ." , oData.ChannelSelect.u8Value );
      DIA_TR_INF("dia_SAFeatureAudio::setAudioTestToneMute - Frequency %d ; 0x%08x .", oData.Frequency, oData.Frequency);
      DIA_TR_INF("dia_SAFeatureAudio::setAudioTestToneMute - e8VolType %d ." , oData.Volume.e8VolType.enType );
      DIA_TR_INF("dia_SAFeatureAudio::setAudioTestToneMute - s16Volume %d ." , oData.Volume.s16Volume );

      //put the data in message
      fi_tclVisitorMessage oMessage(oData);
      mpSrvPlugin->vInitServiceData(oMessage, MIDW_MASCFFI_C_U16_AUDIOTESTTONE, AMT_C_U8_CCAMSG_OPCODE_METHODSTART);

      if (mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE) {
         retCode = DIA_SUCCESS;
         DIA_TR_INF("dia_SAFeatureAudio::setAudioTestToneMute - transmitMessage success.");
      } else {
         DIA_TR_ERR("dia_SAFeatureAudio::setAudioTestToneMute - transmitMessage failed.");
      }
   } else {
      DIA_TR_ERR("dia_SAFeatureAudio::setAudioTestToneMute - getRegistrationID failed.");
      DIA_TR_ERR("dia_SAFeatureAudio::setAudioTestToneMute - getRegistrationID == AMT_C_U16_REGID_INVALID.");
   }

   return retCode;
}


//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureAudio::dia_setAudioBalance ( tS8 balance )
{
   dia_tclFnctTrace trc("dia_SAFeatureAudio::dia_setAudioBalance()");
   tDiaResult retCode = DIA_FAILED;

   if (mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID) {
      DIA_TR_INF("dia_SAFeatureAudio::dia_setAudioBalance - send message.");

      midw_mascffi_tclMsgBalanceSet oData;

      oData.SoundType.enType = midw_fi_tcl_e8_AudioSoundType::FI_EN_AUDIO_SND_TYPE_ABS;
      oData.Resource.enType = midw_fi_tcl_e8_ResourceNo::FI_EN_AUDIO_RESOURCE_LS;
      oData.Balance = balance;

//      DIA_TR_INF("dia_SAFeatureAudio::dia_setAudioBalance - SoundType %d.", oData.SoundType.enType);
//      DIA_TR_INF("dia_SAFeatureAudio::dia_setAudioBalance - Resource  %d.", oData.Resource.enType);
//      DIA_TR_INF("dia_SAFeatureAudio::dia_setAudioBalance - Balance   %d.", oData.Balance);

      //put the data in message
      fi_tclVisitorMessage oMessage(oData);
      mpSrvPlugin->vInitServiceData(oMessage, MIDW_MASCFFI_C_U16_BALANCE, AMT_C_U8_CCAMSG_OPCODE_SET);

      if (mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE) {
         retCode = DIA_SUCCESS;
         DIA_TR_INF("dia_SAFeatureAudio::dia_setAudioBalance - transmitMessage success.");
      } else {
         DIA_TR_INF("dia_SAFeatureAudio::dia_setAudioBalance - transmitMessage failed.");
      }
   } else {
      DIA_TR_INF("dia_SAFeatureAudio::dia_setAudioBalance - getRegistrationID failed.");
      DIA_TR_INF("dia_SAFeatureAudio::dia_setAudioBalance - getRegistrationID == AMT_C_U16_REGID_INVALID.");
   }

   return retCode;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SAFeatureAudio::dia_setAudioFader ( tS8 fader )
{
   dia_tclFnctTrace trc("dia_SAFeatureAudio::dia_setAudioFader()");
   tDiaResult retCode = DIA_FAILED;

   if (mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID) {
      DIA_TR_INF("dia_SAFeatureAudio::dia_setAudioFader - send message.");

      midw_mascffi_tclMsgFaderSet oData;

      oData.SoundType.enType = midw_fi_tcl_e8_AudioSoundType::FI_EN_AUDIO_SND_TYPE_ABS;
      oData.Resource.enType = midw_fi_tcl_e8_ResourceNo::FI_EN_AUDIO_RESOURCE_LS;
      oData.Fader = fader;

//      DIA_TR_INF("dia_SAFeatureAudio::dia_setAudioFader - SoundType %d.", oData.SoundType.enType);
//      DIA_TR_INF("dia_SAFeatureAudio::dia_setAudioFader - Resource  %d.", oData.Resource.enType);
//      DIA_TR_INF("dia_SAFeatureAudio::dia_setAudioFader - Fader   %d.", oData.Fader);

      //put the data in message
      fi_tclVisitorMessage oMessage(oData);
      mpSrvPlugin->vInitServiceData(oMessage, MIDW_MASCFFI_C_U16_FADER, AMT_C_U8_CCAMSG_OPCODE_SET);

      if (mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE) {
         retCode = DIA_SUCCESS;
         DIA_TR_INF("dia_SAFeatureAudio::dia_setAudioFader - transmitMessage success.");
      } else {
         DIA_TR_INF("dia_SAFeatureAudio::dia_setAudioFader - transmitMessage failed.");
      }
   } else {
      DIA_TR_INF("dia_SAFeatureAudio::dia_setAudioFader - getRegistrationID failed.");
      DIA_TR_INF("dia_SAFeatureAudio::dia_setAudioFader - getRegistrationID == AMT_C_U16_REGID_INVALID.");
   }

   return retCode;
}

tDiaResult
dia_SAFeatureAudio::micPowerSuppyInfo_Get ( tU8 /*micID*/ )
{
   dia_tclFnctTrace trc("dia_SAFeatureAudio::micPowerSuppyInfo_Get()");
   tDiaResult retCode = DIA_FAILED;

   if ( mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID )
   {
      gm_tclU16Message oMessage (
         mAppID,
         mpSrvPlugin->getClientID(),
         mpSrvPlugin->getRegistrationID(),
         0,
         mpSrvPlugin->getServiceID(),
         MIDW_MASCFFI_C_U16_MICROPHONECONNECTIONSTATUS,
         CCA_C_U8_OPCODE_GET
      );

      if ( mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE )
      {
         retCode = DIA_SUCCESS;
      }
   }
   return retCode;
}

//-----------------------------------------------------------------------------
// .... HANDLER ...............................................................
//-----------------------------------------------------------------------------

void
dia_SAFeatureAudio::vHandleAudioTestTone ( amt_tclServiceData* poMessage ) const
{
   dia_tclFnctTrace trc("dia_SAFeatureAudio::vHandleAudioTestTone");

   if ( poMessage )
   {
      DIA_ASSERT(poMessage->bIsServerMessage() == TRUE);

      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODRESULT )
      {
         dia_IAudioListener* pListener = OSAL_NULL;
         querySysAdapterListener<dia_IAudioListener>(&pListener);
         if ( pListener )
         {
            fi_tclVisitorMessage oResultMsg(poMessage);
            midw_mascffi_tclMsgAudioTestToneMethodResult oCompResp;
            (void) oResultMsg.s32GetData(oCompResp);

//            DIA_TR_INF("dia_SAFeatureAudio::vHandleAudioTestTone ChannelSelect.u8Value=0x%02x .", oCompResp.ChannelSelect.u8Value);
//            DIA_TR_INF("dia_SAFeatureAudio::vHandleAudioTestTone Status Compare is %s .", oCompResp.Status.enType!=midw_fi_tcl_e8_Aud_TestToneControl::FI_EN_FC_AUDIO_TEST_TONE_UNDEF?"OK":"Not OK");

            if( oCompResp.ChannelSelect.u8Value != 0x00 && oCompResp.Status.enType != midw_fi_tcl_e8_Aud_TestToneControl::FI_EN_FC_AUDIO_TEST_TONE_UNDEF ){
               DIA_TR_INF("dia_SAFeatureAudio::vHandleAudioTestTone SUCCESSFUL.");
               pListener->vOnTestTone(DIA_SUCCESS);
               pListener->vOnLoudspeakerTestTone(DIA_SUCCESS);
            } else {
               if(oCompResp.ChannelSelect.u8Value == 0x00){
                  DIA_TR_INF("dia_SAFeatureAudio::vHandleAudioTestTone Tone is now OFF.");
                  pListener->vOnTestTone(DIA_SUCCESS);
                  pListener->vOnLoudspeakerTestTone(DIA_SUCCESS);
               } else {
                  DIA_TR_ERR("dia_SAFeatureAudio::vHandleAudioTestTone FAILED. SpeakerType = 0x%02x, Status = 0x%02x .", (tU8) oCompResp.ChannelSelect.u8Value, oCompResp.Status.enType);
               }
            }

         }
      }
      else if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_ERROR )
      {
           amt_tclServiceDataError oErrorMsg( poMessage );
           tU16 u16ErrorCode = oErrorMsg.u16GetErrorData();
           DIA_TR_INF( "dia_SAFeatureAudio---opcode error received with error code: %d", u16ErrorCode);
      }

      (void) poMessage->bDelete();
   }
}

//-----------------------------------------------------------------------------

void
dia_SAFeatureAudio::vHandleAudioBalance ( amt_tclServiceData* poMessage ) const
{
   dia_tclFnctTrace trc("dia_SAFeatureAudio::vHandleAudioBalance");

   dia_IAudioBalFaderListener* pListener = OSAL_NULL;
   querySysAdapterListener<dia_IAudioBalFaderListener>(&pListener);
   if (NULL == pListener)
   {
      DIA_TR_ERR("dia_SAFeatureAudio::vHandleAudioBalance ERR UNABLE TO OPEN LISTENER OBJECT.");
      return;
   }

   if ( poMessage )
   {
      DIA_ASSERT(poMessage->bIsServerMessage() == TRUE);

      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS )
      {
//         DIA_TR_INF("dia_SAFeatureAudio::PROCESS WORK ON BALANCE (4) RECEIVED STATUS. xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx ");

           pListener->vOnAudioBalance(DIA_SUCCESS);

      } else if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_ERROR ) {
//         DIA_TR_INF("dia_SAFeatureAudio::PROCESS WORK ON BALANCE (4) RECEIVED ERROR. xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx ");
           amt_tclServiceDataError oErrorMsg( poMessage );
           tU16 u16ErrorCode = oErrorMsg.u16GetErrorData();
           DIA_TR_INF( "dia_SAFeatureAudio --- opcode error received with error code: %d", u16ErrorCode);

           pListener->vOnAudioBalance(DIA_FAILED);
      }

      (void) poMessage->bDelete();
   }
}

//-----------------------------------------------------------------------------

void
dia_SAFeatureAudio::vHandleAudioFader ( amt_tclServiceData* poMessage ) const
{
   dia_tclFnctTrace trc("dia_SAFeatureAudio::vHandleAudioFader");

   dia_IAudioBalFaderListener* pListener = OSAL_NULL;
   querySysAdapterListener<dia_IAudioBalFaderListener>(&pListener);
   if (NULL == pListener)
   {
      DIA_TR_ERR("dia_SAFeatureAudio::vHandleAudioFader ERR UNABLE TO OPEN LISTENER OBJECT.");
      return;
   }

   if ( poMessage )
   {
      DIA_ASSERT(poMessage->bIsServerMessage() == TRUE);

      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS )
      {
//         DIA_TR_INF("dia_SAFeatureAudio::PROCESS WORK ON FADER (4) RECEIVED STATUS. xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx ");
         //fi_tclVisitorMessage oResultMsg(poMessage);
         //midw_mascffi_tclMsgFaderStatus oCompResp;
         //(void) oResultMsg.s32GetData(oCompResp);  // receiving Status means success; don't need to examine payload

         DIA_TR_INF("dia_SAFeatureAudio::vHandleAudioFader STATUS.");
         pListener->vOnAudioFader(DIA_SUCCESS);

      } else if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_ERROR ) {
//         DIA_TR_INF("dia_SAFeatureAudio::PROCESS WORK ON FADER (4) RECEIVED ERROR. xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx ");
           amt_tclServiceDataError oErrorMsg( poMessage );
           tU16 u16ErrorCode = oErrorMsg.u16GetErrorData();
           DIA_TR_INF( "dia_SAFeatureAudio---opcode error received with error code: %d", u16ErrorCode);
           pListener->vOnAudioFader(DIA_FAILED);
      }

      (void) poMessage->bDelete();
   }
}

void dia_SAFeatureAudio::vHandleMicrophoneConnectionInfo(amt_tclServiceData* poMessage) const
{
   dia_tclFnctTrace trc("dia_SAFeatureAudio::vHandleMicrophoneConnectionStatus");

   if (!poMessage || (poMessage->bIsServerMessage() != TRUE))
      return;

   if (poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS) {
      dia_IAudioListener* pListener = OSAL_NULL;
      querySysAdapterListener<dia_IAudioListener>(&pListener);

      if (pListener) {
         // the received message will be a parameter of the constructor of the new decode type
         DIA_TR_INF("dia_SAFeatureAudio::vHandleMicrophoneConnectionStatus: Extract the Status Msg");

         fi_tclVisitorMessage oMsg(poMessage);
         midw_mascffi_tclMsgMicrophoneConnectionStatusStatus oMsgData;
         (void) oMsg.s32GetData(oMsgData);
         std::vector<dia_tMicrophoneStatus> Microphonestatus_list;
         dia_tMicrophoneStatus Mic_values;
         std::vector<midw_fi_tcl_MicrophoneConnectionStatus, std::allocator<midw_fi_tcl_MicrophoneConnectionStatus> >::const_iterator it;

         it = oMsgData.MicrophoneConnectionStatusList.MicrophoneConnectionStatusList.begin();

         for (; it != oMsgData.MicrophoneConnectionStatusList.MicrophoneConnectionStatusList.end(); ++it)
         {
            midw_fi_tcl_MicrophoneConnectionStatus mic_status = (*it);

            DIA_TR_INF("MIC NUMBER = %d ", mic_status.e8MicrophoneNumber.enType);
            DIA_TR_INF("MIC STATUS = %d ", mic_status.e8MicrophoneConnectionStatus.enType);
            DIA_TR_INF("MIC CURRENT  = %d ", mic_status.u16MicrophoneCurrent);

            switch (mic_status.e8MicrophoneConnectionStatus.enType)
            {
               case midw_fi_tcl_e8_MicrophoneConnectionStatus::FI_EN_FC_AUDIO_DIAG_MIC_CONNECTION_OPEN: {
                  Mic_values.ConnectionStatus = DIA_EN_MICROPHONE_CONNECTION_OPEN;
                  break;
               }
               case midw_fi_tcl_e8_MicrophoneConnectionStatus::FI_EN_FC_AUDIO_DIAG_MIC_CONNECTION_SHORT: {
                  Mic_values.ConnectionStatus = DIA_EN_MICROPHONE_CONNECTION_SHORT;
                  break;
               }
               case midw_fi_tcl_e8_MicrophoneConnectionStatus::FI_EN_FC_AUDIO_DIAG_MIC_CONNECTION_OK: {
                  Mic_values.ConnectionStatus = DIA_EN_MICROPHONE_CONNECTION_OK;
                  break;
               }
               case midw_fi_tcl_e8_MicrophoneConnectionStatus::FI_EN_FC_AUDIO_DIAG_MIC_CONNECTION_SHORT_TO_BATTERY: {
                  Mic_values.ConnectionStatus = DIA_EN_MICROPHONE_CONNECTION_SHORT_TO_BATTERY;
                  break;
               }
               case midw_fi_tcl_e8_MicrophoneConnectionStatus::FI_EN_FC_AUDIO_DIAG_MIC_CONNECTION_UNDEFINED: {
                  Mic_values.ConnectionStatus = DIA_EN_MICROPHONE_CONNECTION_UNDEFINED;
                  break;
               }
               default: {
                  Mic_values.ConnectionStatus = DIA_EN_MICROPHONE_CONNECTION_UNKNOWN;
                  break;
               }
            }

            switch (mic_status.e8MicrophoneNumber.enType)//Coverity Fix(CID:52684)
            {
            case midw_fi_tcl_e8_MicrophoneNumber::FI_EN_MIC_1:
            	Mic_values.Mic_num = DIA_EN_MICROPHONE_1;
            	break;

            case midw_fi_tcl_e8_MicrophoneNumber::FI_EN_MIC_2:
            	Mic_values.Mic_num = DIA_EN_MICROPHONE_2;
            	break;

            default:
            	Mic_values.Mic_num = DIA_EN_MICROPHONE_UNKNOWN;
            	break;

            }

            Mic_values.u16CurrentValue = mic_status.u16MicrophoneCurrent;
            Microphonestatus_list.push_back(Mic_values);
         }

         pListener->vOnMicrophonePowersupplyInfo(Microphonestatus_list);

      }
   }
   else
   {
      DIA_TR_INF("OpCode = %d received", poMessage->u8GetOpCode());
   }

   (void) poMessage->bDelete();
}


/***********************************************************************************************************************************************************************/

tDiaResult
dia_SAFeatureAudio::regToANCSWVersion ( void )
{
dia_tclFnctTrace trc("dia_SAFeatureAudio::regToANCSWVersion()");

   tDiaResult retCode = DIA_FAILED;

   if ( mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID )
   {
      DIA_TR_INF("dia_SAFeatureAudio::regToANCSWVersion - send message.");
      gm_tclEmptyMessage oMessage ( mAppID, mpSrvPlugin->getClientID(),
                                    mpSrvPlugin->getRegistrationID(), 0,
                                    mpSrvPlugin->getServiceID(),
                                    MIDW_MASCFFI_C_U16_ANCSWVERSION,
                                    CCA_C_U8_OPCODE_UPREG
                                  );

      if ( mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE )
      {
         retCode = DIA_SUCCESS;
         DIA_TR_INF("dia_SAFeatureAudio::regToANCSWVersion - transmitMessage success.");
      }
      else
      {
         DIA_TR_INF("dia_SAFeatureAudio::regToANCSWVersion - transmitMessage failed.");
      }
   }
   else
   {
      DIA_TR_INF("dia_SAFeatureAudio::regToANCSWVersion - getRegistrationID failed.");
      DIA_TR_INF("dia_SAFeatureAudio::regToANCSWVersion - getRegistrationID == AMT_C_U16_REGID_INVALID.");
   }

   return retCode;
}

/***********************************************************************************************************************************************************************/

tDiaResult
dia_SAFeatureAudio::regToASCSWVersion ( void )
{
dia_tclFnctTrace trc("dia_SAFeatureAudio::regToANCSWVersion()");

   tDiaResult retCode = DIA_FAILED;

   if ( mpSrvPlugin->getRegistrationID() != AMT_C_U16_REGID_INVALID )
   {
      DIA_TR_INF("dia_SAFeatureAudio::regToANCSWVersion - send message.");
      gm_tclEmptyMessage oMessage ( mAppID, mpSrvPlugin->getClientID(),
                                    mpSrvPlugin->getRegistrationID(), 0,
                                    mpSrvPlugin->getServiceID(),
                                    MIDW_MASCFFI_C_U16_ASCSWVERSION,
                                    CCA_C_U8_OPCODE_UPREG
                                  );

      if ( mpSrvPlugin->bTransmitMessage(&oMessage) == TRUE )
      {
         retCode = DIA_SUCCESS;
         DIA_TR_INF("dia_SAFeatureAudio::regToANCSWVersion - transmitMessage success.");
      }
      else
      {
         DIA_TR_INF("dia_SAFeatureAudio::regToANCSWVersion - transmitMessage failed.");
      }
   }
   else
   {
      DIA_TR_INF("dia_SAFeatureAudio::regToANCSWVersion - getRegistrationID failed.");
      DIA_TR_INF("dia_SAFeatureAudio::regToANCSWVersion - getRegistrationID == AMT_C_U16_REGID_INVALID.");
   }

   return retCode;
}

tVoid
dia_SAFeatureAudio::vHandleANCSWVersion ( amt_tclServiceData* poMessage )
{
 dia_tclFnctTrace trc("dia_SAFeatureAudio::vHandleANCSWVersion");

   if ( poMessage )
   {
      DIA_ASSERT(poMessage->bIsServerMessage() == TRUE);

      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS )
      {
         dia_IAudioListener* pListener = OSAL_NULL;       
         querySysAdapterListener<dia_IAudioListener>(&pListener);    
         if ( pListener )
         {
		    fi_tclVisitorMessage oStatusMessage(poMessage);
            midw_mascffi_tclMsgANCSWVersionStatus oStatusMsgData;
            (void) oStatusMessage.s32GetData(oStatusMsgData);
             
            DIA_TR_INF("dia_SAFeatureAudio::vHandleANCSWVersion - Received !!!");
            DIA_TR_INF("dia_SAFeatureAudio::vHandleANCSWVersion - LargeVersion = %d", oStatusMsgData.LargeVersion);
            DIA_TR_INF("dia_SAFeatureAudio::vHandleANCSWVersion - MiddleVersion = %d", oStatusMsgData.MiddleVersion);
            DIA_TR_INF("dia_SAFeatureAudio::vHandleANCSWVersion - SmallVersion = %d", oStatusMsgData.SmallVersion);
			dia_tBoseAmpSWVersionInfo ancSWVersionInfo = dia_tBoseAmpSWVersionInfo( oStatusMsgData.LargeVersion,
                                                          oStatusMsgData.MiddleVersion,
														  oStatusMsgData.SmallVersion
                                                            );

            pListener->onANCSWVersionUpdate(ancSWVersionInfo);
         }
      }
      else if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_ERROR )
      {
           amt_tclServiceDataError oErrorMsg( poMessage );
           tU16 u16ErrorCode = oErrorMsg.u16GetErrorData();
           DIA_TR_ERR( "---opcode error recievd with error code: 0x%04x", u16ErrorCode);
      }


      (void) poMessage->bDelete();
   }
}


tVoid
dia_SAFeatureAudio::vHandleASCSWVersion( amt_tclServiceData* poMessage )
{
 dia_tclFnctTrace trc("dia_SAFeatureAudio::vHandleASCSWVersion");

   if ( poMessage )
   {
      DIA_ASSERT(poMessage->bIsServerMessage() == TRUE);

      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS )
      {
         dia_IAudioListener* pListener = OSAL_NULL;       
         querySysAdapterListener<dia_IAudioListener>(&pListener);    
         if ( pListener )
         {
		    fi_tclVisitorMessage oStatusMessage(poMessage);
            midw_mascffi_tclMsgASCSWVersionStatus oStatusMsgData;
            (void) oStatusMessage.s32GetData(oStatusMsgData);
            dia_tBoseAmpSWVersionInfo ascSWVersionInfo;
            DIA_TR_INF("dia_SAFeatureAudio::vHandleASCSWVersion - Received !!!");
            DIA_TR_INF("dia_SAFeatureAudio::vHandleASCSWVersion - LargeVersion = %d", oStatusMsgData.LargeVersion);
            DIA_TR_INF("dia_SAFeatureAudio::vHandleASCSWVersion - MiddleVersion = %d", oStatusMsgData.MiddleVersion);
            DIA_TR_INF("dia_SAFeatureAudio::vHandleASCSWVersion - SmallVersion = %d", oStatusMsgData.SmallVersion);
			ascSWVersionInfo = dia_tBoseAmpSWVersionInfo( oStatusMsgData.LargeVersion,
                                                          oStatusMsgData.MiddleVersion,
														  oStatusMsgData.SmallVersion
                                                         );
           pListener->onASCSWVersionUpdate(ascSWVersionInfo);
         }
      }
      else if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_ERROR )
      {
           amt_tclServiceDataError oErrorMsg( poMessage );
           tU16 u16ErrorCode = oErrorMsg.u16GetErrorData();
           DIA_TR_ERR( "---opcode error recievd with error code: 0x%04x", u16ErrorCode);
      }

      (void) poMessage->bDelete();
   }
}



