#ifndef __INCLUDED_DIA_SIGMAVTDDSTORE__
#include "project/framework/sigma/dia_SigmaVTDDStore.h"
#endif

#ifndef __INCLUDED_DIA_DATALOGGER__
#include <common/framework/datalogger/dia_DataLogger.h>
#endif

dia_SigmaVTDDStore::dia_SigmaVTDDStore(tU32 maxSlots):
   slots(maxSlots)
{
   init();
}

void dia_SigmaVTDDStore::readData(tU32 slot, std::vector<tU8>& buffer) const
{
   this->records[slot].getAsBuffer(buffer);
}

void dia_SigmaVTDDStore::storeData(tU32 slot, tU32 sigNo)
{
   dia_SigmaVTDDRecord newRecord(static_cast<tU8>(sigNo & 0xff));         
   for(tS32 offset = dia_DataLogger::historyPeriod; offset <= dia_DataLogger::futurePeriod; offset += dia_DataLogger::resolution)
   {
      newRecord.setData(offset);
   }
   this->records[slot] = newRecord;
}
        
void dia_SigmaVTDDStore::getAsBuffer(std::vector<tU8>& buffer) const 
{
   for(std::size_t i = 0; i < this->records.size(); ++i)
   {
      std::vector<tU8> rec;
      records[i].getAsBuffer(rec);
      buffer.insert(buffer.end(), rec.begin(), rec.end());  //lint !e864 Info: expression possibly depends on order of evaluation
   }

}

std::vector<tU8>::const_iterator dia_SigmaVTDDStore::setFromBuffer(std::vector<tU8>::const_iterator it)
{
   for(std::size_t i = 0; i < this->records.size(); ++i)
   {
      it = records[i].setFromBuffer(it);
   }
   return it;
}

void dia_SigmaVTDDStore::init()
{
   dia_SigmaVTDDRecord emptyRecord;
   this->records.assign(this->slots, emptyRecord);
}
