#ifndef __INCLUDED_DIA_SIGMAVTDDRECORD__
#define __INCLUDED_DIA_SIGMAVTDDRECORD__

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

#ifndef __INCLUDED_DIA_SIGMARECORD__
#include "project/framework/sigma/dia_SigmaRecord.h"
#endif

#ifndef __INCLUDED_DIA_DATALOGGER__
#include <common/framework/datalogger/dia_DataLogger.h>
#endif

class dia_SigmaVTDDRecord: public dia_SigmaRecord
{
private:
   static tU32 basedVoltageLogHandle;
   static tU32 standardVoltageLogHandle;
   static tU32 diagMuxOnLogHandle;
   static tU32 ignStatusLogHandle;
   static tU32 cutOffLogHandle;
   static tU32 odbDiagMuxOnLogHandle;
   static tU32 gadeLogHandle;
   static tU32 wakeUpSleepLogHandle;
   static tU32 refuseToSleepLogHandle;
public:
   static void setBasedVoltageLogHandle(tU32 handle) {basedVoltageLogHandle = handle;}
   static void setStandardVoltageLogHandle(tU32 handle) {standardVoltageLogHandle = handle;}
   static void setDiagMuxOnLogHandle(tU32 handle) {diagMuxOnLogHandle = handle;}
   static void setIgnStatusLogHandle(tU32 handle) {ignStatusLogHandle = handle;}
   static void setCutOffLogHandle(tU32 handle) {cutOffLogHandle = handle;}
   static void setODBDiagMuxOnLogHandle(tU32 handle) {odbDiagMuxOnLogHandle = handle;}
   static void setGADELogHandle(tU32 handle) {gadeLogHandle = handle;}
   static void setWakeUpSleepLogHandle(tU32 handle) {wakeUpSleepLogHandle = handle;}
   static void setRefuseToSleepLogHandle(tU32 handle) {refuseToSleepLogHandle = handle;}

private:
   static const tU32 RECORD_SIZE = 68;
   static const tU32 SIGNO_OFFSET = 0;
   static const tU32 BASED_VOLTAGE_BYTE_START = 1;       
   static const tU32 BASED_VOLTAGE_BIT_START = 7;     
   static const tU32 BASED_VOLTAGE_BIT_SIZE = 8;   
   static const tU32 ECU_VOLTAGE_BYTE_START = 20;       
   static const tU32 ECU_VOLTAGE_BIT_START = 7;     
   static const tU32 ECU_VOLTAGE_BIT_SIZE = 10;   
   static const tU32 DIAG_MUX_ON_BYTE_START = 43;
   static const tU32 DIAG_MUX_ON_BIT_START = 1;
   static const tU32 DIAG_MUX_ON_BIT_SIZE = 1;
   static const tU32 IGN_STATUS_BYTE_START = 46;
   static const tU32 IGN_STATUS_BIT_START = 6;
   static const tU32 IGN_STATUS_BIT_SIZE = 1;
   static const tU32 IGN_STATUS_BYTE_START_C1A = 43;
   static const tU32 IGN_STATUS_BIT_START_C1A = 1;
   static const tU32 IGN_STATUS_BIT_SIZE_C1A = 1;
   static const tU32 CUT_OFF_BYTE_START = 48;
   static const tU32 CUT_OFF_BIT_START = 3;
   static const tU32 CUT_OFF_BIT_SIZE = 1;
   static const tU32 CUT_OFF_BYTE_START_C1A = 46;
   static const tU32 CUT_OFF_BIT_START_C1A = 6;
   static const tU32 CUT_OFF_BIT_SIZE_C1A = 2;
   static const tU32 ODB_DIAG_MUX_ON_BYTE_START = 50;
   static const tU32 ODB_DIAG_MUX_ON_BIT_START = 0;
   static const tU32 ODB_DIAG_MUX_ON_BIT_SIZE = 1;
   static const tU32 GADE_BYTE_START = 53;
   static const tU32 GADE_BIT_START = 5;
   static const tU32 GADE_BIT_SIZE = 2;
   static const tU32 GADE_BYTE_START_C1A = 50;
   static const tU32 GADE_BIT_START_C1A = 0;
   static const tU32 GADE_BIT_SIZE_C1A = 3;
   static const tU32 WAKE_UP_SLEEP_BYTE_START = 58;
   static const tU32 WAKE_UP_SLEEP_BIT_START = 7;
   static const tU32 WAKE_UP_SLEEP_BIT_SIZE = 2;
   static const tU32 REFUSE_TO_SLEEP_BYTE_START = 62;
   static const tU32 REFUSE_TO_SLEEP_BIT_START = 1;
   static const tU32 REFUSE_TO_SLEEP_BIT_SIZE = 2;
public:
   dia_SigmaVTDDRecord();
   dia_SigmaVTDDRecord(tU8 sigNo); 
   void setData(tS32 timeOffset);
private:
   tU32 calcTimeOffset(tS32 timeOffset) {return static_cast<tU32>((timeOffset + -dia_DataLogger::historyPeriod) / dia_DataLogger::resolution);}
};

#endif