#ifndef __INCLUDED_DIA_SIGMAVSSDSTORE__
#define __INCLUDED_DIA_SIGMAVSSDSTORE__

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

#ifndef __INCLUDED_DIA_SIGMAVSSDRECORD__
#include "project/framework/sigma/dia_SigmaVSSDRecord.h"
#endif

#ifndef __INCLUDED_DIA_DATALOGGER__
#include <common/framework/datalogger/dia_DataLogger.h>
#endif

class dia_SigmaVSSDStore
{
private:
   std::vector<dia_SigmaVSSDRecord> records;
   tU32 slots;
private:
   void init();
public:
   dia_SigmaVSSDStore(tU32 maxSlots);
   void readData(tU32 slot, std::vector<tU8>& buffer) const;
   void storeData(tU32 slot, tU32 sigNo, bool triggered, std::vector<dia_SIGMATriggerFrame> const& triggerFrames, std::vector<tU32> const& info);
   void getAsBuffer(std::vector<tU8>& buffer) const; 
   std::vector<tU8>::const_iterator setFromBuffer(std::vector<tU8>::const_iterator it);
   void clear() {init();}
};

#endif