#ifndef __INCLUDED_DIA_SIGMAVSSDSTORE__
#include "project/framework/sigma/dia_SigmaVSSDStore.h"
#endif

dia_SigmaVSSDStore::dia_SigmaVSSDStore(tU32 maxSlots):
   slots(maxSlots)
{
   init();
}

void dia_SigmaVSSDStore::readData(tU32 slot, std::vector<tU8>& buffer) const
{
   this->records[slot].getAsBuffer(buffer);
}

void dia_SigmaVSSDStore::storeData(tU32 slot, tU32 sigNo, bool triggered, std::vector<dia_SIGMATriggerFrame> const& triggerFrames, std::vector<tU32> const& info)
{
   dia_SigmaVSSDRecord newRecord(static_cast<tU8>(sigNo & 0xff), triggered);
   newRecord.setData(info, triggerFrames);
   this->records[slot] = newRecord;
}

void dia_SigmaVSSDStore::getAsBuffer(std::vector<tU8>& buffer) const 
{
   for(std::size_t i = 0; i < this->records.size(); ++i)
   {
      std::vector<tU8> rec;
      records[i].getAsBuffer(rec);
      buffer.insert(buffer.end(), rec.begin(), rec.end());  //lint !e864 Info: expression possibly depends on order of evaluation
   }
}

std::vector<tU8>::const_iterator dia_SigmaVSSDStore::setFromBuffer(std::vector<tU8>::const_iterator it)
{
   for(std::size_t i = 0; i < this->records.size(); ++i)
   {
      it = records[i].setFromBuffer(it);
   }
   return it;
}

void dia_SigmaVSSDStore::init()
{
   dia_SigmaVSSDRecord emptyRecord;
   this->records.assign(this->slots, emptyRecord);
}
