#ifndef __INCLUDED_DIA_SIGMAVSSDRECORD__
#define __INCLUDED_DIA_SIGMAVSSDRECORD__

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

#ifndef __INCLUDED_DIA_SIGMATRIGGERFRAME__
#include "project/framework/sigma/dia_SigmaTriggerFrame.h"
#endif

#ifndef __INCLUDED_DIA_SIGMARECORD__
#include "project/framework/sigma/dia_SigmaRecord.h"
#endif

class dia_DataLoggerRecord;

class dia_SigmaVSSDRecord: public dia_SigmaRecord
{
private:
   static tU32 mileageLogHandle;
   static tU32 mileageUnitLogHandle;
   static tU32 ignStatusLogHandle;
public:
   static const tU32 maxTriggerFrames = 8;
   static void setIgnStatusLogHandle(tU32 handle) {ignStatusLogHandle = handle;}
   static void setMileageLogHandle(tU32 handle) {mileageLogHandle = handle;}
   static void setMileageUnitLogHandle(tU32 handle) {mileageUnitLogHandle = handle;}

private:
   static const tU32 RECORD_SIZE = 63;
   static const tU32 SIGNO_OFFSET = 0;
   static const tU32 TRIGGER_BYTE_START = 1;
   static const tU32 TRIGGER_BIT_START = 7;
   static const tU32 TRIGGER_BIT_SIZE = 1;
   static const tU32 IGN_BYTE_START = 1;
   static const tU32 IGN_BIT_START = 6;
   static const tU32 IGN_BIT_SIZE = 1;
   static const tU32 TRICOUNT_BYTE_START = 1;
   static const tU32 TRICOUNT_BIT_START = 5;
   static const tU32 TRICOUNT_BIT_SIZE = 3;
   static const tU32 MILEAGE_BYTE_START = 2;
   static const tU32 MILEAGE_BIT_START = 7;
   static const tU32 MILEAGE_BIT_SIZE = 24;
   static const tU32 INFO_BYTE_START = 5;
   static const tU32 INFO_BIT_START = 7;
   static const tU32 INFO_BIT_SIZE = 2;
   static const tU32 FRAME_BYTE_START = 7;
   static const tU32 FRAME_BIT_START = 7;
   static const tU32 FRAME_BIT_SIZE = 56;
public:
   dia_SigmaVSSDRecord(): dia_SigmaRecord(RECORD_SIZE, 0xff) {}
   dia_SigmaVSSDRecord(dia_SigmaVSSDRecord const& src): dia_SigmaRecord(src) {}
//   dia_SigmaVSSDRecord& operator=(dia_SigmaVSSDRecord const& src)  {src.getAsBuffer(this->data); return *this;}
   dia_SigmaVSSDRecord(tU8 sigNo, bool triggered);
private:
   double adjustKmBasedOnCangen(double) const;
   void convertCSMMileageToSigma(std::vector<tU8>& mileage, bool convertToKm) const;
   double convertMilesToKm(double) const;
   bool mustConvertToKm(tU8) const;
   void setIgnition(dia_DataLoggerRecord const&);
   void setMileage(dia_DataLoggerRecord const&);
   void setInfo(std::vector<tU32> const& info);
   void setFrame(std::vector<dia_SIGMATriggerFrame> const& triggerFrames);
public:
   void setData(std::vector<tU32> const& info, std::vector<dia_SIGMATriggerFrame> const& triggerFrames);
};

#endif