#ifndef __INCLUDED_DIA_SIGMATRIGGERFRAME__
#include "project/framework/sigma/dia_SigmaTriggerFrame.h"
#endif

#ifndef __INCLUDED_DIA_SIGMACSM__
#include "project/framework/sigma/dia_SigmaCSM.h"
#endif

dia_SIGMATriggerFrame::dia_SIGMATriggerFrame(std::vector<tU8> buffer)
{
   ecuId = static_cast<tU32>(buffer[0]) << 24u;
   ecuId |= buffer[1] << 16;
   ecuId |= buffer[2] << 8;
   ecuId |= buffer[3];
   dtcId = buffer[4] << 16;
   dtcId |= buffer[5] << 8;
   dtcId |= buffer[6];
}

void dia_SIGMATriggerFrame::getAsBuffer(std::vector<tU8>& buffer) const 
{
   buffer.clear();
   buffer.push_back((ecuId >> 24) & 0xff);
   buffer.push_back((ecuId >> 16) & 0xff);
   buffer.push_back((ecuId >> 8) & 0xff);
   buffer.push_back(ecuId & 0xff);
   buffer.push_back((dtcId >> 16) & 0xff);
   buffer.push_back((dtcId >> 8) & 0xff);
   buffer.push_back(dtcId & 0xff);
}

void dia_SIGMATriggerFrame::send() const
{
   std::vector<tU8> buf;
   this->getAsBuffer(buf);
   dia_CSMWrapper::getInstance()->sendTriggerFrame(buf);
}
