#ifndef __INCLUDED_DIA_SIGMAREQUEST__
#define __INCLUDED_DIA_SIGMAREQUEST__

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

#ifndef __INCLUDED_DIA_DATALOGGERREQUEST__
#include <common/framework/datalogger/dia_DataLoggerRequest.h>
#endif

#ifndef __INCLUDED_DIA_SIGMADATASTORE__
#include "project/framework/sigma/dia_SigmaDataStore.h"
#endif

#ifndef __INCLUDED_DIA_SIGMATRIGGERFRAME__
#include "project/framework/sigma/dia_SigmaTriggerFrame.h"
#endif

class dia_SigmaRequest: public dia_DataLoggerRequest
{
public:
   dia_SigmaRequest();
   virtual ~dia_SigmaRequest();
private:
   dia_SigmaDataStore* sigmaDataStore;
   bool isTriggered;
   std::vector<dia_SIGMATriggerFrame> triggerFrames;
   std::vector<tU32> info;
   tU32 count;
   mutable dia_Lock syncObj;
public:
   tU32 getCount() const  {return count;}
   bool hasDtc(tU32 dtc) const;
   virtual void storeData();
   void request(dia_SigmaDataStore& dataStore, dia_SIGMATriggerFrame const& triggerFrame, bool triggered);
};

#endif
