#ifndef __INCLUDED_DIA_SIGMARECORD__
#include <project/framework/sigma/dia_SigmaRecord.h>
#endif

#ifndef __INCLUDED_DIA_DATALOGGER__
#include <common/framework/datalogger/dia_DataLogger.h>
#endif

void dia_SigmaRecord::addData(tU8 src, tU32 byteStart)
{
   if(byteStart < this->data.size())
   {
      this->data[byteStart] = src;
   }
}

tU32 dia_SigmaRecord::shiftRight(tU32 src, tS32 shift)
{
   return src >> shift;
}

tU32 dia_SigmaRecord::shiftLeft(tU32 src, tS32 shift)
{
   return src << shift;
}

tU32 dia_SigmaRecord::makeCutOut(std::vector<tU8> const& src, tU32 byteStart, tU32 bitStart, tU32 bitSize, tU32 offset, std::vector<tU8>& cutOut)
{
   if(src.empty())
   {
      return 0;
   }
   tU32 byteCount = dia_SigmaRecord::byteCount(byteStart, bitStart, bitSize, offset);
   tU32 dstByteStart = dia_SigmaRecord::bytePosition(byteStart, bitStart, bitSize, offset);
   tU32 dstBitStart = dia_SigmaRecord::bitPosition(byteStart, bitStart, bitSize, offset);
   cutOut.assign(byteCount, 0);
   for(tS32 i = cutOut.size() - 1, j = src.size() - 1; (j >= 0) && (i >= 0); --i, --j)
   {
      cutOut[i] |= static_cast<tU8>(shiftLeft(src[j], dstBitStart) & 0xff);
      if (((dstBitStart + bitSize) > 8) && (i>0))
      {
         cutOut[i-1] |= static_cast<tU8>(shiftRight(src[j], 8 - dstBitStart) & 0xff);
      }
      else if (((dstBitStart + bitSize) > 8) && (i==0))
      {
          DIA_TR_INF("dia_SigmaRecord::makeCutOut i is 0. offset=%d,src.size()=%d", offset, src.size());
          DIA_TR_INF("dia_SigmaRecord::makeCutOut i is 0. dstBitStart=%d, bitSize=%d", dstBitStart, bitSize);
      }
   }
   
   if (0==byteCount)
   {
      DIA_TR_INF("dia_SigmaRecord::makeCutOut byteCount is 0.");
   }
   return dstByteStart;
}

void dia_SigmaRecord::addData(std::vector<tU8> const& src, tU32 byteStart)
{
   std::vector<tU8>::iterator itDst = this->data.begin() + static_cast<tS32>(byteStart);
   for(
      std::vector<tU8>::const_iterator it = src.begin(); 
      (it != src.end()) && (itDst != this->data.end()); 
      ++it, ++itDst
      )
   {
      (*itDst) |= (*it);
   }
}

tU32 dia_SigmaRecord::bytePosition(tU32 byteStart, tU32 bitStart, tU32 bitSize, tU32 offset)
{
   tU32 bytePosition = byteStart + (((7 - bitStart) + (bitSize * offset)) / 8);
   return bytePosition;
}

tU32 dia_SigmaRecord::byteCount(tU32 byteStart, tU32 bitStart, tU32 bitSize, tU32 offset)
{
   tU32 bitPosition = dia_SigmaRecord::bitPosition(byteStart, bitStart, bitSize, offset);
   tU32 byteCount = ((bitSize + bitPosition + 7) / 8) ;
   return byteCount;
}

tU32 dia_SigmaRecord::bitPosition(tU32 byteStart, tU32 bitStart, tU32 bitSize, tU32 offset)
{
   tU32 dataSize = (bitSize * (offset+1));
   tU32 bitPosition = (tU32)abs((tS32)bitStart - (tS32)dataSize + 1);
   if(bitStart < dataSize)
   {
      bitPosition = bitPosition % 8;
      bitPosition = (8 - bitPosition) % 8;
   }
   return bitPosition;
}


void dia_SigmaRecord::getAsBuffer(std::vector<tU8>& buffer) const 
{
   buffer = this->data;
}

//lint -efunc(1746, dia_SigmaRecord::setFromBuffer ) 
std::vector<tU8>::const_iterator dia_SigmaRecord::setFromBuffer(std::vector<tU8>::const_iterator it)
{
   this->data.assign(it, it + static_cast<tS32>(data.size())); 
   return (it + static_cast<tS32>(data.size()));
}
