#ifndef __INCLUDED_DIA_SIGMACSM__
#define __INCLUDED_DIA_SIGMACSM__

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

#ifndef __INCLUDED_CSM_IF__
#define CSM_S_IMPORT_INTERFACE_GENERIC_USER
#include "csm_if.h"
#endif 

class dia_IDataLoggerItem;

class dia_CSMWrapper
{
public:
   DECL_SINGLETON_CONSTRUCTOR_AND_DESTRUCTOR(dia_CSMWrapper);
   csm_tclCsmAccessUser CSMInterface;
   void init() {CSMInterface.vApplCallbackPreInit();}
   void registerForTriggerFrame();
   void unregisterForTriggerFrame();
   void sendTriggerFrame(std::vector<tU8>&);
   static boost::shared_ptr<dia_IDataLoggerItem> createCSMLogItem(tU32 sig, tU32 len);

   static void vSignalIndCallback(tVoid* , tU32 , tU32 ); 

};

class dia_IDataAcquisitionStrategy
{
public:
   virtual bool acquire(std::vector<tU8>&) = 0;
};

class CSMDataLogStrategy : public dia_IDataAcquisitionStrategy
{
public:
   CSMDataLogStrategy();
   CSMDataLogStrategy(tU32 sig, tU32 len): signalId(sig), length(len) {}
   virtual bool acquire(std::vector<tU8>&);
private:
   tU32  signalId;
   tU32  length;
};


#endif
