#ifndef __INCLUDED_DIA_SIGMACSM__
#include "project/framework/sigma/dia_SigmaCSM.h"
#endif

#ifndef __INCLUDED_DIA_SIGMA__
#include "project/framework/sigma/dia_Sigma.h"
#endif

#ifndef __INCLUDED_DIA_DATALOGGERITEM__
#include "common/framework/datalogger/dia_DataLoggerItem.h"
#endif

//kaa1hi: to be deleted if stabi branch is not necessary
#ifndef CSM_C_ASIG_RX_SIGMA_ECU
#define CSM_C_ASIG_RX_SIGMA_ECU 0
#endif

//kaa1hi: to be deleted if stabi branch is not necessary
#ifndef CSM_C_ASIG_TX_SIGMA_DTU
#define CSM_C_ASIG_TX_SIGMA_DTU 0
#endif


DIA_IMPL_SINGLETON(dia_CSMWrapper)

void dia_CSMWrapper::registerForTriggerFrame()
{
   //Task 239541 , Task 243961
   //CSMInterface.s32SignalCallbackInit(CSM_C_ASIG_RX_SIGMA_ECU, vSignalIndCallback);
}

void dia_CSMWrapper::unregisterForTriggerFrame()
{
   CSMInterface.s32SignalCallbackDeInit(CSM_C_ASIG_RX_SIGMA_ECU);
}

void dia_CSMWrapper::vSignalIndCallback(tVoid* /*pHandle*/, tU32 signalId, tU32 /*state*/)
{
   std::vector<tU8> buf(8, 0);
   tU32 signalStatus = 0;
   tS32 result = dia_CSMWrapper::getInstance()->CSMInterface.s32SignalRead(signalId, (void*)&buf[0], static_cast<tU8>(buf.size() & 0xff), &signalStatus);
   if (
      (result == CSM_C_NO_ERROR) 
      && 
      ((signalStatus & CSM_C_SIGNAL_TIMEOUT) == 0)
      &&
      (
         ((signalStatus & CSM_C_SIGNAL_ARRIVED_FIRST) == CSM_C_SIGNAL_ARRIVED_FIRST)
         || 
         ((signalStatus & CSM_C_SIGNAL_ARRIVED) == CSM_C_SIGNAL_ARRIVED)
      )
      )
   {
      //DIA_TR_INF("dia_CSMWrapper::vSignalIndCallback: trigger frame successfully received, status 0x%x", signalStatus);
      buf.resize(dia_SIGMATriggerFrame::length);
      std::reverse(buf.begin(), buf.end()); //lint !e864 Info: expression possibly depends on order of evaluation
      dia_SIGMATriggerFrame triggerFrame(buf);
      dia_Sigma::getInstance()->externalTriggerEvent(triggerFrame);
   }
   else
   {
      //DIA_TR_ERR("dia_CSMWrapper::vSignalIndCallback: trigger frame receive FAILED: %d", result);
   }
}

void dia_CSMWrapper::sendTriggerFrame(std::vector<tU8>& buf)
{
   std::reverse(buf.begin(), buf.end()); //lint !e864 Info: expression possibly depends on order of evaluation  
   tS32 result = CSMInterface.s32SignalWrite(CSM_C_ASIG_TX_SIGMA_DTU, (void*)&buf[0], static_cast<tU8>(buf.size() & 0xff), CSM_C_TX_AS_CONFIGURED);
   //tS32 result = CSMInterface.s32SignalWrite(CSM_C_SIG_TX_SLOT5_18CC0767_SIGMA_DTU, (void*)&buf[0], static_cast<tU8>(buf.size() & 0xff), CSM_C_TX_AS_CONFIGURED);
   if(CSM_C_NO_ERROR == result)
   {
      DIA_TR_INF("dia_CSMWrapper::sendTriggerFrame: trigger frame successfully sent");
   }
   else
   {
      DIA_TR_ERR("dia_CSMWrapper::sendTriggerFrame: send trigger frame FAILED: %d", result);
   }
}

boost::shared_ptr<dia_IDataLoggerItem> dia_CSMWrapper::createCSMLogItem(tU32 sig, tU32 len)
{
   dia_tclFnctTrace oTrace("dia_CSMWrapper::createCSMLogItem");
   CSMDataLogStrategy strategy(sig, len);
   DIA_TR_INF("dia_CSMWrapper::createCSMLogItem: created strategy");

   boost::shared_ptr<dia_IDataLoggerItem> pItem(new dia_DataLoggerItem<CSMDataLogStrategy>(strategy));
   DIA_TR_INF("dia_CSMWrapper::createCSMLogItem: created smart pointer");
   return pItem;
}

bool CSMDataLogStrategy::acquire(std::vector<tU8>& acqData)
{
   const tU32 msgLength = 8;
   bool result = false;
   acqData.assign(msgLength, 0);
   tU32 signalStatus = 0;
   tS32 csmResult = dia_CSMWrapper::getInstance()->CSMInterface.s32SignalRead(this->signalId, (void*)&acqData[0], msgLength, &signalStatus);
   if (
      (csmResult == CSM_C_NO_ERROR) 
      && 
      (
         ((signalStatus & CSM_C_SIGNAL_ARRIVED_FIRST) == CSM_C_SIGNAL_ARRIVED_FIRST)
         || 
         ((signalStatus & CSM_C_SIGNAL_ARRIVED) == CSM_C_SIGNAL_ARRIVED)
      )
      )
   {
      //DIA_TR_INF("CSM read signal OK--- CSMDataLogStrategy::acquire => Signal: 0x%x", this->signalId);
      //for(std::vector<tU8>::iterator it = acqData.begin(); it != acqData.end(); ++it)
      //{
      //   DIA_TR_INF("CSM read signal Data--- CSMDataLogStrategy::acquire => Data[]: 0x%x", *it);
      //}
      acqData.resize(this->length);
      std::reverse(acqData.begin(), acqData.end()); //lint !e864 Info: expression possibly depends on order of evaluation
      result = true;
   }
   else
   {
      acqData.resize(this->length);
      acqData.assign(this->length, 0xff);
      //DIA_TR_INF("CSM read signal FAILED--- CSMDataLogStrategy::acquire => Signal: 0x%x", this->signalId);
      //DIA_TR_INF("CSM read signal FAILED--- CSMDataLogStrategy::acquire => Result: %d, Signal Status: 0x%02x", csmResult, signalStatus);
   }
   return result;
}

