#ifndef __INCLUDED_DIA_SIGMA__
#define __INCLUDED_DIA_SIGMA__

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif
#ifndef __INCLUDED_DIA_DEFS_CONFIG_PROJECT__
#include "project/framework/config/dia_defsProjectConfig.h"
#endif

#ifndef __INCLUDED_DIA_FACTORY_METHODS_PROJECT__
#include "project/framework/factory/dia_factoryMethodsProject.h"
#endif

#ifndef __INCLUDED_DIA_DATALOGGER__
#include <common/framework/datalogger/dia_DataLogger.h>
#endif

#ifndef __INCLUDED_DIA_SIGMADATASTORE__
#include "project/framework/sigma/dia_SigmaDataStore.h"
#endif

#ifndef __INCLUDED_DIA_SIGMATRIGGERFRAME__
#include "project/framework/sigma/dia_SigmaTriggerFrame.h"
#endif

#ifndef __INCLUDED_DIA_SIGMAREQUEST__
#include "project/framework/sigma/dia_SigmaRequest.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_ERRORLOG_LISTENER__
#include "common/interfaces/dia_IErrorLogListener.h"
#endif

class SigmaDTCTriggers
{
private:
   static const tU32 dtcCANCommunication = 0xD00001;
   static const tU32 dtcAVCommunication = 0xD30001;
   static const tU32 dtcLowVoltageError = 0x934116;
   static const tU32 dtcHighVoltageError = 0x934117;
   static const tU32 dtcHUHighTemperature = 0x934198;
   static const tU32 dtcAmpTemperatureUp = 0x938298;
private:
   std::vector<tU32> triggeredDTCs;
public:
   SigmaDTCTriggers();
   bool isDTCTrigger(tU32) const;
};

class dia_Sigma : public dia_IErrorLogListenerImpl
{
public:
   dia_Sigma();
   DECL_SINGLETON_CONSTRUCTOR_AND_DESTRUCTOR(dia_Sigma);
private:
   static const tU32 ecu = 0x18cc0767;
   static const bool nonTriggeredEvents = false;
   dia_SigmaRequest dataRequest;
   dia_SigmaDataStore data;
   SigmaDTCTriggers dtcTriggers;
private:
   void clearData();
   void disptachTriggerFrame(tU32 dtc);
   void localDTCEvent(tU32 dtc, bool triggered);
   void localTriggerDTCEvent(tU32 dtc);
   template <bool b> void localNonTriggerDTCEvent(tU32 dtc) {}

public:
   static bool isConfigured();
   static eCanGen getCanGen();
   virtual void vOnClearResult();
   virtual void vOnFailedDTCList ( std::list<tU32>& failedDTCs );
   std::vector<tU8>::size_type getData(tU16 did, std::vector<tU8>& buffer) const;
   void externalTriggerEvent(dia_SIGMATriggerFrame triggerFrame);
   void start();
   void stop();
};

template <> 
inline void dia_Sigma::localNonTriggerDTCEvent<true>(tU32 dtc)
{ 
   localDTCEvent(dtc, false);
}

#endif 
