/*
 * dia_CMCSecurityLevelCISInstallationContainer.cpp
 *
 *  Created on: Jan 24, 2020
 *      Author: urm7kor
 */
#ifndef __INCLUDED_DIA_CMC_SECURITY_LEVEL_CIS_INSTALLATION_CONTAINER__
#include "project/framework/security/dia_CMCSecurityLevelCISInstallationContainer.h"
#endif

#ifndef __INCLUDED_DIA_SECURITY__
#include "common/framework/security/dia_security.h"
#endif

#ifndef __INCLUDED_DIA_RANDOM_GENERATOR__
#include "common/framework/utils/dia_RandomGenerator.h"
#endif

#ifndef __INCLUDED_DIA_DEFS_CONFIG_PROJECT__
#include "project/framework/config/dia_defsProjectConfig.h"
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#ifndef __INCLUDED_DIA_UTILITIES__
#include "common/framework/utils/dia_utilities.h"
#endif

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_DIAGNOSTICS_SM
#include "trcGenProj/Header/dia_CMCSecurityLevelCISInstallationContainer.cpp.trc.h"
#endif


#include "common/depricated/dia_tclDiagSession.h"

#define DIA_C_U16_CMC_SECURITY_LEVEL_CIS_INST_CNTNR_ACCESS_TYPE_SEED_LEN 2
#define DIA_C_U16_CMC_SECURITY_LEVEL_CIS_INST_CNTNR_ACCESS_TYPE_KEY_LEN 2
#define DIA_CONST_CMC_SECURITY_LEVEL_CIS_INST_CNTNR_A 15749
#define DIA_CONST_CMC_SECURITY_LEVEL_CIS_INST_CNTNR_B 451
#define DIA_CONST_CMC_SECURITY_LEVEL_CIS_INST_CNTNR_C -4836
#define DIA_CONST_CMC_SECURITY_LEVEL_CIS_INST_CNTNR_D 0x10000

dia_CMCSecurityLevelCISInstallationContainer::dia_CMCSecurityLevelCISInstallationContainer(dia_SecurityLevelConfiguration& config)
: dia_SecurityLevel(DIA_NAME_SECURITY_LEVEL_PROJECT_03, config),
  mbIsKeyInvalid(true)
{
	dia_tclFnctTrace trc("dia_CMCSecurityLevelCISInstallationContainer::dia_CMCSecurityLevelCISInstallationContainer");
	mNeedToRunSeedKeyPolicy = true;
	mIsLevelUnderSessionControl = true;
}

dia_CMCSecurityLevelCISInstallationContainer::~dia_CMCSecurityLevelCISInstallationContainer()
{
	// TODO Auto-generated destructor stub
	DIA_TR_INF("dia_CMCSecurityLevelCISInstallationContainer::~dia_CMCSecurityLevelCISInstallationContainer()");
}

void
dia_CMCSecurityLevelCISInstallationContainer::initialize ( void )
{
	dia_tclFnctTrace trc("dia_CMCSecurityLevelCISInstallationContainer::initialize");

	dia_SecurityLevel::initialize();

	(void) acceptEvent(dia_SecurityLevelFSM::evOperationModeUpdate, 0 );
}

//-----------------------------------------------------------------------------

tDiaResult
dia_CMCSecurityLevelCISInstallationContainer::getSeed ( void )
{
	dia_tclFnctTrace trc("dia_CMCSecurityLevelCISInstallationContainer::getSeed");

	tDiaResult retCode = DIA_FAILED;

	DIA_TR_INF("mStatus = 0x%x", mStatus);

	if (mStatus == DIA_EN_SECURITY_LEVEL_STATUS_ACTIVE)
	{
		std::vector<tU8> seedValue;
		for (unsigned i = 0; i < DIA_C_U16_CMC_SECURITY_LEVEL_CIS_INST_CNTNR_ACCESS_TYPE_SEED_LEN; i++)
		{
			seedValue.push_back(0);
		}
		notifySeedResult(DIA_SUCCESS, seedValue);

		return DIA_SUCCESS;
	}
	acceptSeed();

	return DIA_SUCCESS;
}

//-----------------------------------------------------------------------------

void
dia_CMCSecurityLevelCISInstallationContainer::vFsmCalculateSeed ( void* /*pArg*/ )
{
	dia_tclFnctTrace trc("dia_CMCSecurityLevelCISInstallationContainer::vFsmCalculateSeed");

	tDiaResult retCode = generateSeed();

	if (retCode == DIA_SUCCESS)
	{
		vOnStaticKey(mSeed);
	}
	else
	{
		DIA_TR_ERR("!!! dia_CMCSecurityLevelCISInstallationContainer::vFsmCalculateSeed: generateSeed FAILED");
	}
}

//------------------------------------------------------------------------------

tDiaResult
dia_CMCSecurityLevelCISInstallationContainer::generateSeed ( void )
{
	dia_tclFnctTrace oTrace("dia_CMCSecurityLevelCISInstallationContainer::generateSeed");

	tDiaResult retCode = DIA_FAILED;

	// initialize the seed attribute
	initializeSeed();

	// STD-SEC-TS.0200(1): When a SecuritySeed is requested to the UDS_Server, it generates and store a eight bytes PUN into its own memory.
	dia_RandomGenerator* pRandomGenerator = getInstanceOfRandomGenerator();
	if ( pRandomGenerator == NULL )
	{
		DIA_TR_ERR("### FAILED TO GET INSTANCE OF RANDOM GENERATOR ###");
		return retCode;
	}
	tU16 random1  = pRandomGenerator->getRandomNumber();
	DIA_TR_INF("--- dia_CMCSecurityLevelCISInstallationContainer::generateSeed=%d", random1);
	mPUN.clear();
	mPUN.push_back((random1 >>8));
	mPUN.push_back(random1);
	mSeed = mPUN;
	if (mPUN.size() == DIA_C_U16_CMC_SECURITY_LEVEL_CIS_INST_CNTNR_ACCESS_TYPE_SEED_LEN)
	{
		mIsSeedValid = TRUE;
		retCode = DIA_SUCCESS;
	}
	else
	{
		DIA_TR_ERR("### INVALID SEED LENGTH GENERATED ###");
	}

	return retCode;
}

//-----------------------------------------------------------------------------


bool
dia_CMCSecurityLevelCISInstallationContainer::isKeyInvalid ( void* pArg )
{
	dia_tclFnctTrace trc("dia_CMCSecurityLevelCISInstallationContainer::isKeyInvalid");

	return mbIsKeyInvalid;
}

//------------------------------------------------------------------------------

void
dia_CMCSecurityLevelCISInstallationContainer::vOnStaticKey ( const std::vector<tU8>& seedval )
{
   dia_tclFnctTrace oTrace("dia_CMCSecurityLevelCISInstallationContainer::vOnStaticKey");
   tU16 seed = (seedval[0] << 8) | seedval[1] ;
   
   DIA_TR_INF("--- dia_CMCSecurityLevelCISInstallationContainer::vOnStaticKey: %d", seed);
   tS16 CMCkey = ((DIA_CONST_CMC_SECURITY_LEVEL_CIS_INST_CNTNR_A * DIA_CONST_CMC_SECURITY_LEVEL_CIS_INST_CNTNR_B *(seed)) + (DIA_CONST_CMC_SECURITY_LEVEL_CIS_INST_CNTNR_C *(seed))) % DIA_CONST_CMC_SECURITY_LEVEL_CIS_INST_CNTNR_D;
   DIA_TR_INF("dia_CMCSecurityLevelCISInstallationContainer key: %d", CMCkey);
   
   mSessionKey.clear();
   mSessionKey.push_back((CMCkey>>8));
   mSessionKey.push_back((CMCkey));
   
   
   for (int i = 0; i < mSessionKey.size(); i++)
   {
	   DIA_TR_INF("Key[%02d]: 0x%02x",i, mSessionKey.at(i) );
   }

   //Send the SecuritySeed
   (void) acceptEvent(dia_SecurityLevelFSM::evOnSeedAvailable,0);

}

//-----------------------------------------------------------------------------
void
dia_CMCSecurityLevelCISInstallationContainer::acceptSeed ( void )
{
   dia_tclFnctTrace oTrace("dia_CMCSecurityLevelCISInstallationContainer::acceptSeed");
   (void) acceptEvent(dia_SecurityLevelFSM::evSeedRequested, 0 );
}

//-----------------------------------------------------------------------------
void
dia_CMCSecurityLevelCISInstallationContainer::vFsmSendSeed ( void* /*pArg*/ )
{
	 dia_tclFnctTrace trc("dia_CMCSecurityLevelCISInstallationContainer::vFsmSendSeed");
	  notifySeedResult(DIA_SUCCESS, mSeed);
}

//-----------------------------------------------------------------------------

tDiaResult
dia_CMCSecurityLevelCISInstallationContainer::acceptKey ( std::vector<tU8>& keyValue )
{
	dia_tclFnctTrace trc("dia_CMCSecurityLevelCISInstallationContainer::acceptKey");

	mErrorCode = DIA_E_NOERROR;

	if (!(keyValue.size()))
	{
		DIA_TR_ERR("!!! dia_CMCSecurityLevelCISInstallationContainer::acceptKey FAILED with invalid key size = %d", keyValue.size());
		mErrorCode = DIA_E_INVALID_MESSAGE_LENGHT_OR_INVALID_FORMAT;
	}
	else
	{
		if ((keyValue.size() == DIA_C_U16_CMC_SECURITY_LEVEL_CIS_INST_CNTNR_ACCESS_TYPE_KEY_LEN))
		{
			ETG_TRACE_COMP(("--- dia_CMCSecurityLevelCISInstallationContainer::acceptKey: SecurityKey Length: %d Data: %02x",
					keyValue.size(), ETG_LIST_LEN(keyValue.size()), ETG_LIST_PTR_T8(keyValue.data())));

			(void) acceptEvent(dia_SecurityLevelFSM::evKeyReceived, (tVoid*) &keyValue);
		}
		else
		{
			mErrorCode = DIA_FAILED;
		}
	}

	return mErrorCode;
}

//------------------------------------------------------------------------------

void
dia_CMCSecurityLevelCISInstallationContainer::vFsmValidateKey ( void* pArg )
{
   dia_tclFnctTrace trc("dia_CMCSecurityLevelCISInstallationContainer::vFsmValidateKey");
   mbIsKeyInvalid = true;
   if ( pArg != NULL )
   {
	   dia_tclFnctTrace trc("dia_CMCSecurityLevelCISInstallationContainer::pArg is not NULL");
	   std::vector<tU8>* pSecurityKey = (std::vector<tU8>*) pArg;
	   std::vector<tU8>& pSecurityKeyRef=*pSecurityKey;
	   mbIsKeyInvalid = false;
	   tS16 TesterKey = (pSecurityKeyRef[0] << 8) | pSecurityKeyRef[1] ;
	   for (int i = 0; i < mSessionKey.size(); i++)
	   {
		   if (mSessionKey[i] != pSecurityKeyRef[i])
		   {
			   DIA_TR_ERR("!!! dia_CMCSecurityLevelCISInstallationContainer::vFsmValidateKey: FAILED to compare with Session key at %d (0x%02x != 0x%02x)",
					   i, mSessionKey[i], pSecurityKeyRef[i]);
			   mbIsKeyInvalid = true;
			   break;
		   }
		   else
		   {
			   //do nothing
		   }
	   }
   }
   else
   {
	   DIA_TR_ERR("##### TESTER HAS SENT INVALID KEY #####");
   }
   if ( mbIsKeyInvalid == true )
   {
      DIA_TR_ERR("##### INVALID SECURITY KEY RECEIVED #####");
   }

   acceptEvent(dia_SecurityLevelFSM::evOnKeyValidationDone,0);
}

//-----------------------------------------------------------------------------
