/*
 * dia_RequestDownloadHandlerAIVI.cpp
 *
 *  Created on: Dec 15, 2016
 *      Author: kaa1hi
 *
 *      Copied from dia_MultipleReadDataByIDHandler
 */

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_FACTORY__
#include <common/framework/application/dia_Factory.h>
#endif

#ifndef __INCLUDED_DIA_MESSAGE_BUFFER_UDS__
#include <common/framework/protocols/uds/dia_MessageBufferUDS.h>
#endif

#ifndef __INCLUDED_DIA_DATA_DOWNLOAD_CONFIG_PROJECT__
#include "project/framework/datadownload/dia_DataDownloadConfigProject.h"
#endif

#include "dia_RequestDownloadHandlerAIVI.h"

#define DIA_U16_SIZEOF_HEADER_OF_REQ_DOWNLOAD         ((tU16) (1 /*dataFormatIdentifier*/ + 1 /*addressAndLengthFormatIdentifier*/))
#define DIA_U16_SIZEOF_MEMORY_ADDRESS_REQ_DOWNLOAD    ((tU16) (3))

//-----------------------------------------------------------------------------

dia_RequestDownloadHandlerAIVI::dia_RequestDownloadHandlerAIVI ( void )
   : mIsSetupDone(false),
     mpActiveMessageBuffer(0),
     mLastDTCNumber(0)
{
   dia_tclFnctTrace trc("dia_MultipleReadDataByIDHandler::dia_MultipleReadDataByIDHandler");

   if ( dia_RequestDownloadHandlerAIVI::setup() != DIA_SUCCESS )
   {
      DIA_TR_INF("### SETUP OF MULTIPLE DID READER FAILED ###");
   }
}

//-----------------------------------------------------------------------------

dia_RequestDownloadHandlerAIVI::dia_RequestDownloadHandlerAIVI ( dia_MessageHandler* nextHandler )
   : dia_MessageHandler(nextHandler),
     mIsSetupDone(false),
     mpActiveMessageBuffer(0),
     mLastDTCNumber(0)
{
   dia_tclFnctTrace trc("dia_MultipleReadDataByIDHandler::dia_MultipleReadDataByIDHandler(dia_MessageHandler*)");

   if ( dia_RequestDownloadHandlerAIVI::setup() != DIA_SUCCESS )
   {
      DIA_TR_INF("### SETUP OF MULTIPLE DID READER FAILED ###");
   }
}

//-----------------------------------------------------------------------------

dia_RequestDownloadHandlerAIVI::~dia_RequestDownloadHandlerAIVI ( void )
{
   _BP_TRY_BEGIN
   {
      (void) dia_RequestDownloadHandlerAIVI::tearDown();
   }
   _BP_CATCH_ALL
   {
      DIA_TR_ERR("EXCEPTION CAUGHT: dia_MultipleReadDataByIDHandler::~dia_MultipleReadDataByIDHandler !!!");
      DIA_ASSERT_ALWAYS();
   }
   _BP_CATCH_END
}

//-----------------------------------------------------------------------------

tDiaResult
dia_RequestDownloadHandlerAIVI::setup ( void )
{
   dia_tclFnctTrace trc("dia_MultipleReadDataByIDHandler::setup");

   // we setup the engine object only once
   if ( mIsSetupDone )
   {
      DIA_TR_INF("### MULTIPLE DID READER WAS ALREADY SET UP. RETURNING... ###");
      return DIA_SUCCESS;
   }

   mIsSetupDone = true;

   //set mapping
   mLogicAddrToDtcGroupRepo[BLOCK_FD00_REFERENCE_CHECKSUM_START]        = DIA_C_U16_DID_AIVI_LOGICAL_BLOCK_REFERENCE_CHECKSUM;
   mLogicAddrToDtcGroupRepo[BLOCK_FD01_PHONE_ECNR_NBS_START]            = DIA_C_U16_DID_AIVI_LOGICAL_BLOCK_PHONE_ECNR_NBS;
   mLogicAddrToDtcGroupRepo[BLOCK_FD02_PHONE_ECNR_WBS_START]            = DIA_C_U16_DID_AIVI_LOGICAL_BLOCK_PHONE_ECNR_WBS;
   mLogicAddrToDtcGroupRepo[BLOCK_FD03_VR_PARAM_START]                  = DIA_C_U16_DID_AIVI_LOGICAL_BLOCK_VR_PARAM;
   mLogicAddrToDtcGroupRepo[BLOCK_FD04_CARPLAY_PHONE_ECNR_NBS_START]    = DIA_C_U16_DID_AIVI_LOGICAL_BLOCK_CARPLAY_PHONE_ECNR_NBS;
   mLogicAddrToDtcGroupRepo[BLOCK_FD05_CARPLAY_PHONE_ECNR_WBS_START]    = DIA_C_U16_DID_AIVI_LOGICAL_BLOCK_CARPLAY_PHONE_ECNR_WBS;
   mLogicAddrToDtcGroupRepo[BLOCK_FD06_CARPLAY_FACETIME_ECNR_SWB_START] = DIA_C_U16_DID_AIVI_LOGICAL_BLOCK_CARPLAY_FACETIME_ECNR_SWB;
   mLogicAddrToDtcGroupRepo[BLOCK_FD07_ACOUSTIC_PARAM_START]            = DIA_C_U16_DID_AIVI_LOGICAL_BLOCK_ACOUSTIC_PARAM;
   mLogicAddrToDtcGroupRepo[BLOCK_FD08_ESE_START]                       = DIA_C_U16_DID_AIVI_LOGICAL_BLOCK_ESE_PARAM;
   mLogicAddrToDtcGroupRepo[BLOCK_FD09_BT_VOICE_ECNR_NBS_START]         = DIA_C_U16_DID_AIVI_LOGICAL_BLOCK_BT_VOICE_ECNR_NBS;
   mLogicAddrToDtcGroupRepo[BLOCK_FD0A_BT_VOICE_ECNR_WBS_START]         = DIA_C_U16_DID_AIVI_LOGICAL_BLOCK_BT_VOICE_ECNR_WBS;
   mLogicAddrToDtcGroupRepo[BLOCK_FD0B_BT_SIRI_ECNR_WBS_START]          = DIA_C_U16_DID_AIVI_LOGICAL_BLOCK_BT_SIRI_ECNR_WBS;
   mLogicAddrToDtcGroupRepo[BLOCK_FD0C_CARPLAY_SIRI_ECNR_WBS_START]     = DIA_C_U16_DID_AIVI_LOGICAL_BLOCK_CARPLAY_SIRI_ECNR_WBS;
   mLogicAddrToDtcGroupRepo[BLOCK_FD0D_ANDROID_AUTO_VR_ECNR_WBS_START]  = DIA_C_U16_DID_AIVI_LOGICAL_BLOCK_ANDROID_AUTO_VR_ECNR_WBS;
   mLogicAddrToDtcGroupRepo[BLOCK_FD0E_ECNR_VPA_VOICE_WB_START]         = DIA_C_U16_DID_AIVI_LOGICAL_BLOCK_ECNR_VPA_VOICE_WB;

   //set mapping
   mDtcProgrammingToPropertyIDRepo[DIA_LOGICAL_BLOCK_00_FTB_PROGRAMMING_FAILURE] = DIA_PROP_AIVI_LB00_DTC_PROGRAMMING_FAILURE_STATUS;
   mDtcProgrammingToPropertyIDRepo[DIA_LOGICAL_BLOCK_01_FTB_PROGRAMMING_FAILURE] = DIA_PROP_AIVI_LB01_DTC_PROGRAMMING_FAILURE_STATUS;
   mDtcProgrammingToPropertyIDRepo[DIA_LOGICAL_BLOCK_02_FTB_PROGRAMMING_FAILURE] = DIA_PROP_AIVI_LB02_DTC_PROGRAMMING_FAILURE_STATUS;
   mDtcProgrammingToPropertyIDRepo[DIA_LOGICAL_BLOCK_03_FTB_PROGRAMMING_FAILURE] = DIA_PROP_AIVI_LB03_DTC_PROGRAMMING_FAILURE_STATUS;
   mDtcProgrammingToPropertyIDRepo[DIA_LOGICAL_BLOCK_04_FTB_PROGRAMMING_FAILURE] = DIA_PROP_AIVI_LB04_DTC_PROGRAMMING_FAILURE_STATUS;
   mDtcProgrammingToPropertyIDRepo[DIA_LOGICAL_BLOCK_05_FTB_PROGRAMMING_FAILURE] = DIA_PROP_AIVI_LB05_DTC_PROGRAMMING_FAILURE_STATUS;
   mDtcProgrammingToPropertyIDRepo[DIA_LOGICAL_BLOCK_06_FTB_PROGRAMMING_FAILURE] = DIA_PROP_AIVI_LB06_DTC_PROGRAMMING_FAILURE_STATUS;
   mDtcProgrammingToPropertyIDRepo[DIA_LOGICAL_BLOCK_07_FTB_PROGRAMMING_FAILURE] = DIA_PROP_AIVI_LB07_DTC_PROGRAMMING_FAILURE_STATUS;
   mDtcProgrammingToPropertyIDRepo[DIA_LOGICAL_BLOCK_08_FTB_PROGRAMMING_FAILURE] = DIA_PROP_AIVI_LB08_DTC_PROGRAMMING_FAILURE_STATUS;
   mDtcProgrammingToPropertyIDRepo[DIA_LOGICAL_BLOCK_09_FTB_PROGRAMMING_FAILURE] = DIA_PROP_AIVI_LB09_DTC_PROGRAMMING_FAILURE_STATUS;
   mDtcProgrammingToPropertyIDRepo[DIA_LOGICAL_BLOCK_10_FTB_PROGRAMMING_FAILURE] = DIA_PROP_AIVI_LB10_DTC_PROGRAMMING_FAILURE_STATUS;
   mDtcProgrammingToPropertyIDRepo[DIA_LOGICAL_BLOCK_11_FTB_PROGRAMMING_FAILURE] = DIA_PROP_AIVI_LB11_DTC_PROGRAMMING_FAILURE_STATUS;
   mDtcProgrammingToPropertyIDRepo[DIA_LOGICAL_BLOCK_12_FTB_PROGRAMMING_FAILURE] = DIA_PROP_AIVI_LB12_DTC_PROGRAMMING_FAILURE_STATUS;
   mDtcProgrammingToPropertyIDRepo[DIA_LOGICAL_BLOCK_13_FTB_PROGRAMMING_FAILURE] = DIA_PROP_AIVI_LB13_DTC_PROGRAMMING_FAILURE_STATUS;
   mDtcProgrammingToPropertyIDRepo[DIA_LOGICAL_BLOCK_14_FTB_PROGRAMMING_FAILURE] = DIA_PROP_AIVI_LB14_DTC_PROGRAMMING_FAILURE_STATUS;

   return DIA_SUCCESS;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_RequestDownloadHandlerAIVI::tearDown ( void )
{
   dia_tclFnctTrace trc("dia_MultipleReadDataByIDHandler::tearDown");

   OSAL_DELETE mpActiveMessageBuffer;
   mpActiveMessageBuffer = 0;

   return DIA_SUCCESS;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_RequestDownloadHandlerAIVI::handleMessage ( dia_MessageBuffer& msg )
{
   dia_tclFnctTrace trc("dia_RequestDownloadHandlerAIVI::handleMessage(dia_MessageBuffer&)");

   tDiaResult retCode = DIA_FAILED;
   tU32 memoryAddress = 0;
   tU32 groupOfDtcProgramming = 0;

   if ( msg.getProtocol() == DIA_EN_PROTOCOL_UDS )
   {
	  //CID - 70896 and 70852 Fix
	  const tU16 dataLength = msg.u16GetDataLength();
      tU16 offset = (msg.getFormat() == dia_MessageBuffer::format_length_and_data) ? 2 : 1; /* one length byte plus one byte SID */
      if (dataLength < offset)
      {
         DIA_TR_ERR("### dataLength=%d <= offset=%d. Error in the framework! ####", dataLength, offset);
         msg.vSetNegResp(getInstanceOfFactory()->makeNRC(DIA_E_INVALID_MESSAGE_LENGHT_OR_INVALID_FORMAT));
         msg.vSendResponse();
         return DIA_FAILED;
      }

      if ( msg.getDataU8(offset-1) == DIA_C_U8_UDS_SID_REQUEST_DOWNLOAD )
      {
         if ( dataLength > (offset + DIA_U16_SIZEOF_HEADER_OF_REQ_DOWNLOAD + DIA_U16_SIZEOF_MEMORY_ADDRESS_REQ_DOWNLOAD) )
         {
            tU32 tmpOffset = offset + DIA_U16_SIZEOF_HEADER_OF_REQ_DOWNLOAD;

            memoryAddress = (((tU32) msg.getDataU8(tmpOffset+0)) << 16) | (((tU32) msg.getDataU8(tmpOffset+1)) << 8) | (((tU32) msg.getDataU8(tmpOffset+2)) << 0);
            DIA_TR_INF("memoryAddress = 0x%06X.", memoryAddress);

            std::map<tU32, tU16>::iterator it = mLogicAddrToDtcGroupRepo.find(memoryAddress);
            if ( it != mLogicAddrToDtcGroupRepo.end() )
            {
               groupOfDtcProgramming = (((tU32)it->second)<<8) | FTB_PROGRAMMING_FAILURE;

               DIA_TR_INF("DTC found in repository: groupOfDtcProgramming = 0x%06X.", groupOfDtcProgramming);
            }
            else
            {
               DIA_TR_INF("DTC found not in repository.");
            }
         }
         else
         {
            DIA_TR_ERR("### dataLength %d not greater than offset=%d + %d + %d ####", dataLength, offset, DIA_U16_SIZEOF_HEADER_OF_REQ_DOWNLOAD, DIA_U16_SIZEOF_MEMORY_ADDRESS_REQ_DOWNLOAD);
         }
      }
   }

   if (0!=groupOfDtcProgramming)
   {
      DIA_TR_INF("Forwarding dia_RequestDownloadHandlerAIVI::getStatusDTC call to save thread.");
      DIA_TR_INF("dia_RequestDownloadHandlerAIVI::handleMessage groupOfDtcProgramming = 0x%06X.", groupOfDtcProgramming);

      // store the original message as it contains the callback method used to deliver the final result
      mpActiveMessageBuffer = &msg;
      retCode = DIA_SUCCESS;

      getInstanceOfApplication()->postMessage (
            OSAL_NEW dia_tclDiagSession::tclEventIntMsgRxGeneric (
                  OSAL_NEW dia_FunctorOneArgNoReturnValue< dia_RequestDownloadHandlerAIVI, tU32 >(this, &dia_RequestDownloadHandlerAIVI::getStatusDTC, groupOfDtcProgramming)
            )
      );
   }
   else
   {
      retCode = dia_MessageHandler::handleMessage(msg);
   }

   return retCode;
}

//-------------------------------------------------------------------------

void
dia_RequestDownloadHandlerAIVI::getStatusDTC(const tU32 u32DTCMask)
{
   dia_tclFnctTrace oTrace("dia_RequestDownloadHandlerAIVI::getStatusDTC()");

   DIA_TR_INF("dia_RequestDownloadHandlerAIVI::getStatusDTC u32DTCMask=0x%06X", u32DTCMask);

   dia_IErrorLog* pErrorLog = 0;
   if ( querySysAdapterInterface<dia_IErrorLog>(&pErrorLog) == DIA_SUCCESS && pErrorLog)
   {
      DIA_TR_INF("Interface found.");

      (void) setSysAdapterListener<dia_IErrorLogListener>(this);

      //response will be delivered in vOnReadDTCbyStatusMaskResult
      if (pErrorLog->getStatusByDTC(DIAGLOG_MEMORY_REPROGRAMMING, u32DTCMask) == DIA_SUCCESS)
      {
         DIA_TR_INF("dia_RequestDownloadHandlerAIVI::handleMessage getStatusByDTC passed.");
         mLastDTCNumber = u32DTCMask;
      }
      else
      {
         DIA_TR_ERR("### getStatusByDTC FAILED FIRST TIME ####");
         NORMAL_M_ASSERT_ALWAYS();

         //1st WORKAROUND: Try it a second time because of an issue in the handling of ConditionVariables in the Systemadapter
         if (pErrorLog->getStatusByDTC(DIAGLOG_MEMORY_REPROGRAMMING, u32DTCMask) == DIA_SUCCESS)
         {
            DIA_TR_INF("dia_RequestDownloadHandlerAIVI::handleMessage getStatusByDTC passed.");
            mLastDTCNumber = u32DTCMask;
         }
         else
         {
            DIA_TR_ERR("### getStatusByDTC FAILED SECOND TIME ####");
            NORMAL_M_ASSERT_ALWAYS();

            //2nd WORKAROUND: Send NRC $22
            if (mpActiveMessageBuffer)
            {
               mpActiveMessageBuffer->vSetNegResp(getInstanceOfFactory()->makeNRC(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT));
               mpActiveMessageBuffer->vSendResponse();
               mpActiveMessageBuffer = NULL;
            }
         }
      }
   }
   else
   {
      (void) unsetSysAdapterListener<dia_IErrorLogListener>(this);
      DIA_TR_ERR("### dia_RequestDownloadHandlerAIVI::handleMessage querySysAdapterInterface || pErrorLog failed ###");
#if 0
      msg.vSetNegResp(getInstanceOfFactory()->makeNRC(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT));
      msg.vSendResponse();
#else
      NORMAL_M_ASSERT_ALWAYS();
#endif
   }

   return;
}

//-------------------------------------------------------------------------

void
dia_RequestDownloadHandlerAIVI::vOnReadStatusByDTCResult(const tU8 u8DTCStatusAvailabilityMask, std::list<tdia_IErrorLogResult>& ErrorLogList)
{
   dia_tclFnctTrace oTrace("dia_RequestDownloadHandlerAIVI::vOnReadStatusByDTCResult()");

   (void) unsetSysAdapterListener<dia_IErrorLogListener>(this);

   DIA_TR_INF( "u8DTCStatusAvailabilityMask = 0x%02X.", u8DTCStatusAvailabilityMask);
   DIA_TR_INF( "ErrorLogList.size()=%d.", ErrorLogList.size());

   bool DtcFound = false;
   tU8 dtcStatus = 0x00;
   tBool errorOccurred = TRUE;

   //look for current DTC and if found, check DTC status
   std::list<tdia_IErrorLogResult>::iterator it = ErrorLogList.begin();
   while (ErrorLogList.end()!=it)
   {
      if (mLastDTCNumber==it->u32DTC)
      {
         DIA_TR_INF( "DTC 0x%06X found and its status is 0x%02X.", mLastDTCNumber, it->u8Status);
         DtcFound = true;
         dtcStatus = it->u8Status;
         break;
      }
      ++it;
   }

   if (DtcFound)
   {
      std::map<tU32, tU32>::iterator it = mDtcProgrammingToPropertyIDRepo.find(mLastDTCNumber);
      if ( it != mDtcProgrammingToPropertyIDRepo.end() )
      {
         DIA_TR_INF( "dia_RequestDownloadHandlerAIVI::vOnReadStatusByDTCResult DTC 0x%06X found in repo.", mLastDTCNumber);

         tDiaResult retResult;
         retResult = dia_setProperty(it->second, dtcStatus);
         if (DIA_SUCCESS==retResult)
         {
            DIA_TR_INF( "dia_RequestDownloadHandlerAIVI::vOnReadStatusByDTCResult dtcStatus 0x%02X written 0x%08X.", dtcStatus, it->second);
            errorOccurred = FALSE;
         }
         else
         {
            DIA_TR_ERR( "### dia_RequestDownloadHandlerAIVI::vOnReadStatusByDTCResult Error code 0x%08X.", retResult);
         }
      }
      else
      {
         DIA_TR_ERR( "### dia_RequestDownloadHandlerAIVI::vOnReadStatusByDTCResult DTC 0x%06X not found.", mLastDTCNumber);
      }
   }
   else
   {
      DIA_TR_INF( "dia_RequestDownloadHandlerAIVI::vOnReadStatusByDTCResult DTC 0x%06X not found.", mLastDTCNumber);
   }

   if (FALSE==errorOccurred)
   {
      DIA_TR_INF( "dia_RequestDownloadHandlerAIVI::vOnReadStatusByDTCResult forward mpActiveMessageBuffer - DownloadRequest to UDS engine.");
      getInstanceOfApplication()->postMessage(OSAL_NEW dia_tclDiagSession::tclEventReqRx(mpActiveMessageBuffer));
   }

   mpActiveMessageBuffer = NULL;
}


