/*!
 * \file       dia_CustomerDiagHandlerSpeedLimitAIVI.h
 *
 * \brief      Pre-service handler for all A-IVI customer services (check vehicle speed,
 *             if not zero, send NRC 0x22 for specific service handler)
 * \details
 *
 * \component  Diagnosis
 *
 * \ingroup    diaServicesProject
 *
 * \copyright  (c) 2017 Robert Bosch GmbH
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */


#ifndef __INCLUDED_DIA_CUSTOMER_DIAG_HANDLER_SPEED_LIMIT_AIVI__
#define __INCLUDED_DIA_CUSTOMER_DIAG_HANDLER_SPEED_LIMIT_AIVI__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_MESSAGEHANDLER__
#include <common/framework/engine/dia_MessageHandler.h>
#endif

#ifndef __INCLUDED_DIA_INTERFACE_TIMER_LISTENER__
#include <common/interfaces/dia_ITimerListener.h>
#endif

#ifndef __INCLUDED_DIA_INTERFACE_SENSORSPEED_LISTENER__
#include "common/interfaces/dia_ISensorSpeedListener.h"
#endif

class dia_MessageBuffer;

class dia_CustomerDiagHandlerSpeedLimitAIVI
   : public dia_MessageHandler,
     public dia_ISensorSpeedListenerImpl
{
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_CustomerDiagHandlerSpeedLimitAIVI);//coverity fix:80640,80639
public:
   //! class constructor
   dia_CustomerDiagHandlerSpeedLimitAIVI ( void );
   //! class constructor with next handler passed
   dia_CustomerDiagHandlerSpeedLimitAIVI ( dia_MessageHandler* nextHandler );
   //! class destructor
   virtual ~dia_CustomerDiagHandlerSpeedLimitAIVI ( void );

   //! method to be implemented by concrete handlers for processing incoming messages. Return value of DIA_SUCCESS indicates that the message was handled within the chain of handlers
   virtual tDiaResult handleMessage ( dia_MessageBuffer& msg );

   //! send request to Sensor PV to get vehicle speed (must be called from save thread).
   virtual void getVehicleSpeed();

   //-------------------------------------------------------------------------
   //
   // Overloaded public dia_ISensorSpeedListenerImpl methods
   //
   //-------------------------------------------------------------------------

   //! deliver response for getVehicleSpee
   virtual void vOnSensorSpeed ( tU16 /*speed*/ );

protected:
   //! setup method for the application
   virtual tDiaResult setup ( void );
   //! shutdown method for the application
   virtual tDiaResult tearDown ( void );

protected:
   //!
   bool mIsSetupDone;

   //! active diagnosis request
   dia_MessageBuffer* mpActiveMessageBuffer;

   //Ecu Reset Repo (to be limited)
   std::vector<tU8 /*SubFunction*/> mEcuResetRepo;

   //IO Controls Repo (to be limited)
   std::map<tU16 /*DataIndetifier*/, std::vector<tU8> /*ControlOptionRecord*/> mIOControlRepo;

   //Routine Controls Repo (to be limited)
   std::map<tU16 /*RoutineIndetifier*/, std::vector<tU8> /*SubFunction*/> mRoutineRepo;

   //! true if service shall be limited with non-zero speed
   bool CheckEcuReset(tU8 subfunction);

   //! true if service shall be limited with non-zero speed
   bool CheckIOControl(tU16 dataIdentifier, tU8 controlOptionRecord);

   //! true if service shall be limited with non-zero speed
   bool CheckRoutineControl ( tU16 routineIdentifier, tU8 subFunction );
};

#endif /* __INCLUDED_DIA_CUSTOMER_DIAG_HANDLER_SPEED_LIMIT_AIVI__ */
