/*!
 * \file       dia_ASFComponentSubsystemDiagnosisServer.h
 *
 * \brief      ASF Component to implement the Subsystem Diagnosis Stub.
 *
 * \component  Diagnosis
 *
 * \ingroup    diaASFComponent
 *
 * \copyright  (c) 2019 Robert Bosch GmbH
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */

#ifndef __INCLUDED_DIA_ASF_COMPONENT_SUBSYSTEM_DIAGNOSIS_SERVER__
#define __INCLUDED_DIA_ASF_COMPONENT_SUBSYSTEM_DIAGNOSIS_SERVER__

#include "asf/core/BaseComponent.h"
#include "asf/core/ComponentFactory.h"
#include "org/bosch/cm/diagnosis/dbus/SubsystemDiagnosisStub.h"

#include <pthread.h>

#ifndef __INCLUDED_DIA_DEFINES_SUBSYSTEM_DIAGNOSIS__
#include <project/framework/cis/subsystem/dia_defsSubsystemDiagnosis.h>
#endif

#ifndef DOIP_TESTER_H
#include "doipclient/DoIP_Tester.h"
#endif

#ifndef DOIP_NODE_H_
#include "doipclient/DoIP_Node.h"
#endif

#ifndef DOIP_CFG_UDPSOCKET_LISTENER_STACKSIZE
#define DOIP_CFG_UDPSOCKET_LISTENER_STACKSIZE  (12*1024)
#endif

using namespace ::asf::core;
using namespace ::org::bosch::cm::diagnosis::dbus::SubsystemDiagnosis;

namespace asf {

class dia_ASFComponentSubsystemDiagnosisServer
   : public BaseComponent,
     public SubsystemDiagnosisStub,
	 public DoIP_Tester
{
   friend BaseComponent* ComponentFactory<dia_ASFComponentSubsystemDiagnosisServer>::getComponent();

private:
   //! default class constructor called only by ComponentFactory<dia_ASFComponentSubsystemDiagnosisServer>::getComponent()
   dia_ASFComponentSubsystemDiagnosisServer();

public:
   //! default class destructor
   virtual ~dia_ASFComponentSubsystemDiagnosisServer();
   
   	//! overloaded functions of DoIP Tester
    virtual DoIP_Node* vAddNode(DoIP_Node* node);
    virtual DoIP_Node* vAddNode(tU16 testerAddress, sockaddr_in IP, tU16 logAddr, tU32 maxDataSize);
    virtual DoIP_Node* vAddNode(tU16 testerAddress, sockaddr_in IP, tU16 logAddr, const tU8* EID, const tU8* GID, const tU8* VIN, DoIP_NodeType nodeType, tU32 maxDataSize);

   virtual void vAddNode(sockaddr_in IP, tU16 logAddr, const tU8* EID, const tU8* GID, const tU8* VIN, DoIP_NodeType nodeType, tU32 maxDataSize);
	
   //! overrides from SubsystemDiagnosisStub
   virtual void onStartUDPBroadcastClientRequest (const ::boost::shared_ptr< StartUDPBroadcastClientRequest >& /* request */) override;
   virtual void onDiscoverEntitiesRequest (const ::boost::shared_ptr< DiscoverEntitiesRequest >& /* request */) override;
   virtual void onDiscoverEntitiesResultsRequest (const ::boost::shared_ptr< DiscoverEntitiesResultsRequest >& /* request */) override;
   virtual void onAvdeccFilesDeleteRequest (const ::boost::shared_ptr< AvdeccFilesDeleteRequest >& /*request*/) override;

protected:

	::std::vector< DiscoverEntitiesResultsResponseNodeListStruct > nodeList;
	
	bool avdecc_filesDelete(void);

	DoIP_Cfg cfg;

	DoIP_Node* poNode;

};

} //namespace asf

#endif /* __INCLUDED_DIA_ASF_COMPONENT_SUBSYSTEM_DIAGNOSIS_SERVER__ */
