/*!
 * \file       dia_ASFComponentSubsystemDiagnosisClient.cpp
 *
 * \brief      ASF Component to implement the Subsystem Diagnosis Proxy.
 *
 * \component  Diagnosis
 *
 * \ingroup    diaASFComponent
 *
 * \copyright  (c) 2019 Robert Bosch GmbH
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */

#ifndef __INCLUDED_DIA_FACTORY__
#include "common/framework/application/dia_Factory.h"
#endif

#ifndef __INCLUDED_DIA_SAFEATURE_SUBSYSTEM_DIAGNOSIS__
#include "project/framework/sysadapters/dia_SAFeatureSubsystemDiagnosis.h"
#endif

#ifndef __INCLUDED_DIA_ASF_COMPONENT_SUBSYSTEM_DIAGNOSIS_CLIENT__
#include "dia_ASFComponentSubsystemDiagnosisClient.h"
#endif

#include "org/bosch/cm/diagnosis/dbus/SubsystemDiagnosisProxy.h"

using namespace ::org::bosch::cm::diagnosis::dbus::SubsystemDiagnosis;

namespace asf {

//------------------------------------------------------------------------------

dia_ASFComponentSubsystemDiagnosisClient::dia_ASFComponentSubsystemDiagnosisClient ( void )
{
   dia::ScopeTrace trc("dia_ASFComponentSubsystemDiagnosisClient::dia_ASFComponentSubsystemDiagnosisClient");

   dia_Factory* pFactory = getInstanceOfFactory();
   if ( !pFactory )
   {
     DIA_TR_ERR("dia_ASFComponentSubsystemDiagnosisClient::dia_ASFComponentSubsystemDiagnosisClient. Error: Failed to get pointer to global factory !!");
     return;
   }

   tDiaResult retCode = pFactory->requestInitializationLevel(DIA_EN_INITLEVEL_1);
   if ( retCode != DIA_SUCCESS )
   {
     DIA_TR_ERR("dia_ASFComponentSubsystemDiagnosisClient::dia_ASFComponentSubsystemDiagnosisClient. Error: Failed to initialize DIA_EN_INITLEVEL_1 !!");
     return;
   }

   //
   // asf System Adapter object
   //
   std::shared_ptr<dia_SystemAdapterASF> pSystemAdapter(createSystemAdapter());
   ::boost::shared_ptr< SubsystemDiagnosisProxy > proxy =  SubsystemDiagnosisProxy::createProxy("SubsystemDiagnosisClientPort", *pSystemAdapter);

   //
   // Service Plugins
   //
   dia_SystemAdapterServicePluginASF< SubsystemDiagnosisProxy >* pSASubsystemDiagnosis = dia_ASFComponent::createSystemAdapterServicePlugin<SubsystemDiagnosisProxy>("DIA_SASubsystemDiagnosis", proxy, pSystemAdapter);

   //
   // Feature Plugins
   //
   dia_SAFeatureSubsystemDiagnosis* pSAFeatureSubsystemDiagnosis = dia_ASFComponent::createSystemAdapterFeature<dia_SAFeatureSubsystemDiagnosis, SubsystemDiagnosisProxy>(pSASubsystemDiagnosis);

   if ( pSAFeatureSubsystemDiagnosis )
   {
      if (assignInterfaceAndNotifier<dia_ISubsystemDiagnosisProxy, dia_ISubsystemDiagnosisProxyListener, dia_ISubsystemDiagnosisProxyNotifier>(pSAFeatureSubsystemDiagnosis) != DIA_SUCCESS)
      {
         DIA_TR_ERR("dia_ASFComponentSubsystemDiagnosisClient::dia_ASFComponentSubsystemDiagnosisClient. Error: assignInterfaceAndNotifier failed");
      }
   }
}

//------------------------------------------------------------------------------

dia_ASFComponentSubsystemDiagnosisClient::~dia_ASFComponentSubsystemDiagnosisClient()
{
}

//------------------------------------------------------------------------------

//------------------------------------------------------------------------------

} //namespace asf